/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableLongDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableLongDoubleMap;
import org.eclipse.collections.api.map.primitive.LongDoubleMap;
import org.eclipse.collections.impl.factory.primitive.LongDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongDoubleSingletonMap;

public class ImmutableLongDoubleMapFactoryImpl
implements ImmutableLongDoubleMapFactory {
    public static final ImmutableLongDoubleMapFactory INSTANCE = new ImmutableLongDoubleMapFactoryImpl();

    @Override
    public ImmutableLongDoubleMap empty() {
        return ImmutableLongDoubleEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableLongDoubleMap of() {
        return this.empty();
    }

    @Override
    public ImmutableLongDoubleMap with() {
        return this.empty();
    }

    @Override
    public ImmutableLongDoubleMap of(long key, double value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableLongDoubleMap with(long key, double value) {
        return new ImmutableLongDoubleSingletonMap(key, value);
    }

    @Override
    public ImmutableLongDoubleMap ofAll(LongDoubleMap map) {
        return this.withAll(map);
    }

    @Override
    public ImmutableLongDoubleMap withAll(LongDoubleMap map) {
        if (map instanceof ImmutableLongDoubleMap) {
            return (ImmutableLongDoubleMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableLongDoubleHashMap(map);
    }

    @Override
    public <T> ImmutableLongDoubleMap from(Iterable<T> iterable, LongFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction) {
        return LongDoubleMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

