/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.aes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/aes/AesScaling;", "", "()V", "PIE_UNIT_SIZE", "", "POINT_UNIT_SIZE", "circleDiameter", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "circleDiameterSmaller", "lineWidth", "pieDiameter", "pointStrokeWidth", "sizeFromCircleDiameter", "diameter", "strokeWidth", "textSize", "plot-base"})
public final class AesScaling {
    @NotNull
    public static final AesScaling INSTANCE = new AesScaling();
    public static final double POINT_UNIT_SIZE = 2.2;
    public static final double PIE_UNIT_SIZE = 10.0;

    private AesScaling() {
    }

    public final double strokeWidth(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.size();
        Intrinsics.checkNotNull((Object)d);
        return d * 2.2;
    }

    public final double pointStrokeWidth(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.stroke();
        Intrinsics.checkNotNull((Object)d);
        return d * 2.2;
    }

    public final double lineWidth(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.linewidth();
        Intrinsics.checkNotNull((Object)d);
        return d * 2.2;
    }

    public final double circleDiameter(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.size();
        Intrinsics.checkNotNull((Object)d);
        return d * 2.2;
    }

    public final double pieDiameter(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.size();
        Intrinsics.checkNotNull((Object)d);
        return d * 10.0;
    }

    public final double circleDiameterSmaller(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.size();
        Intrinsics.checkNotNull((Object)d);
        return d * 1.5;
    }

    public final double sizeFromCircleDiameter(double diameter) {
        return diameter / 2.2;
    }

    public final double textSize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.size();
        Intrinsics.checkNotNull((Object)d);
        return d * (double)2;
    }
}

