/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;

public class LookupAllExpression
extends UnaryExpression {
    public LookupAllExpression(Expression lhs) {
        super(lhs);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.INSPECT;
    }

    @Override
    public final ItemType getItemType() {
        ItemType lhs = this.getBaseExpression().getItemType();
        if (lhs instanceof MapType) {
            return ((MapType)lhs).getValueType().getPrimaryType();
        }
        if (lhs instanceof ArrayItemType) {
            return ((ArrayItemType)lhs).getMemberType().getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.getItemType().getUType();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean isMapLookup;
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        this.getOperand().typeCheck(visitor, contextInfo);
        ItemType containerType = this.getBaseExpression().getItemType();
        boolean isArrayLookup = containerType instanceof ArrayItemType;
        boolean bl = isMapLookup = containerType instanceof MapType || containerType instanceof TupleType;
        if (!isArrayLookup && !isMapLookup && th.relationship(containerType, MapType.ANY_MAP_TYPE) == Affinity.DISJOINT && th.relationship(containerType, ArrayItemType.getInstance()) == Affinity.DISJOINT) {
            if (Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
                visitor.issueWarning("The left-hand operand of '?' must be a map or an array; the expression can succeed only if the operand is an empty sequence " + containerType, this.getLocation());
            } else {
                XPathException err = new XPathException("The left-hand operand of '?' must be a map or an array; the supplied expression is of type " + containerType, "XPTY0004");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                err.setFailingExpression(this);
                throw err;
            }
        }
        if (this.getBaseExpression() instanceof Literal) {
            try {
                return new Literal(SequenceTool.toGroundedValue(this.iterate(visitor.makeDynamicContext())));
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.getOperand().optimize(visitor, contextItemType);
        if (this.getBaseExpression() instanceof Literal) {
            return new Literal(SequenceTool.toGroundedValue(this.iterate(visitor.makeDynamicContext())));
        }
        if (this.getBaseExpression() instanceof SquareArrayConstructor) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (Operand o : this.getBaseExpression().operands()) {
                children.add(o.getChildExpression().copy(new RebindingMap()));
            }
            Expression[] childExpressions = children.toArray(new Expression[0]);
            Block block = new Block(childExpressions);
            ExpressionTool.copyLocationInfo(this, block);
            return block;
        }
        return this;
    }

    @Override
    public double getCost() {
        return this.getBaseExpression().getCost() + 1.0;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public LookupAllExpression copy(RebindingMap rebindings) {
        return new LookupAllExpression(this.getBaseExpression().copy(rebindings));
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LookupAllExpression)) {
            return false;
        }
        LookupAllExpression p = (LookupAllExpression)other;
        return this.getBaseExpression().isEqual(p.getBaseExpression());
    }

    @Override
    protected int computeHashCode() {
        return "LookupAll".hashCode() ^ this.getBaseExpression().hashCode();
    }

    @Override
    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        return new SequenceIterator(){
            final SequenceIterator level0;
            Iterator<GroundedValue> level1forArrays;
            Iterator<KeyValuePair> level1forMaps;
            SequenceIterator level2;
            {
                this.level0 = LookupAllExpression.this.getBaseExpression().iterate(context);
                this.level1forArrays = null;
                this.level1forMaps = null;
                this.level2 = null;
            }

            @Override
            public Item next() {
                if (this.level2 == null) {
                    if (this.level1forArrays == null && this.level1forMaps == null) {
                        Item lhs = this.level0.next();
                        if (lhs == null) {
                            return null;
                        }
                        if (lhs instanceof ArrayItem) {
                            this.level1forArrays = ((ArrayItem)lhs).members().iterator();
                            return this.next();
                        }
                        if (lhs instanceof MapItem) {
                            this.level1forMaps = ((MapItem)lhs).keyValuePairs().iterator();
                            return this.next();
                        }
                        try {
                            LookupExpression.mustBeArrayOrMap(LookupAllExpression.this, lhs);
                        }
                        catch (XPathException e) {
                            throw new UncheckedXPathException(e);
                        }
                        return null;
                    }
                    if (this.level1forArrays != null && this.level1forArrays.hasNext()) {
                        GroundedValue nextEntry = this.level1forArrays.next();
                        this.level2 = nextEntry.iterate();
                    } else if (this.level1forMaps != null && this.level1forMaps.hasNext()) {
                        KeyValuePair nextEntry = this.level1forMaps.next();
                        GroundedValue value = nextEntry.value;
                        this.level2 = value.iterate();
                    } else {
                        this.level1forMaps = null;
                        this.level1forArrays = null;
                    }
                    return this.next();
                }
                Item nextItem = this.level2.next();
                if (nextItem == null) {
                    this.level2 = null;
                    return this.next();
                }
                return nextItem;
            }

            @Override
            public void close() {
                if (this.level0 != null) {
                    this.level0.close();
                }
                if (this.level2 != null) {
                    this.level2.close();
                }
            }

            @Override
            public void discharge() {
                if (this.level0 != null) {
                    this.level0.discharge();
                }
                if (this.level2 != null) {
                    this.level2.discharge();
                }
            }
        };
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("lookupAll", this);
        this.getBaseExpression().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "?*";
    }

    @Override
    public String toShortString() {
        return this.getBaseExpression().toShortString() + "?*";
    }
}

