/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BSFTestElement;
import org.apache.jmeter.visualizers.Visualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSFListener
extends BSFTestElement
implements Cloneable,
SampleListener,
TestBean,
Visualizer {
    private static final Logger log = LoggerFactory.getLogger(BSFListener.class);
    private static final long serialVersionUID = 234L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampleOccurred(SampleEvent event) {
        BSFManager mgr = null;
        try {
            mgr = this.getManager();
            if (mgr == null) {
                log.error("Problem creating BSF manager");
                return;
            }
            mgr.declareBean("sampleEvent", (Object)event, SampleEvent.class);
            SampleResult result = event.getResult();
            mgr.declareBean("sampleResult", (Object)result, SampleResult.class);
            this.processFileOrScript(mgr);
        }
        catch (BSFException e) {
            if (log.isWarnEnabled()) {
                log.warn("Problem in BSF script. {}", (Object)e.toString());
            }
        }
        finally {
            if (mgr != null) {
                mgr.terminate();
            }
        }
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void add(SampleResult sample) {
    }

    public boolean isStats() {
        return false;
    }

    public Object clone() {
        return super.clone();
    }
}

