/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.FlippableGeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintsCollection;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "flipHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/FlippableGeomHelper;", "wontRender", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getWontRender", "()Ljava/util/List;", "afterRotation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "x", "", "y", "(Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "aes", "buildHints", "", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "dataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRibbonGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RibbonGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n1#3:122\n*S KotlinDebug\n*F\n+ 1 RibbonGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom\n*L\n33#1:118\n33#1:119,3\n*E\n"})
public final class RibbonGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final FlippableGeomHelper flipHelper;
    public static final boolean HANDLES_GROUPS = true;

    public RibbonGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.flipHelper = new FlippableGeomHelper(this.isVertical);
    }

    private final Aes<Double> afterRotation(Aes<Double> aes2) {
        return this.flipHelper.getEffectiveAes(aes2);
    }

    private final DoubleVector afterRotation(Double x, Double y) {
        DoubleVector doubleVector;
        if (SeriesUtil.INSTANCE.isFinite(x) && SeriesUtil.INSTANCE.isFinite(y)) {
            Double d = x;
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = y;
            Intrinsics.checkNotNull((Object)d3);
            doubleVector = this.flipHelper.flip(new DoubleVector(d2, d3.doubleValue()));
        } else {
            doubleVector = null;
        }
        return doubleVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Aes<?>> getWontRender() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Aes[]{Aes.Companion.getXMIN(), Aes.Companion.getXMAX()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Aes aes2 = (Aes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.afterRotation((Aes<Double>)p0));
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<DataPointAesthetics> dataPoints(Aesthetics aesthetics2) {
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Iterable<DataPointAesthetics> data = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), xAes, minAes, maxAes);
        return GeomUtil.INSTANCE.ordered_X(data);
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Iterable<DataPointAesthetics> dataPoints2 = this.dataPoints(aesthetics2);
        LinesHelper helper2 = new LinesHelper(pos, coord, ctx);
        Function1 upper2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, xAes, maxAes){
            final /* synthetic */ RibbonGeom this$0;
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $maxAes;
            {
                this.this$0 = $receiver;
                this.$xAes = $xAes;
                this.$maxAes = $maxAes;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$afterRotation(this.this$0, p.get(this.$xAes), p.get(this.$maxAes));
            }
        };
        Function1 lower2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, xAes, minAes){
            final /* synthetic */ RibbonGeom this$0;
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $minAes;
            {
                this.this$0 = $receiver;
                this.$xAes = $xAes;
                this.$minAes = $minAes;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$afterRotation(this.this$0, p.get(this.$xAes), p.get(this.$minAes));
            }
        };
        List paths = LinesHelper.createBands$default(helper2, dataPoints2, upper2, lower2, false, 8, null);
        GeomBase.Companion.appendNodes(root, paths);
        helper2.setAlphaEnabled(false);
        GeomBase.Companion.appendNodes(root, helper2.createLines(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)upper2));
        GeomBase.Companion.appendNodes(root, helper2.createLines(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)lower2));
        this.buildHints(aesthetics2, pos, coord, ctx);
    }

    private final void buildHints(Aesthetics aesthetics2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        TipLayoutHint.Kind kind;
        boolean bl;
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx);
        Function1<DataPointAesthetics, List<Color>> colorMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.RIBBON, ctx);
        boolean bl2 = this.isVertical;
        if (bl2) {
            bl = !ctx.getFlipped();
        } else if (!bl2) {
            bl = ctx.getFlipped();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVerticallyOriented = bl;
        TipLayoutHint.Kind kind2 = kind = TipLayoutHint.Kind.HORIZONTAL_TOOLTIP;
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(0.0);
        boolean bl3 = false;
        boolean bl4 = isVerticallyOriented;
        TipLayoutHint.Kind kind3 = bl4 ? kind : null;
        if (kind3 == null) {
            kind3 = TipLayoutHint.Kind.VERTICAL_TOOLTIP;
        }
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultKind(kind3);
        Aes<Double> xAes = this.afterRotation(Aes.Companion.getX());
        Aes<Double> minAes = this.afterRotation(Aes.Companion.getYMIN());
        Aes<Double> maxAes = this.afterRotation(Aes.Companion.getYMAX());
        Function1 location2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, xAes){
            final /* synthetic */ RibbonGeom this$0;
            final /* synthetic */ Aes<Double> $xAes;
            {
                this.this$0 = $receiver;
                this.$xAes = $xAes;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$afterRotation(this.this$0, p.get(this.$xAes), 0.0);
            }
        };
        Function1 upper2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, xAes, maxAes){
            final /* synthetic */ RibbonGeom this$0;
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $maxAes;
            {
                this.this$0 = $receiver;
                this.$xAes = $xAes;
                this.$maxAes = $maxAes;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$afterRotation(this.this$0, p.get(this.$xAes), p.get(this.$maxAes));
            }
        };
        Function1 lower2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(this, xAes, minAes){
            final /* synthetic */ RibbonGeom this$0;
            final /* synthetic */ Aes<Double> $xAes;
            final /* synthetic */ Aes<Double> $minAes;
            {
                this.this$0 = $receiver;
                this.$xAes = $xAes;
                this.$minAes = $minAes;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                return RibbonGeom.access$afterRotation(this.this$0, p.get(this.$xAes), p.get(this.$minAes));
            }
        };
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            DoubleVector doubleVector = (DoubleVector)location2.invoke((Object)p);
            if (doubleVector == null) continue;
            DoubleVector it = doubleVector;
            boolean bl5 = false;
            DoubleVector doubleVector2 = helper2.toClient(it, p);
            doubleVector = doubleVector2;
            if (doubleVector2 == null) {
                continue;
            }
            double x = doubleVector.getX();
            DoubleVector doubleVector3 = (DoubleVector)upper2.invoke((Object)p);
            if (doubleVector3 == null) continue;
            DoubleVector it2 = doubleVector3;
            boolean bl6 = false;
            DoubleVector doubleVector4 = helper2.toClient(it2, p);
            doubleVector3 = doubleVector4;
            if (doubleVector4 == null) {
                continue;
            }
            double top = doubleVector3.getY();
            DoubleVector doubleVector5 = (DoubleVector)lower2.invoke((Object)p);
            if (doubleVector5 == null) continue;
            DoubleVector it3 = doubleVector5;
            boolean bl7 = false;
            DoubleVector doubleVector6 = helper2.toClient(it3, p);
            doubleVector5 = doubleVector6;
            if (doubleVector6 == null) {
                continue;
            }
            double bottom = doubleVector5.getY();
            Double d = p.get(xAes);
            Intrinsics.checkNotNull((Object)d);
            HintsCollection.HintConfigFactory hintConfigFactory2 = hint.defaultCoord(((Number)d).doubleValue());
            Color color = p.fill();
            Intrinsics.checkNotNull((Object)color);
            hintConfigFactory2.defaultColor(color, null);
            HintsCollection hintsCollection = new HintsCollection(p, helper2).addHint(hint.create(maxAes)).addHint(hint.create(minAes));
            GeomTargetCollector.TooltipParams tooltipParams = new GeomTargetCollector.TooltipParams(hintsCollection.getHints(), null, null, (List)colorMapper.invoke((Object)p), 6, null);
            GeomTargetCollector.DefaultImpls.addPoint$default(ctx.getTargetCollector(), p.index(), new DoubleVector(x, top), 0.0, tooltipParams, null, 16, null);
            GeomTargetCollector.DefaultImpls.addPoint$default(ctx.getTargetCollector(), p.index(), new DoubleVector(x, bottom), 0.0, tooltipParams, null, 16, null);
        }
    }

    public static final /* synthetic */ DoubleVector access$afterRotation(RibbonGeom $this, Double x, Double y) {
        return $this.afterRotation(x, y);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/RibbonGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

