/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.regression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.ForsythePolynomialGenerator;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.PolynomialFunction;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.PolynomialFunctionKt;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionEvaluator;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fBC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/PolynomialRegression;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator;", "n", "", "meanX", "", "sumXX", "model", "Lkotlin/Function1;", "standardErrorOfEstimate", "tCritical", "(IDDLkotlin/jvm/functions/Function1;DD)V", "Companion", "plot-base"})
public final class PolynomialRegression
extends RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private PolynomialRegression(int n, double meanX, double sumXX, Function1<? super Double, Double> model2, double standardErrorOfEstimate, double tCritical) {
        super(n, meanX, sumXX, model2, standardErrorOfEstimate, tCritical);
    }

    public /* synthetic */ PolynomialRegression(int n, double meanX, double sumXX, Function1 model2, double standardErrorOfEstimate, double tCritical, DefaultConstructorMarker $constructor_marker) {
        this(n, meanX, sumXX, (Function1<? super Double, Double>)model2, standardErrorOfEstimate, tCritical);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J8\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/PolynomialRegression$Companion;", "", "()V", "calculatePolynomial", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialFunction;", "deg", "", "xVals", "", "yVals", "coefficient", "", "p", "fit", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/PolynomialRegression;", "xs", "", "ys", "confidenceLevel", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nPolynomialRegression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolynomialRegression.kt\norg/jetbrains/letsPlot/core/plot/base/stat/regression/PolynomialRegression$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PolynomialRegression fit(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, int deg) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            RegressionEvaluator.Companion.check(xs, ys, confidenceLevel);
            if (!(deg >= 2)) {
                boolean $i$a$-require-PolynomialRegression$Companion$fit$22 = false;
                String $i$a$-require-PolynomialRegression$Companion$fit$22 = "Degree of polynomial must be at least 2";
                throw new IllegalArgumentException($i$a$-require-PolynomialRegression$Companion$fit$22.toString());
            }
            Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
            double[] xVals = (double[])pair.component1();
            double[] yVals = (double[])pair.component2();
            int n = xVals.length;
            double degreesOfFreedom = (double)(n - deg) - 1.0;
            if (n <= deg) {
                return null;
            }
            double meanX = ArraysKt.average((double[])xVals);
            double sumXX = RegressionUtilKt.sumOfSquaredDeviations(xVals, meanX);
            PolynomialFunction polynomial = this.calculatePolynomial(deg, xVals, yVals);
            Function1 model2 = (Function1)new Function1<Double, Double>(polynomial){
                final /* synthetic */ PolynomialFunction $polynomial;
                {
                    this.$polynomial = $polynomial;
                    super(1);
                }

                @NotNull
                public final Double invoke(double x) {
                    return this.$polynomial.value(x);
                }
            };
            return new PolynomialRegression(n, meanX, sumXX, model2, RegressionEvaluator.Companion.calcStandardErrorOfEstimate(xVals, yVals, (Function1<? super Double, Double>)model2, degreesOfFreedom), RegressionEvaluator.Companion.calcTCritical(degreesOfFreedom, confidenceLevel), null);
        }

        private final PolynomialFunction calculatePolynomial(int deg, double[] xVals, double[] yVals) {
            ForsythePolynomialGenerator fpg = new ForsythePolynomialGenerator(xVals);
            double[] dArray = new double[]{0.0};
            PolynomialFunction res = new PolynomialFunction(dArray);
            int i = 0;
            if (i <= deg) {
                while (true) {
                    PolynomialFunction p = fpg.getPolynomial(i);
                    double s = this.coefficient(p, xVals, yVals);
                    res = res.plus(PolynomialFunctionKt.times(s, p));
                    if (i == deg) break;
                    ++i;
                }
            }
            return res;
        }

        private final double coefficient(PolynomialFunction p, double[] xVals, double[] yVals) {
            double ww = 0.0;
            double w = 0.0;
            int n = xVals.length;
            for (int i = 0; i < n; ++i) {
                double x = xVals[i];
                double y = yVals[i];
                double pval = p.value(x);
                ww += pval * pval;
                w += y * pval;
            }
            return w / ww;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

