/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.LinkedHashMap;
import java.util.List;

public class MergeFunction
extends BaseFunction {
    public MergeFunction() {
        super(ArgumentConstraints.listOf(1, Integer.MAX_VALUE, ArgumentConstraints.typeOf(JmesPathType.OBJECT)));
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        LinkedHashMap<T, T> accumulator = new LinkedHashMap<T, T>();
        for (FunctionArgument<T> argument : arguments) {
            T value = argument.value();
            for (T property : runtime.getPropertyNames(value)) {
                accumulator.put(property, runtime.getProperty(value, property));
            }
        }
        return runtime.createObject(accumulator);
    }
}

