/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="5.5")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0004H\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/apache/jmeter/threads/openmodel/EvenArrivalsRamp;", "Ljava/util/PrimitiveIterator$OfDouble;", "()V", "acceleration", "", "beginRate", "endRate", "meanRate", "n", "", "numEvents", "hasNext", "", "nextDouble", "prepare", "", "duration", "remove", "Companion", "ApacheJMeter_core"})
public final class EvenArrivalsRamp
implements PrimitiveIterator.OfDouble {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private double beginRate;
    private double endRate;
    private double meanRate;
    private double acceleration;
    private long n;
    private long numEvents;
    private static final Logger log = LoggerFactory.getLogger(EvenArrivalsRamp.class);

    @Override
    public void remove() {
        String string = "Element removal is not supported";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean hasNext() {
        return this.n < this.numEvents;
    }

    @Override
    public double nextDouble() {
        double res = this.n == 0L ? 0.0 : (this.acceleration == 0.0 ? (double)this.n / this.meanRate : (Math.sqrt(this.beginRate * this.beginRate + (double)2 * this.acceleration * (double)this.n) - this.beginRate) / this.acceleration);
        long l = this.n;
        this.n = l + 1L;
        return res;
    }

    public final void prepare(double beginRate, double endRate, double duration) {
        this.beginRate = beginRate;
        this.endRate = endRate;
        this.meanRate = (beginRate + endRate) / (double)2;
        this.numEvents = (long)(this.meanRate * duration);
        this.n = 0L;
        double d = this.acceleration = Math.abs(endRate - beginRate) < 1.0E-4 * this.meanRate ? 0.0 : (endRate - beginRate) / duration;
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{this.numEvents, beginRate, endRate, duration};
            log.info("Generating {} events, beginRate = {} / sec, endRate = {} / sec, duration = {} sec", objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/jmeter/threads/openmodel/EvenArrivalsRamp$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ApacheJMeter_core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

