/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.github.weisj.darklaf.util.PropertyUtil;
import com.intellij.util.ui.StringUIClientPropertyKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class UIUtilities {
    private static final int MIN_LAYOUT_CHARCODE = 768;
    private static final int MAX_LAYOUT_CHARCODE = 8303;
    private static final int HI_SURROGATE_START = 55296;
    private static final int LO_SURROGATE_END = 57343;
    private static final int CACHE_SIZE = 6;
    private static final LSBCacheEntry[] fontCache = new LSBCacheEntry[6];
    private static int nextIndex;
    private static LSBCacheEntry searchKey;
    private static final FontRenderContext DEFAULT_FRC;
    private static final StringBuilder SKIP_CLICK_COUNT;
    public static final StringUIClientPropertyKey BASICMENUITEMUI_MAX_TEXT_OFFSET;
    private static final Object charsBufferLock;
    private static final int CHAR_BUFFER_SIZE = 100;
    private static char[] charsBuffer;

    private static int syncCharsBuffer(String s) {
        int length = s.length();
        if (charsBuffer != null && charsBuffer.length >= length) {
            s.getChars(0, length, charsBuffer, 0);
        } else {
            charsBuffer = s.toCharArray();
        }
        return length;
    }

    public static boolean isComplexLayout(char[] text, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (text[i] < '\u0300' || !UIUtilities.isNonSimpleChar(text[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isNonSimpleChar(char ch) {
        return UIUtilities.isComplexCharCode(ch) || ch >= '\ud800' && ch <= '\udfff';
    }

    public static boolean isComplexCharCode(int code) {
        if (code < 768 || code > 8303) {
            return false;
        }
        if (code <= 879) {
            return true;
        }
        if (code < 1424) {
            return false;
        }
        if (code <= 1791) {
            return true;
        }
        if (code < 2304) {
            return false;
        }
        if (code <= 3711) {
            return true;
        }
        if (code < 3840) {
            return false;
        }
        if (code <= 4095) {
            return true;
        }
        if (code < 4256) {
            return true;
        }
        if (code < 4352) {
            return false;
        }
        if (code < 4607) {
            return true;
        }
        if (code < 6016) {
            return false;
        }
        if (code <= 6143) {
            return true;
        }
        if (code < 8204) {
            return false;
        }
        if (code <= 8205) {
            return true;
        }
        if (code >= 8234 && code <= 8238) {
            return true;
        }
        return code >= 8298 && code <= 8303;
    }

    public static int getLeftSideBearing(JComponent c, FontMetrics fm, String string) {
        return string != null && string.length() != 0 ? UIUtilities.getLeftSideBearing(c, fm, string.charAt(0)) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(JComponent c, FontMetrics fm, char firstChar) {
        if (firstChar < 'X' && firstChar >= 'W') {
            FontRenderContext frc = UIUtilities.getFontRenderContext(c, fm);
            Font font = fm.getFont();
            Class<UIUtilities> clazz = UIUtilities.class;
            synchronized (UIUtilities.class) {
                LSBCacheEntry entry = null;
                if (searchKey == null) {
                    searchKey = new LSBCacheEntry(frc, font);
                } else {
                    searchKey.reset(frc, font);
                }
                for (LSBCacheEntry cacheEntry : fontCache) {
                    if (!searchKey.equals(cacheEntry)) continue;
                    entry = cacheEntry;
                    break;
                }
                if (entry == null) {
                    entry = searchKey;
                    UIUtilities.fontCache[UIUtilities.nextIndex] = searchKey;
                    searchKey = null;
                    nextIndex = (nextIndex + 1) % 6;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return entry.getLeftSideBearing(firstChar);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        if (string != null && !string.equals("")) {
            boolean needsTextLayout;
            boolean bl = needsTextLayout = c != null && c.getClientProperty(TextAttribute.NUMERIC_SHAPING) != null;
            if (needsTextLayout) {
                Object object = charsBufferLock;
                synchronized (object) {
                    int length = UIUtilities.syncCharsBuffer(string);
                    needsTextLayout = UIUtilities.isComplexLayout(charsBuffer, 0, length);
                }
            }
            if (needsTextLayout) {
                TextLayout layout = UIUtilities.createTextLayout(c, string, fm.getFont(), fm.getFontRenderContext());
                return (int)layout.getAdvance();
            }
            return fm.stringWidth(string);
        }
        return 0;
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        if (string != null && !string.equals("")) {
            int textWidth = UIUtilities.stringWidth(c, fm, string);
            return textWidth > availTextWidth ? UIUtilities.clipString(c, fm, string, availTextWidth) : string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        boolean needsTextLayout;
        String clipString = "...";
        if ((availTextWidth -= UIUtilities.stringWidth(c, fm, clipString)) <= 0) {
            return clipString;
        }
        Object object = charsBufferLock;
        synchronized (object) {
            int stringLength = UIUtilities.syncCharsBuffer(string);
            needsTextLayout = UIUtilities.isComplexLayout(charsBuffer, 0, stringLength);
            if (!needsTextLayout) {
                int width = 0;
                for (int nChars = 0; nChars < stringLength; ++nChars) {
                    if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                    string = string.substring(0, nChars);
                    break;
                }
            }
        }
        if (needsTextLayout) {
            AttributedString aString = new AttributedString(string);
            if (c != null) {
                aString.addAttribute(TextAttribute.NUMERIC_SHAPING, c.getClientProperty(TextAttribute.NUMERIC_SHAPING));
            }
            LineBreakMeasurer measurer = new LineBreakMeasurer(aString.getIterator(), BreakIterator.getCharacterInstance(), UIUtilities.getFontRenderContext(c, fm));
            string = string.substring(0, measurer.nextOffset(availTextWidth));
        }
        return string + clipString;
    }

    private static TextLayout createTextLayout(JComponent c, String s, Font f, FontRenderContext frc) {
        Object shaper;
        Object object = shaper = c == null ? null : c.getClientProperty(TextAttribute.NUMERIC_SHAPING);
        if (shaper == null) {
            return new TextLayout(s, f, frc);
        }
        HashMap<TextAttribute, Object> a = new HashMap<TextAttribute, Object>();
        a.put(TextAttribute.FONT, f);
        a.put(TextAttribute.NUMERIC_SHAPING, shaper);
        return new TextLayout(s, a, frc);
    }

    public static FontRenderContext getFontRenderContext(Component c) {
        return c == null ? DEFAULT_FRC : c.getFontMetrics(c.getFont()).getFontRenderContext();
    }

    private static FontRenderContext getFontRenderContext(Component c, FontMetrics fm) {
        assert (fm != null || c != null);
        return fm != null ? fm.getFontRenderContext() : UIUtilities.getFontRenderContext(c);
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        if (anchor == -1) {
            anchor = lead;
        }
        if (lead == -1) {
            model.setAnchorSelectionIndex(-1);
            model.setLeadSelectionIndex(-1);
        } else {
            if (model.isSelectedIndex(lead)) {
                model.addSelectionInterval(lead, lead);
            } else {
                model.removeSelectionInterval(lead, lead);
            }
            model.setAnchorSelectionIndex(anchor);
        }
    }

    public static int loc2IndexFileList(JList<?> list, Point point) {
        boolean bySize;
        int index = list.locationToIndex(point);
        if (index != -1 && (bySize = PropertyUtil.getBooleanProperty(list, (String)"List.isFileList")) && !UIUtilities.pointIsInActualBounds(list, index, point)) {
            index = -1;
        }
        return index;
    }

    private static <T> boolean pointIsInActualBounds(JList<T> list, int index, Point point) {
        ListCellRenderer<T> renderer = list.getCellRenderer();
        T value = list.getModel().getElementAt(index);
        Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
        Dimension itemSize = item.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!item.getComponentOrientation().isLeftToRight()) {
            cellBounds.x += cellBounds.width - itemSize.width;
        }
        cellBounds.width = itemSize.width;
        return cellBounds.contains(point);
    }

    public static boolean pointOutsidePrefSize(JTable table, int row, int column, Point p) {
        if (table.convertColumnIndexToModel(column) != 0 || row == -1) {
            return true;
        }
        TableCellRenderer tcr = table.getCellRenderer(row, column);
        Object value = table.getValueAt(row, column);
        Component cell = tcr.getTableCellRendererComponent(table, value, false, false, row, column);
        Dimension itemSize = cell.getPreferredSize();
        Rectangle cellBounds = table.getCellRect(row, column, false);
        cellBounds.width = itemSize.width;
        cellBounds.height = itemSize.height;
        assert (p.x >= cellBounds.x && p.y >= cellBounds.y);
        return p.x > cellBounds.x + cellBounds.width || p.y > cellBounds.y + cellBounds.height;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        if (comp != null) {
            if (comp.isFocusTraversable()) {
                UIUtilities.compositeRequestFocus(comp);
                return true;
            }
            return comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus();
        }
        return false;
    }

    public static void setSkipClickCount(Component comp, int count) {
        if (comp instanceof JTextComponent && ((JTextComponent)comp).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)comp).putClientProperty(SKIP_CLICK_COUNT, count);
        }
    }

    static {
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
        BASICMENUITEMUI_MAX_TEXT_OFFSET = new StringUIClientPropertyKey("maxTextOffset");
        charsBufferLock = new Object();
        charsBuffer = new char[100];
    }

    private static class LSBCacheEntry {
        private static final char[] oneChar = new char[1];
        private final byte[] lsbCache = new byte[1];
        private Font font;
        private FontRenderContext frc;

        public LSBCacheEntry(FontRenderContext frc, Font font) {
            this.reset(frc, font);
        }

        public void reset(FontRenderContext frc, Font font) {
            this.font = font;
            this.frc = frc;
            for (int counter = this.lsbCache.length - 1; counter >= 0; --counter) {
                this.lsbCache[counter] = 127;
            }
        }

        public int getLeftSideBearing(char aChar) {
            int index = aChar - 87;
            assert (index == 0);
            byte lsb = this.lsbCache[index];
            if (lsb == 127) {
                Object aaHint;
                LSBCacheEntry.oneChar[0] = aChar;
                GlyphVector gv = this.font.createGlyphVector(this.frc, oneChar);
                lsb = (byte)gv.getGlyphPixelBounds((int)0, (FontRenderContext)this.frc, (float)0.0f, (float)0.0f).x;
                if (lsb < 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                    lsb = (byte)(lsb + 1);
                }
                this.lsbCache[index] = lsb;
            }
            return lsb;
        }

        public boolean equals(Object entry) {
            if (entry == this) {
                return true;
            }
            if (!(entry instanceof LSBCacheEntry)) {
                return false;
            }
            LSBCacheEntry oEntry = (LSBCacheEntry)entry;
            return this.font.equals(oEntry.font) && this.frc.equals(oEntry.frc);
        }

        public int hashCode() {
            int result = 17;
            if (this.font != null) {
                result = 37 * result + this.font.hashCode();
            }
            if (this.frc != null) {
                result = 37 * result + this.frc.hashCode();
            }
            return result;
        }
    }
}

