/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.plaf.ext;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import org.pbjar.jxlayer.plaf.ext.AbstractLayerUI;

public class MouseEventUI<V extends JComponent>
extends AbstractLayerUI<V> {
    private Component lastEnteredTarget;
    private Component lastPressedTarget;
    private boolean dispatchingMode = false;
    private JLayer<? extends V> installedLayer;

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return c.inside(x, y);
    }

    @Override
    public void installUI(JComponent component) throws IllegalStateException {
        super.installUI(component);
        if (this.installedLayer != null) {
            throw new IllegalStateException(this.getClass().getName() + " cannot be shared between multiple layers");
        }
        this.installedLayer = (JLayer)component;
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.installedLayer = null;
        super.uninstallUI(c);
    }

    @Override
    public long getLayerEventMask() {
        return 131120L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent event, JLayer<? extends V> layer) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (!this.dispatchingMode) {
                this.dispatchingMode = true;
                try {
                    this.redispatch(mouseEvent, layer);
                }
                finally {
                    this.dispatchingMode = false;
                }
            } else if (504 == mouseEvent.getID() || 505 == mouseEvent.getID()) {
                layer.getGlassPane().setCursor(null);
            } else {
                Component component = mouseEvent.getComponent();
                layer.getGlassPane().setCursor(component.getCursor());
            }
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent event, JLayer<? extends V> jxlayer) {
        if (!event.isConsumed()) {
            event.consume();
            Component target = event.getComponent();
            Component newTarget = this.findWheelListenerComponent(target);
            if (newTarget == null) {
                newTarget = jxlayer.getParent();
            }
            Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), newTarget);
            newTarget.dispatchEvent(this.createMouseWheelEvent(event, point, newTarget));
        }
    }

    private Point calculateTargetPoint(JLayer<? extends V> layer, MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        SwingUtilities.convertPointFromScreen(point, layer);
        return this.transformPoint(layer, point);
    }

    private MouseWheelEvent createMouseWheelEvent(MouseWheelEvent mouseWheelEvent, Point point, Component target) {
        return new MouseWheelEvent(target, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
    }

    private void dispatchMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Component target = mouseEvent.getComponent();
            target.dispatchEvent(mouseEvent);
        }
    }

    private Component findWheelListenerComponent(Component target) {
        if (target == null) {
            return null;
        }
        if (target.getMouseWheelListeners().length == 0) {
            return this.findWheelListenerComponent(target.getParent());
        }
        return target;
    }

    private void generateEnterExitEvents(JLayer<? extends V> layer, MouseEvent originalEvent, Component newTarget, Point realPoint) {
        if (this.lastEnteredTarget != newTarget) {
            this.dispatchMouseEvent(this.transformMouseEvent(layer, originalEvent, this.lastEnteredTarget, realPoint, 505));
            this.lastEnteredTarget = newTarget;
            this.dispatchMouseEvent(this.transformMouseEvent(layer, originalEvent, this.lastEnteredTarget, realPoint, 504));
        }
    }

    private Component getListeningComponent(MouseEvent event, Component component) {
        Component comp;
        switch (event.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                comp = this.getMouseListeningComponent(component);
                break;
            }
            case 503: 
            case 506: {
                comp = this.getMouseMotionListeningComponent(component);
                break;
            }
            case 507: {
                comp = this.getMouseWheelListeningComponent(component);
                break;
            }
            default: {
                comp = null;
            }
        }
        return comp;
    }

    private Component getMouseListeningComponent(Component component) {
        if (component.getMouseListeners().length > 0) {
            return component;
        }
        Container parent = component.getParent();
        if (parent != null) {
            return this.getMouseListeningComponent(parent);
        }
        return null;
    }

    private Component getMouseMotionListeningComponent(Component component) {
        if (component.getMouseMotionListeners().length > 0 || component.getMouseListeners().length > 0) {
            return component;
        }
        Container parent = component.getParent();
        if (parent != null) {
            return this.getMouseMotionListeningComponent(parent);
        }
        return null;
    }

    private Component getMouseWheelListeningComponent(Component component) {
        if (component.getMouseWheelListeners().length > 0) {
            return component;
        }
        Container parent = component.getParent();
        if (parent != null) {
            return this.getMouseWheelListeningComponent(parent);
        }
        return null;
    }

    private Component getTarget(JLayer<? extends V> layer, Point targetPoint) {
        V view = layer.getView();
        if (view == null) {
            return null;
        }
        Point viewPoint = SwingUtilities.convertPoint(layer, targetPoint, view);
        return SwingUtilities.getDeepestComponentAt(view, viewPoint.x, viewPoint.y);
    }

    private void redispatch(MouseEvent originalEvent, JLayer<? extends V> layer) {
        if (layer.getView() != null) {
            if (originalEvent.getComponent() != layer.getGlassPane()) {
                originalEvent.consume();
            }
            MouseEvent newEvent = null;
            Point realPoint = this.calculateTargetPoint(layer, originalEvent);
            Component realTarget = this.getTarget(layer, realPoint);
            if (realTarget != null) {
                realTarget = this.getListeningComponent(originalEvent, realTarget);
            }
            switch (originalEvent.getID()) {
                case 501: {
                    newEvent = this.transformMouseEvent(layer, originalEvent, realTarget, realPoint);
                    if (newEvent == null) break;
                    this.lastPressedTarget = newEvent.getComponent();
                    break;
                }
                case 502: {
                    newEvent = this.transformMouseEvent(layer, originalEvent, this.lastPressedTarget, realPoint);
                    this.lastPressedTarget = null;
                    break;
                }
                case 504: 
                case 505: {
                    this.generateEnterExitEvents(layer, originalEvent, realTarget, realPoint);
                    break;
                }
                case 503: {
                    newEvent = this.transformMouseEvent(layer, originalEvent, realTarget, realPoint);
                    this.generateEnterExitEvents(layer, originalEvent, realTarget, realPoint);
                    break;
                }
                case 506: {
                    newEvent = this.transformMouseEvent(layer, originalEvent, this.lastPressedTarget, realPoint);
                    this.generateEnterExitEvents(layer, originalEvent, realTarget, realPoint);
                    break;
                }
                case 500: {
                    newEvent = this.transformMouseEvent(layer, originalEvent, realTarget, realPoint);
                    break;
                }
                case 507: {
                    this.redispatchMouseWheelEvent((MouseWheelEvent)originalEvent, realTarget, layer);
                }
            }
            this.dispatchMouseEvent(newEvent);
        }
    }

    private void redispatchMouseWheelEvent(MouseWheelEvent mouseWheelEvent, Component target, JLayer<? extends V> layer) {
        MouseWheelEvent newEvent = this.transformMouseWheelEvent(mouseWheelEvent, target, layer);
        this.processMouseWheelEvent(newEvent, layer);
    }

    private MouseEvent transformMouseEvent(JLayer<? extends V> layer, MouseEvent mouseEvent, Component target, Point realPoint) {
        return this.transformMouseEvent(layer, mouseEvent, target, realPoint, mouseEvent.getID());
    }

    private MouseEvent transformMouseEvent(JLayer<? extends V> layer, MouseEvent mouseEvent, Component target, Point targetPoint, int id) {
        if (target == null) {
            return null;
        }
        Point newPoint = new Point(targetPoint);
        SwingUtilities.convertPointToScreen(newPoint, layer);
        SwingUtilities.convertPointFromScreen(newPoint, target);
        return new MouseEvent(target, id, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), newPoint.x, newPoint.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    private MouseWheelEvent transformMouseWheelEvent(MouseWheelEvent mouseWheelEvent, Component t, JLayer<? extends V> layer) {
        JLayer<? extends V> target = t;
        if (target == null) {
            target = layer;
        }
        Point point = SwingUtilities.convertPoint(mouseWheelEvent.getComponent(), mouseWheelEvent.getPoint(), target);
        return this.createMouseWheelEvent(mouseWheelEvent, point, target);
    }

    private Point transformPoint(JLayer<? extends V> layer, Point point) {
        AffineTransform transform = this.getTransform(layer);
        if (transform != null) {
            try {
                transform.inverseTransform(point, point);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
        return point;
    }

    protected JLayer<? extends V> getInstalledLayer() {
        return this.installedLayer;
    }
}

