/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.fsm;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.basic.fsm.Action;
import org.glassfish.pfl.basic.fsm.FSM;
import org.glassfish.pfl.basic.fsm.Guard;
import org.glassfish.pfl.basic.fsm.Input;
import org.glassfish.pfl.basic.fsm.Runner;
import org.glassfish.pfl.basic.fsm.State;
import org.glassfish.pfl.basic.fsm.Transition;

public class StateEngine {
    private static Action emptyAction = new Action.Base("Empty"){

        @Override
        public void doIt(FSM fsm, Input in) {
        }
    };
    private boolean initializing = true;
    private Action defaultAction = new Action.Base("Invalid Transition"){

        @Override
        public void doIt(FSM fsm, Input in) {
            throw new IllegalStateException("Invalid transition attempted from " + fsm.getState() + " under " + in);
        }
    };
    private Map<State.Kind, Set<State>> stateKinds = new EnumMap<State.Kind, Set<State>>(State.Kind.class);
    private Map<State.Kind, Set<State>> unmodifiableStateKinds;

    public static StateEngine create() {
        return new StateEngine();
    }

    private StateEngine() {
        EnumMap map = new EnumMap(State.Kind.class);
        for (State.Kind kind : (State.Kind[])State.Kind.class.getEnumConstants()) {
            HashSet states = new HashSet();
            this.stateKinds.put(kind, states);
            map.put(kind, Collections.unmodifiableSet(states));
        }
        this.unmodifiableStateKinds = Collections.unmodifiableMap(this.stateKinds);
    }

    private void dprint(String msg) {
        System.out.println("StateEngine: " + msg);
    }

    private Set<State> getKindSet(State.Kind kind) {
        Set<State> result = this.stateKinds.get((Object)kind);
        return result;
    }

    private void updateStateMap(State oldState, State newState) {
        if (oldState.getKind() == State.Kind.FINAL) {
            throw new IllegalStateException("Cannot create a transition that leaves a final state");
        }
        if (oldState.getKind() == State.Kind.REFERENCE) {
            throw new IllegalStateException("Cannot create a transition that leaves a reference state");
        }
        Set<State> oldKindSet = this.getKindSet(oldState.getKind());
        oldKindSet.add(oldState);
        Set<State> newKindSet = this.getKindSet(newState.getKind());
        newKindSet.add(newState);
    }

    public Set<State> getStates(State.Kind kind) {
        return this.unmodifiableStateKinds.get((Object)kind);
    }

    public StateEngine add(State oldState, Input input, Guard guard, Action action, State newState) {
        this.mustBeInitializing();
        this.updateStateMap(oldState, newState);
        Transition ga = new Transition(guard, action, newState);
        oldState.addTransition(input, ga);
        return this;
    }

    public StateEngine add(State oldState, Set<Input> input, Guard guard, Action action, State newState) {
        for (Input in : input) {
            this.add(oldState, in, guard, action, newState);
        }
        return this;
    }

    public StateEngine add(State oldState, Input input, Action action, State newState) {
        this.mustBeInitializing();
        this.updateStateMap(oldState, newState);
        Transition ta = new Transition(action, newState);
        oldState.addTransition(input, ta);
        return this;
    }

    public StateEngine add(State oldState, Set<Input> input, Action action, State newState) {
        for (Input in : input) {
            this.add(oldState, in, action, newState);
        }
        return this;
    }

    public StateEngine setDefault(State oldState, Action action, State newState) {
        this.mustBeInitializing();
        oldState.setDefaultAction(action);
        oldState.setDefaultNextState(newState);
        return this;
    }

    public StateEngine setDefault(State oldState, State newState) {
        return this.setDefault(oldState, emptyAction, newState);
    }

    public StateEngine setDefault(State oldState) {
        return this.setDefault(oldState, oldState);
    }

    public void done() {
        this.mustBeInitializing();
        this.initializing = false;
    }

    public void setDefaultAction(Action act) {
        this.mustBeInitializing();
        this.defaultAction = act;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(Runner runner, Input in, boolean debug) {
        FSM fsm = runner.peek();
        if (debug) {
            this.dprint("doIt enter: currentState = " + fsm.getState() + " in = " + in);
        }
        try {
            this.innerDoIt(runner, in, debug);
        }
        finally {
            if (debug) {
                this.dprint("doIt exit");
            }
        }
    }

    private State getDefaultNextState(State currentState) {
        State nextState = currentState.getDefaultNextState();
        if (nextState == null) {
            nextState = currentState;
        }
        return nextState;
    }

    private Action getDefaultAction(State currentState) {
        Action action = currentState.getDefaultAction();
        if (action == null) {
            action = this.defaultAction;
        }
        return action;
    }

    private void innerDoIt(Runner runner, Input in, boolean debug) {
        if (debug) {
            this.dprint("Calling innerDoIt with input " + in);
        }
        FSM fsm = runner.peek();
        State currentState = null;
        State nextState = null;
        Action action = null;
        boolean deferral = false;
        block0: do {
            Set<Transition> gas;
            deferral = false;
            currentState = fsm.getState();
            nextState = this.getDefaultNextState(currentState);
            action = this.getDefaultAction(currentState);
            if (debug) {
                this.dprint("currentState      = " + currentState);
                this.dprint("in                = " + in);
                this.dprint("default nextState = " + nextState);
                this.dprint("default action    = " + action);
            }
            if ((gas = currentState.getTransitions(in)) == null) continue;
            for (Transition ga : gas) {
                Guard.Result gr = ga.getGuard().evaluate(fsm, in);
                if (debug) {
                    this.dprint("doIt: evaluated " + ga + " with result " + (Object)((Object)gr));
                }
                if (gr == Guard.Result.ENABLED) {
                    nextState = ga.getNextState();
                    action = ga.getAction();
                    if (!debug) continue block0;
                    this.dprint("nextState = " + nextState);
                    this.dprint("action    = " + action);
                    continue block0;
                }
                if (gr != Guard.Result.DEFERRED) continue;
                deferral = true;
                continue block0;
            }
        } while (deferral);
        this.performStateTransition(runner, in, nextState, action, debug);
        fsm = runner.peek();
        State state = fsm.getState();
        if (state.getKind() == State.Kind.FINAL) {
            runner.pop();
            FSM nextFSM = runner.peek();
            if (nextFSM == null) {
                return;
            }
            State st1 = nextFSM.getState();
            State newState = st1.returnAction(nextFSM, fsm);
            StateEngine se = nextFSM.getStateEngine();
            se.performStateTransition(runner, null, newState, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performStateTransition(Runner runner, Input in, State nextState, Action action, boolean debug) {
        boolean different;
        FSM fsm;
        block17: {
            fsm = runner.peek();
            State currentState = fsm.getState();
            boolean bl = different = !currentState.equals(nextState);
            if (different) {
                if (debug) {
                    this.dprint("doIt: executing postAction for state " + currentState);
                }
                try {
                    currentState.postAction(fsm);
                }
                catch (Throwable thr) {
                    if (!debug) break block17;
                    this.dprint("doIt: postAction threw " + thr);
                }
            }
        }
        try {
            if (action != null) {
                action.doIt(fsm, in);
            }
        }
        finally {
            if (different) {
                FSM newFSM;
                block19: {
                    if (debug) {
                        this.dprint("doIt: executing preAction for state " + nextState);
                    }
                    newFSM = null;
                    try {
                        newFSM = nextState.preAction(fsm);
                    }
                    catch (Throwable thr) {
                        if (!debug) break block19;
                        this.dprint("doIt: preAction threw " + thr);
                    }
                }
                if (newFSM == null) {
                    fsm.setState(nextState);
                } else {
                    runner.push(newFSM);
                }
            }
            if (debug) {
                this.dprint("doIt: state is now " + nextState);
            }
        }
    }

    private void mustBeInitializing() {
        if (!this.initializing) {
            throw new IllegalStateException("Invalid method call after initialization completed");
        }
    }

    private void mustNotBeInitializing() {
        if (this.initializing) {
            throw new IllegalStateException("Invalid method call before initialization completed");
        }
    }
}

