/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.putty;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.impl.AbstractIdentityResourceLoader;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.putty.PuttyKeyPairResourceParser;
import org.apache.sshd.putty.PuttyKeyReader;

public abstract class AbstractPuttyKeyDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractIdentityResourceLoader<PUB, PRV>
implements PuttyKeyPairResourceParser<PUB, PRV> {
    public static final String ENCRYPTION_HEADER = "Encryption";

    protected AbstractPuttyKeyDecoder(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        super(pubType, prvType, names);
    }

    @Override
    public boolean canExtractKeyPairs(NamedResource resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        if (!PuttyKeyPairResourceParser.super.canExtractKeyPairs(resourceKey, lines)) {
            return false;
        }
        for (String l : lines) {
            if (!(l = GenericUtils.trimToEmpty((String)l)).startsWith("PuTTY-User-Key-File-")) continue;
            int pos = l.indexOf(58);
            if (pos <= 0 || pos >= l.length() - 1) {
                return false;
            }
            NavigableSet supported = this.getSupportedKeyTypes();
            String typeValue = l.substring(pos + 1).trim();
            return supported.contains(typeValue);
        }
        return false;
    }

    public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        List<String> pubLines = Collections.emptyList();
        List<String> prvLines = Collections.emptyList();
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String prvEncryption = null;
        int formatVersion = -1;
        int numLines = lines.size();
        block10: for (int index = 0; index < numLines; ++index) {
            String l = lines.get(index);
            int pos = (l = GenericUtils.trimToEmpty((String)l)).indexOf(58);
            if (pos <= 0 || pos >= l.length() - 1) continue;
            String hdrName = l.substring(0, pos).trim();
            String hdrValue = l.substring(pos + 1).trim();
            headers.put(hdrName, hdrValue);
            if (hdrName.startsWith("PuTTY-User-Key-File-")) {
                String versionValue = hdrName.substring("PuTTY-User-Key-File-".length());
                int fileVersion = Integer.parseInt(versionValue);
                if (formatVersion >= 0 && fileVersion != formatVersion) {
                    throw new InvalidKeySpecException("Inconsistent key file version specification: " + formatVersion + " and " + fileVersion);
                }
                formatVersion = fileVersion;
            }
            switch (hdrName) {
                case "Encryption": {
                    if (prvEncryption != null) {
                        throw new StreamCorruptedException("Duplicate " + hdrName + " in" + resourceKey);
                    }
                    prvEncryption = hdrValue;
                    continue block10;
                }
                case "Public-Lines": {
                    pubLines = AbstractPuttyKeyDecoder.extractDataLines(resourceKey, lines, index + 1, hdrName, hdrValue, pubLines);
                    index += pubLines.size();
                    continue block10;
                }
                case "Private-Lines": {
                    prvLines = AbstractPuttyKeyDecoder.extractDataLines(resourceKey, lines, index + 1, hdrName, hdrValue, prvLines);
                    index += prvLines.size();
                    continue block10;
                }
            }
        }
        return this.loadKeyPairs(session, resourceKey, formatVersion, pubLines, prvLines, prvEncryption, passwordProvider, headers);
    }

    public static List<String> extractDataLines(NamedResource resourceKey, List<String> lines, int startIndex, String hdrName, String hdrValue, List<String> curLines) throws IOException {
        int numLines;
        if (GenericUtils.size(curLines) > 0) {
            throw new StreamCorruptedException("Duplicate " + hdrName + " in " + resourceKey);
        }
        try {
            numLines = Integer.parseInt(hdrValue);
        }
        catch (NumberFormatException e) {
            throw new StreamCorruptedException("Bad " + hdrName + " value (" + hdrValue + ") in " + resourceKey);
        }
        int endIndex = startIndex + numLines;
        int totalLines = lines.size();
        if (endIndex > totalLines) {
            throw new StreamCorruptedException("Excessive " + hdrName + " value (" + hdrValue + ") in " + resourceKey);
        }
        return lines.subList(startIndex, endIndex);
    }

    public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, int formatVersion, List<String> pubLines, List<String> prvLines, String prvEncryption, FilePasswordProvider passwordProvider, Map<String, String> headers) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(session, resourceKey, formatVersion, KeyPairResourceParser.joinDataLines(pubLines), KeyPairResourceParser.joinDataLines(prvLines), prvEncryption, passwordProvider, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, int formatVersion, String pubData, String prvData, String prvEncryption, FilePasswordProvider passwordProvider, Map<String, String> headers) throws IOException, GeneralSecurityException {
        Base64.Decoder b64Decoder = Base64.getDecoder();
        byte[] pubBytes = b64Decoder.decode(pubData);
        byte[] prvBytes = b64Decoder.decode(prvData);
        if (GenericUtils.isEmpty((CharSequence)prvEncryption) || "none".equalsIgnoreCase(prvEncryption)) {
            try {
                Collection<KeyPair> collection = this.loadKeyPairs(resourceKey, formatVersion, pubBytes, prvBytes, headers);
                return collection;
            }
            finally {
                Arrays.fill(prvBytes, (byte)0);
            }
        }
        int pos = prvEncryption.indexOf(45);
        if (pos <= 0) {
            throw new StreamCorruptedException("Missing private key encryption mode in " + prvEncryption);
        }
        String mode = prvEncryption.substring(pos + 1).toUpperCase();
        String algName = null;
        int numBits = 0;
        for (int index = 0; index < pos; ++index) {
            char ch = prvEncryption.charAt(index);
            if (ch < '0' || ch > '9') continue;
            algName = prvEncryption.substring(0, index).toUpperCase();
            numBits = Integer.parseInt(prvEncryption.substring(index, pos));
            break;
        }
        if (GenericUtils.isEmpty(algName) || numBits <= 0) {
            throw new StreamCorruptedException("Missing private key encryption algorithm details in " + prvEncryption);
        }
        String algorithm = algName;
        int bits = numBits;
        Collection keys = (Collection)passwordProvider.decode(session, resourceKey, password -> {
            byte[] decBytes = PuttyKeyPairResourceParser.decodePrivateKeyBytes(formatVersion, prvBytes, algorithm, bits, mode, password, headers);
            try {
                Collection<KeyPair> collection = this.loadKeyPairs(resourceKey, formatVersion, pubBytes, decBytes, headers);
                return collection;
            }
            finally {
                Arrays.fill(decBytes, (byte)0);
            }
        });
        return keys == null ? Collections.emptyList() : keys;
    }

    /*
     * Exception decompiling
     */
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, int formatVersion, byte[] pubData, byte[] prvData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, int formatVersion, InputStream pubData, InputStream prvData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract Collection<KeyPair> loadKeyPairs(NamedResource var1, int var2, PuttyKeyReader var3, PuttyKeyReader var4, Map<String, String> var5) throws IOException, GeneralSecurityException;
}

