/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters.kex;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.DefaultIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.filters.kex.KexFilter;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.slf4j.Logger;

class KexOutputHandler
implements OutputHandler {
    private static ExecutorService flushRunner = ThreadUtils.newCachedThreadPool((String)"kex-flusher");
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private final KexFilter filter;
    private final Logger log;
    private final Queue<PendingWriteFuture> pendingPackets = new ConcurrentLinkedQueue<PendingWriteFuture>();
    private final AtomicBoolean kexFlushed = new AtomicBoolean(true);
    private final AtomicBoolean shutDown = new AtomicBoolean();
    private final AtomicReference<DefaultKeyExchangeFuture> kexFlushedFuture = new AtomicReference();

    KexOutputHandler(KexFilter filter, Logger log) {
        this.filter = Objects.requireNonNull(filter);
        this.log = Objects.requireNonNull(log);
        DefaultKeyExchangeFuture initialFuture = new DefaultKeyExchangeFuture(this.toString(), null);
        initialFuture.setValue(Boolean.TRUE);
        this.kexFlushedFuture.set(initialFuture);
    }

    void updateState(Runnable update) {
        this.updateState(() -> {
            update.run();
            return null;
        });
    }

    <V> V updateState(Supplier<V> update) {
        this.lock.writeLock().lock();
        try {
            V v = update.get();
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    DefaultKeyExchangeFuture initNewKeyExchange() {
        return this.updateState(() -> {
            this.kexFlushed.set(false);
            return this.kexFlushedFuture.getAndSet(new DefaultKeyExchangeFuture(this.filter.getSession().toString(), this.filter.getSession().getFutureLock()));
        });
    }

    AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture> terminateKeyExchange() {
        return this.updateState(() -> {
            int numPending = this.pendingPackets.size();
            if (numPending == 0) {
                this.kexFlushed.set(true);
            }
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(numPending, this.kexFlushedFuture.get());
        });
    }

    public void shutdown() {
        this.shutDown.set(true);
        AbstractMap.SimpleImmutableEntry items = this.updateState(() -> {
            this.kexFlushed.set(true);
            return new AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture>(this.pendingPackets.size(), this.kexFlushedFuture.get());
        });
        ((DefaultKeyExchangeFuture)items.getValue()).setValue((Integer)items.getKey() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture send(int cmd, Buffer buffer) throws IOException {
        boolean isLowLevelMessage = cmd <= 49 && cmd != 5 && cmd != 6;
        IoWriteFuture future = null;
        try {
            if (isLowLevelMessage) {
                future = this.filter.write(cmd, buffer);
                this.filter.startKexIfNeeded();
            } else {
                future = this.writeOrEnqueue(cmd, buffer);
                if (!(future instanceof PendingWriteFuture)) {
                    this.filter.startKexIfNeeded();
                }
            }
        }
        finally {
            this.filter.getSession().resetIdleTimeout();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoWriteFuture writeOrEnqueue(int cmd, Buffer buffer) throws IOException {
        this.lock.readLock().lock();
        try {
            boolean kexDone;
            if (this.shutDown.get()) {
                throw new SshException("Write attempt on closing session: " + SshConstants.getCommandMessageName((int)cmd));
            }
            KexState state = this.filter.getKexState().get();
            boolean bl = kexDone = KexState.DONE.equals((Object)state) || KexState.KEYS.equals((Object)state);
            if (kexDone && this.kexFlushed.get()) {
                IoWriteFuture ioWriteFuture = this.filter.write(cmd, buffer);
                return ioWriteFuture;
            }
            if (this.log.isDebugEnabled()) {
                if (kexDone) {
                    this.log.debug("writeOrEnqueue({})[{}]: Queuing packet while flushing", (Object)this.filter.getSession(), (Object)SshConstants.getCommandMessageName((int)cmd));
                } else {
                    this.log.debug("writeOrEnqueue({})[{}]: Queuing packet", (Object)this.filter.getSession(), (Object)SshConstants.getCommandMessageName((int)cmd));
                }
            }
            PendingWriteFuture pendingWriteFuture = this.enqueuePendingPacket(cmd, buffer);
            return pendingWriteFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private PendingWriteFuture enqueuePendingPacket(int cmd, Buffer buffer) {
        String cmdName = SshConstants.getCommandMessageName((int)cmd);
        PendingWriteFuture future = new PendingWriteFuture(cmdName, buffer);
        this.pendingPackets.add(future);
        int numPending = this.pendingPackets.size();
        if (this.log.isDebugEnabled()) {
            if (numPending == 1) {
                this.log.debug("enqueuePendingPacket({})[{}] Start flagging packets as pending until key exchange is done", (Object)this.filter.getSession(), (Object)cmdName);
            } else {
                this.log.debug("enqueuePendingPacket({})[{}] enqueued until key exchange is done (pending={})", new Object[]{this.filter.getSession(), cmdName, numPending});
            }
        }
        return future;
    }

    void flushQueue(DefaultKeyExchangeFuture flushDone) {
        flushRunner.submit(() -> {
            ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingFutures = new ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>>();
            boolean allFlushed = false;
            DefaultKeyExchangeFuture newFuture = null;
            Serializable error = null;
            try {
                boolean warnedAboutChunkLimit = false;
                int lastSize = -1;
                int take = 2;
                while (!allFlushed) {
                    this.lock.writeLock().lock();
                    try {
                        PendingWriteFuture pending;
                        if (this.pendingPackets.isEmpty()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.filter.getSession());
                            }
                            this.kexFlushed.set(true);
                            allFlushed = true;
                            break;
                        }
                        if (!this.filter.getSession().isOpen()) {
                            this.log.info("flushQueue({}): Session closed while flushing pending packets at end of KEX", (Object)this.filter.getSession());
                            DefaultIoWriteFuture aborted = new DefaultIoWriteFuture((Object)this.filter.getSession(), null);
                            aborted.setValue((Object)new SshException("Session closed while flushing pending packets at end of KEX"));
                            this.drainQueueTo(pendingFutures, (IoWriteFuture)aborted);
                            this.kexFlushed.set(true);
                            error = Boolean.FALSE;
                            break;
                        }
                        DefaultKeyExchangeFuture currentFuture = this.kexFlushedFuture.get();
                        if (currentFuture != flushDone) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("flushQueue({}): Stopping flushing pending packets", (Object)this.filter.getSession());
                            }
                            newFuture = currentFuture;
                            break;
                        }
                        int newSize = this.pendingPackets.size();
                        if (lastSize < 0) {
                            this.log.info("flushQueue({}): {} pending packets to flush", (Object)this.filter.getSession(), (Object)newSize);
                        } else if (newSize >= lastSize) {
                            this.log.info("flushQueue({}): queue size before={} now={}", new Object[]{this.filter.getSession(), lastSize, newSize});
                            if (take < 64) {
                                take *= 2;
                            } else if (!warnedAboutChunkLimit) {
                                warnedAboutChunkLimit = true;
                                this.log.warn("flushQueue({}): maximum queue flush chunk of 64 reached", (Object)this.filter.getSession());
                            }
                        }
                        lastSize = newSize;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("flushQueue({}): flushing {} packets", (Object)this.filter.getSession(), (Object)Math.min(lastSize, take));
                        }
                        for (int i = 0; i < take && (pending = this.pendingPackets.poll()) != null; ++i) {
                            IoWriteFuture written;
                            try {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("flushQueue({}): Flushing a packet at end of KEX for {}", (Object)this.filter.getSession(), pending.getId());
                                }
                                Buffer buf = pending.getBuffer();
                                int cmd = buf.rawByte(buf.rpos()) & 0xFF;
                                written = this.filter.write(cmd, buf);
                                this.filter.startKexIfNeeded();
                            }
                            catch (Throwable e2) {
                                this.log.error("flushQueue({}): Exception while flushing packet at end of KEX for {}", new Object[]{this.filter.getSession(), pending.getId(), e2});
                                AbstractIoWriteFuture aborted = new AbstractIoWriteFuture(pending.getId(), null){};
                                aborted.setValue((Object)e2);
                                pendingFutures.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, 1>(pending, aborted));
                                this.drainQueueTo(pendingFutures, (IoWriteFuture)aborted);
                                this.kexFlushed.set(true);
                                error = e2;
                                this.lock.writeLock().unlock();
                                if (allFlushed) {
                                    flushDone.setValue(Boolean.TRUE);
                                } else if (error != null) {
                                    flushDone.setValue(error);
                                    if (error instanceof Throwable) {
                                        this.filter.getSession().exceptionCaught((Throwable)error);
                                    }
                                } else if (newFuture != null) {
                                    newFuture.addListener(f -> {
                                        Throwable failed = f.getException();
                                        flushDone.setValue(failed != null ? failed : Boolean.TRUE);
                                    });
                                }
                                pendingFutures.forEach(e -> ((IoWriteFuture)e.getValue()).addListener((SshFutureListener)e.getKey()));
                                return;
                            }
                            pendingFutures.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(pending, written));
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("flushQueue({}): Flushed a packet at end of KEX for {}", (Object)this.filter.getSession(), pending.getId());
                            }
                            this.filter.getSession().resetIdleTimeout();
                        }
                        if (!this.pendingPackets.isEmpty()) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("flushQueue({}): All packets at end of KEX flushed", (Object)this.filter.getSession());
                        }
                        this.kexFlushed.set(true);
                        allFlushed = true;
                        break;
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                }
            }
            finally {
                if (allFlushed) {
                    flushDone.setValue(Boolean.TRUE);
                } else if (error != null) {
                    flushDone.setValue(error);
                    if (error instanceof Throwable) {
                        this.filter.getSession().exceptionCaught((Throwable)error);
                    }
                } else if (newFuture != null) {
                    newFuture.addListener(f -> {
                        Throwable failed = f.getException();
                        flushDone.setValue(failed != null ? failed : Boolean.TRUE);
                    });
                }
                pendingFutures.forEach(e -> ((IoWriteFuture)e.getValue()).addListener((SshFutureListener)e.getKey()));
            }
        });
    }

    private void drainQueueTo(List<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingAborted, IoWriteFuture aborted) {
        PendingWriteFuture pending = this.pendingPackets.poll();
        while (pending != null) {
            pendingAborted.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(pending, aborted));
            pending = this.pendingPackets.poll();
        }
    }
}

