/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public abstract class AntArtifact {
    private final Properties PROPS = new Properties();
    private static final Set<String> warnedClasses = Collections.synchronizedSet(new HashSet());

    protected AntArtifact() {
        try {
            if (this.getClass().getMethod("getArtifactLocation", new Class[0]).getDeclaringClass() == AntArtifact.class && this.getClass().getMethod("getArtifactLocations", new Class[0]).getDeclaringClass() == AntArtifact.class) {
                throw new IllegalStateException(this.getClass().getName() + ".getArtifactLocations() must be overridden");
            }
        }
        catch (NoSuchMethodException x) {
            throw new AssertionError((Object)x);
        }
    }

    public abstract String getType();

    public abstract File getScriptLocation();

    public abstract String getTargetName();

    public abstract String getCleanTargetName();

    @Deprecated
    public URI getArtifactLocation() {
        return this.getArtifactLocations()[0];
    }

    public URI[] getArtifactLocations() {
        String name = this.getClass().getName();
        if (warnedClasses.add(name)) {
            Logger.getLogger(AntArtifact.class.getName()).warning(name + ".getArtifactLocations() must be overridden");
        }
        return new URI[]{this.getArtifactLocation()};
    }

    public String getID() {
        return this.getTargetName();
    }

    @Deprecated
    public final FileObject getArtifactFile() {
        FileObject[] fos = this.getArtifactFiles();
        if (fos.length > 0) {
            return fos[0];
        }
        return null;
    }

    private FileObject getArtifactFile(URI artifactLocation) {
        URL artifact;
        assert (!artifactLocation.isAbsolute() || !artifactLocation.isOpaque() && "file".equals(artifactLocation.getScheme())) : artifactLocation;
        try {
            artifact = BaseUtilities.normalizeURI(BaseUtilities.toURI(this.getScriptLocation()).resolve(artifactLocation)).toURL();
        }
        catch (MalformedURLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
            return null;
        }
        FileObject fo = URLMapper.findFileObject(artifact);
        if (fo != null) {
            assert (FileUtil.toFile(fo) != null) : fo;
            return fo;
        }
        return null;
    }

    public final FileObject[] getArtifactFiles() {
        ArrayList<FileObject> l = new ArrayList<FileObject>();
        for (URI artifactLocation : this.getArtifactLocations()) {
            FileObject fo = this.getArtifactFile(artifactLocation);
            if (fo == null) continue;
            l.add(fo);
        }
        return l.toArray(new FileObject[0]);
    }

    public final FileObject getScriptFile() {
        FileObject fo = FileUtil.toFileObject(this.getScriptLocation());
        assert (fo == null || FileUtil.toFile(fo) != null) : fo;
        return fo;
    }

    public Project getProject() {
        return FileOwnerQuery.getOwner(BaseUtilities.toURI(this.getScriptLocation()));
    }

    public Properties getProperties() {
        return this.PROPS;
    }
}

