/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.header;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.StatusLine;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.communication.ODataServerErrorException;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ODataErrorResponseChecker {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataErrorResponseChecker.class);

    private static ODataError getGenericError(int code, String errorMsg) {
        ODataError error = new ODataError();
        error.setCode(String.valueOf(code));
        error.setMessage(errorMsg);
        return error;
    }

    public static ODataRuntimeException checkResponse(ODataClient odataClient, StatusLine statusLine, InputStream entity, ContentType contentType) {
        ODataRuntimeException result;
        ByteArrayInputStream entityForException = null;
        if (entity == null) {
            result = new ODataClientErrorException(statusLine);
        } else {
            ODataError error;
            block9: {
                error = new ODataError();
                if (!contentType.isCompatible(ContentType.TEXT_PLAIN)) {
                    try {
                        Map<String, String> innerError;
                        byte[] bytes = IOUtils.toByteArray(entity);
                        entityForException = new ByteArrayInputStream(bytes);
                        error = odataClient.getReader().readError(new ByteArrayInputStream(bytes), contentType);
                        if (error == null || (innerError = error.getInnerError()) == null) break block9;
                        if (innerError.get("internalexception") != null) {
                            error.setMessage(error.getMessage() + innerError.get("internalexception"));
                            break block9;
                        }
                        error.setMessage(error.getMessage() + innerError.get("message"));
                    }
                    catch (IOException | RuntimeException | ODataDeserializerException e) {
                        LOG.warn("Error deserializing error response", e);
                        error = ODataErrorResponseChecker.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                } else {
                    error.setCode(String.valueOf(statusLine.getStatusCode()));
                    error.setTarget(statusLine.getReasonPhrase());
                    try {
                        error.setMessage(IOUtils.toString(entity));
                    }
                    catch (IOException e) {
                        LOG.warn("Error deserializing error response", e);
                        error = ODataErrorResponseChecker.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                }
            }
            result = !(statusLine.getStatusCode() < 500 || error == null || error.getDetails() != null && !error.getDetails().isEmpty() || error.getInnerError() != null && error.getInnerError().size() != 0) ? new ODataServerErrorException(statusLine, entityForException) : new ODataClientErrorException(statusLine, error, entityForException);
        }
        return result;
    }

    private ODataErrorResponseChecker() {
    }
}

