/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumMember;

@JsonDeserialize(using=EnumMemberDeserializer.class)
class ClientCsdlEnumMember
extends CsdlEnumMember
implements Serializable {
    private static final long serialVersionUID = -6138606817225829791L;

    ClientCsdlEnumMember() {
    }

    static class EnumMemberDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlEnumMember> {
        EnumMemberDeserializer() {
        }

        @Override
        protected CsdlEnumMember doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            CsdlEnumMember member = new CsdlEnumMember();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        member.setName(jp.nextTextValue());
                    } else if ("Value".equals(jp.getCurrentName())) {
                        member.setValue(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        member.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return member;
        }
    }
}

