/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmGuid
extends SingletonPrimitiveType {
    private static final String PATTERN = "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";
    private static final EdmGuid INSTANCE = new EdmGuid();

    public static EdmGuid getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return UUID.class;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : this.validateLiteral(value);
    }

    private boolean validateLiteral(String value) {
        return value.matches(PATTERN);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (!this.validateLiteral(value)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        UUID result = UUID.fromString(value);
        if (returnType.isAssignableFrom(UUID.class)) {
            return returnType.cast(result);
        }
        throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof UUID) {
            return ((UUID)value).toString();
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

