/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.")
public class V2ResourceMetricSource {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    private V2MetricTarget target;

    public V2ResourceMetricSource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V2ResourceMetricSource target(V2MetricTarget target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V2MetricTarget getTarget() {
        return this.target;
    }

    public void setTarget(V2MetricTarget target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ResourceMetricSource v2ResourceMetricSource = (V2ResourceMetricSource)o;
        return Objects.equals(this.name, v2ResourceMetricSource.name) && Objects.equals(this.target, v2ResourceMetricSource.target);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ResourceMetricSource {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

