/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.api;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.common.coder.Coder;
import org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;

public class StateStoreSpec {
    private String name;
    private Coder<?> keyCoder;
    private Coder<?> valCoder;
    private File localStateStoreDir;
    private String stream;
    private boolean isReadonly;
    private ScheduledExecutorService writeIOScheduler;
    private ScheduledExecutorService readIOScheduler;
    private ScheduledExecutorService checkpointIOScheduler;
    private CheckpointStore checkpointStore;
    private Duration checkpointDuration;
    private Map<String, Object> configs;
    private boolean checkpointChecksumEnable;
    private boolean checkpointChecksumCompatible;
    private boolean localStorageCleanupEnable;
    private Duration checkpointRestoreIdleLimit;
    private int ttlSeconds;

    private static Duration $default$checkpointDuration() {
        return Duration.ofMinutes(1L);
    }

    private static boolean $default$checkpointChecksumEnable() {
        return true;
    }

    private static boolean $default$checkpointChecksumCompatible() {
        return true;
    }

    private static boolean $default$localStorageCleanupEnable() {
        return false;
    }

    private static Duration $default$checkpointRestoreIdleLimit() {
        return Duration.ofMinutes(5L);
    }

    private static int $default$ttlSeconds() {
        return 0;
    }

    StateStoreSpec(String name, Coder<?> keyCoder, Coder<?> valCoder, File localStateStoreDir, String stream, boolean isReadonly, ScheduledExecutorService writeIOScheduler, ScheduledExecutorService readIOScheduler, ScheduledExecutorService checkpointIOScheduler, CheckpointStore checkpointStore, Duration checkpointDuration, Map<String, Object> configs, boolean checkpointChecksumEnable, boolean checkpointChecksumCompatible, boolean localStorageCleanupEnable, Duration checkpointRestoreIdleLimit, int ttlSeconds) {
        this.name = name;
        this.keyCoder = keyCoder;
        this.valCoder = valCoder;
        this.localStateStoreDir = localStateStoreDir;
        this.stream = stream;
        this.isReadonly = isReadonly;
        this.writeIOScheduler = writeIOScheduler;
        this.readIOScheduler = readIOScheduler;
        this.checkpointIOScheduler = checkpointIOScheduler;
        this.checkpointStore = checkpointStore;
        this.checkpointDuration = checkpointDuration;
        this.configs = configs;
        this.checkpointChecksumEnable = checkpointChecksumEnable;
        this.checkpointChecksumCompatible = checkpointChecksumCompatible;
        this.localStorageCleanupEnable = localStorageCleanupEnable;
        this.checkpointRestoreIdleLimit = checkpointRestoreIdleLimit;
        this.ttlSeconds = ttlSeconds;
    }

    public static StateStoreSpecBuilder builder() {
        return new StateStoreSpecBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Coder<?> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<?> getValCoder() {
        return this.valCoder;
    }

    public File getLocalStateStoreDir() {
        return this.localStateStoreDir;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public ScheduledExecutorService getWriteIOScheduler() {
        return this.writeIOScheduler;
    }

    public ScheduledExecutorService getReadIOScheduler() {
        return this.readIOScheduler;
    }

    public ScheduledExecutorService getCheckpointIOScheduler() {
        return this.checkpointIOScheduler;
    }

    public CheckpointStore getCheckpointStore() {
        return this.checkpointStore;
    }

    public Duration getCheckpointDuration() {
        return this.checkpointDuration;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public boolean isCheckpointChecksumEnable() {
        return this.checkpointChecksumEnable;
    }

    public boolean isCheckpointChecksumCompatible() {
        return this.checkpointChecksumCompatible;
    }

    public boolean isLocalStorageCleanupEnable() {
        return this.localStorageCleanupEnable;
    }

    public Duration getCheckpointRestoreIdleLimit() {
        return this.checkpointRestoreIdleLimit;
    }

    public int getTtlSeconds() {
        return this.ttlSeconds;
    }

    public static class StateStoreSpecBuilder {
        private String name;
        private Coder<?> keyCoder;
        private Coder<?> valCoder;
        private File localStateStoreDir;
        private String stream;
        private boolean isReadonly;
        private ScheduledExecutorService writeIOScheduler;
        private ScheduledExecutorService readIOScheduler;
        private ScheduledExecutorService checkpointIOScheduler;
        private CheckpointStore checkpointStore;
        private boolean checkpointDuration$set;
        private Duration checkpointDuration$value;
        private ArrayList<String> configs$key;
        private ArrayList<Object> configs$value;
        private boolean checkpointChecksumEnable$set;
        private boolean checkpointChecksumEnable$value;
        private boolean checkpointChecksumCompatible$set;
        private boolean checkpointChecksumCompatible$value;
        private boolean localStorageCleanupEnable$set;
        private boolean localStorageCleanupEnable$value;
        private boolean checkpointRestoreIdleLimit$set;
        private Duration checkpointRestoreIdleLimit$value;
        private boolean ttlSeconds$set;
        private int ttlSeconds$value;

        StateStoreSpecBuilder() {
        }

        public StateStoreSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StateStoreSpecBuilder keyCoder(Coder<?> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        public StateStoreSpecBuilder valCoder(Coder<?> valCoder) {
            this.valCoder = valCoder;
            return this;
        }

        public StateStoreSpecBuilder localStateStoreDir(File localStateStoreDir) {
            this.localStateStoreDir = localStateStoreDir;
            return this;
        }

        public StateStoreSpecBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public StateStoreSpecBuilder isReadonly(boolean isReadonly) {
            this.isReadonly = isReadonly;
            return this;
        }

        public StateStoreSpecBuilder writeIOScheduler(ScheduledExecutorService writeIOScheduler) {
            this.writeIOScheduler = writeIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder readIOScheduler(ScheduledExecutorService readIOScheduler) {
            this.readIOScheduler = readIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder checkpointIOScheduler(ScheduledExecutorService checkpointIOScheduler) {
            this.checkpointIOScheduler = checkpointIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder checkpointStore(CheckpointStore checkpointStore) {
            this.checkpointStore = checkpointStore;
            return this;
        }

        public StateStoreSpecBuilder checkpointDuration(Duration checkpointDuration) {
            this.checkpointDuration$value = checkpointDuration;
            this.checkpointDuration$set = true;
            return this;
        }

        public StateStoreSpecBuilder config(String configKey, Object configValue) {
            if (this.configs$key == null) {
                this.configs$key = new ArrayList();
                this.configs$value = new ArrayList();
            }
            this.configs$key.add(configKey);
            this.configs$value.add(configValue);
            return this;
        }

        public StateStoreSpecBuilder configs(Map<? extends String, ? extends Object> configs) {
            if (configs == null) {
                throw new NullPointerException("configs cannot be null");
            }
            if (this.configs$key == null) {
                this.configs$key = new ArrayList();
                this.configs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : configs.entrySet()) {
                this.configs$key.add($lombokEntry.getKey());
                this.configs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public StateStoreSpecBuilder clearConfigs() {
            if (this.configs$key != null) {
                this.configs$key.clear();
                this.configs$value.clear();
            }
            return this;
        }

        public StateStoreSpecBuilder checkpointChecksumEnable(boolean checkpointChecksumEnable) {
            this.checkpointChecksumEnable$value = checkpointChecksumEnable;
            this.checkpointChecksumEnable$set = true;
            return this;
        }

        public StateStoreSpecBuilder checkpointChecksumCompatible(boolean checkpointChecksumCompatible) {
            this.checkpointChecksumCompatible$value = checkpointChecksumCompatible;
            this.checkpointChecksumCompatible$set = true;
            return this;
        }

        public StateStoreSpecBuilder localStorageCleanupEnable(boolean localStorageCleanupEnable) {
            this.localStorageCleanupEnable$value = localStorageCleanupEnable;
            this.localStorageCleanupEnable$set = true;
            return this;
        }

        public StateStoreSpecBuilder checkpointRestoreIdleLimit(Duration checkpointRestoreIdleLimit) {
            this.checkpointRestoreIdleLimit$value = checkpointRestoreIdleLimit;
            this.checkpointRestoreIdleLimit$set = true;
            return this;
        }

        public StateStoreSpecBuilder ttlSeconds(int ttlSeconds) {
            this.ttlSeconds$value = ttlSeconds;
            this.ttlSeconds$set = true;
            return this;
        }

        public StateStoreSpec build() {
            Map<Object, Object> configs;
            switch (this.configs$key == null ? 0 : this.configs$key.size()) {
                case 0: {
                    configs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    configs = Collections.singletonMap(this.configs$key.get(0), this.configs$value.get(0));
                    break;
                }
                default: {
                    configs = new LinkedHashMap(this.configs$key.size() < 0x40000000 ? 1 + this.configs$key.size() + (this.configs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.configs$key.size(); ++$i) {
                        configs.put(this.configs$key.get($i), this.configs$value.get($i));
                    }
                    configs = Collections.unmodifiableMap(configs);
                }
            }
            Duration checkpointDuration$value = this.checkpointDuration$value;
            if (!this.checkpointDuration$set) {
                checkpointDuration$value = StateStoreSpec.$default$checkpointDuration();
            }
            boolean checkpointChecksumEnable$value = this.checkpointChecksumEnable$value;
            if (!this.checkpointChecksumEnable$set) {
                checkpointChecksumEnable$value = StateStoreSpec.$default$checkpointChecksumEnable();
            }
            boolean checkpointChecksumCompatible$value = this.checkpointChecksumCompatible$value;
            if (!this.checkpointChecksumCompatible$set) {
                checkpointChecksumCompatible$value = StateStoreSpec.$default$checkpointChecksumCompatible();
            }
            boolean localStorageCleanupEnable$value = this.localStorageCleanupEnable$value;
            if (!this.localStorageCleanupEnable$set) {
                localStorageCleanupEnable$value = StateStoreSpec.$default$localStorageCleanupEnable();
            }
            Duration checkpointRestoreIdleLimit$value = this.checkpointRestoreIdleLimit$value;
            if (!this.checkpointRestoreIdleLimit$set) {
                checkpointRestoreIdleLimit$value = StateStoreSpec.$default$checkpointRestoreIdleLimit();
            }
            int ttlSeconds$value = this.ttlSeconds$value;
            if (!this.ttlSeconds$set) {
                ttlSeconds$value = StateStoreSpec.$default$ttlSeconds();
            }
            return new StateStoreSpec(this.name, this.keyCoder, this.valCoder, this.localStateStoreDir, this.stream, this.isReadonly, this.writeIOScheduler, this.readIOScheduler, this.checkpointIOScheduler, this.checkpointStore, checkpointDuration$value, configs, checkpointChecksumEnable$value, checkpointChecksumCompatible$value, localStorageCleanupEnable$value, checkpointRestoreIdleLimit$value, ttlSeconds$value);
        }

        public String toString() {
            return "StateStoreSpec.StateStoreSpecBuilder(name=" + this.name + ", keyCoder=" + this.keyCoder + ", valCoder=" + this.valCoder + ", localStateStoreDir=" + this.localStateStoreDir + ", stream=" + this.stream + ", isReadonly=" + this.isReadonly + ", writeIOScheduler=" + this.writeIOScheduler + ", readIOScheduler=" + this.readIOScheduler + ", checkpointIOScheduler=" + this.checkpointIOScheduler + ", checkpointStore=" + this.checkpointStore + ", checkpointDuration$value=" + this.checkpointDuration$value + ", configs$key=" + this.configs$key + ", configs$value=" + this.configs$value + ", checkpointChecksumEnable$value=" + this.checkpointChecksumEnable$value + ", checkpointChecksumCompatible$value=" + this.checkpointChecksumCompatible$value + ", localStorageCleanupEnable$value=" + this.localStorageCleanupEnable$value + ", checkpointRestoreIdleLimit$value=" + this.checkpointRestoreIdleLimit$value + ", ttlSeconds$value=" + this.ttlSeconds$value + ")";
        }
    }
}

