/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ControlledClusterFailoverBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.Runnables;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.asynchttpclient.channel.KeepAliveStrategy;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledClusterFailover
implements ServiceUrlProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControlledClusterFailover.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    private static final int DEFAULT_MAX_REDIRECTS = 20;
    private final Map<String, String> headers;
    private final String urlProvider;
    private PulsarClientImpl pulsarClient;
    private volatile String currentPulsarServiceUrl;
    private volatile ControlledConfiguration currentControlledConfiguration;
    private final ScheduledExecutorService executor;
    private final long interval;
    private AsyncHttpClient httpClient;
    private BoundRequestBuilder requestBuilder;

    private ControlledClusterFailover(ControlledClusterFailoverBuilderImpl builder) throws IOException {
        this.currentPulsarServiceUrl = builder.defaultServiceUrl;
        this.interval = builder.interval;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)((Object)new ExecutorProvider.ExtendedThreadFactory("pulsar-service-provider")));
        this.urlProvider = builder.urlProvider;
        this.headers = builder.header != null && !builder.header.isEmpty() ? new LinkedHashMap<String, String>(builder.header) : Collections.emptyMap();
    }

    private AsyncHttpClient buildHttpClient() {
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setCookieStore(null);
        confBuilder.setUseProxyProperties(true);
        confBuilder.setFollowRedirect(true);
        confBuilder.setMaxRedirects(20);
        confBuilder.setConnectTimeout(10000);
        confBuilder.setReadTimeout(30000);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setKeepAliveStrategy((KeepAliveStrategy)new DefaultKeepAliveStrategy(){

            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        confBuilder.setNettyTimer(this.pulsarClient.timer());
        confBuilder.setEventLoopGroup(this.pulsarClient.eventLoopGroup());
        DefaultAsyncHttpClientConfig config = confBuilder.build();
        return new DefaultAsyncHttpClient((AsyncHttpClientConfig)config);
    }

    public void initialize(PulsarClient client) {
        this.pulsarClient = (PulsarClientImpl)client;
        this.httpClient = this.buildHttpClient();
        this.requestBuilder = (BoundRequestBuilder)((BoundRequestBuilder)this.httpClient.prepareGet(this.urlProvider).setNameResolver(this.pulsarClient.getNameResolver())).addHeader((CharSequence)"Accept", "application/json");
        this.headers.forEach((arg_0, arg_1) -> ((BoundRequestBuilder)this.requestBuilder).addHeader(arg_0, arg_1));
        this.executor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(() -> {
            ControlledConfiguration controlledConfiguration = null;
            try {
                controlledConfiguration = this.fetchControlledConfiguration();
                if (controlledConfiguration != null && !Strings.isNullOrEmpty((String)controlledConfiguration.getServiceUrl()) && !controlledConfiguration.equals(this.currentControlledConfiguration)) {
                    log.info("Switch Pulsar service url from {} to {}", (Object)this.currentControlledConfiguration, (Object)controlledConfiguration.toString());
                    Authentication authentication = null;
                    if (!Strings.isNullOrEmpty((String)controlledConfiguration.authPluginClassName) && !Strings.isNullOrEmpty((String)controlledConfiguration.getAuthParamsString())) {
                        authentication = AuthenticationFactory.create((String)controlledConfiguration.getAuthPluginClassName(), (String)controlledConfiguration.getAuthParamsString());
                    }
                    String tlsTrustCertsFilePath = controlledConfiguration.getTlsTrustCertsFilePath();
                    String serviceUrl = controlledConfiguration.getServiceUrl();
                    if (authentication != null) {
                        this.pulsarClient.updateAuthentication(authentication);
                    }
                    if (!Strings.isNullOrEmpty((String)tlsTrustCertsFilePath)) {
                        this.pulsarClient.updateTlsTrustCertsFilePath(tlsTrustCertsFilePath);
                    }
                    this.pulsarClient.updateServiceUrl(serviceUrl);
                    this.pulsarClient.reloadLookUp();
                    this.currentPulsarServiceUrl = serviceUrl;
                    this.currentControlledConfiguration = controlledConfiguration;
                }
            }
            catch (IOException e) {
                log.error("Failed to switch new Pulsar url, current: {}, new: {}", new Object[]{this.currentControlledConfiguration, controlledConfiguration, e});
            }
        }), this.interval, this.interval, TimeUnit.MILLISECONDS);
    }

    public String getCurrentPulsarServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    @VisibleForTesting
    protected BoundRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    protected ControlledConfiguration fetchControlledConfiguration() throws IOException {
        try {
            Response response = (Response)this.requestBuilder.execute().get();
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                String content = response.getResponseBody(StandardCharsets.UTF_8);
                return (ControlledConfiguration)ObjectMapperFactory.getMapper().reader().readValue(content, ControlledConfiguration.class);
            }
            log.warn("Failed to fetch controlled configuration, status code: {}", (Object)statusCode);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to fetch controlled configuration ", (Throwable)e);
        }
        return null;
    }

    public String getServiceUrl() {
        return this.currentPulsarServiceUrl;
    }

    public void close() {
        this.executor.shutdown();
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error("Failed to close http client.");
            }
        }
    }

    public static ControlledClusterFailoverBuilder builder() {
        return new ControlledClusterFailoverBuilderImpl();
    }

    public static class ControlledClusterFailoverBuilderImpl
    implements ControlledClusterFailoverBuilder {
        private String defaultServiceUrl;
        private String urlProvider;
        private Map<String, String> header = null;
        private long interval = 30000L;

        public ControlledClusterFailoverBuilder defaultServiceUrl(@NonNull String serviceUrl) {
            if (serviceUrl == null) {
                throw new NullPointerException("serviceUrl is marked non-null but is null");
            }
            this.defaultServiceUrl = serviceUrl;
            return this;
        }

        public ControlledClusterFailoverBuilder urlProvider(@NonNull String urlProvider) {
            if (urlProvider == null) {
                throw new NullPointerException("urlProvider is marked non-null but is null");
            }
            this.urlProvider = urlProvider;
            return this;
        }

        public ControlledClusterFailoverBuilder urlProviderHeader(Map<String, String> header) {
            this.header = header;
            return this;
        }

        public ControlledClusterFailoverBuilder checkInterval(long interval, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.interval = timeUnit.toMillis(interval);
            return this;
        }

        public ServiceUrlProvider build() throws IOException {
            Objects.requireNonNull(this.defaultServiceUrl, "default service url shouldn't be null");
            Objects.requireNonNull(this.urlProvider, "urlProvider shouldn't be null");
            ControlledClusterFailoverBuilderImpl.checkArgument(this.interval > 0L, "checkInterval should > 0");
            return new ControlledClusterFailover(this);
        }

        public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }

    protected static class ControlledConfiguration {
        private String serviceUrl;
        private String tlsTrustCertsFilePath;
        private String authPluginClassName;
        private String authParamsString;

        public String toJson() {
            try {
                return ObjectMapperFactory.getMapper().writer().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                log.warn("Failed to write as json. ", (Throwable)e);
                return null;
            }
        }

        @Generated
        public ControlledConfiguration() {
        }

        @Generated
        public String getServiceUrl() {
            return this.serviceUrl;
        }

        @Generated
        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        @Generated
        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        @Generated
        public String getAuthParamsString() {
            return this.authParamsString;
        }

        @Generated
        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        @Generated
        public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        }

        @Generated
        public void setAuthPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
        }

        @Generated
        public void setAuthParamsString(String authParamsString) {
            this.authParamsString = authParamsString;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlledConfiguration)) {
                return false;
            }
            ControlledConfiguration other = (ControlledConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceUrl = this.getServiceUrl();
            String other$serviceUrl = other.getServiceUrl();
            if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
                return false;
            }
            String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
            if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
                return false;
            }
            String this$authPluginClassName = this.getAuthPluginClassName();
            String other$authPluginClassName = other.getAuthPluginClassName();
            if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
                return false;
            }
            String this$authParamsString = this.getAuthParamsString();
            String other$authParamsString = other.getAuthParamsString();
            return !(this$authParamsString == null ? other$authParamsString != null : !this$authParamsString.equals(other$authParamsString));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ControlledConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceUrl = this.getServiceUrl();
            result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
            String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
            String $authPluginClassName = this.getAuthPluginClassName();
            result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
            String $authParamsString = this.getAuthParamsString();
            result = result * 59 + ($authParamsString == null ? 43 : $authParamsString.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ControlledClusterFailover.ControlledConfiguration(serviceUrl=" + this.getServiceUrl() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParamsString=" + this.getAuthParamsString() + ")";
        }
    }
}

