/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapperUtils;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArgWrapperJavaType
extends SimpleType {
    private static final long serialVersionUID = 964882360361204479L;
    private final Map<String, ArgInfo> argInfos = new HashMap<String, ArgInfo>();

    public ArgWrapperJavaType() {
        super(Object.class);
    }

    public void addProperty(String name, Type type) {
        this.argInfos.put(name, new ArgInfo(type));
    }

    public Map<String, Object> readValue(ObjectMapper mapper, String json) throws IOException {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        JsonParser jp = mapper.getFactory().createParser(json);
        DeserializationContext deserializationContext = ObjectMapperUtils.createDeserializationContext((ObjectMapper)mapper, (JsonParser)jp);
        jp.nextToken();
        String fieldName = jp.nextFieldName();
        while (fieldName != null) {
            jp.nextToken();
            ArgInfo argInfo = this.argInfos.get(fieldName);
            if (argInfo != null) {
                if (argInfo.deserializer == null) {
                    argInfo.deserializer = deserializationContext.findRootValueDeserializer(argInfo.javaType);
                }
                args.put(fieldName, argInfo.deserializer.deserialize(jp, deserializationContext));
            }
            fieldName = jp.nextFieldName();
        }
        return args;
    }

    static class ArgInfo {
        JavaType javaType;
        JsonDeserializer<Object> deserializer;

        public ArgInfo(Type type) {
            this.javaType = TypeFactory.defaultInstance().constructType(type);
        }
    }
}

