/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.mcp.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import org.apache.shenyu.client.mcp.common.dto.ShenyuMcpTool;
import org.apache.shenyu.client.mcp.generator.McpRequestConfigGenerator;
import org.apache.shenyu.register.common.dto.McpToolsRegisterDTO;

public class McpToolsRegisterDTOGenerator {
    public static McpToolsRegisterDTO generateRegisterDTO(ShenyuMcpTool shenyuMcpTool, JsonObject openApiJsonObject, String url, String namespaceId) {
        JsonObject root = new JsonObject();
        JsonObject paths = openApiJsonObject.getAsJsonObject("paths");
        JsonObject path = paths.getAsJsonObject(url);
        JsonObject method = path.getAsJsonObject(shenyuMcpTool.getMethod());
        JsonArray parameters = method.getAsJsonArray("parameters");
        JsonObject requestConfig = McpRequestConfigGenerator.generateRequestConfig(openApiJsonObject, shenyuMcpTool.getRequestConfig());
        root.addProperty("requestConfig", requestConfig.toString());
        root.addProperty("name", shenyuMcpTool.getToolName());
        root.add("parameters", (JsonElement)McpToolsRegisterDTOGenerator.parameterFormatting(parameters));
        root.addProperty("description", shenyuMcpTool.getOperation().getDescription());
        McpToolsRegisterDTO mcpToolsRegisterDTO = new McpToolsRegisterDTO();
        mcpToolsRegisterDTO.setNamespaceId(namespaceId);
        mcpToolsRegisterDTO.setMcpConfig(root.toString());
        return mcpToolsRegisterDTO;
    }

    public static JsonArray parameterFormatting(JsonArray parameters) {
        parameters.forEach(parameter -> {
            JsonObject schemaObj;
            JsonElement typeElement;
            JsonObject paramObj = parameter.getAsJsonObject();
            JsonElement schema = paramObj.remove("schema");
            if (Objects.nonNull(schema) && schema.isJsonObject() && Objects.nonNull(typeElement = (schemaObj = schema.getAsJsonObject()).get("type")) && typeElement.isJsonPrimitive()) {
                String type = typeElement.getAsString();
                paramObj.addProperty("type", type);
            }
            if (!paramObj.has("description")) {
                paramObj.addProperty("description", paramObj.get("name").getAsString());
            }
            paramObj.remove("in");
        });
        return parameters;
    }
}

