/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.mcp.utils;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.mcp.common.annotation.ShenyuMcpHeader;
import org.apache.shenyu.client.mcp.common.dto.ShenyuMcpRequestConfig;

public class OpenApiConvertorUtil {
    public static Parameter convertParameter(io.swagger.v3.oas.annotations.Parameter annotation) {
        Parameter parameter = new Parameter();
        if (!Objects.nonNull(annotation)) {
            return parameter;
        }
        parameter.setName(annotation.name());
        parameter.setIn(annotation.in().toString().toLowerCase());
        parameter.setDescription(annotation.description());
        parameter.setRequired(Boolean.valueOf(annotation.required()));
        Schema schemaAnn = annotation.schema();
        if (!schemaAnn.implementation().equals(Void.class) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{schemaAnn.type()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{schemaAnn.format()})) {
            io.swagger.v3.oas.models.media.Schema schema = new io.swagger.v3.oas.models.media.Schema();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{schemaAnn.type()})) {
                schema.setType(schemaAnn.type());
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    public static Operation convertOperation(io.swagger.v3.oas.annotations.Operation operationAnnotation) {
        Operation operation = new Operation();
        if (Objects.isNull(operationAnnotation)) {
            return operation;
        }
        operation.setSummary(operationAnnotation.summary());
        operation.setDescription(operationAnnotation.description());
        operation.setDeprecated(Boolean.valueOf(operationAnnotation.deprecated()));
        operation.setOperationId(operationAnnotation.operationId());
        if (Objects.nonNull(operationAnnotation.tags()) && operationAnnotation.tags().length > 0) {
            operation.setTags(Arrays.asList(operationAnnotation.tags()));
        }
        if (Objects.nonNull(operationAnnotation.parameters()) && operationAnnotation.parameters().length > 0) {
            List parameters = Arrays.stream(operationAnnotation.parameters()).map(OpenApiConvertorUtil::convertParameter).collect(Collectors.toList());
            operation.setParameters(parameters);
        }
        return operation;
    }

    public static ShenyuMcpRequestConfig convertRequestConfig(org.apache.shenyu.client.mcp.common.annotation.ShenyuMcpRequestConfig requestConfigAnnotation) {
        ShenyuMcpRequestConfig requestConfigObject = new ShenyuMcpRequestConfig();
        ShenyuMcpHeader[] headersAnnotation = requestConfigAnnotation.headers();
        Map<String, String> headersObject = requestConfigObject.getHeaders();
        for (ShenyuMcpHeader shenyuMcpHeader : headersAnnotation) {
            headersObject.put(shenyuMcpHeader.key(), shenyuMcpHeader.value());
        }
        requestConfigObject.setBodyToJson(requestConfigAnnotation.bodyToJson());
        return requestConfigObject;
    }
}

