/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.registrar;

import java.util.List;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.registrar.ApiRegistrar;
import org.apache.shenyu.register.common.type.DataTypeParent;

public abstract class AbstractApiRegistrar<D extends DataTypeParent>
implements ApiRegistrar {
    private final ShenyuClientRegisterEventPublisher publisher;

    protected AbstractApiRegistrar(ShenyuClientRegisterEventPublisher publisher) {
        this.publisher = publisher;
    }

    protected Boolean preMatch(ApiBean apiBean) {
        return false;
    }

    protected D preParse(ApiBean apiBean) {
        throw new UnsupportedOperationException("If the preMatch method was implemented ,the preParse method should be implemented.");
    }

    protected abstract Boolean match(ApiBean var1);

    protected abstract Boolean match(ApiBean.ApiDefinition var1);

    protected abstract List<D> parse(ApiBean.ApiDefinition var1);

    @Override
    public void register(ApiBean apiBean) {
        if (this.preMatch(apiBean).booleanValue()) {
            this.publisher.publishEvent((DataTypeParent)this.preParse(apiBean));
            return;
        }
        if (!this.match(apiBean).booleanValue()) {
            return;
        }
        apiBean.getApiDefinitions().stream().filter(this::match).map(this::parse).forEach(apiDatas -> apiDatas.forEach(this.publisher::publishEvent));
    }
}

