/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.springframework.data.ldap.repository.Query;
import org.springframework.data.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class AnnotatedLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final Query queryAnnotation;

    public AnnotatedLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators) {
        super(queryMethod, entityType, ldapOperations, mappingContext, instantiators);
        Assert.notNull((Object)queryMethod.getQueryAnnotation(), (String)"Annotation must be present");
        Assert.hasLength((String)queryMethod.getQueryAnnotation().value(), (String)"Query filter must be specified");
        this.queryAnnotation = queryMethod.getRequiredQueryAnnotation();
    }

    @Override
    protected LdapQuery createQuery(LdapParameterAccessor parameters) {
        return LdapQueryBuilder.query().base(this.queryAnnotation.base()).searchScope(this.queryAnnotation.searchScope()).countLimit(this.queryAnnotation.countLimit()).timeLimit(this.queryAnnotation.timeLimit()).filter(this.queryAnnotation.value(), parameters.getBindableParameterValues());
    }
}

