/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.config.properties.ClusterZookeeperProperties;
import org.apache.shenyu.admin.mode.cluster.impl.zookeeper.ClusterSelectMasterServiceZookeeperImpl;
import org.apache.shenyu.admin.mode.cluster.impl.zookeeper.ClusterZookeeperClient;
import org.apache.shenyu.admin.mode.cluster.impl.zookeeper.ClusterZookeeperConfig;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.zookeeper.lock.ZookeeperLockRegistry;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ClusterProperties.class, ClusterZookeeperProperties.class})
@ConditionalOnProperty(value={"shenyu.cluster.type"}, havingValue="zookeeper", matchIfMissing=false)
public class ClusterZookeeperConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterZookeeperConfiguration.class);
    private static final String LOCK_PATH = "/shenyu-cluster-lock";

    @Bean
    public ZookeeperLockRegistry zookeeperLockRegistry(ClusterZookeeperClient clusterZookeeperClient) {
        return new ZookeeperLockRegistry(clusterZookeeperClient.getClient(), LOCK_PATH);
    }

    @Bean
    public ClusterSelectMasterService clusterSelectMasterZookeeperService(ClusterProperties clusterProperties, ZookeeperLockRegistry zookeeperLockRegistry, ClusterZookeeperClient clusterZookeeperClient) {
        return new ClusterSelectMasterServiceZookeeperImpl(clusterProperties, zookeeperLockRegistry, clusterZookeeperClient);
    }

    @Bean
    public ClusterZookeeperClient clusterZookeeperClient(ClusterZookeeperProperties clusterZookeeperProperties) {
        int sessionTimeout = clusterZookeeperProperties.getSessionTimeout();
        int connectionTimeout = clusterZookeeperProperties.getConnectionTimeout();
        ClusterZookeeperConfig zkConfig = new ClusterZookeeperConfig(clusterZookeeperProperties.getUrl());
        zkConfig.setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        ClusterZookeeperClient client = new ClusterZookeeperClient(zkConfig);
        client.start();
        return client;
    }
}

