/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.service.AiProxyConnectionService;
import org.apache.shenyu.admin.service.support.AiProxyRealKeyResolver;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class AiProxySelectorResolverInvalidator
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxySelectorResolverInvalidator.class);
    private final AiProxyRealKeyResolver resolver;
    private final AiProxyConnectionService aiProxyConnectionService;

    public AiProxySelectorResolverInvalidator(AiProxyRealKeyResolver resolver, AiProxyConnectionService aiProxyConnectionService) {
        this.resolver = resolver;
        this.aiProxyConnectionService = aiProxyConnectionService;
    }

    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        for (final SelectorData d : changed) {
            if (Objects.isNull(d) || Objects.isNull(d.getId()) || !PluginEnum.AI_PROXY.getName().equals(d.getPluginName())) continue;
            this.resolver.invalidate(d.getId());
            LOG.info("[AiProxyResolverInvalidator] invalidated selectorId={} due to {} (selector)", (Object)d.getId(), (Object)eventType);
            try {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                        public void afterCommit() {
                            AiProxySelectorResolverInvalidator.this.aiProxyConnectionService.refreshApiKeysBySelectorId(d.getId());
                        }
                    });
                    continue;
                }
                this.aiProxyConnectionService.refreshApiKeysBySelectorId(d.getId());
            }
            catch (Exception ex) {
                LOG.warn("[AiProxyResolverInvalidator] failed to refresh AI_PROXY_API_KEY for selectorId={}: {}", (Object)d.getId(), (Object)ex.getMessage());
            }
        }
    }

    public void onProxySelectorChanged(List<ProxySelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        for (final ProxySelectorData d : changed) {
            if (Objects.isNull(d) || Objects.isNull(d.getId()) || !PluginEnum.AI_PROXY.getName().equals(d.getPluginName())) continue;
            this.resolver.invalidate(d.getId());
            LOG.info("[AiProxyResolverInvalidator] invalidated selectorId={} due to {} (proxy selector)", (Object)d.getId(), (Object)eventType);
            try {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                        public void afterCommit() {
                            AiProxySelectorResolverInvalidator.this.aiProxyConnectionService.refreshApiKeysBySelectorId(d.getId());
                        }
                    });
                    continue;
                }
                this.aiProxyConnectionService.refreshApiKeysBySelectorId(d.getId());
            }
            catch (Exception ex) {
                LOG.warn("[AiProxyResolverInvalidator] failed to refresh AI_PROXY_API_KEY for selectorId={}: {}", (Object)d.getId(), (Object)ex.getMessage());
            }
        }
    }
}

