/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.plugin;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginChangedEvent;
import org.apache.shenyu.common.utils.ListUtil;

public class BatchNamespacePluginDeletedEvent
extends BatchPluginChangedEvent {
    private final List<String> deletedPluginIds;
    private final String namespaceId;

    public BatchNamespacePluginDeletedEvent(Collection<PluginDO> source, String operator, String namespaceId) {
        super(source, (Collection<PluginDO>)null, EventTypeEnum.PLUGIN_DELETE, operator);
        this.deletedPluginIds = ListUtil.map(source, BaseDO::getId);
        this.namespaceId = namespaceId;
    }

    @Override
    public String buildContext() {
        String plugins = ((Collection)this.getSource()).stream().map(s -> ((PluginDO)s).getName()).collect(Collectors.joining(","));
        return String.format("the plugins[%s] is %s", plugins, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<PluginDO> getPlugins() {
        return ((Collection)this.getSource()).stream().map(PluginDO.class::cast).collect(Collectors.toList());
    }

    public List<String> getDeletedPluginIds() {
        return this.deletedPluginIds;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }
}

