/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.model.vo.DiscoveryUpstreamVO;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.ConfigsService;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.ProxySelectorService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.utils.ZipUtil;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigsServiceImpl
implements ConfigsService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigsServiceImpl.class);
    private final AppAuthService appAuthService;
    private final PluginService pluginService;
    private final NamespacePluginService namespacePluginService;
    private final PluginHandleService pluginHandleService;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final MetaDataService metaDataService;
    private final ShenyuDictService shenyuDictService;
    private final ProxySelectorService proxySelectorService;
    private final DiscoveryService discoveryService;
    private final DiscoveryUpstreamService discoveryUpstreamService;
    private final List<ConfigsExportImportHandler> configsExportImportHandlers;

    public ConfigsServiceImpl(AppAuthService appAuthService, PluginService pluginService, NamespacePluginService namespacePluginService, PluginHandleService pluginHandleService, SelectorService selectorService, RuleService ruleService, MetaDataService metaDataService, ShenyuDictService shenyuDictService, ProxySelectorService proxySelectorService, DiscoveryService discoveryService, DiscoveryUpstreamService discoveryUpstreamService, List<ConfigsExportImportHandler> configsExportImportHandlers) {
        this.appAuthService = appAuthService;
        this.pluginService = pluginService;
        this.namespacePluginService = namespacePluginService;
        this.pluginHandleService = pluginHandleService;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.metaDataService = metaDataService;
        this.shenyuDictService = shenyuDictService;
        this.proxySelectorService = proxySelectorService;
        this.discoveryService = discoveryService;
        this.discoveryUpstreamService = discoveryUpstreamService;
        this.configsExportImportHandlers = configsExportImportHandlers.stream().sorted(Comparator.comparingInt(c -> c.configsEnum().getImportOrder())).toList();
    }

    @Override
    public ShenyuAdminResult configsExport() {
        ArrayList zipItemList = Lists.newArrayList();
        this.exportAuthData(zipItemList);
        this.exportMetadata(zipItemList);
        this.exportPluginData(zipItemList);
        this.exportSelectorData(zipItemList);
        this.exportRuleData(zipItemList);
        this.exportDictData(zipItemList);
        this.exportProxySelectorData(zipItemList);
        this.exportDiscoveryData(zipItemList);
        this.exportDiscoveryUpstreamData(zipItemList);
        return ShenyuAdminResult.success(ZipUtil.zip(zipItemList));
    }

    @Override
    public ShenyuAdminResult configsExport(String namespace) {
        ArrayList zipItemList = Lists.newArrayList();
        for (ConfigsExportImportHandler configsExportImportHandler : this.configsExportImportHandlers) {
            configsExportImportHandler.configsExport(namespace).ifPresent(data -> zipItemList.add(new ZipUtil.ZipItem(configsExportImportHandler.configsEnum().getConfigName(), (String)data)));
        }
        return ShenyuAdminResult.success(ZipUtil.zip(zipItemList));
    }

    private void exportPluginHandleData(List<ZipUtil.ZipItem> zipItemList) {
        List<PluginHandleVO> pluginHandleDataList = this.pluginHandleService.listAllData();
        if (CollectionUtils.isNotEmpty(pluginHandleDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("plugin_handle.json", JsonUtils.toJson(pluginHandleDataList)));
        }
    }

    private void exportDiscoveryUpstreamData(List<ZipUtil.ZipItem> zipItemList) {
        List<DiscoveryUpstreamVO> discoveryUpstreamList = this.discoveryUpstreamService.listAllData();
        if (CollectionUtils.isNotEmpty(discoveryUpstreamList)) {
            zipItemList.add(new ZipUtil.ZipItem("discovery_upstream.json", JsonUtils.toJson(discoveryUpstreamList)));
        }
    }

    private void exportDiscoveryUpstreamData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<DiscoveryUpstreamVO> discoveryUpstreamList = this.discoveryUpstreamService.listAllDataByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(discoveryUpstreamList)) {
            zipItemList.add(new ZipUtil.ZipItem("discovery_upstream.json", JsonUtils.toJson(discoveryUpstreamList)));
        }
    }

    private void exportDiscoveryData(List<ZipUtil.ZipItem> zipItemList) {
        List<DiscoveryVO> discoveryList = this.discoveryService.listAllData();
        if (CollectionUtils.isNotEmpty(discoveryList)) {
            zipItemList.add(new ZipUtil.ZipItem("discovery.json", JsonUtils.toJson(discoveryList)));
        }
    }

    private void exportDiscoveryData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<DiscoveryVO> discoveryList = this.discoveryService.listAllDataByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(discoveryList)) {
            discoveryList.forEach(discoveryVO -> discoveryVO.setNamespaceId(null));
            zipItemList.add(new ZipUtil.ZipItem("discovery.json", JsonUtils.toJson(discoveryList)));
        }
    }

    private void exportProxySelectorData(List<ZipUtil.ZipItem> zipItemList) {
        List<ProxySelectorData> proxySelectorDataList = this.proxySelectorService.listAll();
        if (CollectionUtils.isNotEmpty(proxySelectorDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("proxy_selector.json", JsonUtils.toJson(proxySelectorDataList)));
        }
    }

    private void exportProxySelectorData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<ProxySelectorData> proxySelectorDataList = this.proxySelectorService.listAllByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(proxySelectorDataList)) {
            proxySelectorDataList.forEach(proxySelectorData -> proxySelectorData.setNamespaceId(null));
            zipItemList.add(new ZipUtil.ZipItem("proxy_selector.json", JsonUtils.toJson(proxySelectorDataList)));
        }
    }

    private void exportDictData(List<ZipUtil.ZipItem> zipItemList) {
        List<ShenyuDictVO> dictDataList = this.shenyuDictService.listAllData();
        if (CollectionUtils.isNotEmpty(dictDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("dict.json", JsonUtils.toJson(dictDataList)));
        }
    }

    private void exportRuleData(List<ZipUtil.ZipItem> zipItemList) {
        List<RuleVO> ruleDataList = this.ruleService.listAllData();
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("rule.json", JsonUtils.toJson(ruleDataList)));
        }
    }

    private void exportRuleData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<RuleVO> ruleDataList = this.ruleService.listAllDataByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("rule.json", JsonUtils.toJson(ruleDataList)));
        }
    }

    private void exportSelectorData(List<ZipUtil.ZipItem> zipItemList) {
        List<SelectorVO> selectorDataList = this.selectorService.listAllData();
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("selector.json", JsonUtils.toJson(selectorDataList)));
        }
    }

    private void exportSelectorData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<SelectorVO> selectorDataList = this.selectorService.listAllDataByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            selectorDataList.forEach(selectorVO -> selectorVO.setNamespaceId(null));
            zipItemList.add(new ZipUtil.ZipItem("selector.json", JsonUtils.toJson(selectorDataList)));
        }
    }

    private void exportPluginData(List<ZipUtil.ZipItem> zipItemList) {
        List<PluginVO> pluginDataList = this.pluginService.listAllData();
        if (CollectionUtils.isNotEmpty(pluginDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("plugin.json", JsonUtils.toJson(pluginDataList)));
        }
    }

    private void exportNamespacePluginData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<NamespacePluginVO> namespacePluginVOList = this.namespacePluginService.listAllData(namespace);
        if (CollectionUtils.isNotEmpty(namespacePluginVOList)) {
            zipItemList.add(new ZipUtil.ZipItem("namespace_plugin.json", JsonUtils.toJson(namespacePluginVOList)));
        }
    }

    private void exportPluginTemplateData(List<ZipUtil.ZipItem> zipItemList) {
        List<PluginVO> pluginDataList = this.pluginService.listAllData();
        if (CollectionUtils.isNotEmpty(pluginDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("plugin_template.json", JsonUtils.toJson(pluginDataList)));
        }
    }

    private void exportMetadata(List<ZipUtil.ZipItem> zipItemList) {
        List<MetaDataVO> metaDataList = this.metaDataService.listAllData();
        if (CollectionUtils.isNotEmpty(metaDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("meta.json", JsonUtils.toJson(metaDataList)));
        }
    }

    private void exportMetadata(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<MetaDataVO> metaDataList = this.metaDataService.listAllDataByNamespaceId(namespace);
        if (CollectionUtils.isNotEmpty(metaDataList)) {
            metaDataList.forEach(metaDataVO -> metaDataVO.setNamespaceId(null));
            zipItemList.add(new ZipUtil.ZipItem("meta.json", JsonUtils.toJson(metaDataList)));
        }
    }

    private void exportAuthData(List<ZipUtil.ZipItem> zipItemList) {
        List<AppAuthVO> authDataList = this.appAuthService.listAllData();
        if (CollectionUtils.isNotEmpty(authDataList)) {
            zipItemList.add(new ZipUtil.ZipItem("auth.json", JsonUtils.toJson(authDataList)));
        }
    }

    private void exportAuthData(String namespace, List<ZipUtil.ZipItem> zipItemList) {
        List<AppAuthVO> authDataList = this.appAuthService.listAllDataByNamespace(namespace);
        if (CollectionUtils.isNotEmpty(authDataList)) {
            authDataList.forEach(appAuthVO -> appAuthVO.setNamespaceId(null));
            zipItemList.add(new ZipUtil.ZipItem("auth.json", JsonUtils.toJson(authDataList)));
        }
    }

    @Override
    public ShenyuAdminResult configsImport(byte[] source) {
        ZipUtil.UnZipResult unZipResult = ZipUtil.unzip(source);
        List<ZipUtil.ZipItem> zipItemList = unZipResult.getZipItemList();
        if (CollectionUtils.isEmpty(zipItemList)) {
            LOG.info("import file is empty");
            return ShenyuAdminResult.success();
        }
        HashMap result = Maps.newHashMap();
        for (ZipUtil.ZipItem zipItem : zipItemList) {
            switch (zipItem.getItemName()) {
                case "auth.json": {
                    this.importAuthData(result, zipItem);
                    break;
                }
                case "meta.json": {
                    this.importMetaData(result, zipItem);
                    break;
                }
                case "plugin.json": {
                    this.importPluginData(result, zipItem);
                    break;
                }
                case "selector.json": {
                    this.importSelectorData(result, zipItem);
                    break;
                }
                case "rule.json": {
                    this.importRuleData(result, zipItem);
                    break;
                }
                case "dict.json": {
                    this.importDictData(result, zipItem);
                    break;
                }
                case "proxy_selector.json": {
                    this.importProxySelectorData(result, zipItem);
                    break;
                }
                case "discovery.json": {
                    this.importDiscoveryData(result, zipItem);
                    break;
                }
                case "discovery_upstream.json": {
                    this.importDiscoveryUpstreamData(result, zipItem);
                    break;
                }
            }
        }
        return ShenyuAdminResult.success(result);
    }

    @Override
    public ShenyuAdminResult configsImport(String namespace, byte[] source) {
        ZipUtil.UnZipResult unZipResult = ZipUtil.unzip(source);
        List<ZipUtil.ZipItem> zipItemList = unZipResult.getZipItemList();
        if (CollectionUtils.isEmpty(zipItemList)) {
            LOG.info("import file is empty");
            return ShenyuAdminResult.success();
        }
        ConfigsImportContext context = new ConfigsImportContext();
        Map zipItemNameMap = ListUtil.toMap(zipItemList, ZipUtil.ZipItem::getItemName);
        for (ConfigsExportImportHandler configsExportImportHandler : this.configsExportImportHandlers) {
            ZipUtil.ZipItem zipItem = (ZipUtil.ZipItem)zipItemNameMap.get(configsExportImportHandler.configsEnum().getConfigName());
            if (!Objects.nonNull(zipItem) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zipItem.getItemData()})) continue;
            configsExportImportHandler.configsImport(namespace, zipItem.getItemData(), context);
        }
        return ShenyuAdminResult.success(context.getResult());
    }

    private void importDiscoveryUpstreamData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String discoveryUpstreamJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)discoveryUpstreamJson)) {
            List discoveryUpstreamList = GsonUtils.getInstance().fromList(discoveryUpstreamJson, DiscoveryUpstreamDTO.class);
            ConfigImportResult configImportResult = this.discoveryUpstreamService.importData(discoveryUpstreamList);
            result.put("discoveryUpstreamImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("discoveryUpstreamImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importDiscoveryData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String discoveryJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)discoveryJson)) {
            List discoveryList = GsonUtils.getInstance().fromList(discoveryJson, DiscoveryDTO.class);
            ConfigImportResult configImportResult = this.discoveryService.importData(discoveryList);
            result.put("discoveryImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("discoveryImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importProxySelectorData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String proxySelectorJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)proxySelectorJson)) {
            List proxySelectorList = GsonUtils.getInstance().fromList(proxySelectorJson, ProxySelectorData.class);
            ConfigImportResult configImportResult = this.proxySelectorService.importData(proxySelectorList);
            result.put("proxySelectorImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("proxySelectorImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importDictData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String dictJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)dictJson)) {
            List dictList = GsonUtils.getInstance().fromList(dictJson, ShenyuDictDTO.class);
            ConfigImportResult configImportResult = this.shenyuDictService.importData(dictList);
            result.put("dictImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("dictImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importRuleData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String ruleJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)ruleJson)) {
            List ruleList = GsonUtils.getInstance().fromList(ruleJson, RuleDTO.class);
            ConfigImportResult configImportResult = this.ruleService.importData(ruleList);
            result.put("ruleImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("ruleImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importSelectorData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String selectorJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)selectorJson)) {
            List selectorList = GsonUtils.getInstance().fromList(selectorJson, SelectorDTO.class);
            ConfigImportResult configImportResult = this.selectorService.importData(selectorList);
            result.put("selectorImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("selectorImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importPluginData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String pluginJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)pluginJson)) {
            List pluginList = GsonUtils.getInstance().fromList(pluginJson, PluginDTO.class);
            ConfigImportResult configImportResult = this.pluginService.importData(pluginList, null);
            result.put("pluginImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("pluginImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importMetaData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String metaJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)metaJson)) {
            List metaDataList = GsonUtils.getInstance().fromList(metaJson, MetaDataDTO.class);
            ConfigImportResult configImportResult = this.metaDataService.importData(metaDataList);
            result.put("metaImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("metaImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }

    private void importAuthData(Map<String, Object> result, ZipUtil.ZipItem zipItem) {
        String authJson = zipItem.getItemData();
        if (StringUtils.isNotEmpty((CharSequence)authJson)) {
            List authDataList = GsonUtils.getInstance().fromList(authJson, AppAuthDTO.class);
            ConfigImportResult configImportResult = this.appAuthService.importData(authDataList);
            result.put("authImportSuccessCount", configImportResult.getSuccessCount());
            if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
                result.put("authImportFailMessage", configImportResult.getFailMessage());
            }
        }
    }
}

