/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;
import shade.polaris.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public class ServerConnectorConfigImpl
extends PluginConfigImpl
implements ServerConnectorConfig {
    private static final Pattern addressPattern = Pattern.compile("([a-zA-Z\\d]+(:)[a-zA-Z\\d~!@&%#_]+@)?(.*)(:)\\d+$");
    private final Map<String, String> metadata = new ConcurrentHashMap<String, String>();
    @JsonProperty
    private List<String> addresses;
    @JsonProperty
    private String protocol;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long connectTimeout;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long messageTimeout;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long serverSwitchInterval;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long connectionIdleTimeout;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long reconnectInterval;
    @JsonProperty
    private String trustedCAFile;
    @JsonProperty
    private String certFile;
    @JsonProperty
    private String keyFile;
    @JsonProperty
    private String id = "polaris";

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public long getConnectTimeout() {
        if (null == this.connectTimeout) {
            return 0L;
        }
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public long getMessageTimeout() {
        if (null == this.messageTimeout) {
            return 0L;
        }
        return this.messageTimeout;
    }

    public void setMessageTimeout(Long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    @Override
    public long getServerSwitchInterval() {
        if (null == this.serverSwitchInterval) {
            return 0L;
        }
        return this.serverSwitchInterval;
    }

    public void setServerSwitchInterval(Long serverSwitchInterval) {
        this.serverSwitchInterval = serverSwitchInterval;
    }

    @Override
    public long getConnectionIdleTimeout() {
        if (null == this.connectionIdleTimeout) {
            return 0L;
        }
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(Long connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    @Override
    public long getReconnectInterval() {
        if (null == this.reconnectInterval) {
            return 0L;
        }
        return this.reconnectInterval;
    }

    public void setReconnectInterval(Long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTrustedCAFile() {
        return this.trustedCAFile;
    }

    @Override
    public String getCertFile() {
        return this.certFile;
    }

    @Override
    public String getKeyFile() {
        return this.keyFile;
    }

    public void setTrustedCAFile(String trustedCAFile) {
        this.trustedCAFile = trustedCAFile;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void verify() {
        if (CollectionUtils.isEmpty(this.addresses)) {
            throw new IllegalArgumentException(String.format("addresses of [%s] must not be empty", this.protocol));
        }
        for (String address : this.addresses) {
            boolean matched = addressPattern.matcher(address).find();
            if (matched) continue;
            throw new IllegalArgumentException(String.format("address [%s] of [%s] is invalid", address, this.protocol));
        }
        ConfigUtils.validateString(this.id, "serverConnector.id");
        if ("grpc".equals(this.protocol)) {
            ConfigUtils.validateString(this.protocol, "serverConnector.protocol");
            ConfigUtils.validateInterval(this.connectTimeout, "serverConnector.connectTimeout");
            ConfigUtils.validateInterval(this.messageTimeout, "serverConnector.messageTimeout");
            ConfigUtils.validateInterval(this.serverSwitchInterval, "serverConnector.serverSwitchInterval");
            ConfigUtils.validateInterval(this.connectionIdleTimeout, "serverConnector.connectionIdleTimeout");
            ConfigUtils.validateInterval(this.reconnectInterval, "serverConnector.reconnectInterval");
        }
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            ServerConnectorConfig serverConnectorConfig = (ServerConnectorConfig)defaultObject;
            if (null == this.addresses) {
                this.setAddresses(serverConnectorConfig.getAddresses());
            }
            if (null == this.protocol) {
                this.setProtocol(serverConnectorConfig.getProtocol());
            }
            if (null == this.connectTimeout) {
                this.setConnectTimeout(serverConnectorConfig.getConnectTimeout());
            }
            if (null == this.messageTimeout) {
                this.setMessageTimeout(serverConnectorConfig.getMessageTimeout());
            }
            if (null == this.serverSwitchInterval) {
                this.setServerSwitchInterval(serverConnectorConfig.getServerSwitchInterval());
            }
            if (null == this.connectionIdleTimeout) {
                this.setConnectionIdleTimeout(serverConnectorConfig.getConnectionIdleTimeout());
            }
            if (null == this.reconnectInterval) {
                this.setReconnectInterval(serverConnectorConfig.getReconnectInterval());
            }
            this.setDefaultPluginConfig(serverConnectorConfig);
        }
    }

    public String toString() {
        return "ServerConnectorConfigImpl{addresses=" + this.addresses + ", protocol='" + this.protocol + '\'' + ", connectTimeout=" + this.connectTimeout + ", messageTimeout=" + this.messageTimeout + ", serverSwitchInterval=" + this.serverSwitchInterval + ", connectionIdleTimeout=" + this.connectionIdleTimeout + ", reconnectInterval=" + this.reconnectInterval + ", trustedCertificate=" + this.trustedCAFile + ", clientCertificate=" + this.certFile + ", clientKey=" + this.keyFile + "} " + super.toString();
    }
}

