/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.logging;

import com.tencent.polaris.logging.AbstractPolarisLogging;
import com.tencent.polaris.logging.log4j.Log4jPolarisLogging;
import com.tencent.polaris.logging.log4j2.Log4j2PolarisLogging;
import com.tencent.polaris.logging.logback.LogbackPolarisLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisLogging.class);
    public static final String LOGBACK_CLASSIC_LOGGER = "ch.qos.logback.classic.Logger";
    public static final String LOG4J2_CLASSIC_LOGGER = "org.apache.logging.log4j.LogManager";
    private AbstractPolarisLogging polarisLogging;
    private boolean isLogback = false;

    private PolarisLogging() {
        try {
            Class.forName(LOGBACK_CLASSIC_LOGGER);
            this.polarisLogging = new LogbackPolarisLogging();
            this.isLogback = true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(LOG4J2_CLASSIC_LOGGER);
                this.polarisLogging = new Log4j2PolarisLogging();
            }
            catch (ClassNotFoundException e1) {
                this.polarisLogging = new Log4jPolarisLogging();
            }
        }
    }

    public static PolarisLogging getInstance() {
        return PolarisLoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        try {
            this.polarisLogging.loadConfiguration();
        }
        catch (Throwable t) {
            if (this.isLogback) {
                LOGGER.warn("fail to load logback configuration: {}", (Object)t.getMessage());
            }
            LOGGER.warn("fail to load log4j configuration: {}", (Object)t.getMessage());
        }
    }

    private static class PolarisLoggingInstance {
        private static final PolarisLogging INSTANCE = new PolarisLogging();

        private PolarisLoggingInstance() {
        }
    }
}

