/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common.stat;

import com.tencent.polaris.plugins.circuitbreaker.common.stat.ResMetricArray;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimePosition;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimeRange;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Bucket {
    private final ResMetricArray metric;
    private final TimeRange timeRange;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicReference<Bucket> nextBucket = new AtomicReference();

    public Bucket(long start, long intervalMs, int metricSize) {
        this.timeRange = new TimeRange(start, start + intervalMs);
        this.metric = new ResMetricArray(metricSize);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public long getMetric(int dimension) {
        return this.metric.getMetric(dimension);
    }

    public long addMetric(int dimension, long value) {
        return this.metric.addMetric(dimension, value);
    }

    public void setMetric(int dimension, long value) {
        this.metric.setMetric(dimension, value);
    }

    public AtomicReference<Bucket> getNextBucket() {
        return this.nextBucket;
    }

    public AtomicInteger getCount() {
        return this.count;
    }

    public Bucket getTailBucket() {
        Bucket head = this;
        Bucket next = head.getNextBucket().get();
        while (null != next) {
            head = next;
            next = head.getNextBucket().get();
        }
        return head;
    }

    long calcMetricsBothIncluded(int dimension, TimeRange timeRange) {
        long total = 0L;
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        Bucket next = this;
        while (null != next) {
            TimeRange bucketTimeRange = next.getTimeRange();
            TimePosition posStart = bucketTimeRange.isTimeInBucket(timeRange.getStart());
            TimePosition posEnd = bucketTimeRange.isTimeInBucket(timeRange.getEnd());
            TimePosition posBucketRangeStart = timeRange.isTimeInBucket(bucketTimeRange.getStart());
            TimePosition posBucketRangeEnd = timeRange.isTimeInBucket(bucketTimeRange.getEnd());
            if (posStart == TimePosition.inside || posEnd == TimePosition.inside) {
                buckets.add(next);
            } else if (posBucketRangeStart == TimePosition.inside && posBucketRangeEnd == TimePosition.inside) {
                buckets.add(next);
            }
            next = next.getNextBucket().get();
        }
        for (Bucket bucket : buckets) {
            total += bucket.getMetric(dimension);
        }
        return total;
    }
}

