/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.MethodResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.ServiceResource;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.stat.DefaultCircuitBreakResult;
import com.tencent.polaris.api.plugin.stat.StatInfo;
import com.tencent.polaris.api.plugin.stat.StatReporter;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.HalfOpenStatus;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.PolarisCircuitBreaker;
import com.tencent.polaris.plugins.circuitbreaker.composite.StatusChangeHandler;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.ConsecutiveCounter;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.CounterOptions;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.ErrRateCounter;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.TriggerCounter;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ResourceCounters
implements StatusChangeHandler {
    private static final Logger CB_EVENT_LOG = LoggerFactory.getLogger("polaris-circuitbreaker-event");
    private static final Logger LOG = LoggerFactory.getLogger(ErrRateCounter.class);
    private final CircuitBreakerProto.CircuitBreakerRule currentActiveRule;
    private final List<TriggerCounter> counters = new ArrayList<TriggerCounter>();
    private final Resource resource;
    private final ScheduledExecutorService stateChangeExecutors;
    private final AtomicReference<CircuitBreakerStatus> circuitBreakerStatusReference = new AtomicReference();
    private final CircuitBreakerStatus.FallbackInfo fallbackInfo;
    private final Function<String, Pattern> regexFunction;
    private Extensions extensions;

    public ResourceCounters(Resource resource, CircuitBreakerProto.CircuitBreakerRule currentActiveRule, ScheduledExecutorService stateChangeExecutors, PolarisCircuitBreaker polarisCircuitBreaker) {
        this.currentActiveRule = currentActiveRule;
        this.resource = resource;
        this.stateChangeExecutors = stateChangeExecutors;
        this.regexFunction = regex -> {
            if (null == polarisCircuitBreaker) {
                return Pattern.compile(regex);
            }
            FlowCache flowCache = polarisCircuitBreaker.getExtensions().getFlowCache();
            return flowCache.loadOrStoreCompiledRegex((String)regex);
        };
        this.circuitBreakerStatusReference.set(new CircuitBreakerStatus(currentActiveRule.getName(), CircuitBreakerStatus.Status.CLOSE, System.currentTimeMillis()));
        this.fallbackInfo = ResourceCounters.buildFallbackInfo(currentActiveRule);
        if (Objects.nonNull(polarisCircuitBreaker)) {
            this.extensions = polarisCircuitBreaker.getExtensions();
        }
        this.init();
    }

    private void init() {
        List<CircuitBreakerProto.TriggerCondition> triggerConditionList = this.currentActiveRule.getTriggerConditionList();
        for (CircuitBreakerProto.TriggerCondition triggerCondition : triggerConditionList) {
            CounterOptions counterOptions = new CounterOptions();
            counterOptions.setResource(this.resource);
            counterOptions.setTriggerCondition(triggerCondition);
            counterOptions.setStatusChangeHandler(this);
            counterOptions.setExecutorService(this.stateChangeExecutors);
            switch (triggerCondition.getTriggerType()) {
                case ERROR_RATE: {
                    this.counters.add(new ErrRateCounter(this.currentActiveRule.getName(), counterOptions));
                    break;
                }
                case CONSECUTIVE_ERROR: {
                    this.counters.add(new ConsecutiveCounter(this.currentActiveRule.getName(), counterOptions));
                    break;
                }
            }
        }
    }

    private static CircuitBreakerStatus.FallbackInfo buildFallbackInfo(CircuitBreakerProto.CircuitBreakerRule currentActiveRule) {
        if (null == currentActiveRule) {
            return null;
        }
        if (currentActiveRule.getLevel() != CircuitBreakerProto.Level.METHOD && currentActiveRule.getLevel() != CircuitBreakerProto.Level.SERVICE) {
            return null;
        }
        CircuitBreakerProto.FallbackConfig fallbackConfig = currentActiveRule.getFallbackConfig();
        if (null == fallbackConfig || !fallbackConfig.getEnable()) {
            return null;
        }
        CircuitBreakerProto.FallbackResponse response = fallbackConfig.getResponse();
        if (null == response) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (CircuitBreakerProto.FallbackResponse.MessageHeader messageHeader : response.getHeadersList()) {
            headers.put(messageHeader.getKey(), messageHeader.getValue());
        }
        return new CircuitBreakerStatus.FallbackInfo(response.getCode(), headers, response.getBody());
    }

    public CircuitBreakerProto.CircuitBreakerRule getCurrentActiveRule() {
        return this.currentActiveRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeToOpen(String circuitBreaker) {
        ResourceCounters resourceCounters = this;
        synchronized (resourceCounters) {
            CircuitBreakerStatus circuitBreakerStatus = this.circuitBreakerStatusReference.get();
            if (circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.CLOSE) {
                this.toOpen(circuitBreakerStatus, circuitBreaker);
            }
        }
    }

    private void toOpen(CircuitBreakerStatus preStatus, String circuitBreaker) {
        CircuitBreakerStatus newStatus = new CircuitBreakerStatus(circuitBreaker, CircuitBreakerStatus.Status.OPEN, System.currentTimeMillis(), this.fallbackInfo);
        this.circuitBreakerStatusReference.set(newStatus);
        CB_EVENT_LOG.info("previous status {}, current status {}, resource {}, rule {}", new Object[]{preStatus.getStatus(), newStatus.getStatus(), this.resource, circuitBreaker});
        this.reportCircuitStatus();
        int sleepWindow = this.currentActiveRule.getRecoverCondition().getSleepWindow();
        this.stateChangeExecutors.schedule(new Runnable(){

            @Override
            public void run() {
                ResourceCounters.this.openToHalfOpen();
            }
        }, (long)sleepWindow, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openToHalfOpen() {
        ResourceCounters resourceCounters = this;
        synchronized (resourceCounters) {
            CircuitBreakerStatus circuitBreakerStatus = this.circuitBreakerStatusReference.get();
            if (circuitBreakerStatus.getStatus() != CircuitBreakerStatus.Status.OPEN) {
                return;
            }
            int consecutiveSuccess = this.currentActiveRule.getRecoverCondition().getConsecutiveSuccess();
            HalfOpenStatus halfOpenStatus = new HalfOpenStatus(circuitBreakerStatus.getCircuitBreaker(), System.currentTimeMillis(), consecutiveSuccess);
            CB_EVENT_LOG.info("previous status {}, current status {}, resource {}, rule {}", new Object[]{circuitBreakerStatus.getStatus(), halfOpenStatus.getStatus(), this.resource, circuitBreakerStatus.getCircuitBreaker()});
            this.circuitBreakerStatusReference.set(halfOpenStatus);
            this.reportCircuitStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halfOpenToClose() {
        ResourceCounters resourceCounters = this;
        synchronized (resourceCounters) {
            CircuitBreakerStatus circuitBreakerStatus = this.circuitBreakerStatusReference.get();
            if (circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.HALF_OPEN) {
                CircuitBreakerStatus newStatus = new CircuitBreakerStatus(circuitBreakerStatus.getCircuitBreaker(), CircuitBreakerStatus.Status.CLOSE, System.currentTimeMillis());
                this.circuitBreakerStatusReference.set(newStatus);
                CB_EVENT_LOG.info("previous status {}, current status {}, resource {}, rule {}", new Object[]{circuitBreakerStatus.getStatus(), newStatus.getStatus(), this.resource, circuitBreakerStatus.getCircuitBreaker()});
                for (TriggerCounter triggerCounter : this.counters) {
                    triggerCounter.resume();
                }
                this.reportCircuitStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halfOpenToOpen() {
        ResourceCounters resourceCounters = this;
        synchronized (resourceCounters) {
            CircuitBreakerStatus circuitBreakerStatus = this.circuitBreakerStatusReference.get();
            if (circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.HALF_OPEN) {
                this.toOpen(circuitBreakerStatus, circuitBreakerStatus.getCircuitBreaker());
            }
        }
    }

    public RetStatus parseRetStatus(ResourceStat resourceStat) {
        List<CircuitBreakerProto.ErrorCondition> errorConditionsList = this.currentActiveRule.getErrorConditionsList();
        if (CollectionUtils.isEmpty(errorConditionsList)) {
            return resourceStat.getRetStatus();
        }
        for (CircuitBreakerProto.ErrorCondition errorCondition : errorConditionsList) {
            ModelProto.MatchString condition = errorCondition.getCondition();
            switch (errorCondition.getInputType()) {
                case RET_CODE: {
                    boolean codeMatched = RuleUtils.matchStringValue(condition, String.valueOf(resourceStat.getRetCode()), this.regexFunction);
                    if (!codeMatched) break;
                    return RetStatus.RetFail;
                }
                case DELAY: {
                    String value = condition.getValue().getValue();
                    int delayValue = Integer.parseInt(value);
                    if (resourceStat.getDelay() < (long)delayValue) break;
                    return RetStatus.RetTimeout;
                }
            }
        }
        return RetStatus.RetSuccess;
    }

    public void report(ResourceStat resourceStat) {
        RetStatus retStatus = this.parseRetStatus(resourceStat);
        boolean success = retStatus != RetStatus.RetFail && retStatus != RetStatus.RetTimeout;
        CircuitBreakerStatus circuitBreakerStatus = this.circuitBreakerStatusReference.get();
        LOG.debug("[CircuitBreaker] report resource stat {}", (Object)resourceStat);
        if (null != circuitBreakerStatus && circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.HALF_OPEN) {
            HalfOpenStatus halfOpenStatus = (HalfOpenStatus)circuitBreakerStatus;
            boolean checked = halfOpenStatus.report(success);
            LOG.debug("[CircuitBreaker] report resource halfOpen stat {}, checked {}", (Object)resourceStat.getResource(), (Object)checked);
            if (checked) {
                CircuitBreakerStatus.Status nextStatus = halfOpenStatus.calNextStatus();
                switch (nextStatus) {
                    case CLOSE: {
                        this.stateChangeExecutors.execute(new Runnable(){

                            @Override
                            public void run() {
                                ResourceCounters.this.halfOpenToClose();
                            }
                        });
                        break;
                    }
                    case OPEN: {
                        this.stateChangeExecutors.execute(new Runnable(){

                            @Override
                            public void run() {
                                ResourceCounters.this.halfOpenToOpen();
                            }
                        });
                        break;
                    }
                }
            }
        } else {
            LOG.debug("[CircuitBreaker] report resource stat to counter {}", (Object)resourceStat.getResource());
            for (TriggerCounter counter : this.counters) {
                counter.report(success);
            }
        }
    }

    public CircuitBreakerStatus getCircuitBreakerStatus() {
        return this.circuitBreakerStatusReference.get();
    }

    public void reportCircuitStatus() {
        if (Objects.isNull(this.extensions)) {
            return;
        }
        Collection<Plugin> statPlugins = this.extensions.getPlugins().getPlugins(PluginTypes.STAT_REPORTER.getBaseType());
        if (null != statPlugins) {
            try {
                for (Plugin statPlugin : statPlugins) {
                    if (!(statPlugin instanceof StatReporter)) continue;
                    DefaultCircuitBreakResult result = new DefaultCircuitBreakResult();
                    result.setCallerService(this.resource.getCallerService());
                    result.setCircuitBreakStatus(this.getCircuitBreakerStatus());
                    result.setService(this.resource.getService().getService());
                    result.setNamespace(this.resource.getService().getNamespace());
                    result.setLevel(this.resource.getLevel().name());
                    result.setRuleName(this.currentActiveRule.getName());
                    switch (this.resource.getLevel()) {
                        case SERVICE: {
                            ServiceResource serviceResource = (ServiceResource)this.resource;
                            break;
                        }
                        case METHOD: {
                            MethodResource methodResource = (MethodResource)this.resource;
                            result.setMethod(methodResource.getMethod());
                            break;
                        }
                        case INSTANCE: {
                            InstanceResource instanceResource = (InstanceResource)this.resource;
                            result.setHost(instanceResource.getHost());
                            result.setPort(instanceResource.getPort());
                        }
                    }
                    StatInfo info = new StatInfo();
                    info.setCircuitBreakGauge(result);
                    ((StatReporter)statPlugin).reportStat(info);
                }
            }
            catch (Exception ex) {
                LOG.info("circuit breaker report encountered exception, e: {}", (Object)ex.getMessage());
            }
        }
    }
}

