/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.converter.IdentityConverter;
import org.apache.sis.converter.SystemRegistry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.Containers;

public final class ObjectConverters
extends Static {
    private ObjectConverters() {
    }

    public static <T> ObjectConverter<T, T> identity(Class<T> type) {
        return new IdentityConverter<T, T>(Objects.requireNonNull(type), type, null).unique();
    }

    public static <S, T> ObjectConverter<? super S, ? extends T> find(Class<S> source, Class<T> target) throws UnconvertibleObjectException {
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        return SystemRegistry.INSTANCE.find(source, target);
    }

    public static <T> T convert(Object value, Class<T> target) throws UnconvertibleObjectException {
        if (!target.isInstance(value) && value != null) {
            value = SystemRegistry.INSTANCE.find(value.getClass(), target).apply(value);
        }
        return (T)value;
    }

    public static <S, E> Set<E> derivedSet(Set<S> storage, ObjectConverter<S, E> converter) {
        return Containers.derivedSet(storage, converter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        return Containers.derivedMap(storage, keyConverter, valueConverter);
    }

    public static <SK, K, V> Map<K, V> derivedKeys(Map<SK, V> storage, ObjectConverter<SK, K> keyConverter, Class<V> valueType) {
        ArgumentChecks.ensureNonNull("valueType", valueType);
        return Containers.derivedMap(storage, keyConverter, ObjectConverters.identity(valueType));
    }

    public static <K, SV, V> Map<K, V> derivedValues(Map<K, SV> storage, Class<K> keyType, ObjectConverter<SV, V> valueConverter) {
        ArgumentChecks.ensureNonNull("keyType", keyType);
        return Containers.derivedMap(storage, ObjectConverters.identity(keyType), valueConverter);
    }
}

