/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class Db2URLParser
extends AbstractURLParser {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 50000;
    private static final String DB_TYPE = "DB2";
    private static final String JDBC_PREFIX = "jdbc:db2:";

    public Db2URLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        if (hostLabelStartIndex == -1) {
            return null;
        }
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        int hostLabelEndIndexWithParameter = this.url.indexOf(":", hostLabelEndIndex + 1);
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = hostLabelEndIndexWithParameter;
        }
        if (hostLabelEndIndexWithParameter < hostLabelEndIndex && hostLabelEndIndexWithParameter != -1) {
            hostLabelEndIndex = hostLabelEndIndexWithParameter;
        }
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = this.url.length();
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    protected String fetchDatabaseNameFromURL(int startSize) {
        URLLocation hostsLocation = this.fetchDatabaseNameIndexRange(startSize);
        if (hostsLocation == null) {
            return "";
        }
        return this.url.substring(hostsLocation.startIndex(), hostsLocation.endIndex());
    }

    protected URLLocation fetchDatabaseNameIndexRange(int startSize) {
        int databaseEndTag;
        int databaseStartTag = this.url.indexOf("/", startSize);
        int parameterStartTag = this.url.indexOf(":", startSize);
        if (parameterStartTag < databaseStartTag && parameterStartTag != -1) {
            return null;
        }
        if (databaseStartTag == -1) {
            databaseStartTag = startSize - 1;
        }
        if ((databaseEndTag = this.url.indexOf(":", startSize)) == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag = this.url.lastIndexOf("/");
        int databaseEndTag = this.url.indexOf(":", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        if (location == null) {
            return new ConnectionInfo(ComponentsDefine.DB2_JDBC_DRIVER, DB_TYPE, DEFAULT_HOST, 50000, this.fetchDatabaseNameFromURL(JDBC_PREFIX.length()));
        }
        String hosts = this.url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host).append(":").append(50000).append(",");
                    continue;
                }
                sb.append(host).append(",");
            }
            return new ConnectionInfo(ComponentsDefine.DB2_JDBC_DRIVER, DB_TYPE, sb.substring(0, sb.length() - 1), this.fetchDatabaseNameFromURL());
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo(ComponentsDefine.DB2_JDBC_DRIVER, DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL(location.endIndex()));
        }
        return new ConnectionInfo(ComponentsDefine.DB2_JDBC_DRIVER, DB_TYPE, hostAndPort[0], 50000, this.fetchDatabaseNameFromURL(location.endIndex()));
    }
}

