/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.List;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatus;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatusListener;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.ProfileSnapshotSender;
import org.apache.skywalking.apm.agent.core.profile.TracingThreadSnapshot;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;

@OverrideImplementor(value=ProfileSnapshotSender.class)
public class KafkaProfileSnapshotSender
extends ProfileSnapshotSender
implements KafkaConnectionStatusListener {
    private static final ILog LOGGER = LogManager.getLogger(ProfileSnapshotSender.class);
    private String topic;
    private KafkaProducer<String, Bytes> producer;

    public void prepare() {
        KafkaProducerManager producerManager = (KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class);
        producerManager.addListener(this);
        this.topic = producerManager.formatTopicNameThenRegister(KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_PROFILING);
    }

    public void boot() {
    }

    public void send(List<TracingThreadSnapshot> buffer) {
        if (this.producer == null) {
            return;
        }
        for (TracingThreadSnapshot snapshot : buffer) {
            ThreadSnapshot object = snapshot.transform();
            if (LOGGER.isDebugEnable()) {
                LOGGER.debug("Thread snapshot reporting, topic: {}, taskId: {}, sequence:{}, traceId: {}", new Object[]{object.getTaskId(), object.getSequence(), object.getTraceSegmentId()});
            }
            this.producer.send(new ProducerRecord<String, Bytes>(this.topic, object.getTaskId() + object.getSequence(), Bytes.wrap(object.toByteArray())));
        }
    }

    @Override
    public void onStatusChanged(KafkaConnectionStatus status) {
        if (status == KafkaConnectionStatus.CONNECTED) {
            this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
        }
    }
}

