// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// This file is autogenerated. Do not edit it!

use std::fmt;

/// List of all SVG attributes.
#[derive(Copy,Clone,Eq,PartialEq,Ord,PartialOrd,Hash)]
#[allow(missing_docs)]
pub enum AttributeId {
    AccentHeight,
    Accumulate,
    Additive,
    AlignmentBaseline,
    Alphabetic,
    Amplitude,
    ArabicForm,
    Ascent,
    AttributeName,
    AttributeType,
    Azimuth,
    BaseFrequency,
    BaselineShift,
    BaseProfile,
    Bbox,
    Begin,
    Bias,
    By,
    CalcMode,
    CapHeight,
    Class,
    Clip,
    ClipPath,
    ClipRule,
    ClipPathUnits,
    Color,
    ColorInterpolation,
    ColorInterpolationFilters,
    ColorProfile,
    ColorRendering,
    ContentScriptType,
    ContentStyleType,
    Cursor,
    Cx,
    Cy,
    D,
    Descent,
    DiffuseConstant,
    Direction,
    Display,
    Divisor,
    DominantBaseline,
    Dur,
    Dx,
    Dy,
    EdgeMode,
    Elevation,
    EnableBackground,
    End,
    Exponent,
    ExternalResourcesRequired,
    Fill,
    FillOpacity,
    FillRule,
    Filter,
    FilterRes,
    FilterUnits,
    FloodColor,
    FloodOpacity,
    Font,
    FontFamily,
    FontSize,
    FontSizeAdjust,
    FontStretch,
    FontStyle,
    FontVariant,
    FontWeight,
    Format,
    From,
    Fx,
    Fy,
    G1,
    G2,
    GlyphName,
    GlyphOrientationHorizontal,
    GlyphOrientationVertical,
    GlyphRef,
    GradientTransform,
    GradientUnits,
    Hanging,
    Height,
    HorizAdvX,
    HorizOriginX,
    HorizOriginY,
    Id,
    Ideographic,
    ImageRendering,
    In,
    In2,
    Intercept,
    K,
    K1,
    K2,
    K3,
    K4,
    KernelMatrix,
    KernelUnitLength,
    Kerning,
    KeyPoints,
    KeySplines,
    KeyTimes,
    Lang,
    LengthAdjust,
    LetterSpacing,
    LightingColor,
    LimitingConeAngle,
    LineHeight,
    Local,
    Marker,
    MarkerEnd,
    MarkerMid,
    MarkerStart,
    MarkerHeight,
    MarkerUnits,
    MarkerWidth,
    Mask,
    MaskContentUnits,
    MaskUnits,
    Mathematical,
    Max,
    Media,
    Method,
    Min,
    Mode,
    Name,
    NumOctaves,
    Offset,
    Onabort,
    Onactivate,
    Onbegin,
    Onclick,
    Onend,
    Onerror,
    Onfocusin,
    Onfocusout,
    Onload,
    Onmousedown,
    Onmousemove,
    Onmouseout,
    Onmouseover,
    Onmouseup,
    Onrepeat,
    Onresize,
    Onscroll,
    Onunload,
    Onzoom,
    Opacity,
    Operator,
    Order,
    Orient,
    Orientation,
    Origin,
    Overflow,
    OverlinePosition,
    OverlineThickness,
    Panose1,
    Path,
    PathLength,
    PatternContentUnits,
    PatternTransform,
    PatternUnits,
    PointerEvents,
    Points,
    PointsAtX,
    PointsAtY,
    PointsAtZ,
    PreserveAlpha,
    PreserveAspectRatio,
    PrimitiveUnits,
    R,
    Radius,
    RefX,
    RefY,
    RenderingIntent,
    RepeatCount,
    RepeatDur,
    RequiredExtensions,
    RequiredFeatures,
    Restart,
    Result,
    Rotate,
    Rx,
    Ry,
    Scale,
    Seed,
    ShapeRendering,
    Slope,
    Spacing,
    SpecularConstant,
    SpecularExponent,
    SpreadMethod,
    StartOffset,
    StdDeviation,
    Stemh,
    Stemv,
    StitchTiles,
    StopColor,
    StopOpacity,
    StrikethroughPosition,
    StrikethroughThickness,
    String,
    Stroke,
    StrokeDasharray,
    StrokeDashoffset,
    StrokeLinecap,
    StrokeLinejoin,
    StrokeMiterlimit,
    StrokeOpacity,
    StrokeWidth,
    Style,
    SurfaceScale,
    SystemLanguage,
    TableValues,
    Target,
    TargetX,
    TargetY,
    TextAnchor,
    TextDecoration,
    TextRendering,
    TextLength,
    Title,
    To,
    Transform,
    Type,
    U1,
    U2,
    UnderlinePosition,
    UnderlineThickness,
    Unicode,
    UnicodeBidi,
    UnicodeRange,
    UnitsPerEm,
    VAlphabetic,
    VHanging,
    VIdeographic,
    VMathematical,
    Values,
    Version,
    VertAdvY,
    VertOriginX,
    VertOriginY,
    ViewBox,
    ViewTarget,
    Visibility,
    Width,
    Widths,
    WordSpacing,
    WritingMode,
    X,
    XHeight,
    X1,
    X2,
    XChannelSelector,
    XlinkActuate,
    XlinkArcrole,
    XlinkHref,
    XlinkRole,
    XlinkShow,
    XlinkTitle,
    XlinkType,
    XmlBase,
    XmlLang,
    XmlSpace,
    Xmlns,
    XmlnsXlink,
    Y,
    Y1,
    Y2,
    YChannelSelector,
    Z,
    ZoomAndPan
}

static ATTRIBUTES: ::phf::Map<&'static str, AttributeId> = ::phf::Map {
    key: 1897749892740154578,
    disps: ::phf::Slice::Static(&[
        (0, 5),
        (0, 25),
        (0, 212),
        (0, 234),
        (2, 151),
        (0, 36),
        (1, 150),
        (1, 0),
        (0, 7),
        (1, 27),
        (0, 220),
        (0, 15),
        (0, 127),
        (0, 43),
        (0, 129),
        (0, 89),
        (0, 1),
        (0, 138),
        (1, 126),
        (0, 15),
        (0, 0),
        (0, 170),
        (1, 80),
        (0, 86),
        (0, 13),
        (0, 0),
        (4, 117),
        (0, 5),
        (0, 3),
        (2, 67),
        (2, 125),
        (4, 42),
        (2, 136),
        (0, 199),
        (0, 257),
        (0, 6),
        (1, 177),
        (0, 0),
        (1, 152),
        (1, 138),
        (7, 44),
        (0, 1),
        (0, 19),
        (0, 186),
        (0, 4),
        (0, 19),
        (0, 10),
        (13, 64),
        (5, 20),
        (0, 12),
        (0, 0),
        (1, 48),
        (0, 0),
        (0, 11),
        (0, 69),
    ]),
    entries: ::phf::Slice::Static(&[
        ("stop-opacity", AttributeId::StopOpacity),
        ("pointer-events", AttributeId::PointerEvents),
        ("contentStyleType", AttributeId::ContentStyleType),
        ("ideographic", AttributeId::Ideographic),
        ("preserveAlpha", AttributeId::PreserveAlpha),
        ("from", AttributeId::From),
        ("azimuth", AttributeId::Azimuth),
        ("glyph-orientation-horizontal", AttributeId::GlyphOrientationHorizontal),
        ("local", AttributeId::Local),
        ("lengthAdjust", AttributeId::LengthAdjust),
        ("xlink:type", AttributeId::XlinkType),
        ("targetY", AttributeId::TargetY),
        ("visibility", AttributeId::Visibility),
        ("y1", AttributeId::Y1),
        ("word-spacing", AttributeId::WordSpacing),
        ("by", AttributeId::By),
        ("patternTransform", AttributeId::PatternTransform),
        ("order", AttributeId::Order),
        ("numOctaves", AttributeId::NumOctaves),
        ("display", AttributeId::Display),
        ("limitingConeAngle", AttributeId::LimitingConeAngle),
        ("string", AttributeId::String),
        ("maskUnits", AttributeId::MaskUnits),
        ("in2", AttributeId::In2),
        ("attributeType", AttributeId::AttributeType),
        ("xlink:actuate", AttributeId::XlinkActuate),
        ("edgeMode", AttributeId::EdgeMode),
        ("color-rendering", AttributeId::ColorRendering),
        ("onmouseout", AttributeId::Onmouseout),
        ("xlink:show", AttributeId::XlinkShow),
        ("onrepeat", AttributeId::Onrepeat),
        ("bbox", AttributeId::Bbox),
        ("version", AttributeId::Version),
        ("name", AttributeId::Name),
        ("targetX", AttributeId::TargetX),
        ("orientation", AttributeId::Orientation),
        ("k2", AttributeId::K2),
        ("opacity", AttributeId::Opacity),
        ("lighting-color", AttributeId::LightingColor),
        ("textLength", AttributeId::TextLength),
        ("clip", AttributeId::Clip),
        ("g2", AttributeId::G2),
        ("fill-opacity", AttributeId::FillOpacity),
        ("font-style", AttributeId::FontStyle),
        ("fill", AttributeId::Fill),
        ("restart", AttributeId::Restart),
        ("startOffset", AttributeId::StartOffset),
        ("surfaceScale", AttributeId::SurfaceScale),
        ("spacing", AttributeId::Spacing),
        ("stitchTiles", AttributeId::StitchTiles),
        ("onmouseup", AttributeId::Onmouseup),
        ("contentScriptType", AttributeId::ContentScriptType),
        ("onend", AttributeId::Onend),
        ("onmousedown", AttributeId::Onmousedown),
        ("font-weight", AttributeId::FontWeight),
        ("strikethrough-thickness", AttributeId::StrikethroughThickness),
        ("marker-end", AttributeId::MarkerEnd),
        ("onload", AttributeId::Onload),
        ("keySplines", AttributeId::KeySplines),
        ("intercept", AttributeId::Intercept),
        ("bias", AttributeId::Bias),
        ("begin", AttributeId::Begin),
        ("glyph-orientation-vertical", AttributeId::GlyphOrientationVertical),
        ("widths", AttributeId::Widths),
        ("id", AttributeId::Id),
        ("line-height", AttributeId::LineHeight),
        ("color-profile", AttributeId::ColorProfile),
        ("yChannelSelector", AttributeId::YChannelSelector),
        ("cy", AttributeId::Cy),
        ("width", AttributeId::Width),
        ("marker-mid", AttributeId::MarkerMid),
        ("rx", AttributeId::Rx),
        ("filterUnits", AttributeId::FilterUnits),
        ("stroke-linecap", AttributeId::StrokeLinecap),
        ("k", AttributeId::K),
        ("xml:space", AttributeId::XmlSpace),
        ("points", AttributeId::Points),
        ("in", AttributeId::In),
        ("kernelMatrix", AttributeId::KernelMatrix),
        ("onmousemove", AttributeId::Onmousemove),
        ("baseProfile", AttributeId::BaseProfile),
        ("z", AttributeId::Z),
        ("pointsAtZ", AttributeId::PointsAtZ),
        ("pointsAtY", AttributeId::PointsAtY),
        ("onfocusin", AttributeId::Onfocusin),
        ("horiz-origin-y", AttributeId::HorizOriginY),
        ("stroke-dashoffset", AttributeId::StrokeDashoffset),
        ("elevation", AttributeId::Elevation),
        ("xmlns", AttributeId::Xmlns),
        ("onmouseover", AttributeId::Onmouseover),
        ("clipPathUnits", AttributeId::ClipPathUnits),
        ("keyPoints", AttributeId::KeyPoints),
        ("panose-1", AttributeId::Panose1),
        ("accent-height", AttributeId::AccentHeight),
        ("enable-background", AttributeId::EnableBackground),
        ("viewBox", AttributeId::ViewBox),
        ("diffuseConstant", AttributeId::DiffuseConstant),
        ("y", AttributeId::Y),
        ("overline-thickness", AttributeId::OverlineThickness),
        ("ry", AttributeId::Ry),
        ("onresize", AttributeId::Onresize),
        ("k4", AttributeId::K4),
        ("path", AttributeId::Path),
        ("onactivate", AttributeId::Onactivate),
        ("fill-rule", AttributeId::FillRule),
        ("slope", AttributeId::Slope),
        ("xlink:title", AttributeId::XlinkTitle),
        ("color", AttributeId::Color),
        ("pointsAtX", AttributeId::PointsAtX),
        ("horiz-origin-x", AttributeId::HorizOriginX),
        ("clip-rule", AttributeId::ClipRule),
        ("units-per-em", AttributeId::UnitsPerEm),
        ("v-ideographic", AttributeId::VIdeographic),
        ("exponent", AttributeId::Exponent),
        ("onclick", AttributeId::Onclick),
        ("media", AttributeId::Media),
        ("pathLength", AttributeId::PathLength),
        ("maskContentUnits", AttributeId::MaskContentUnits),
        ("specularExponent", AttributeId::SpecularExponent),
        ("k1", AttributeId::K1),
        ("alphabetic", AttributeId::Alphabetic),
        ("font-stretch", AttributeId::FontStretch),
        ("stdDeviation", AttributeId::StdDeviation),
        ("glyph-name", AttributeId::GlyphName),
        ("ascent", AttributeId::Ascent),
        ("font", AttributeId::Font),
        ("accumulate", AttributeId::Accumulate),
        ("orient", AttributeId::Orient),
        ("onscroll", AttributeId::Onscroll),
        ("u1", AttributeId::U1),
        ("scale", AttributeId::Scale),
        ("mathematical", AttributeId::Mathematical),
        ("horiz-adv-x", AttributeId::HorizAdvX),
        ("rotate", AttributeId::Rotate),
        ("to", AttributeId::To),
        ("color-interpolation-filters", AttributeId::ColorInterpolationFilters),
        ("end", AttributeId::End),
        ("seed", AttributeId::Seed),
        ("mode", AttributeId::Mode),
        ("values", AttributeId::Values),
        ("divisor", AttributeId::Divisor),
        ("onabort", AttributeId::Onabort),
        ("dx", AttributeId::Dx),
        ("xml:lang", AttributeId::XmlLang),
        ("font-size", AttributeId::FontSize),
        ("refY", AttributeId::RefY),
        ("v-hanging", AttributeId::VHanging),
        ("clip-path", AttributeId::ClipPath),
        ("direction", AttributeId::Direction),
        ("text-decoration", AttributeId::TextDecoration),
        ("xlink:arcrole", AttributeId::XlinkArcrole),
        ("operator", AttributeId::Operator),
        ("offset", AttributeId::Offset),
        ("dy", AttributeId::Dy),
        ("x-height", AttributeId::XHeight),
        ("text-anchor", AttributeId::TextAnchor),
        ("method", AttributeId::Method),
        ("descent", AttributeId::Descent),
        ("x2", AttributeId::X2),
        ("font-variant", AttributeId::FontVariant),
        ("xml:base", AttributeId::XmlBase),
        ("u2", AttributeId::U2),
        ("stroke-opacity", AttributeId::StrokeOpacity),
        ("radius", AttributeId::Radius),
        ("letter-spacing", AttributeId::LetterSpacing),
        ("gradientUnits", AttributeId::GradientUnits),
        ("stroke-dasharray", AttributeId::StrokeDasharray),
        ("patternUnits", AttributeId::PatternUnits),
        ("zoomAndPan", AttributeId::ZoomAndPan),
        ("baseline-shift", AttributeId::BaselineShift),
        ("gradientTransform", AttributeId::GradientTransform),
        ("alignment-baseline", AttributeId::AlignmentBaseline),
        ("stroke", AttributeId::Stroke),
        ("keyTimes", AttributeId::KeyTimes),
        ("unicode-range", AttributeId::UnicodeRange),
        ("xChannelSelector", AttributeId::XChannelSelector),
        ("kerning", AttributeId::Kerning),
        ("xlink:href", AttributeId::XlinkHref),
        ("requiredFeatures", AttributeId::RequiredFeatures),
        ("writing-mode", AttributeId::WritingMode),
        ("x1", AttributeId::X1),
        ("image-rendering", AttributeId::ImageRendering),
        ("cap-height", AttributeId::CapHeight),
        ("amplitude", AttributeId::Amplitude),
        ("baseFrequency", AttributeId::BaseFrequency),
        ("min", AttributeId::Min),
        ("markerWidth", AttributeId::MarkerWidth),
        ("class", AttributeId::Class),
        ("preserveAspectRatio", AttributeId::PreserveAspectRatio),
        ("cursor", AttributeId::Cursor),
        ("result", AttributeId::Result),
        ("stemh", AttributeId::Stemh),
        ("k3", AttributeId::K3),
        ("cx", AttributeId::Cx),
        ("patternContentUnits", AttributeId::PatternContentUnits),
        ("origin", AttributeId::Origin),
        ("r", AttributeId::R),
        ("onbegin", AttributeId::Onbegin),
        ("flood-opacity", AttributeId::FloodOpacity),
        ("dominant-baseline", AttributeId::DominantBaseline),
        ("markerHeight", AttributeId::MarkerHeight),
        ("externalResourcesRequired", AttributeId::ExternalResourcesRequired),
        ("hanging", AttributeId::Hanging),
        ("requiredExtensions", AttributeId::RequiredExtensions),
        ("y2", AttributeId::Y2),
        ("primitiveUnits", AttributeId::PrimitiveUnits),
        ("dur", AttributeId::Dur),
        ("onzoom", AttributeId::Onzoom),
        ("title", AttributeId::Title),
        ("markerUnits", AttributeId::MarkerUnits),
        ("refX", AttributeId::RefX),
        ("x", AttributeId::X),
        ("stroke-linejoin", AttributeId::StrokeLinejoin),
        ("arabic-form", AttributeId::ArabicForm),
        ("height", AttributeId::Height),
        ("xmlns:xlink", AttributeId::XmlnsXlink),
        ("kernelUnitLength", AttributeId::KernelUnitLength),
        ("stroke-width", AttributeId::StrokeWidth),
        ("repeatCount", AttributeId::RepeatCount),
        ("tableValues", AttributeId::TableValues),
        ("overline-position", AttributeId::OverlinePosition),
        ("fy", AttributeId::Fy),
        ("shape-rendering", AttributeId::ShapeRendering),
        ("color-interpolation", AttributeId::ColorInterpolation),
        ("repeatDur", AttributeId::RepeatDur),
        ("attributeName", AttributeId::AttributeName),
        ("overflow", AttributeId::Overflow),
        ("glyphRef", AttributeId::GlyphRef),
        ("text-rendering", AttributeId::TextRendering),
        ("stop-color", AttributeId::StopColor),
        ("onunload", AttributeId::Onunload),
        ("max", AttributeId::Max),
        ("lang", AttributeId::Lang),
        ("filterRes", AttributeId::FilterRes),
        ("font-family", AttributeId::FontFamily),
        ("mask", AttributeId::Mask),
        ("target", AttributeId::Target),
        ("spreadMethod", AttributeId::SpreadMethod),
        ("transform", AttributeId::Transform),
        ("g1", AttributeId::G1),
        ("v-mathematical", AttributeId::VMathematical),
        ("filter", AttributeId::Filter),
        ("strikethrough-position", AttributeId::StrikethroughPosition),
        ("stemv", AttributeId::Stemv),
        ("viewTarget", AttributeId::ViewTarget),
        ("vert-origin-x", AttributeId::VertOriginX),
        ("onerror", AttributeId::Onerror),
        ("v-alphabetic", AttributeId::VAlphabetic),
        ("d", AttributeId::D),
        ("format", AttributeId::Format),
        ("type", AttributeId::Type),
        ("marker", AttributeId::Marker),
        ("flood-color", AttributeId::FloodColor),
        ("vert-adv-y", AttributeId::VertAdvY),
        ("calcMode", AttributeId::CalcMode),
        ("vert-origin-y", AttributeId::VertOriginY),
        ("unicode", AttributeId::Unicode),
        ("marker-start", AttributeId::MarkerStart),
        ("specularConstant", AttributeId::SpecularConstant),
        ("style", AttributeId::Style),
        ("additive", AttributeId::Additive),
        ("systemLanguage", AttributeId::SystemLanguage),
        ("unicode-bidi", AttributeId::UnicodeBidi),
        ("rendering-intent", AttributeId::RenderingIntent),
        ("fx", AttributeId::Fx),
        ("xlink:role", AttributeId::XlinkRole),
        ("stroke-miterlimit", AttributeId::StrokeMiterlimit),
        ("font-size-adjust", AttributeId::FontSizeAdjust),
        ("underline-thickness", AttributeId::UnderlineThickness),
        ("onfocusout", AttributeId::Onfocusout),
        ("underline-position", AttributeId::UnderlinePosition),
    ]),
};

impl AttributeId {
    /// Converts name into id.
    pub fn from_name(text: &str) -> Option<AttributeId> {
        ATTRIBUTES.get(text).cloned()
    }

    /// Converts id into name.
    pub fn name(&self) -> &str {
        match *self {
            AttributeId::AccentHeight => "accent-height",
            AttributeId::Accumulate => "accumulate",
            AttributeId::Additive => "additive",
            AttributeId::AlignmentBaseline => "alignment-baseline",
            AttributeId::Alphabetic => "alphabetic",
            AttributeId::Amplitude => "amplitude",
            AttributeId::ArabicForm => "arabic-form",
            AttributeId::Ascent => "ascent",
            AttributeId::AttributeName => "attributeName",
            AttributeId::AttributeType => "attributeType",
            AttributeId::Azimuth => "azimuth",
            AttributeId::BaseFrequency => "baseFrequency",
            AttributeId::BaselineShift => "baseline-shift",
            AttributeId::BaseProfile => "baseProfile",
            AttributeId::Bbox => "bbox",
            AttributeId::Begin => "begin",
            AttributeId::Bias => "bias",
            AttributeId::By => "by",
            AttributeId::CalcMode => "calcMode",
            AttributeId::CapHeight => "cap-height",
            AttributeId::Class => "class",
            AttributeId::Clip => "clip",
            AttributeId::ClipPath => "clip-path",
            AttributeId::ClipRule => "clip-rule",
            AttributeId::ClipPathUnits => "clipPathUnits",
            AttributeId::Color => "color",
            AttributeId::ColorInterpolation => "color-interpolation",
            AttributeId::ColorInterpolationFilters => "color-interpolation-filters",
            AttributeId::ColorProfile => "color-profile",
            AttributeId::ColorRendering => "color-rendering",
            AttributeId::ContentScriptType => "contentScriptType",
            AttributeId::ContentStyleType => "contentStyleType",
            AttributeId::Cursor => "cursor",
            AttributeId::Cx => "cx",
            AttributeId::Cy => "cy",
            AttributeId::D => "d",
            AttributeId::Descent => "descent",
            AttributeId::DiffuseConstant => "diffuseConstant",
            AttributeId::Direction => "direction",
            AttributeId::Display => "display",
            AttributeId::Divisor => "divisor",
            AttributeId::DominantBaseline => "dominant-baseline",
            AttributeId::Dur => "dur",
            AttributeId::Dx => "dx",
            AttributeId::Dy => "dy",
            AttributeId::EdgeMode => "edgeMode",
            AttributeId::Elevation => "elevation",
            AttributeId::EnableBackground => "enable-background",
            AttributeId::End => "end",
            AttributeId::Exponent => "exponent",
            AttributeId::ExternalResourcesRequired => "externalResourcesRequired",
            AttributeId::Fill => "fill",
            AttributeId::FillOpacity => "fill-opacity",
            AttributeId::FillRule => "fill-rule",
            AttributeId::Filter => "filter",
            AttributeId::FilterRes => "filterRes",
            AttributeId::FilterUnits => "filterUnits",
            AttributeId::FloodColor => "flood-color",
            AttributeId::FloodOpacity => "flood-opacity",
            AttributeId::Font => "font",
            AttributeId::FontFamily => "font-family",
            AttributeId::FontSize => "font-size",
            AttributeId::FontSizeAdjust => "font-size-adjust",
            AttributeId::FontStretch => "font-stretch",
            AttributeId::FontStyle => "font-style",
            AttributeId::FontVariant => "font-variant",
            AttributeId::FontWeight => "font-weight",
            AttributeId::Format => "format",
            AttributeId::From => "from",
            AttributeId::Fx => "fx",
            AttributeId::Fy => "fy",
            AttributeId::G1 => "g1",
            AttributeId::G2 => "g2",
            AttributeId::GlyphName => "glyph-name",
            AttributeId::GlyphOrientationHorizontal => "glyph-orientation-horizontal",
            AttributeId::GlyphOrientationVertical => "glyph-orientation-vertical",
            AttributeId::GlyphRef => "glyphRef",
            AttributeId::GradientTransform => "gradientTransform",
            AttributeId::GradientUnits => "gradientUnits",
            AttributeId::Hanging => "hanging",
            AttributeId::Height => "height",
            AttributeId::HorizAdvX => "horiz-adv-x",
            AttributeId::HorizOriginX => "horiz-origin-x",
            AttributeId::HorizOriginY => "horiz-origin-y",
            AttributeId::Id => "id",
            AttributeId::Ideographic => "ideographic",
            AttributeId::ImageRendering => "image-rendering",
            AttributeId::In => "in",
            AttributeId::In2 => "in2",
            AttributeId::Intercept => "intercept",
            AttributeId::K => "k",
            AttributeId::K1 => "k1",
            AttributeId::K2 => "k2",
            AttributeId::K3 => "k3",
            AttributeId::K4 => "k4",
            AttributeId::KernelMatrix => "kernelMatrix",
            AttributeId::KernelUnitLength => "kernelUnitLength",
            AttributeId::Kerning => "kerning",
            AttributeId::KeyPoints => "keyPoints",
            AttributeId::KeySplines => "keySplines",
            AttributeId::KeyTimes => "keyTimes",
            AttributeId::Lang => "lang",
            AttributeId::LengthAdjust => "lengthAdjust",
            AttributeId::LetterSpacing => "letter-spacing",
            AttributeId::LightingColor => "lighting-color",
            AttributeId::LimitingConeAngle => "limitingConeAngle",
            AttributeId::LineHeight => "line-height",
            AttributeId::Local => "local",
            AttributeId::Marker => "marker",
            AttributeId::MarkerEnd => "marker-end",
            AttributeId::MarkerMid => "marker-mid",
            AttributeId::MarkerStart => "marker-start",
            AttributeId::MarkerHeight => "markerHeight",
            AttributeId::MarkerUnits => "markerUnits",
            AttributeId::MarkerWidth => "markerWidth",
            AttributeId::Mask => "mask",
            AttributeId::MaskContentUnits => "maskContentUnits",
            AttributeId::MaskUnits => "maskUnits",
            AttributeId::Mathematical => "mathematical",
            AttributeId::Max => "max",
            AttributeId::Media => "media",
            AttributeId::Method => "method",
            AttributeId::Min => "min",
            AttributeId::Mode => "mode",
            AttributeId::Name => "name",
            AttributeId::NumOctaves => "numOctaves",
            AttributeId::Offset => "offset",
            AttributeId::Onabort => "onabort",
            AttributeId::Onactivate => "onactivate",
            AttributeId::Onbegin => "onbegin",
            AttributeId::Onclick => "onclick",
            AttributeId::Onend => "onend",
            AttributeId::Onerror => "onerror",
            AttributeId::Onfocusin => "onfocusin",
            AttributeId::Onfocusout => "onfocusout",
            AttributeId::Onload => "onload",
            AttributeId::Onmousedown => "onmousedown",
            AttributeId::Onmousemove => "onmousemove",
            AttributeId::Onmouseout => "onmouseout",
            AttributeId::Onmouseover => "onmouseover",
            AttributeId::Onmouseup => "onmouseup",
            AttributeId::Onrepeat => "onrepeat",
            AttributeId::Onresize => "onresize",
            AttributeId::Onscroll => "onscroll",
            AttributeId::Onunload => "onunload",
            AttributeId::Onzoom => "onzoom",
            AttributeId::Opacity => "opacity",
            AttributeId::Operator => "operator",
            AttributeId::Order => "order",
            AttributeId::Orient => "orient",
            AttributeId::Orientation => "orientation",
            AttributeId::Origin => "origin",
            AttributeId::Overflow => "overflow",
            AttributeId::OverlinePosition => "overline-position",
            AttributeId::OverlineThickness => "overline-thickness",
            AttributeId::Panose1 => "panose-1",
            AttributeId::Path => "path",
            AttributeId::PathLength => "pathLength",
            AttributeId::PatternContentUnits => "patternContentUnits",
            AttributeId::PatternTransform => "patternTransform",
            AttributeId::PatternUnits => "patternUnits",
            AttributeId::PointerEvents => "pointer-events",
            AttributeId::Points => "points",
            AttributeId::PointsAtX => "pointsAtX",
            AttributeId::PointsAtY => "pointsAtY",
            AttributeId::PointsAtZ => "pointsAtZ",
            AttributeId::PreserveAlpha => "preserveAlpha",
            AttributeId::PreserveAspectRatio => "preserveAspectRatio",
            AttributeId::PrimitiveUnits => "primitiveUnits",
            AttributeId::R => "r",
            AttributeId::Radius => "radius",
            AttributeId::RefX => "refX",
            AttributeId::RefY => "refY",
            AttributeId::RenderingIntent => "rendering-intent",
            AttributeId::RepeatCount => "repeatCount",
            AttributeId::RepeatDur => "repeatDur",
            AttributeId::RequiredExtensions => "requiredExtensions",
            AttributeId::RequiredFeatures => "requiredFeatures",
            AttributeId::Restart => "restart",
            AttributeId::Result => "result",
            AttributeId::Rotate => "rotate",
            AttributeId::Rx => "rx",
            AttributeId::Ry => "ry",
            AttributeId::Scale => "scale",
            AttributeId::Seed => "seed",
            AttributeId::ShapeRendering => "shape-rendering",
            AttributeId::Slope => "slope",
            AttributeId::Spacing => "spacing",
            AttributeId::SpecularConstant => "specularConstant",
            AttributeId::SpecularExponent => "specularExponent",
            AttributeId::SpreadMethod => "spreadMethod",
            AttributeId::StartOffset => "startOffset",
            AttributeId::StdDeviation => "stdDeviation",
            AttributeId::Stemh => "stemh",
            AttributeId::Stemv => "stemv",
            AttributeId::StitchTiles => "stitchTiles",
            AttributeId::StopColor => "stop-color",
            AttributeId::StopOpacity => "stop-opacity",
            AttributeId::StrikethroughPosition => "strikethrough-position",
            AttributeId::StrikethroughThickness => "strikethrough-thickness",
            AttributeId::String => "string",
            AttributeId::Stroke => "stroke",
            AttributeId::StrokeDasharray => "stroke-dasharray",
            AttributeId::StrokeDashoffset => "stroke-dashoffset",
            AttributeId::StrokeLinecap => "stroke-linecap",
            AttributeId::StrokeLinejoin => "stroke-linejoin",
            AttributeId::StrokeMiterlimit => "stroke-miterlimit",
            AttributeId::StrokeOpacity => "stroke-opacity",
            AttributeId::StrokeWidth => "stroke-width",
            AttributeId::Style => "style",
            AttributeId::SurfaceScale => "surfaceScale",
            AttributeId::SystemLanguage => "systemLanguage",
            AttributeId::TableValues => "tableValues",
            AttributeId::Target => "target",
            AttributeId::TargetX => "targetX",
            AttributeId::TargetY => "targetY",
            AttributeId::TextAnchor => "text-anchor",
            AttributeId::TextDecoration => "text-decoration",
            AttributeId::TextRendering => "text-rendering",
            AttributeId::TextLength => "textLength",
            AttributeId::Title => "title",
            AttributeId::To => "to",
            AttributeId::Transform => "transform",
            AttributeId::Type => "type",
            AttributeId::U1 => "u1",
            AttributeId::U2 => "u2",
            AttributeId::UnderlinePosition => "underline-position",
            AttributeId::UnderlineThickness => "underline-thickness",
            AttributeId::Unicode => "unicode",
            AttributeId::UnicodeBidi => "unicode-bidi",
            AttributeId::UnicodeRange => "unicode-range",
            AttributeId::UnitsPerEm => "units-per-em",
            AttributeId::VAlphabetic => "v-alphabetic",
            AttributeId::VHanging => "v-hanging",
            AttributeId::VIdeographic => "v-ideographic",
            AttributeId::VMathematical => "v-mathematical",
            AttributeId::Values => "values",
            AttributeId::Version => "version",
            AttributeId::VertAdvY => "vert-adv-y",
            AttributeId::VertOriginX => "vert-origin-x",
            AttributeId::VertOriginY => "vert-origin-y",
            AttributeId::ViewBox => "viewBox",
            AttributeId::ViewTarget => "viewTarget",
            AttributeId::Visibility => "visibility",
            AttributeId::Width => "width",
            AttributeId::Widths => "widths",
            AttributeId::WordSpacing => "word-spacing",
            AttributeId::WritingMode => "writing-mode",
            AttributeId::X => "x",
            AttributeId::XHeight => "x-height",
            AttributeId::X1 => "x1",
            AttributeId::X2 => "x2",
            AttributeId::XChannelSelector => "xChannelSelector",
            AttributeId::XlinkActuate => "xlink:actuate",
            AttributeId::XlinkArcrole => "xlink:arcrole",
            AttributeId::XlinkHref => "xlink:href",
            AttributeId::XlinkRole => "xlink:role",
            AttributeId::XlinkShow => "xlink:show",
            AttributeId::XlinkTitle => "xlink:title",
            AttributeId::XlinkType => "xlink:type",
            AttributeId::XmlBase => "xml:base",
            AttributeId::XmlLang => "xml:lang",
            AttributeId::XmlSpace => "xml:space",
            AttributeId::Xmlns => "xmlns",
            AttributeId::XmlnsXlink => "xmlns:xlink",
            AttributeId::Y => "y",
            AttributeId::Y1 => "y1",
            AttributeId::Y2 => "y2",
            AttributeId::YChannelSelector => "yChannelSelector",
            AttributeId::Z => "z",
            AttributeId::ZoomAndPan => "zoomAndPan"
        }
    }
}

impl fmt::Debug for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.name())
    }
}

impl fmt::Display for AttributeId {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.name())
    }
}
