/* src/bazaar.p/bz-blocklist-condition-match-locale.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-blocklist-condition-match-locale.h"



struct _BzBlocklistConditionMatchLocale
{
  GObject parent_instance;

  char *regex;
};

G_DEFINE_FINAL_TYPE (BzBlocklistConditionMatchLocale, bz_blocklist_condition_match_locale, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_REGEX,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_blocklist_condition_match_locale_dispose (GObject *object)
{
  BzBlocklistConditionMatchLocale *self = BZ_BLOCKLIST_CONDITION_MATCH_LOCALE (object);

  g_clear_pointer (&self->regex, g_free);

  G_OBJECT_CLASS (bz_blocklist_condition_match_locale_parent_class)->dispose (object);
}

static void
bz_blocklist_condition_match_locale_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzBlocklistConditionMatchLocale *self = BZ_BLOCKLIST_CONDITION_MATCH_LOCALE (object);

  switch (prop_id)
    {
    case PROP_REGEX:
      g_value_set_string (value, bz_blocklist_condition_match_locale_get_regex (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_condition_match_locale_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzBlocklistConditionMatchLocale *self = BZ_BLOCKLIST_CONDITION_MATCH_LOCALE (object);

  switch (prop_id)
    {
    case PROP_REGEX:
      bz_blocklist_condition_match_locale_set_regex (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_condition_match_locale_class_init (BzBlocklistConditionMatchLocaleClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_blocklist_condition_match_locale_set_property;
  object_class->get_property = bz_blocklist_condition_match_locale_get_property;
  object_class->dispose      = bz_blocklist_condition_match_locale_dispose;

  props[PROP_REGEX] =
      g_param_spec_string (
          "regex",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_blocklist_condition_match_locale_init (BzBlocklistConditionMatchLocale *self)
{
}

BzBlocklistConditionMatchLocale *
bz_blocklist_condition_match_locale_new (void){
  return g_object_new (BZ_TYPE_BLOCKLIST_CONDITION_MATCH_LOCALE, NULL);
}

const char *
bz_blocklist_condition_match_locale_get_regex (BzBlocklistConditionMatchLocale *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST_CONDITION_MATCH_LOCALE (self), NULL);
  return self->regex;
}

void
bz_blocklist_condition_match_locale_set_regex (BzBlocklistConditionMatchLocale *self,
    const char *regex){
  g_return_if_fail (BZ_IS_BLOCKLIST_CONDITION_MATCH_LOCALE (self));

  if (regex == self->regex || (regex != NULL && self->regex != NULL && g_strcmp0(regex, self->regex) == 0))
    return;

  g_clear_pointer (&self->regex, g_free);
  if (regex != NULL)
    self->regex = g_strdup (regex);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_REGEX]);
}

/* End of src/bazaar.p/bz-blocklist-condition-match-locale.c */
