/* DefaultCharactersSet.c generated by valac 0.56.17, the Vala compiler
 * generated from DefaultCharactersSet.vala, do not modify */

/*
Copyright (C) 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _bird_font_default_languages_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_default_languages_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontParamSpecDefaultCharacterSet BirdFontParamSpecDefaultCharacterSet;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BirdFontParamSpecDefaultLanguages BirdFontParamSpecDefaultLanguages;

struct _BirdFontParamSpecDefaultCharacterSet {
	GParamSpec parent_instance;
};

struct _BirdFontParamSpecDefaultLanguages {
	GParamSpec parent_instance;
};

static gpointer bird_font_default_character_set_parent_class = NULL;
BirdFontDefaultLanguages* bird_font_default_character_set_languages = NULL;
static gpointer bird_font_default_languages_parent_class = NULL;
GeeArrayList* bird_font_default_languages_names = NULL;
GeeArrayList* bird_font_default_languages_codes = NULL;
GeeArrayList* bird_font_default_languages_characters = NULL;

static gchar* bird_font_default_character_set_get_prefered_language_code (void);
static void bird_font_default_character_set_use_private_area (BirdFontGlyphRange* gr);
static void bird_font_default_character_set_use_default_range_alphabetic (BirdFontGlyphRange* gr);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void bird_font_default_character_set_finalize (BirdFontDefaultCharacterSet * obj);
static GType bird_font_default_character_set_get_type_once (void);
static void bird_font_default_languages_finalize (BirdFontDefaultLanguages * obj);
static GType bird_font_default_languages_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
bird_font_default_character_set_create_default_character_sets (void)
{
	BirdFontDefaultLanguages* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	_tmp0_ = bird_font_default_languages_new ();
	_bird_font_default_languages_unref0 (bird_font_default_character_set_languages);
	bird_font_default_character_set_languages = _tmp0_;
	_tmp1_ = bird_font_t_ ("Default Language");
	_tmp2_ = _tmp1_;
	bird_font_default_character_set_add_language (_tmp2_, "", "");
	_g_free0 (_tmp2_);
	_tmp3_ = bird_font_t_ ("Private Use Area");
	_tmp4_ = _tmp3_;
	bird_font_default_character_set_add_language (_tmp4_, "PRIVATE_USE", "");
	_g_free0 (_tmp4_);
	_tmp5_ = bird_font_t_ ("Czech");
	_tmp6_ = _tmp5_;
	bird_font_default_character_set_add_language (_tmp6_, "cs", "A Á B C Č D Ď E É Ě F G H Ch I Í J K L M N Ň O Ó P Q R Ř S Š T Ť U Ú Ů" \
" V W X Y Ý Z Ž a á b c č d ď e é ě f g h ch i í j k l m n ň o ó p q r " \
"ř s š t ť u ú ů v w x y ý z ž");
	_g_free0 (_tmp6_);
	_tmp7_ = bird_font_t_ ("Chinese");
	_tmp8_ = _tmp7_;
	bird_font_default_character_set_add_language (_tmp8_, "zh", "");
	_g_free0 (_tmp8_);
	_tmp9_ = bird_font_t_ ("English");
	_tmp10_ = _tmp9_;
	bird_font_default_character_set_add_language (_tmp10_, "en", "A B C D E F G H I J K L M N O P Q R S T U V W X Y Z a b c d e f g h i " \
"j k l m n o p q r s t u v w x y z");
	_g_free0 (_tmp10_);
	_tmp11_ = bird_font_t_ ("Greek");
	_tmp12_ = _tmp11_;
	bird_font_default_character_set_add_language (_tmp12_, "el", "Α Β Γ Δ Ε Ζ Η Θ Ι Κ Λ Μ Ν Ξ Ο Π Ρ Σ Τ Υ Φ Χ Ψ Ω α β γ δ ε ζ η θ ι κ λ " \
"μ ν ξ ο π ρ σ ς τ υ φ χ ψ ω");
	_g_free0 (_tmp12_);
	_tmp13_ = bird_font_t_ ("Japanese");
	_tmp14_ = _tmp13_;
	bird_font_default_character_set_add_language (_tmp14_, "ja", "");
	_g_free0 (_tmp14_);
	_tmp15_ = bird_font_t_ ("Javanese");
	_tmp16_ = _tmp15_;
	bird_font_default_character_set_add_language (_tmp16_, "jv", "ꦀ ꦁ ꦂ ꦃ ꦄ ꦅ ꦆ ꦇ ꦈ ꦉ ꦊ ꦋ ꦌ ꦍ ꦎ ꦏ ꦐ ꦑ ꦒ ꦓ ꦔ ꦕ ꦖ ꦗ ꦘ ꦙ ꦚ ꦛ ꦜ ꦝ ꦞ ꦟ ꦠ ꦡ ꦢ " \
"ꦣ ꦤ ꦥ ꦦ ꦧ ꦨ ꦩ ꦪ ꦫ ꦬ ꦭ ꦮ ꦯ ꦰ ꦱ ꦲ ꦳ ꦴ ꦵ ꦶ ꦷ ꦸ ꦹ ꦺ ꦻ ꦼ ꦽ ꦾ ꦿ ꧀ ꧁ ꧂ ꧃ ꧄ ꧅ " \
"꧆ ꧇ ꧈ ꧉ ꧊ ꧋ ꧌ ꧍ ꧏ ꧐ ꧑ ꧒ ꧓ ꧔ ꧕ ꧖ ꧗ ꧘ ꧙ ꧞ ꧟ A B C D E F G H I J K L M N " \
"O P Q R S T U V W X Y Z a b c d e f g h i j k l m n o p q r s t u v w " \
"x y z");
	_g_free0 (_tmp16_);
	_tmp17_ = bird_font_t_ ("Latin");
	_tmp18_ = _tmp17_;
	bird_font_default_character_set_add_language (_tmp18_, "la", "");
	_g_free0 (_tmp18_);
	_tmp19_ = bird_font_t_ ("Russian");
	_tmp20_ = _tmp19_;
	bird_font_default_character_set_add_language (_tmp20_, "ro", "А Б В Г Д Е Ё Ж З И Й К Л М Н О П Р С Т У Ф Х Ц Ч Ш Щ Ъ Ы Ь Э Ю Я а б " \
"в г д е ё ж з и й к л м н о п р с т у ф х ц ч ш щ ъ ы ь э ю я");
	_g_free0 (_tmp20_);
	_tmp21_ = bird_font_t_ ("Swedish");
	_tmp22_ = _tmp21_;
	bird_font_default_character_set_add_language (_tmp22_, "sv", "A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Å Ä Ö a b c d e f " \
"g h i j k l m n o p q r s t u v w x y z å ä ö");
	_g_free0 (_tmp22_);
	_tmp23_ = bird_font_t_ ("Thai");
	_tmp24_ = _tmp23_;
	bird_font_default_character_set_add_language (_tmp24_, "th", "ก-ฺ ฿-๛");
	_g_free0 (_tmp24_);
}

/** Add a new language to the menu for default character set.
 * @param language A localized string for the name of the language.
 * @param language_code ISO code
 * @param characters all characters (including characters with diacritical marks).
 * For languages with too many glyphs should this string be left empty. 
 * See the functions for chinese and japanese.
 */
void
bird_font_default_character_set_add_language (const gchar* language,
                                              const gchar* language_code,
                                              const gchar* characters)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (language != NULL);
	g_return_if_fail (language_code != NULL);
	g_return_if_fail (characters != NULL);
	_tmp0_ = bird_font_default_languages_names;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, language);
	_tmp1_ = bird_font_default_languages_codes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, language_code);
	_tmp2_ = bird_font_default_languages_characters;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, characters);
}

/** Add all glyphs for the current locale settings to this glyph range. */
void
bird_font_default_character_set_use_default_range (BirdFontGlyphRange* gr)
{
	gchar* language = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (gr != NULL);
	_tmp0_ = bird_font_default_character_set_get_prefered_language_code ();
	language = _tmp0_;
	_tmp1_ = language;
	if (g_strcmp0 (_tmp1_, "PRIVATE_USE") == 0) {
		bird_font_default_character_set_use_private_area (gr);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = language;
		if (g_str_has_prefix (_tmp2_, "ja")) {
			bird_font_default_character_set_use_default_range_japanese (gr);
		} else {
			const gchar* _tmp3_;
			_tmp3_ = language;
			if (g_str_has_prefix (_tmp3_, "la")) {
				bird_font_default_character_set_use_default_range_latin (gr);
			} else {
				const gchar* _tmp4_;
				_tmp4_ = language;
				if (g_str_has_prefix (_tmp4_, "zh")) {
					bird_font_default_character_set_use_default_range_chinese (gr);
				} else {
					bird_font_default_character_set_use_default_range_alphabetic (gr);
				}
			}
		}
	}
	bird_font_glyph_range_set_name (gr, "Default");
	_g_free0 (language);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
bird_font_default_character_set_get_prefered_language_code (void)
{
	gchar* prefered_language = NULL;
	gchar** languages = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint languages_length1;
	gint _languages_size_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	languages = _tmp2_;
	languages_length1 = _tmp2__length1;
	_languages_size_ = languages_length1;
	_tmp3_ = bird_font_preferences_get ("language");
	_g_free0 (prefered_language);
	prefered_language = _tmp3_;
	_tmp4_ = prefered_language;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		result = prefered_language;
		languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp5_ = languages;
	_tmp5__length1 = languages_length1;
	if (_tmp5__length1 == 0) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (prefered_language);
		return result;
	}
	_tmp7_ = languages;
	_tmp7__length1 = languages_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	languages = (_vala_array_free (languages, languages_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (prefered_language);
	return result;
}

gchar*
bird_font_default_character_set_get_characters_for_prefered_language (void)
{
	gchar* lang = NULL;
	gchar* _tmp0_;
	gint i = 0;
	gchar* characters = NULL;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = bird_font_default_character_set_get_prefered_language_code ();
	lang = _tmp0_;
	i = 0;
	_tmp1_ = g_strdup ("");
	characters = _tmp1_;
	{
		GeeArrayList* _code_list = NULL;
		GeeArrayList* _tmp2_;
		gint _code_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _code_index = 0;
		_tmp2_ = bird_font_default_languages_codes;
		_code_list = _tmp2_;
		_tmp3_ = _code_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_code_size = _tmp5_;
		_code_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* code = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp14_;
			_code_index = _code_index + 1;
			_tmp6_ = _code_index;
			_tmp7_ = _code_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _code_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _code_index);
			code = (gchar*) _tmp9_;
			_tmp10_ = lang;
			_tmp11_ = code;
			if (g_str_has_prefix (_tmp10_, _tmp11_)) {
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				_tmp12_ = bird_font_default_languages_characters;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
				_g_free0 (characters);
				characters = (gchar*) _tmp13_;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_g_free0 (code);
		}
	}
	result = characters;
	_g_free0 (lang);
	return result;
}

static void
bird_font_default_character_set_use_private_area (BirdFontGlyphRange* gr)
{
	g_return_if_fail (gr != NULL);
	bird_font_glyph_range_add_range (gr, (gunichar) 0xe000, (gunichar) 0xf8ff);
}

static void
bird_font_default_character_set_use_default_range_alphabetic (BirdFontGlyphRange* gr)
{
	gchar* lower_case = NULL;
	gchar* upper_case = NULL;
	gchar* all_characters = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (gr != NULL);
	_tmp0_ = bird_font_default_character_set_get_characters_for_prefered_language ();
	_g_free0 (all_characters);
	all_characters = _tmp0_;
	{
		const gchar* _tmp1_;
		_tmp1_ = all_characters;
		if (g_strcmp0 (_tmp1_, "") != 0) {
			const gchar* _tmp2_;
			_tmp2_ = all_characters;
			bird_font_glyph_range_parse_ranges (gr, _tmp2_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp3_ = bird_font_t_ ("a b c d e f g h i j k l m n o p q r s t u v w x y z");
			_g_free0 (lower_case);
			lower_case = _tmp3_;
			_tmp4_ = bird_font_t_ ("A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");
			_g_free0 (upper_case);
			upper_case = _tmp4_;
			_tmp5_ = lower_case;
			bird_font_glyph_range_parse_ranges (gr, _tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = upper_case;
			bird_font_glyph_range_parse_ranges (gr, _tmp6_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("DefaultCharactersSet.vala:128: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (all_characters);
		_g_free0 (upper_case);
		_g_free0 (lower_case);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	bird_font_glyph_range_add_range (gr, (gunichar) '0', (gunichar) '9');
	bird_font_glyph_range_add_single (gr, (gunichar) ' ');
	bird_font_glyph_range_add_single (gr, (gunichar) '.');
	bird_font_glyph_range_add_single (gr, (gunichar) '?');
	bird_font_glyph_range_add_single (gr, (gunichar) ',');
	bird_font_glyph_range_add_single (gr, 8217U);
	bird_font_glyph_range_add_range (gr, 8220U, 8221U);
	bird_font_glyph_range_add_single (gr, (gunichar) '&');
	bird_font_glyph_range_add_range (gr, (gunichar) ':', (gunichar) ';');
	bird_font_glyph_range_add_single (gr, (gunichar) '/');
	bird_font_glyph_range_add_range (gr, (gunichar) '!', (gunichar) '/');
	bird_font_glyph_range_add_single (gr, (gunichar) '-');
	bird_font_glyph_range_add_range (gr, 8208U, 8212U);
	bird_font_glyph_range_add_range (gr, (gunichar) '<', (gunichar) '@');
	bird_font_glyph_range_add_range (gr, (gunichar) '(', (gunichar) ')');
	_g_free0 (all_characters);
	_g_free0 (upper_case);
	_g_free0 (lower_case);
}

void
bird_font_default_character_set_use_default_range_japanese (BirdFontGlyphRange* gr)
{
	g_return_if_fail (gr != NULL);
	bird_font_glyph_range_add_range (gr, 12353U, 12438U);
	bird_font_glyph_range_add_range (gr, 12441U, 12447U);
	bird_font_glyph_range_add_range (gr, (gunichar) '!', 4370U);
	bird_font_glyph_range_add_range (gr, 65474U, 65479U);
	bird_font_glyph_range_add_range (gr, 65482U, 65487U);
	bird_font_glyph_range_add_range (gr, 65490U, 65495U);
	bird_font_glyph_range_add_range (gr, 65498U, 65500U);
	bird_font_glyph_range_add_range (gr, 162U, 8361U);
	bird_font_glyph_range_add_range (gr, 9474U, 9675U);
	bird_font_glyph_range_add_range (gr, 12784U, 12799U);
	bird_font_glyph_range_add_single (gr, 110592U);
	bird_font_glyph_range_add_single (gr, 110593U);
	bird_font_glyph_range_add_range (gr, 12688U, 12703U);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

void
bird_font_default_character_set_use_default_range_chinese (BirdFontGlyphRange* gr)
{
	gchar* pinyin_tones = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	g_return_if_fail (gr != NULL);
	_tmp0_ = g_strdup ("ˇ ˉ ˊ ˋ ˙ ā á ǎ à ō ó ǒ ò ē é ě è ī í ǐ ì ū ú ǔ ù ǖ ǘ ǚ ǜ ü Ā Á Ǎ À Ō " \
"Ó Ǒ Ò Ē É Ě È");
	_g_free0 (pinyin_tones);
	pinyin_tones = _tmp0_;
	bird_font_glyph_range_add_range (gr, (gunichar) 'a', (gunichar) 'z');
	_tmp1_ = pinyin_tones;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	{
		gchar** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp3_;
		c_collection_length1 = _vala_array_length (_tmp2_);
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			gchar* _tmp4_;
			gchar* c = NULL;
			_tmp4_ = g_strdup (c_collection[c_it]);
			c = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = c;
				bird_font_glyph_range_add_single (gr, string_get_char (_tmp5_, (glong) 0));
				_g_free0 (c);
			}
		}
		c_collection = (_vala_array_free (c_collection, c_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	bird_font_glyph_range_add_range (gr, 12288U, 12293U);
	bird_font_glyph_range_add_range (gr, 12295U, 12305U);
	bird_font_glyph_range_add_range (gr, 12307U, 12319U);
	bird_font_glyph_range_add_range (gr, 65040U, 65049U);
	bird_font_glyph_range_add_range (gr, (gunichar) '0', (gunichar) '9');
	bird_font_glyph_range_add_range (gr, 12832U, 12841U);
	bird_font_glyph_range_add_range (gr, 12992U, 13003U);
	bird_font_glyph_range_add_range (gr, 12881U, 12895U);
	bird_font_glyph_range_add_range (gr, 12977U, 12991U);
	bird_font_glyph_range_add_range (gr, 12928U, 12937U);
	bird_font_glyph_range_add_range (gr, 65281U, 65381U);
	bird_font_glyph_range_add_range (gr, 65504U, 65510U);
	bird_font_glyph_range_add_single (gr, 65512U);
	bird_font_glyph_range_add_range (gr, 13144U, 13311U);
	bird_font_glyph_range_add_range (gr, 13004U, 13007U);
	bird_font_glyph_range_add_range (gr, 12736U, 12770U);
	bird_font_glyph_range_add_range (gr, 11904U, 11929U);
	bird_font_glyph_range_add_range (gr, 11931U, 12019U);
	bird_font_glyph_range_add_single (gr, 8213U);
	bird_font_glyph_range_add_single (gr, 164U);
	bird_font_glyph_range_add_single (gr, 167U);
	bird_font_glyph_range_add_single (gr, 168U);
	bird_font_glyph_range_add_single (gr, 176U);
	bird_font_glyph_range_add_single (gr, 177U);
	bird_font_glyph_range_add_single (gr, 215U);
	bird_font_glyph_range_add_single (gr, 247U);
	bird_font_glyph_range_add_range (gr, 913U, 937U);
	bird_font_glyph_range_add_range (gr, 945U, 969U);
	bird_font_glyph_range_add_range (gr, 1040U, 1103U);
	bird_font_glyph_range_add_single (gr, 1105U);
	bird_font_glyph_range_add_single (gr, 1025U);
	bird_font_glyph_range_add_range (gr, 19968U, 40869U);
	bird_font_glyph_range_add_single (gr, 63788U);
	bird_font_glyph_range_add_single (gr, 63865U);
	bird_font_glyph_range_add_single (gr, 63893U);
	bird_font_glyph_range_add_single (gr, 63975U);
	bird_font_glyph_range_add_single (gr, 63985U);
	bird_font_glyph_range_add_range (gr, 64012U, 64015U);
	bird_font_glyph_range_add_single (gr, 64017U);
	bird_font_glyph_range_add_single (gr, 64019U);
	bird_font_glyph_range_add_single (gr, 64020U);
	bird_font_glyph_range_add_single (gr, 64024U);
	bird_font_glyph_range_add_single (gr, 64031U);
	bird_font_glyph_range_add_single (gr, 64032U);
	bird_font_glyph_range_add_single (gr, 64033U);
	bird_font_glyph_range_add_single (gr, 64035U);
	bird_font_glyph_range_add_single (gr, 64036U);
	bird_font_glyph_range_add_single (gr, 64039U);
	bird_font_glyph_range_add_single (gr, 64040U);
	bird_font_glyph_range_add_single (gr, 64041U);
	_g_free0 (pinyin_tones);
}

void
bird_font_default_character_set_use_default_range_latin (BirdFontGlyphRange* gr)
{
	g_return_if_fail (gr != NULL);
	bird_font_glyph_range_add_range (gr, (gunichar) '!', (gunichar) '~');
	bird_font_glyph_range_add_range (gr, 161U, 687U);
}

void
bird_font_default_character_set_use_full_unicode_range (BirdFontGlyphRange* gr)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (gr != NULL);
	bird_font_char_database_get_full_unicode (gr);
	if (bird_font_glyph_range_get_length (gr) == ((guint32) 0)) {
		{
			bird_font_glyph_range_parse_ranges (gr, "null-ͷ ͺ-; ΄-Ί Ό Ύ-Ρ Σ-ԧ Ա-Ֆ ՙ-՟ ա-և ։-֊ ֏ ֑-ׇ א-ת װ-״ ؀-؄ ؆-؛ ؞-܍ ܏-݊" \
" ݍ-ޱ ߀-ߺ ࠀ-࠭ ࠰-࠾ ࡀ-࡛ ࡞ ࢠ ࢢ-ࢬ ࣤ-ࣾ ऀ-ॷ ॹ-ॿ ঁ-ঃ অ-ঌ এ-ঐ ও-ন প-র ল শ-হ ়-ৄ" \
" ে-ৈ ো-ৎ ৗ ড়-ঢ় য়-৻ ਁ-ਃ ਅ-ਊ ਏ-ਐ ਓ-ਨ ਪ-ਰ ਲ-ਲ਼ ਵ-ਸ਼ ਸ-ਹ ਼ ਾ-ੂ ੇ-ੈ ੋ-੍ ੑ ਖ਼-ੜ" \
" ਫ਼ ੤-ੵ ઁ-ઃ અ-ઍ એ-ઑ ઓ-ન પ-ર લ-ળ વ-હ ઼-ૅ ે-ૉ ો-્ ૐ ૠ-૱ ଁ-ଃ ଅ-ଌ ଏ-ଐ ଓ-ନ ପ" \
"-ର ଲ-ଳ ଵ-ହ ଼-ୄ େ-ୈ ୋ-୍ ୖ-ୗ ଡ଼-ଢ଼ ୟ-୷ ஂ-ஃ அ-ஊ எ-ஐ ஒ-க ங-ச ஜ ஞ-ட ண-த ந-ப ம" \
"-ஹ ா-ூ ெ-ை ொ-் ௐ ௗ ௤-௺ ఁ-ః అ-ఌ ఎ-ఐ ఒ-న ప-ళ వ-హ ఽ-ౄ ె-ై ొ-్ ౕ-ౖ ౘ-ౙ ౠ-౯" \
" ౸-౿ ಂ-ಃ ಅ-ಌ ಎ-ಐ ಒ-ನ ಪ-ಳ ವ-ಹ ಼-ೄ ೆ-ೈ ೊ-್ ೕ-ೖ ೞ ೠ-೯ ೱ-ೲ ം-ഃ അ-ഌ എ-ഐ ഒ-ഺ" \
" ഽ-ൄ െ-ൈ ൊ-ൎ ൗ ൠ-൵ ൹-ൿ ං-ඃ අ-ඖ ක-න ඳ-ර ල ව-ෆ ් ා-ු ූ ෘ-ෟ ෲ-෴ ก-ฺ ฿-๛ ກ" \
"-ຂ ຄ ງ-ຈ ຊ ຍ ດ-ທ ນ-ຟ ມ-ຣ ລ ວ ສ-ຫ ອ-ູ ົ-ຽ ເ-ໄ ໆ ່-ໍ ໐-໙ ໜ-ໟ ༀ-ཇ ཉ-ཬ ཱ-ྗ" \
" ྙ-ྼ ྾-࿌ ࿎-࿚ က-Ⴥ Ⴧ Ⴭ ა-ቈ ቊ-ቍ ቐ-ቖ ቘ ቚ-ቝ በ-ኈ ኊ-ኍ ነ-ኰ ኲ-ኵ ኸ-ኾ ዀ ዂ-ዅ ወ-ዖ ዘ" \
"-ጐ ጒ-ጕ ጘ-ፚ ፝-፼ ᎀ-᎙ Ꭰ-Ᏼ ᐀-᚜ ᚠ-ᛰ ᜀ-ᜌ ᜎ-᜔ ᜠ-᜶ ᝀ-ᝓ ᝠ-ᝬ ᝮ-ᝰ ᝲ-ᝳ ក-៝ ០-៩ ៰-៹" \
" ᠀-᠎ ᠐-᠙ ᠠ-ᡷ ᢀ-ᢪ ᢰ-ᣵ ᤀ-ᤜ ᤠ-ᤫ ᤰ-᤻ ᥀ ᥄-ᥭ ᥰ-ᥴ ᦀ-ᦫ ᦰ-ᧉ ᧐-᧚ ᧞-ᨛ ᨞-ᩞ ᩠-᩼ ᩿-᪉" \
" ᪐-᪙ ᪠-᪭ ᬀ-ᭋ ᭐-᭼ ᮀ-᯳ ᯼-᰷ ᰻-᱉ ᱍ-᱿ ᳀-᳇ ᳐-ᳶ ᴀ-ᷦ ᷼-ἕ Ἐ-Ἕ ἠ-ὅ Ὀ-Ὅ ὐ-ὗ Ὑ Ὓ Ὕ" \
" Ὗ-ώ ᾀ-ᾴ ᾶ-ῄ ῆ-ΐ ῖ-Ί ῝-` ῲ-ῴ ῶ-῾  -⁤ ⁪-₎ ₐ-ₜ ₠-₹ ⃐-⃰ ℀-↉ ←-⏳ ␀-␦ ⑀-⑊ ①" \
"-⛿ ✁-⭌ ⭐-⭙ Ⰰ-Ⱞ ⰰ-ⱞ Ⱡ-ⳳ ⳹-ⴥ ⴧ ⴭ ⴰ-ⵧ ⵯ-⵰ ⵿-ⶖ ⶠ-ⶦ ⶨ-ⶮ ⶰ-ⶶ ⶸ-ⶾ ⷀ-ⷆ ⷈ-ⷎ ⷐ-ⷖ" \
" ⷘ-ⷞ ⷠ-⸻ ⺀-⺙ ⺛-⻳ ⼀-⿕ ⿰-⿻ 　-〿 ぁ-ゖ ゙-ヿ ㄅ-ㄭ ㄱ-ㆎ ㆐-ㆺ ㇀-㇣ ㇰ-㈞ ㈠-㋾ ㌀-㏿ ䷀-䷿ ꀀ" \
"-ꒌ ꒐-꓆ ꓐ-ꘫ Ꙁ-ꚗ ꚟ-꛷ ꜀-ꞎ Ꞑ-ꞓ Ꞡ-Ɦ ꟸ-꠫ ꠰-꠹ ꡀ-꡷ ꢀ-꣄ ꣎-꣙ ꣠-ꣻ ꤀-꥓ ꥟-ꥼ ꦀ-꧍ ꧏ-꧙" \
" ꧞-꧟ ꨀ-ꨶ ꩀ-ꩍ ꩐-꩙ ꩜-ꩻ ꪀ-ꫂ ꫛ-꫶ ꬁ-ꬆ ꬉ-ꬎ ꬑ-ꬖ ꬠ-ꬦ ꬨ-ꬮ ꯀ-꯭ ꯰-꯹ ힰ-ퟆ ퟋ-ퟻ 豈-舘 並" \
"-龎 ﬀ-ﬆ ﬓ-ﬗ יִ-זּ טּ-לּ מּ נּ-סּ ףּ-פּ צּ-﯁ ﯓ-﴿ ﵐ-ﶏ ﶒ-ﷇ ﷰ-﷽ ︀-︙ ︠-︦ ︰-﹒ ﹔-﹦ ﹨-﹫ ﹰ" \
"-ﹴ ﹶ-ﻼ ！-ﾾ ￂ-ￇ ￊ-ￏ ￒ-ￗ ￚ-ￜ ￠-￦ ￨-￮ ￹-� 𐀀-𐀋 𐀍-𐀦 𐀨-𐀺 𐀼-𐀽 𐀿-𐁍 𐁐-𐁝 𐂀-𐃺 𐄀-𐄂" \
" 𐄇-𐄳 𐄷-𐆊 𐆐-𐆛 𐇐-𐇽 𐊀-𐊜 𐊠-𐋐 𐌀-𐌞 𐌠-𐌣 𐌰-𐍊 𐎀-𐎝 𐎟-𐏃 𐏈-𐏕 𐐀-𐒝 𐒠-𐒩 𐠀-𐠅 𐠈 𐠊-𐠵 𐠷-𐠸" \
" 𐠼 𐠿-𐡕 𐡗-𐡟 𐤀-𐤛 𐤟-𐤹 𐤿 𐦀-𐦷 𐦾-𐦿 𐨀-𐨃 𐨅-𐨆 𐨌-𐨓 𐨕-𐨗 𐨙-𐨳 𐨸-𐨺 𐨿-𐩇 𐩐-𐩘 𐩠-𐩿 𐬀-𐬵 𐬹" \
"-𐭕 𐭘-𐭲 𐭸-𐭿 𐰀-𐱈 𐹠-𐹾 𑀀-𑁍 𑁒-𑁯 𑂀-𑃁 𑃐-𑃨 𑃰-𑃹 𑄀-𑄴 𑄶-𑅃 𑆀-𑇈 𑇐-𑇙 𑚀-𑚷 𑛀-𑛉 𒀀-𒍮 𒐀-𒑢" \
" 𒑰-𒑳 𓀀-𓐮 𖠀-𖨸 𖼀-𖽄 𖽐-𖽾 𖾏-𖾟 𛀀-𛀁 𝀀-𝃵 𝄀-𝄦 𝄩-𝇝 𝈀-𝉅 𝌀-𝍖 𝍠-𝍱 𝐀-𝚥 𝚨-𝟋 𝟎-𝟿 𞸀-𞸃 𞸅" \
"-𞸟 𞸡-𞸢 𞸤 𞸧 𞸩-𞸲 𞸴-𞸷 𞸹 𞸻 𞹂 𞹇 𞹉 𞹋 𞹍-𞹏 𞹑-𞹒 𞹔 𞹗 𞹙 𞹛 𞹝 𞹟 𞹡-𞹢 𞹤 𞹧-𞹪 𞹬-𞹲 𞹴-𞹷 𞹹" \
"-𞹼 𞹾 𞺀-𞺉 𞺋-𞺛 𞺡-𞺣 𞺥-𞺩 𞺫-𞺻 𞻰-𞻱 🀀-🀫 🀰-🂓 🂠-🂮 🂱-🂾 🃁-🃏 🃑-🃟 🄀-🄊 🄐-🄮 🄰-🅫 🅰-🆚 🇦" \
"-🈂 🈐-🈺 🉀-🉈 🉐-🉑 🌀-🌠 🌰-🌵 🌷-🍼 🎀-🎓 🎠-🏄 🏆-🏊 🏠-🏰 🐀-🐾 👀 👂-📷 📹-📼 🔀-🔽 🕀-🕃 🕐-🕧 🗻" \
"-🙀 🙅-🙏 🚀-🛅 🜀-🝳 丽-𪘀 󠀁 󠀠-󠁿 󠄀-󠇯", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_markup_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			const gchar* _tmp1_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->message;
			g_warning ("DefaultCharactersSet.vala:278: %s", _tmp1_);
			bird_font_glyph_range_add_range (gr, (gunichar) '\0', (gunichar) 0xFFF8);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	bird_font_glyph_range_set_name (gr, "Unicode");
}

static gpointer
_bird_font_default_languages_ref0 (gpointer self)
{
	return self ? bird_font_default_languages_ref (self) : NULL;
}

BirdFontDefaultLanguages*
bird_font_default_character_set_get_default_languages (void)
{
	BirdFontDefaultLanguages* _tmp0_;
	BirdFontDefaultLanguages* _tmp1_;
	BirdFontDefaultLanguages* result;
	_tmp0_ = bird_font_default_character_set_languages;
	_tmp1_ = _bird_font_default_languages_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontDefaultCharacterSet*
bird_font_default_character_set_construct (GType object_type)
{
	BirdFontDefaultCharacterSet* self = NULL;
	self = (BirdFontDefaultCharacterSet*) g_type_create_instance (object_type);
	return self;
}

BirdFontDefaultCharacterSet*
bird_font_default_character_set_new (void)
{
	return bird_font_default_character_set_construct (BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET);
}

static void
bird_font_value_default_character_set_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_default_character_set_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_default_character_set_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_default_character_set_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_default_character_set_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_default_character_set_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_default_character_set_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontDefaultCharacterSet * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_default_character_set_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_default_character_set_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	BirdFontDefaultCharacterSet ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_default_character_set_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_default_character_set (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	BirdFontParamSpecDefaultCharacterSet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_default_character_set (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_default_character_set (GValue* value,
                                           gpointer v_object)
{
	BirdFontDefaultCharacterSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_default_character_set_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_default_character_set_unref (old);
	}
}

void
bird_font_value_take_default_character_set (GValue* value,
                                            gpointer v_object)
{
	BirdFontDefaultCharacterSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_default_character_set_unref (old);
	}
}

static void
bird_font_default_character_set_class_init (BirdFontDefaultCharacterSetClass * klass,
                                            gpointer klass_data)
{
	bird_font_default_character_set_parent_class = g_type_class_peek_parent (klass);
	((BirdFontDefaultCharacterSetClass *) klass)->finalize = bird_font_default_character_set_finalize;
}

static void
bird_font_default_character_set_instance_init (BirdFontDefaultCharacterSet * self,
                                               gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_default_character_set_finalize (BirdFontDefaultCharacterSet * obj)
{
	BirdFontDefaultCharacterSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_DEFAULT_CHARACTER_SET, BirdFontDefaultCharacterSet);
	g_signal_handlers_destroy (self);
}

/** Default character sets for several languages. */
static GType
bird_font_default_character_set_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_default_character_set_init, bird_font_value_default_character_set_free_value, bird_font_value_default_character_set_copy_value, bird_font_value_default_character_set_peek_pointer, "p", bird_font_value_default_character_set_collect_value, "p", bird_font_value_default_character_set_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontDefaultCharacterSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_default_character_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontDefaultCharacterSet), 0, (GInstanceInitFunc) bird_font_default_character_set_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_default_character_set_type_id;
	bird_font_default_character_set_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontDefaultCharacterSet", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_default_character_set_type_id;
}

GType
bird_font_default_character_set_get_type (void)
{
	static volatile gsize bird_font_default_character_set_type_id__once = 0;
	if (g_once_init_enter (&bird_font_default_character_set_type_id__once)) {
		GType bird_font_default_character_set_type_id;
		bird_font_default_character_set_type_id = bird_font_default_character_set_get_type_once ();
		g_once_init_leave (&bird_font_default_character_set_type_id__once, bird_font_default_character_set_type_id);
	}
	return bird_font_default_character_set_type_id__once;
}

gpointer
bird_font_default_character_set_ref (gpointer instance)
{
	BirdFontDefaultCharacterSet * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_default_character_set_unref (gpointer instance)
{
	BirdFontDefaultCharacterSet * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_DEFAULT_CHARACTER_SET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

BirdFontDefaultLanguages*
bird_font_default_languages_construct (GType object_type)
{
	BirdFontDefaultLanguages* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (BirdFontDefaultLanguages*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_default_languages_names);
	bird_font_default_languages_names = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_default_languages_codes);
	bird_font_default_languages_codes = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_default_languages_characters);
	bird_font_default_languages_characters = _tmp2_;
	return self;
}

BirdFontDefaultLanguages*
bird_font_default_languages_new (void)
{
	return bird_font_default_languages_construct (BIRD_FONT_TYPE_DEFAULT_LANGUAGES);
}

gchar*
bird_font_default_languages_get_name (BirdFontDefaultLanguages* self,
                                      gint index)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_default_languages_names;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = bird_font_default_languages_names;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
		result = (gchar*) _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

gchar*
bird_font_default_languages_get_code (BirdFontDefaultLanguages* self,
                                      gint index)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_default_languages_codes;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = bird_font_default_languages_codes;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
		result = (gchar*) _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

static void
bird_font_value_default_languages_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_default_languages_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_default_languages_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_default_languages_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_default_languages_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_default_languages_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_default_languages_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontDefaultLanguages * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_default_languages_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_default_languages_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	BirdFontDefaultLanguages ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_default_languages_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_default_languages (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	BirdFontParamSpecDefaultLanguages* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_DEFAULT_LANGUAGES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_default_languages (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_LANGUAGES), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_default_languages (GValue* value,
                                       gpointer v_object)
{
	BirdFontDefaultLanguages * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_LANGUAGES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_DEFAULT_LANGUAGES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_default_languages_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_default_languages_unref (old);
	}
}

void
bird_font_value_take_default_languages (GValue* value,
                                        gpointer v_object)
{
	BirdFontDefaultLanguages * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_DEFAULT_LANGUAGES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_DEFAULT_LANGUAGES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_default_languages_unref (old);
	}
}

static void
bird_font_default_languages_class_init (BirdFontDefaultLanguagesClass * klass,
                                        gpointer klass_data)
{
	bird_font_default_languages_parent_class = g_type_class_peek_parent (klass);
	((BirdFontDefaultLanguagesClass *) klass)->finalize = bird_font_default_languages_finalize;
}

static void
bird_font_default_languages_instance_init (BirdFontDefaultLanguages * self,
                                           gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_default_languages_finalize (BirdFontDefaultLanguages * obj)
{
	BirdFontDefaultLanguages * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_DEFAULT_LANGUAGES, BirdFontDefaultLanguages);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_default_languages_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_default_languages_init, bird_font_value_default_languages_free_value, bird_font_value_default_languages_copy_value, bird_font_value_default_languages_peek_pointer, "p", bird_font_value_default_languages_collect_value, "p", bird_font_value_default_languages_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontDefaultLanguagesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_default_languages_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontDefaultLanguages), 0, (GInstanceInitFunc) bird_font_default_languages_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_default_languages_type_id;
	bird_font_default_languages_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontDefaultLanguages", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_default_languages_type_id;
}

GType
bird_font_default_languages_get_type (void)
{
	static volatile gsize bird_font_default_languages_type_id__once = 0;
	if (g_once_init_enter (&bird_font_default_languages_type_id__once)) {
		GType bird_font_default_languages_type_id;
		bird_font_default_languages_type_id = bird_font_default_languages_get_type_once ();
		g_once_init_leave (&bird_font_default_languages_type_id__once, bird_font_default_languages_type_id);
	}
	return bird_font_default_languages_type_id__once;
}

gpointer
bird_font_default_languages_ref (gpointer instance)
{
	BirdFontDefaultLanguages * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_default_languages_unref (gpointer instance)
{
	BirdFontDefaultLanguages * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_DEFAULT_LANGUAGES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

