/* FontSettings.c generated by valac 0.56.17, the Vala compiler
 * generated from FontSettings.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <xmlbird.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_FONT_SETTINGS_0_PROPERTY,
	BIRD_FONT_FONT_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* bird_font_font_settings_properties[BIRD_FONT_FONT_SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontFontSettingsPrivate {
	gchar* font_name;
	GeeHashMap* settings;
};

static gint BirdFontFontSettings_private_offset;
static gpointer bird_font_font_settings_parent_class = NULL;

static GFile* bird_font_font_settings_get_settings_file (BirdFontFontSettings* self);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
VALA_EXTERN gchar* bird_font_bird_font_file_encode (const gchar* s);
static void bird_font_font_settings_parse_settings (BirdFontFontSettings* self,
                                             BTag* tag);
static void bird_font_font_settings_parse_setting (BirdFontFontSettings* self,
                                            BTag* tag);
VALA_EXTERN gchar* bird_font_bird_font_file_decode (const gchar* s);
static void bird_font_font_settings_finalize (GObject * obj);
static GType bird_font_font_settings_get_type_once (void);

static inline gpointer
bird_font_font_settings_get_instance_private (BirdFontFontSettings* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFontSettings_private_offset);
}

BirdFontFontSettings*
bird_font_font_settings_construct (GType object_type)
{
	BirdFontFontSettings * self = NULL;
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	self = (BirdFontFontSettings*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_strdup ("new.bf");
	_g_free0 (self->priv->font_name);
	self->priv->font_name = _tmp1_;
	return self;
}

BirdFontFontSettings*
bird_font_font_settings_new (void)
{
	return bird_font_font_settings_construct (BIRD_FONT_TYPE_FONT_SETTINGS);
}

gchar*
bird_font_font_settings_get_setting (BirdFontFontSettings* self,
                                     const gchar* key)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->settings;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, key)) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, key);
		result = (gchar*) _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup ("");
	result = _tmp3_;
	return result;
}

void
bird_font_font_settings_set_setting (BirdFontFontSettings* self,
                                     const gchar* key,
                                     const gchar* v)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = self->priv->settings;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, v);
	_tmp1_ = self->priv->font_name;
	bird_font_font_settings_save (self, _tmp1_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GFile*
bird_font_font_settings_get_settings_file (BirdFontFontSettings* self)
{
	GFile* config_directory = NULL;
	GFile* _tmp0_;
	gchar* settings_file = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	config_directory = _tmp0_;
	_tmp1_ = self->priv->font_name;
	_tmp2_ = string_replace (_tmp1_, ".bf", ".config");
	settings_file = _tmp2_;
	_tmp3_ = settings_file;
	_tmp4_ = string_replace (_tmp3_, ".birdfont", ".config");
	_g_free0 (settings_file);
	settings_file = _tmp4_;
	_tmp5_ = settings_file;
	_tmp6_ = bird_font_get_child (config_directory, _tmp5_);
	result = _tmp6_;
	_g_free0 (settings_file);
	_g_object_unref0 (config_directory);
	return result;
}

void
bird_font_font_settings_save (BirdFontFontSettings* self,
                              const gchar* font_file_name)
{
	GFile* f = NULL;
	GString* sb = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font_file_name != NULL);
	_tmp0_ = g_strdup (font_file_name);
	_g_free0 (self->priv->font_name);
	self->priv->font_name = _tmp0_;
	{
		GFile* _tmp1_;
		GFile* _tmp2_;
		GString* _tmp4_;
		GString* _tmp5_;
		GString* _tmp6_;
		GString* _tmp31_;
		GFile* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GString* _tmp35_;
		const gchar* _tmp36_;
		_tmp1_ = bird_font_font_settings_get_settings_file (self);
		_g_object_unref0 (f);
		f = _tmp1_;
		_tmp2_ = f;
		if (g_file_query_exists (_tmp2_, NULL)) {
			GFile* _tmp3_;
			_tmp3_ = f;
			g_file_delete (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp4_ = g_string_new ("");
		_g_string_free0 (sb);
		sb = _tmp4_;
		_tmp5_ = sb;
		g_string_append (_tmp5_, "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n");
		_tmp6_ = sb;
		g_string_append (_tmp6_, "<settings>\n");
		{
			GeeIterator* _k_it = NULL;
			GeeHashMap* _tmp7_;
			GeeSet* _tmp8_;
			GeeSet* _tmp9_;
			GeeSet* _tmp10_;
			GeeIterator* _tmp11_;
			GeeIterator* _tmp12_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp10_);
			_k_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_;
				gchar* k = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				GString* _tmp16_;
				GString* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GString* _tmp21_;
				GString* _tmp22_;
				GString* _tmp23_;
				GeeHashMap* _tmp24_;
				const gchar* _tmp25_;
				gpointer _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				GString* _tmp30_;
				_tmp13_ = _k_it;
				if (!gee_iterator_next (_tmp13_)) {
					break;
				}
				_tmp14_ = _k_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				k = (gchar*) _tmp15_;
				_tmp16_ = sb;
				g_string_append (_tmp16_, "\t<setting key=\"");
				_tmp17_ = sb;
				_tmp18_ = k;
				_tmp19_ = bird_font_bird_font_file_encode (_tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append (_tmp17_, _tmp20_);
				_g_free0 (_tmp20_);
				_tmp21_ = sb;
				g_string_append (_tmp21_, "\" ");
				_tmp22_ = sb;
				g_string_append (_tmp22_, "value=\"");
				_tmp23_ = sb;
				_tmp24_ = self->priv->settings;
				_tmp25_ = k;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				_tmp27_ = (gchar*) _tmp26_;
				_tmp28_ = bird_font_bird_font_file_encode (_tmp27_);
				_tmp29_ = _tmp28_;
				g_string_append (_tmp23_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_tmp30_ = sb;
				g_string_append (_tmp30_, "\" />\n");
				_g_free0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp31_ = sb;
		g_string_append (_tmp31_, "</settings>\n");
		_tmp32_ = f;
		_tmp33_ = g_file_get_path (_tmp32_);
		_tmp34_ = (gchar*) _tmp33_;
		_tmp35_ = sb;
		_tmp36_ = _tmp35_->str;
		g_file_set_contents (_tmp34_, _tmp36_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp34_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp37_;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp37_ = stderr;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		fprintf (_tmp37_, "Can not save settings. (%s)", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (sb);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (sb);
	_g_object_unref0 (f);
}

void
bird_font_font_settings_load (BirdFontFontSettings* self,
                              const gchar* font_file_name)
{
	GFile* f = NULL;
	gchar* xml_data = NULL;
	BXmlParser* parser = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font_file_name != NULL);
	{
		GeeHashMap* _tmp0_;
		gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp0_ = self->priv->settings;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
		_tmp1_ = g_strdup (font_file_name);
		_g_free0 (self->priv->font_name);
		self->priv->font_name = _tmp1_;
		_tmp2_ = bird_font_font_settings_get_settings_file (self);
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		if (g_file_query_exists (_tmp3_, NULL)) {
			GFile* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_;
			BXmlParser* _tmp9_;
			BXmlParser* _tmp10_;
			BTag* _tmp11_;
			BTag* _tmp12_;
			_tmp4_ = f;
			_tmp5_ = g_file_get_path (_tmp4_);
			_tmp6_ = (gchar*) _tmp5_;
			g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error0_);
			_g_free0 (xml_data);
			xml_data = _tmp7_;
			_g_free0 (_tmp6_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = xml_data;
			_tmp9_ = b_xml_parser_new (_tmp8_);
			_g_object_unref0 (parser);
			parser = _tmp9_;
			_tmp10_ = parser;
			_tmp11_ = b_xml_parser_get_root_tag (_tmp10_);
			_tmp12_ = _tmp11_;
			bird_font_font_settings_parse_settings (self, _tmp12_);
			_g_object_unref0 (_tmp12_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("FontSettings.vala:102: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (xml_data);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (parser);
	_g_free0 (xml_data);
	_g_object_unref0 (f);
}

static void
bird_font_font_settings_parse_settings (BirdFontFontSettings* self,
                                        BTag* tag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "setting") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BTag* _tmp8_;
				_tmp8_ = t;
				bird_font_font_settings_parse_setting (self, _tmp8_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
}

static void
bird_font_font_settings_parse_setting (BirdFontFontSettings* self,
                                       BTag* tag)
{
	gchar* key = NULL;
	gchar* _tmp0_;
	gchar* v = NULL;
	gchar* _tmp1_;
	GeeHashMap* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = g_strdup ("");
	key = _tmp0_;
	_tmp1_ = g_strdup ("");
	v = _tmp1_;
	{
		BAttributesIterator* _a_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_a_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* a = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp6_ = _a_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _a_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			a = _tmp8_;
			_tmp9_ = a;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "key") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = a;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = bird_font_bird_font_file_decode (_tmp15_);
				_g_free0 (key);
				key = _tmp16_;
				_g_free0 (_tmp15_);
			}
			_tmp17_ = a;
			_tmp18_ = b_attribute_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "value") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp21_ = a;
				_tmp22_ = b_attribute_get_content (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = bird_font_bird_font_file_decode (_tmp23_);
				_g_free0 (v);
				v = _tmp24_;
				_g_free0 (_tmp23_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = key;
	_tmp27_ = v;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, _tmp27_);
	_g_free0 (v);
	_g_free0 (key);
}

static void
bird_font_font_settings_class_init (BirdFontFontSettingsClass * klass,
                                    gpointer klass_data)
{
	bird_font_font_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFontSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_font_settings_finalize;
}

static void
bird_font_font_settings_instance_init (BirdFontFontSettings * self,
                                       gpointer klass)
{
	self->priv = bird_font_font_settings_get_instance_private (self);
}

static void
bird_font_font_settings_finalize (GObject * obj)
{
	BirdFontFontSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FONT_SETTINGS, BirdFontFontSettings);
	_g_free0 (self->priv->font_name);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (bird_font_font_settings_parent_class)->finalize (obj);
}

/** Font specific settings file. */
static GType
bird_font_font_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFontSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_font_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFontSettings), 0, (GInstanceInitFunc) bird_font_font_settings_instance_init, NULL };
	GType bird_font_font_settings_type_id;
	bird_font_font_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFontSettings", &g_define_type_info, 0);
	BirdFontFontSettings_private_offset = g_type_add_instance_private (bird_font_font_settings_type_id, sizeof (BirdFontFontSettingsPrivate));
	return bird_font_font_settings_type_id;
}

GType
bird_font_font_settings_get_type (void)
{
	static volatile gsize bird_font_font_settings_type_id__once = 0;
	if (g_once_init_enter (&bird_font_font_settings_type_id__once)) {
		GType bird_font_font_settings_type_id;
		bird_font_font_settings_type_id = bird_font_font_settings_get_type_once ();
		g_once_init_leave (&bird_font_font_settings_type_id__once, bird_font_font_settings_type_id);
	}
	return bird_font_font_settings_type_id__once;
}

