/* HheaTable.c generated by valac 0.56.17, the Vala compiler
 * generated from HheaTable.vala, do not modify */

/*
Copyright (C) 2012 2013 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_HHEA_TABLE_0_PROPERTY,
	BIRD_FONT_HHEA_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_hhea_table_properties[BIRD_FONT_HHEA_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontHheaTablePrivate {
	BirdFontFixed version;
	guint16 max_advance;
	gint16 min_lsb;
	gint16 min_rsb;
	gint16 xmax_extent;
	gint16 carret_slope;
	gint16 carret_slope_run;
	gint16 carret_offset;
	gint16 metric_format;
	BirdFontGlyfTable* glyf_table;
	BirdFontHeadTable* head_table;
	BirdFontHmtxTable* hmtx_table;
	gint16 winAscent;
	gint16 winDescent;
};

static gint BirdFontHheaTable_private_offset;
static gpointer bird_font_hhea_table_parent_class = NULL;

static void bird_font_hhea_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static void bird_font_hhea_table_finalize (GObject * obj);
static GType bird_font_hhea_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_hhea_table_get_instance_private (BirdFontHheaTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontHheaTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontHheaTable*
bird_font_hhea_table_construct (GType object_type,
                                BirdFontGlyfTable* g,
                                BirdFontHeadTable* h,
                                BirdFontHmtxTable* hm)
{
	BirdFontHheaTable * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	BirdFontHeadTable* _tmp1_;
	BirdFontHmtxTable* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (g != NULL, NULL);
	g_return_val_if_fail (h != NULL, NULL);
	g_return_val_if_fail (hm != NULL, NULL);
	self = (BirdFontHheaTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (g);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	_tmp1_ = _g_object_ref0 (h);
	_g_object_unref0 (self->priv->head_table);
	self->priv->head_table = _tmp1_;
	_tmp2_ = _g_object_ref0 (hm);
	_g_object_unref0 (self->priv->hmtx_table);
	self->priv->hmtx_table = _tmp2_;
	_tmp3_ = g_strdup ("hhea");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp3_;
	return self;
}

BirdFontHheaTable*
bird_font_hhea_table_new (BirdFontGlyfTable* g,
                          BirdFontHeadTable* h,
                          BirdFontHmtxTable* hm)
{
	return bird_font_hhea_table_construct (BIRD_FONT_TYPE_HHEA_TABLE, g, h, hm);
}

gint16
bird_font_hhea_table_get_winascent (BirdFontHheaTable* self)
{
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	if (((gint) self->priv->winAscent) != 0) {
		result = self->priv->winAscent;
		return result;
	}
	{
		GeeArrayList* _glyph_list = NULL;
		BirdFontGlyfTable* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _glyph_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _glyph_index = 0;
		_tmp0_ = self->priv->glyf_table;
		_tmp1_ = _tmp0_->glyf_data;
		_glyph_list = _tmp1_;
		_tmp2_ = _glyph_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_glyph_size = _tmp4_;
		_glyph_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontGlyfData* glyph = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontGlyfData* _tmp9_;
			_glyph_index = _glyph_index + 1;
			_tmp5_ = _glyph_index;
			_tmp6_ = _glyph_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _glyph_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _glyph_index);
			glyph = (BirdFontGlyfData*) _tmp8_;
			_tmp9_ = glyph;
			if (_tmp9_->bounding_box_ymax > self->priv->winAscent) {
				BirdFontGlyfData* _tmp10_;
				_tmp10_ = glyph;
				self->priv->winAscent = _tmp10_->bounding_box_ymax;
			}
			_g_object_unref0 (glyph);
		}
	}
	result = self->priv->winAscent;
	return result;
}

gint16
bird_font_hhea_table_get_windescent (BirdFontHheaTable* self)
{
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	if (((gint) self->priv->winDescent) != 0) {
		result = self->priv->winDescent;
		return result;
	}
	{
		GeeArrayList* _glyph_list = NULL;
		BirdFontGlyfTable* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _glyph_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _glyph_index = 0;
		_tmp0_ = self->priv->glyf_table;
		_tmp1_ = _tmp0_->glyf_data;
		_glyph_list = _tmp1_;
		_tmp2_ = _glyph_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_glyph_size = _tmp4_;
		_glyph_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontGlyfData* glyph = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontGlyfData* _tmp9_;
			_glyph_index = _glyph_index + 1;
			_tmp5_ = _glyph_index;
			_tmp6_ = _glyph_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _glyph_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _glyph_index);
			glyph = (BirdFontGlyfData*) _tmp8_;
			_tmp9_ = glyph;
			if (_tmp9_->bounding_box_ymin < self->priv->winDescent) {
				BirdFontGlyfData* _tmp10_;
				_tmp10_ = glyph;
				self->priv->winDescent = -_tmp10_->bounding_box_ymin;
			}
			_g_object_unref0 (glyph);
		}
	}
	result = self->priv->winDescent;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_hhea_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontHheaTable * self;
	gint16 _tmp5_ = 0;
	gint16 _tmp6_ = 0;
	gint16 _tmp7_ = 0;
	gint16 _tmp8_ = 0;
	gint16 _tmp9_ = 0;
	gint16 _tmp10_ = 0;
	gint16 _tmp11_ = 0;
	gint16 _tmp12_ = 0;
	gint16 _tmp13_ = 0;
	gint16 _tmp14_ = 0;
	gint16 _tmp15_ = 0;
	GError* _inner_error0_ = NULL;
	self = (BirdFontHheaTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	self->priv->version = bird_font_font_data_read_fixed (dis);
	if (!bird_font_fixed_equals (self->priv->version, (guint16) 1, (guint16) 0)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = bird_font_fixed_get_string (self->priv->version);
		_tmp1_ = _tmp0_;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("wrong version in hhea table ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("HheaTable.vala:86: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp1_);
	}
	_tmp5_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->ascender = _tmp5_;
	_tmp6_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->descender = _tmp6_;
	_tmp7_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->line_gap = _tmp7_;
	self->priv->max_advance = bird_font_font_data_read_ushort (dis);
	_tmp8_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->min_lsb = _tmp8_;
	_tmp9_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->min_rsb = _tmp9_;
	_tmp10_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->xmax_extent = _tmp10_;
	_tmp11_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->carret_slope = _tmp11_;
	_tmp12_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->carret_slope_run = _tmp12_;
	_tmp13_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->carret_offset = _tmp13_;
	bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp14_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->metric_format = _tmp14_;
	_tmp15_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->num_horizontal_metrics = _tmp15_;
}

void
bird_font_hhea_table_process (BirdFontHheaTable* self,
                              GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFixed version = 0U;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontHmtxTable* _tmp2_;
	BirdFontHmtxTable* _tmp3_;
	BirdFontHmtxTable* _tmp4_;
	BirdFontHmtxTable* _tmp5_;
	BirdFontGlyfTable* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	BirdFontFontData* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	version = (BirdFontFixed) (1 << 16);
	_tmp1_ = bird_font_open_font_format_writer_get_current_font ();
	font = _tmp1_;
	bird_font_font_data_add_fixed (fd, version, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return;
	}
	self->ascender = (gint16) rint (font->top_limit * bird_font_head_table_UNITS);
	self->ascender = self->ascender - ((gint16) rint (font->base_line * bird_font_head_table_UNITS));
	self->descender = (gint16) rint (font->bottom_limit * bird_font_head_table_UNITS);
	self->descender = self->descender - ((gint16) rint (font->base_line * bird_font_head_table_UNITS));
	bird_font_font_data_add_16 (fd, self->ascender);
	bird_font_font_data_add_16 (fd, self->descender);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	_tmp2_ = self->priv->hmtx_table;
	bird_font_font_data_add_u16 (fd, (guint16) _tmp2_->max_advance);
	_tmp3_ = self->priv->hmtx_table;
	bird_font_font_data_add_16 (fd, _tmp3_->min_lsb);
	_tmp4_ = self->priv->hmtx_table;
	bird_font_font_data_add_16 (fd, _tmp4_->min_rsb);
	_tmp5_ = self->priv->hmtx_table;
	bird_font_font_data_add_16 (fd, _tmp5_->max_extent);
	bird_font_font_data_add_16 (fd, (gint16) 1);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	bird_font_font_data_add_16 (fd, (gint16) 0);
	_tmp6_ = self->priv->glyf_table;
	_tmp7_ = _tmp6_->glyphs;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	bird_font_font_data_add_u16 (fd, (guint16) _tmp9_);
	bird_font_font_data_pad (fd);
	_tmp10_ = _g_object_ref0 (fd);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp10_;
	_g_object_unref0 (font);
	_g_object_unref0 (fd);
}

static void
bird_font_hhea_table_class_init (BirdFontHheaTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_hhea_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontHheaTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_hhea_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_hhea_table_finalize;
}

static void
bird_font_hhea_table_instance_init (BirdFontHheaTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_hhea_table_get_instance_private (self);
	self->priv->winAscent = (gint16) 0;
	self->priv->winDescent = (gint16) 0;
}

static void
bird_font_hhea_table_finalize (GObject * obj)
{
	BirdFontHheaTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_HHEA_TABLE, BirdFontHheaTable);
	_g_object_unref0 (self->priv->glyf_table);
	_g_object_unref0 (self->priv->head_table);
	_g_object_unref0 (self->priv->hmtx_table);
	G_OBJECT_CLASS (bird_font_hhea_table_parent_class)->finalize (obj);
}

static GType
bird_font_hhea_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontHheaTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_hhea_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontHheaTable), 0, (GInstanceInitFunc) bird_font_hhea_table_instance_init, NULL };
	GType bird_font_hhea_table_type_id;
	bird_font_hhea_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontHheaTable", &g_define_type_info, 0);
	BirdFontHheaTable_private_offset = g_type_add_instance_private (bird_font_hhea_table_type_id, sizeof (BirdFontHheaTablePrivate));
	return bird_font_hhea_table_type_id;
}

GType
bird_font_hhea_table_get_type (void)
{
	static volatile gsize bird_font_hhea_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_hhea_table_type_id__once)) {
		GType bird_font_hhea_table_type_id;
		bird_font_hhea_table_type_id = bird_font_hhea_table_get_type_once ();
		g_once_init_leave (&bird_font_hhea_table_type_id__once, bird_font_hhea_table_type_id);
	}
	return bird_font_hhea_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

