/* KerningTools.c generated by valac 0.56.17, the Vala compiler
 * generated from KerningTools.vala, do not modify */

/*
Copyright (C) 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERNING_TOOLS_0_PROPERTY,
	BIRD_FONT_KERNING_TOOLS_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_tools_properties[BIRD_FONT_KERNING_TOOLS_NUM_PROPERTIES];
typedef struct _Block24Data Block24Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))

struct _Block24Data {
	int _ref_count_;
	BirdFontTool* right_to_left;
	gchar* empty_kerning_text;
};

struct _Block25Data {
	int _ref_count_;
	BirdFontKerningDisplay* d;
};

struct _Block26Data {
	int _ref_count_;
	BirdFontFontSettings* fs;
};

static gpointer bird_font_kerning_tools_parent_class = NULL;
GeeArrayList* bird_font_kerning_tools_expanders = NULL;
gint bird_font_kerning_tools_next_class = 0;
BirdFontExpander* bird_font_kerning_tools_classes = NULL;
gdouble bird_font_kerning_tools_font_size = (gdouble) 1;
BirdFontZoomBar* bird_font_kerning_tools_zoom_bar = NULL;
BirdFontTool* bird_font_kerning_tools_previous_kerning_string = NULL;
BirdFontTool* bird_font_kerning_tools_next_kerning_string = NULL;
BirdFontExpander* bird_font_kerning_tools_otf_features = NULL;
static BirdFontOtfTags* bird_font_kerning_tools_active_otf_features;
static BirdFontOtfTags* bird_font_kerning_tools_active_otf_features = NULL;

static void bird_font_kerning_tools_real_selected (BirdFontToolCollection* base);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda94_ (gdouble z);
static void ___lambda94__bird_font_zoom_bar_new_zoom (BirdFontZoomBar* _sender,
                                               gdouble zoom_level,
                                               gpointer self);
static void __lambda95_ (BirdFontTool* _self_);
static void ___lambda95__bird_font_tool_select_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gpointer self);
static void __lambda96_ (BirdFontTool* _self_);
static void ___lambda96__bird_font_tool_select_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gpointer self);
static void __lambda99_ (BirdFontTool* _self_);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda317_ (Block25Data* _data25_,
                   BirdFontGlyphCollection* gc);
static void ___lambda317__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                             BirdFontGlyphCollection* gc,
                                                             gpointer self);
static void ___lambda99__bird_font_tool_select_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gpointer self);
static void __lambda318_ (BirdFontTool* _self_);
static void ___lambda318__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda319_ (Block24Data* _data24_,
                   BirdFontTool* _self_);
static void ___lambda319__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda320_ (Block24Data* _data24_,
                   BirdFontTool* _self_);
static void ___lambda320__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda322_ (Block24Data* _data24_,
                   BirdFontTool* _self_);
static void ___lambda322__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __lambda323_ (Block26Data* _data26_,
                   gboolean enable,
                   const gchar* tag);
static void ___lambda323__bird_font_otf_label_otf_feature_activity (BirdFontOtfLabel* _sender,
                                                             gboolean enable,
                                                             const gchar* tag,
                                                             gpointer self);
static void bird_font_kerning_tools_remove_all_kerning_classes (void);
static GeeArrayList* bird_font_kerning_tools_real_get_expanders (BirdFontToolCollection* base);
static GeeArrayList* bird_font_kerning_tools_real_get_displays (BirdFontToolCollection* base);
static void bird_font_kerning_tools_finalize (GObject * obj);
static GType bird_font_kerning_tools_get_type_once (void);

BirdFontKerningTools*
bird_font_kerning_tools_construct (GType object_type)
{
	BirdFontKerningTools * self = NULL;
	self = (BirdFontKerningTools*) bird_font_tool_collection_construct (object_type);
	bird_font_tool_collection_selected ((BirdFontToolCollection*) self);
	return self;
}

BirdFontKerningTools*
bird_font_kerning_tools_new (void)
{
	return bird_font_kerning_tools_construct (BIRD_FONT_TYPE_KERNING_TOOLS);
}

static void
bird_font_kerning_tools_real_selected (BirdFontToolCollection* base)
{
	BirdFontKerningTools * self;
	self = (BirdFontKerningTools*) base;
	bird_font_kerning_tools_init ();
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontOtfTags*
bird_font_kerning_tools_get_otf_tags (void)
{
	BirdFontOtfTags* _tmp0_;
	BirdFontOtfTags* _tmp2_;
	BirdFontOtfTags* _tmp3_;
	BirdFontOtfTags* result;
	_tmp0_ = bird_font_kerning_tools_active_otf_features;
	if (bird_font_is_null (_tmp0_)) {
		BirdFontOtfTags* _tmp1_;
		_tmp1_ = bird_font_otf_tags_new ();
		result = _tmp1_;
		return result;
	}
	_tmp2_ = bird_font_kerning_tools_active_otf_features;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		_g_free0 (_data24_->empty_kerning_text);
		_g_object_unref0 (_data24_->right_to_left);
		g_slice_free (Block24Data, _data24_);
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
__lambda94_ (gdouble z)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFontSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	bird_font_kerning_tools_font_size = 3 * z;
	if (bird_font_kerning_tools_font_size < 0.1) {
		bird_font_kerning_tools_font_size = 0.1;
	}
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (f);
	f = _tmp0_;
	_tmp1_ = f->settings;
	_tmp2_ = double_to_string (z);
	_tmp3_ = _tmp2_;
	bird_font_font_settings_set_setting (_tmp1_, "kerning_zoom", _tmp3_);
	_g_free0 (_tmp3_);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (f);
}

static void
___lambda94__bird_font_zoom_bar_new_zoom (BirdFontZoomBar* _sender,
                                          gdouble zoom_level,
                                          gpointer self)
{
	__lambda94_ (zoom_level);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda95_ (BirdFontTool* _self_)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	gchar* label = NULL;
	gchar* _tmp1_;
	BirdFontKerningRange* kr = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	BirdFontKerningRange* _tmp8_;
	BirdFontKerningRange* _tmp9_;
	BirdFontExpander* _tmp10_;
	BirdFontExpander* _tmp11_;
	BirdFontExpander* _tmp12_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = bird_font_t_ ("Kerning class");
	label = _tmp1_;
	_tmp2_ = string_to_string (label);
	bird_font_kerning_tools_next_class = bird_font_kerning_tools_next_class + 1;
	_tmp3_ = bird_font_kerning_tools_next_class;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, " ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_kerning_range_new (f, _tmp7_, "");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	kr = _tmp9_;
	_tmp10_ = bird_font_kerning_tools_classes;
	bird_font_expander_add_tool (_tmp10_, (BirdFontTool*) kr, -1);
	bird_font_tool_set_selected (_self_, FALSE);
	_tmp11_ = bird_font_kerning_tools_classes;
	bird_font_expander_clear_cache (_tmp11_);
	_tmp12_ = bird_font_kerning_tools_classes;
	bird_font_expander_redraw (_tmp12_);
	_g_object_unref0 (kr);
	_g_free0 (label);
	_g_object_unref0 (f);
}

static void
___lambda95__bird_font_tool_select_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gpointer self)
{
	__lambda95_ (selected);
}

static void
__lambda96_ (BirdFontTool* _self_)
{
	BirdFontKerningDisplay* d = NULL;
	BirdFontKerningDisplay* _tmp0_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	d = _tmp0_;
	bird_font_kerning_display_set_kerning_by_text (d);
	bird_font_tool_set_selected (_self_, FALSE);
	_g_object_unref0 (d);
}

static void
___lambda96__bird_font_tool_select_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gpointer self)
{
	__lambda96_ (selected);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		_g_object_unref0 (_data25_->d);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda317_ (Block25Data* _data25_,
              BirdFontGlyphCollection* gc)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontTabBar* _tmp2_;
	BirdFontTabBar* _tmp3_;
	g_return_if_fail (gc != NULL);
	_tmp0_ = bird_font_glyph_collection_get_current (gc);
	_tmp1_ = _tmp0_;
	bird_font_kerning_display_inser_glyph (_data25_->d, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_main_window_get_tab_bar ();
	_tmp3_ = _tmp2_;
	bird_font_tab_bar_select_tab_name (_tmp3_, "Kerning");
	_g_object_unref0 (_tmp3_);
}

static void
___lambda317__bird_font_glyph_selection_selected_glyph (BirdFontGlyphSelection* _sender,
                                                        BirdFontGlyphCollection* gc,
                                                        gpointer self)
{
	__lambda317_ (self, gc);
}

static void
__lambda99_ (BirdFontTool* _self_)
{
	Block25Data* _data25_;
	BirdFontKerningDisplay* _tmp0_;
	BirdFontGlyphSelection* gs = NULL;
	BirdFontGlyphSelection* _tmp1_;
	g_return_if_fail (_self_ != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	_data25_->d = _tmp0_;
	_tmp1_ = bird_font_glyph_selection_new ();
	gs = _tmp1_;
	g_signal_connect_data (gs, "selected-glyph", (GCallback) ___lambda317__bird_font_glyph_selection_selected_glyph, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	bird_font_glyph_canvas_set_display ((BirdFontFontDisplay*) gs);
	bird_font_tool_set_selected (_self_, FALSE);
	_g_object_unref0 (gs);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static void
___lambda99__bird_font_tool_select_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gpointer self)
{
	__lambda99_ (selected);
}

static void
__lambda318_ (BirdFontTool* _self_)
{
	BirdFontKerningDisplay* d = NULL;
	BirdFontKerningDisplay* _tmp0_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	d = _tmp0_;
	bird_font_kerning_display_insert_unichar (d);
	bird_font_tool_set_selected (_self_, FALSE);
	_g_object_unref0 (d);
}

static void
___lambda318__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda318_ (selected);
}

static void
__lambda319_ (Block24Data* _data24_,
              BirdFontTool* _self_)
{
	BirdFontTool* _tmp0_;
	g_return_if_fail (_self_ != NULL);
	bird_font_kerning_display_right_to_left = !bird_font_kerning_display_right_to_left;
	_tmp0_ = _data24_->right_to_left;
	bird_font_tool_set_selected (_tmp0_, bird_font_kerning_display_right_to_left);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda319__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda319_ (self, selected);
}

static void
__lambda320_ (Block24Data* _data24_,
              BirdFontTool* _self_)
{
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontKerningDisplay* d = NULL;
	BirdFontFontDisplay* _tmp1_;
	BirdFontKerningDisplay* _tmp2_;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp3_;
	gchar* w = NULL;
	BirdFontFont* _tmp4_;
	BirdFontKerningStrings* _tmp5_;
	gchar* _tmp6_;
	BirdFontFont* _tmp7_;
	BirdFontKerningStrings* _tmp8_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_current_display ();
	fd = _tmp0_;
	_tmp1_ = fd;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay));
	d = _tmp2_;
	_tmp3_ = bird_font_bird_font_get_current_font ();
	f = _tmp3_;
	_tmp4_ = f;
	_tmp5_ = _tmp4_->kerning_strings;
	_tmp6_ = bird_font_kerning_strings_previous (_tmp5_);
	w = _tmp6_;
	_tmp7_ = f;
	_tmp8_ = _tmp7_->kerning_strings;
	if (bird_font_kerning_strings_is_empty (_tmp8_)) {
		const gchar* _tmp9_;
		BirdFontMessageDialog* _tmp10_;
		BirdFontMessageDialog* _tmp11_;
		_tmp9_ = _data24_->empty_kerning_text;
		_tmp10_ = bird_font_main_window_show_message (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
	} else {
		const gchar* _tmp12_;
		_tmp12_ = w;
		if (g_strcmp0 (_tmp12_, "") == 0) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			BirdFontMessageDialog* _tmp15_;
			BirdFontMessageDialog* _tmp16_;
			_tmp13_ = bird_font_t_ ("You have reached the beginning of the list.");
			_tmp14_ = _tmp13_;
			_tmp15_ = bird_font_main_window_show_message (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp16_);
			_g_free0 (_tmp14_);
		} else {
			BirdFontKerningDisplay* _tmp17_;
			BirdFontKerningDisplay* _tmp18_;
			const gchar* _tmp19_;
			_tmp17_ = d;
			bird_font_kerning_display_new_line (_tmp17_);
			_tmp18_ = d;
			_tmp19_ = w;
			bird_font_kerning_display_add_text (_tmp18_, _tmp19_);
		}
	}
	bird_font_tool_set_selected (_self_, FALSE);
	_g_free0 (w);
	_g_object_unref0 (f);
	_g_object_unref0 (d);
	_g_object_unref0 (fd);
}

static void
___lambda320__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda320_ (self, selected);
}

static void
__lambda322_ (Block24Data* _data24_,
              BirdFontTool* _self_)
{
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontKerningDisplay* d = NULL;
	BirdFontFontDisplay* _tmp1_;
	BirdFontKerningDisplay* _tmp2_;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp3_;
	gchar* w = NULL;
	BirdFontFont* _tmp4_;
	BirdFontKerningStrings* _tmp5_;
	gchar* _tmp6_;
	BirdFontFont* _tmp7_;
	BirdFontKerningStrings* _tmp8_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_current_display ();
	fd = _tmp0_;
	_tmp1_ = fd;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay));
	d = _tmp2_;
	_tmp3_ = bird_font_bird_font_get_current_font ();
	f = _tmp3_;
	_tmp4_ = f;
	_tmp5_ = _tmp4_->kerning_strings;
	_tmp6_ = bird_font_kerning_strings_next (_tmp5_);
	w = _tmp6_;
	_tmp7_ = f;
	_tmp8_ = _tmp7_->kerning_strings;
	if (bird_font_kerning_strings_is_empty (_tmp8_)) {
		const gchar* _tmp9_;
		BirdFontMessageDialog* _tmp10_;
		BirdFontMessageDialog* _tmp11_;
		_tmp9_ = _data24_->empty_kerning_text;
		_tmp10_ = bird_font_main_window_show_message (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
	} else {
		const gchar* _tmp12_;
		_tmp12_ = w;
		if (g_strcmp0 (_tmp12_, "") == 0) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			BirdFontMessageDialog* _tmp15_;
			BirdFontMessageDialog* _tmp16_;
			_tmp13_ = bird_font_t_ ("You have reached the end of the list.");
			_tmp14_ = _tmp13_;
			_tmp15_ = bird_font_main_window_show_message (_tmp14_);
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp16_);
			_g_free0 (_tmp14_);
		} else {
			BirdFontKerningDisplay* _tmp17_;
			BirdFontKerningDisplay* _tmp18_;
			const gchar* _tmp19_;
			_tmp17_ = d;
			bird_font_kerning_display_new_line (_tmp17_);
			_tmp18_ = d;
			_tmp19_ = w;
			bird_font_kerning_display_add_text (_tmp18_, _tmp19_);
		}
	}
	bird_font_tool_set_selected (_self_, FALSE);
	_g_free0 (w);
	_g_object_unref0 (f);
	_g_object_unref0 (d);
	_g_object_unref0 (fd);
}

static void
___lambda322__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda322_ (self, selected);
}

void
bird_font_kerning_tools_init (void)
{
	Block24Data* _data24_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOtfTags* _tmp1_;
	BirdFontExpander* kerning_tools = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontExpander* _tmp4_;
	BirdFontExpander* _tmp5_;
	BirdFontExpander* _tmp6_;
	GeeArrayList* _tmp8_;
	BirdFontExpander* font_name = NULL;
	BirdFontExpander* _tmp9_;
	BirdFontExpander* _tmp10_;
	BirdFontFontName* _tmp11_;
	BirdFontFontName* _tmp12_;
	BirdFontExpander* zoom_expander = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BirdFontExpander* _tmp15_;
	BirdFontExpander* _tmp16_;
	BirdFontZoomBar* _tmp17_;
	BirdFontZoomBar* _tmp18_;
	BirdFontExpander* _tmp19_;
	BirdFontZoomBar* _tmp20_;
	BirdFontTool* new_kerning_class = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	BirdFontTool* _tmp23_;
	BirdFontTool* _tmp24_;
	BirdFontTool* _tmp25_;
	BirdFontExpander* _tmp26_;
	BirdFontTool* _tmp27_;
	BirdFontTool* text_kerning = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	BirdFontTool* _tmp30_;
	BirdFontTool* _tmp31_;
	BirdFontTool* _tmp32_;
	BirdFontExpander* _tmp33_;
	BirdFontTool* _tmp34_;
	BirdFontTool* insert_last = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_;
	BirdFontTool* _tmp37_;
	BirdFontTool* _tmp38_;
	BirdFontTool* _tmp39_;
	BirdFontExpander* _tmp40_;
	BirdFontTool* _tmp41_;
	BirdFontTool* insert_unicode = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_;
	BirdFontTool* _tmp44_;
	BirdFontTool* _tmp45_;
	BirdFontTool* _tmp46_;
	BirdFontExpander* _tmp47_;
	BirdFontTool* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	BirdFontTool* _tmp51_;
	BirdFontTool* _tmp52_;
	BirdFontTool* _tmp53_;
	BirdFontExpander* _tmp54_;
	BirdFontTool* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	BirdFontTool* _tmp59_;
	BirdFontTool* _tmp60_;
	BirdFontExpander* _tmp61_;
	BirdFontTool* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	BirdFontTool* _tmp65_;
	BirdFontTool* _tmp66_;
	BirdFontExpander* _tmp67_;
	BirdFontTool* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	BirdFontExpander* _tmp71_;
	BirdFontExpander* _tmp83_;
	BirdFontExpander* _tmp84_;
	BirdFontExpander* _tmp85_;
	BirdFontExpander* _tmp86_;
	GeeArrayList* _tmp87_;
	BirdFontExpander* _tmp88_;
	GeeArrayList* _tmp89_;
	BirdFontExpander* _tmp90_;
	GeeArrayList* _tmp91_;
	BirdFontExpander* _tmp92_;
	GeeArrayList* _tmp93_;
	BirdFontExpander* _tmp94_;
	GeeArrayList* _tmp95_;
	BirdFontExpander* _tmp96_;
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_otf_tags_new ();
	_g_object_unref0 (bird_font_kerning_tools_active_otf_features);
	bird_font_kerning_tools_active_otf_features = _tmp1_;
	_tmp2_ = bird_font_t_ ("Kerning Tools");
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_expander_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	kerning_tools = _tmp5_;
	_tmp6_ = bird_font_kerning_tools_classes;
	if (bird_font_is_null (_tmp6_)) {
		BirdFontExpander* _tmp7_;
		_tmp7_ = bird_font_expander_new (NULL);
		_g_object_unref0 (bird_font_kerning_tools_classes);
		bird_font_kerning_tools_classes = _tmp7_;
		bird_font_kerning_tools_update_kerning_classes ();
	}
	_tmp8_ = gee_array_list_new (BIRD_FONT_TYPE_EXPANDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_kerning_tools_expanders);
	bird_font_kerning_tools_expanders = _tmp8_;
	_tmp9_ = bird_font_expander_new (NULL);
	font_name = _tmp9_;
	_tmp10_ = font_name;
	_tmp11_ = bird_font_font_name_new (NULL, "");
	_tmp12_ = _tmp11_;
	bird_font_expander_add_tool (_tmp10_, (BirdFontTool*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = bird_font_t_ ("Font Size");
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_expander_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	zoom_expander = _tmp16_;
	_tmp17_ = bird_font_zoom_bar_new ();
	_g_object_unref0 (bird_font_kerning_tools_zoom_bar);
	bird_font_kerning_tools_zoom_bar = _tmp17_;
	_tmp18_ = bird_font_kerning_tools_zoom_bar;
	g_signal_connect (_tmp18_, "new-zoom", (GCallback) ___lambda94__bird_font_zoom_bar_new_zoom, NULL);
	_tmp19_ = zoom_expander;
	_tmp20_ = bird_font_kerning_tools_zoom_bar;
	bird_font_expander_add_tool (_tmp19_, (BirdFontTool*) _tmp20_, -1);
	_tmp21_ = bird_font_t_ ("Create new kerning class.");
	_tmp22_ = _tmp21_;
	_tmp23_ = bird_font_tool_new ("kerning_class", _tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	new_kerning_class = _tmp24_;
	_tmp25_ = new_kerning_class;
	g_signal_connect (_tmp25_, "select-action", (GCallback) ___lambda95__bird_font_tool_select_action, NULL);
	_tmp26_ = kerning_tools;
	_tmp27_ = new_kerning_class;
	bird_font_expander_add_tool (_tmp26_, _tmp27_, -1);
	_tmp28_ = bird_font_t_ ("Use text input to enter kerning values.");
	_tmp29_ = _tmp28_;
	_tmp30_ = bird_font_tool_new ("kerning_text_input", _tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	text_kerning = _tmp31_;
	_tmp32_ = text_kerning;
	g_signal_connect (_tmp32_, "select-action", (GCallback) ___lambda96__bird_font_tool_select_action, NULL);
	_tmp33_ = kerning_tools;
	_tmp34_ = text_kerning;
	bird_font_expander_add_tool (_tmp33_, _tmp34_, -1);
	_tmp35_ = bird_font_t_ ("Insert glyph from overview");
	_tmp36_ = _tmp35_;
	_tmp37_ = bird_font_tool_new ("insert_glyph_from_overview", _tmp36_);
	_tmp38_ = _tmp37_;
	_g_free0 (_tmp36_);
	insert_last = _tmp38_;
	_tmp39_ = insert_last;
	g_signal_connect (_tmp39_, "select-action", (GCallback) ___lambda99__bird_font_tool_select_action, NULL);
	_tmp40_ = kerning_tools;
	_tmp41_ = insert_last;
	bird_font_expander_add_tool (_tmp40_, _tmp41_, -1);
	_tmp42_ = bird_font_t_ ("Insert character by unicode value");
	_tmp43_ = _tmp42_;
	_tmp44_ = bird_font_tool_new ("insert_unichar", _tmp43_);
	_tmp45_ = _tmp44_;
	_g_free0 (_tmp43_);
	insert_unicode = _tmp45_;
	_tmp46_ = insert_unicode;
	g_signal_connect (_tmp46_, "select-action", (GCallback) ___lambda318__bird_font_tool_select_action, NULL);
	_tmp47_ = kerning_tools;
	_tmp48_ = insert_unicode;
	bird_font_expander_add_tool (_tmp47_, _tmp48_, -1);
	_tmp49_ = bird_font_t_ ("Right to left");
	_tmp50_ = _tmp49_;
	_tmp51_ = bird_font_tool_new ("right_to_left", _tmp50_);
	_tmp52_ = _tmp51_;
	_g_free0 (_tmp50_);
	_data24_->right_to_left = _tmp52_;
	_tmp53_ = _data24_->right_to_left;
	g_signal_connect_data (_tmp53_, "select-action", (GCallback) ___lambda319__bird_font_tool_select_action, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp54_ = kerning_tools;
	_tmp55_ = _data24_->right_to_left;
	bird_font_expander_add_tool (_tmp54_, _tmp55_, -1);
	_tmp56_ = bird_font_t_ ("Open a text file with kerning strings first.");
	_data24_->empty_kerning_text = _tmp56_;
	_tmp57_ = bird_font_t_ ("Previous kerning string");
	_tmp58_ = _tmp57_;
	_tmp59_ = bird_font_tool_new ("previous_kerning_string", _tmp58_);
	_g_object_unref0 (bird_font_kerning_tools_previous_kerning_string);
	bird_font_kerning_tools_previous_kerning_string = _tmp59_;
	_g_free0 (_tmp58_);
	_tmp60_ = bird_font_kerning_tools_previous_kerning_string;
	g_signal_connect_data (_tmp60_, "select-action", (GCallback) ___lambda320__bird_font_tool_select_action, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp61_ = kerning_tools;
	_tmp62_ = bird_font_kerning_tools_previous_kerning_string;
	bird_font_expander_add_tool (_tmp61_, _tmp62_, -1);
	_tmp63_ = bird_font_t_ ("Next kerning string");
	_tmp64_ = _tmp63_;
	_tmp65_ = bird_font_tool_new ("next_kerning_string", _tmp64_);
	_g_object_unref0 (bird_font_kerning_tools_next_kerning_string);
	bird_font_kerning_tools_next_kerning_string = _tmp65_;
	_g_free0 (_tmp64_);
	_tmp66_ = bird_font_kerning_tools_next_kerning_string;
	g_signal_connect_data (_tmp66_, "select-action", (GCallback) ___lambda322__bird_font_tool_select_action, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp67_ = kerning_tools;
	_tmp68_ = bird_font_kerning_tools_next_kerning_string;
	bird_font_expander_add_tool (_tmp67_, _tmp68_, -1);
	_tmp69_ = bird_font_t_ ("Substitutions");
	_tmp70_ = _tmp69_;
	_tmp71_ = bird_font_expander_new (_tmp70_);
	_g_object_unref0 (bird_font_kerning_tools_otf_features);
	bird_font_kerning_tools_otf_features = _tmp71_;
	_g_free0 (_tmp70_);
	{
		GeeArrayList* _tag_list = NULL;
		BirdFontFont* _tmp72_;
		BirdFontAlternateSets* _tmp73_;
		GeeArrayList* _tmp74_;
		gint _tag_size = 0;
		GeeArrayList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _tag_index = 0;
		_tmp72_ = font;
		_tmp73_ = _tmp72_->alternates;
		_tmp74_ = bird_font_alternate_sets_get_all_tags (_tmp73_);
		_tag_list = _tmp74_;
		_tmp75_ = _tag_list;
		_tmp76_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_tag_size = _tmp77_;
		_tag_index = -1;
		while (TRUE) {
			gint _tmp78_;
			gint _tmp79_;
			gchar* tag = NULL;
			GeeArrayList* _tmp80_;
			gpointer _tmp81_;
			const gchar* _tmp82_;
			_tag_index = _tag_index + 1;
			_tmp78_ = _tag_index;
			_tmp79_ = _tag_size;
			if (!(_tmp78_ < _tmp79_)) {
				break;
			}
			_tmp80_ = _tag_list;
			_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp80_, _tag_index);
			tag = (gchar*) _tmp81_;
			_tmp82_ = tag;
			bird_font_kerning_tools_add_otf_label (_tmp82_);
			_g_free0 (tag);
		}
		_g_object_unref0 (_tag_list);
	}
	_tmp83_ = kerning_tools;
	bird_font_expander_set_persistent (_tmp83_, FALSE);
	_tmp84_ = kerning_tools;
	bird_font_expander_set_unique (_tmp84_, FALSE);
	_tmp85_ = bird_font_kerning_tools_classes;
	bird_font_expander_set_persistent (_tmp85_, TRUE);
	_tmp86_ = bird_font_kerning_tools_classes;
	bird_font_expander_set_unique (_tmp86_, TRUE);
	_tmp87_ = bird_font_kerning_tools_expanders;
	_tmp88_ = font_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp87_, _tmp88_);
	_tmp89_ = bird_font_kerning_tools_expanders;
	_tmp90_ = zoom_expander;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp90_);
	_tmp91_ = bird_font_kerning_tools_expanders;
	_tmp92_ = kerning_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
	_tmp93_ = bird_font_kerning_tools_expanders;
	_tmp94_ = bird_font_kerning_tools_otf_features;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp94_);
	_tmp95_ = bird_font_kerning_tools_expanders;
	_tmp96_ = bird_font_kerning_tools_classes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp95_, _tmp96_);
	_g_object_unref0 (insert_unicode);
	_g_object_unref0 (insert_last);
	_g_object_unref0 (text_kerning);
	_g_object_unref0 (new_kerning_class);
	_g_object_unref0 (zoom_expander);
	_g_object_unref0 (font_name);
	_g_object_unref0 (kerning_tools);
	_g_object_unref0 (font);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		_g_object_unref0 (_data26_->fs);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
__lambda323_ (Block26Data* _data26_,
              gboolean enable,
              const gchar* tag)
{
	BirdFontOtfTags* tags = NULL;
	BirdFontOtfTags* _tmp0_;
	BirdFontOtfTags* _tmp1_;
	BirdFontKerningDisplay* kd = NULL;
	BirdFontKerningDisplay* _tmp2_;
	BirdFontKerningDisplay* _tmp3_;
	BirdFontOtfTags* _tmp4_;
	BirdFontOtfTags* _tmp5_;
	BirdFontKerningDisplay* _tmp14_;
	BirdFontGlyphSequence* _tmp15_;
	BirdFontGlyphSequence* _tmp16_;
	BirdFontOtfTags* _tmp17_;
	g_return_if_fail (tag != NULL);
	_tmp0_ = bird_font_kerning_tools_active_otf_features;
	_tmp1_ = bird_font_otf_tags_copy (_tmp0_);
	tags = _tmp1_;
	_tmp2_ = bird_font_main_window_get_kerning_display ();
	kd = _tmp2_;
	_tmp3_ = kd;
	bird_font_kerning_display_new_segment (_tmp3_);
	_tmp4_ = tags;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (bird_font_kerning_tools_active_otf_features);
	bird_font_kerning_tools_active_otf_features = _tmp5_;
	if (enable) {
		BirdFontOtfTags* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = tags;
		bird_font_otf_tags_add (_tmp6_, tag);
		_tmp7_ = string_to_string (tag);
		_tmp8_ = g_strconcat ("kerning_", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		bird_font_font_settings_set_setting (_data26_->fs, _tmp9_, "true");
		_g_free0 (_tmp9_);
	} else {
		BirdFontOtfTags* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = tags;
		bird_font_otf_tags_remove (_tmp10_, tag);
		_tmp11_ = string_to_string (tag);
		_tmp12_ = g_strconcat ("kerning_", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		bird_font_font_settings_set_setting (_data26_->fs, _tmp13_, "false");
		_g_free0 (_tmp13_);
	}
	_tmp14_ = kd;
	_tmp15_ = bird_font_kerning_display_get_last_segment (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = tags;
	bird_font_glyph_sequence_set_otf_tags (_tmp16_, _tmp17_);
	_g_object_unref0 (_tmp16_);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (kd);
	_g_object_unref0 (tags);
}

static void
___lambda323__bird_font_otf_label_otf_feature_activity (BirdFontOtfLabel* _sender,
                                                        gboolean enable,
                                                        const gchar* tag,
                                                        gpointer self)
{
	__lambda323_ (self, enable, tag);
}

void
bird_font_kerning_tools_add_otf_label (const gchar* tag)
{
	Block26Data* _data26_;
	BirdFontOtfLabel* otf_label = NULL;
	BirdFontOtfLabel* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontFontSettings* _tmp3_;
	BirdFontFontSettings* _tmp4_;
	BirdFontFontSettings* _tmp5_;
	BirdFontExpander* _tmp6_;
	gboolean enable = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (tag != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_tmp0_ = bird_font_otf_label_new (tag);
	otf_label = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->settings;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_data26_->fs = _tmp5_;
	_tmp6_ = bird_font_kerning_tools_otf_features;
	bird_font_expander_add_tool (_tmp6_, (BirdFontTool*) otf_label, -1);
	g_signal_connect_data (otf_label, "otf-feature-activity", (GCallback) ___lambda323__bird_font_otf_label_otf_feature_activity, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp7_ = string_to_string (tag);
	_tmp8_ = g_strconcat ("kerning_", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_font_settings_get_setting (_data26_->fs, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "true") == 0;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	enable = _tmp12_;
	bird_font_otf_label_set_selected_tag (otf_label, enable);
	_g_object_unref0 (otf_label);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}

void
bird_font_kerning_tools_add_unique_class (BirdFontKerningRange* kerning_class)
{
	BirdFontKerningRange* k = NULL;
	BirdFontExpander* _tmp0_;
	BirdFontExpander* _tmp21_;
	g_return_if_fail (kerning_class != NULL);
	_tmp0_ = bird_font_kerning_tools_classes;
	if (bird_font_is_null (_tmp0_)) {
		bird_font_kerning_tools_init ();
	}
	{
		GeeArrayList* _t_list = NULL;
		BirdFontExpander* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _t_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _t_index = 0;
		_tmp1_ = bird_font_kerning_tools_classes;
		_tmp2_ = _tmp1_->tool;
		_t_list = _tmp2_;
		_tmp3_ = _t_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_t_size = _tmp5_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontTool* _tmp10_;
			BirdFontTool* _tmp11_;
			BirdFontKerningRange* _tmp12_;
			BirdFontKerningRange* _tmp13_;
			BirdFontGlyphRange* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			BirdFontGlyphRange* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_t_index = _t_index + 1;
			_tmp6_ = _t_index;
			_tmp7_ = _t_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _t_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _t_index);
			t = (BirdFontTool*) _tmp9_;
			_tmp10_ = t;
			if (!BIRD_FONT_IS_KERNING_RANGE (_tmp10_)) {
				g_warning ("KerningTools.vala:237: Tool is not kerning range");
				_g_object_unref0 (t);
				_g_object_unref0 (k);
				return;
			}
			_tmp11_ = t;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, BIRD_FONT_TYPE_KERNING_RANGE, BirdFontKerningRange));
			_g_object_unref0 (k);
			k = _tmp12_;
			_tmp13_ = k;
			_tmp14_ = _tmp13_->glyph_range;
			_tmp15_ = bird_font_glyph_range_get_all_ranges (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = kerning_class->glyph_range;
			_tmp18_ = bird_font_glyph_range_get_all_ranges (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
			_g_free0 (_tmp19_);
			_g_free0 (_tmp16_);
			if (_tmp20_) {
				_g_object_unref0 (t);
				_g_object_unref0 (k);
				return;
			}
			_g_object_unref0 (t);
		}
	}
	_tmp21_ = bird_font_kerning_tools_classes;
	bird_font_expander_add_tool (_tmp21_, (BirdFontTool*) kerning_class, -1);
	_g_object_unref0 (k);
}

static gpointer
_bird_font_glyph_range_ref0 (gpointer self)
{
	return self ? bird_font_glyph_range_ref (self) : NULL;
}

BirdFontGlyphRange*
bird_font_kerning_tools_get_kerning_class (gint index)
{
	BirdFontExpander* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontGlyphRange* result;
	_tmp0_ = bird_font_kerning_tools_classes;
	_tmp1_ = _tmp0_->tool;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = index;
	if (G_LIKELY ((0 <= _tmp4_) && (_tmp4_ < _tmp3_))) {
		BirdFontExpander* _tmp5_;
		GeeArrayList* _tmp6_;
		gpointer _tmp7_;
		BirdFontKerningRange* _tmp8_;
		BirdFontGlyphRange* _tmp9_;
		BirdFontGlyphRange* _tmp10_;
		BirdFontGlyphRange* _tmp11_;
		_tmp5_ = bird_font_kerning_tools_classes;
		_tmp6_ = _tmp5_->tool;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, index);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST ((BirdFontTool*) _tmp7_, BIRD_FONT_TYPE_KERNING_RANGE, BirdFontKerningRange);
		_tmp9_ = _tmp8_->glyph_range;
		_tmp10_ = _bird_font_glyph_range_ref0 (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp8_);
		result = _tmp11_;
		return result;
	} else {
		BirdFontGlyphRange* _tmp12_;
		g_warning ("KerningTools.vala:254: Index out of bounds.");
		_tmp12_ = bird_font_glyph_range_new ();
		result = _tmp12_;
		return result;
	}
}

void
bird_font_kerning_tools_update_kerning_classes (void)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontKerningClasses* k = NULL;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningRange* kr = NULL;
	BirdFontGlyphRange* r = NULL;
	gint i = 0;
	BirdFontExpander* _tmp31_;
	BirdFontExpander* _tmp32_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	k = _tmp2_;
	bird_font_kerning_tools_remove_all_kerning_classes ();
	{
		gboolean _tmp3_ = FALSE;
		i = 0;
		_tmp3_ = TRUE;
		while (TRUE) {
			BirdFontKerningClasses* _tmp5_;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			BirdFontKerningClasses* _tmp9_;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontGlyphRange* _tmp12_;
			BirdFontKerningClasses* _tmp20_;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontGlyphRange* _tmp23_;
			if (!_tmp3_) {
				gint _tmp4_;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = k;
			_tmp6_ = _tmp5_->classes_first;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (!(i < _tmp8_)) {
				break;
			}
			_tmp9_ = k;
			_tmp10_ = _tmp9_->classes_first;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
			_bird_font_glyph_range_unref0 (r);
			r = (BirdFontGlyphRange*) _tmp11_;
			_tmp12_ = r;
			if (bird_font_glyph_range_is_class (_tmp12_)) {
				BirdFontFont* _tmp13_;
				BirdFontKerningRange* _tmp14_;
				BirdFontKerningRange* _tmp15_;
				BirdFontGlyphRange* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				BirdFontKerningRange* _tmp19_;
				_tmp13_ = font;
				_tmp14_ = bird_font_kerning_range_new (_tmp13_, NULL, "");
				_g_object_unref0 (kr);
				kr = _tmp14_;
				_tmp15_ = kr;
				_tmp16_ = r;
				_tmp17_ = bird_font_glyph_range_get_all_ranges (_tmp16_);
				_tmp18_ = _tmp17_;
				bird_font_kerning_range_set_ranges (_tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_tmp19_ = kr;
				bird_font_kerning_tools_add_unique_class (_tmp19_);
			}
			_tmp20_ = k;
			_tmp21_ = _tmp20_->classes_last;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, i);
			_bird_font_glyph_range_unref0 (r);
			r = (BirdFontGlyphRange*) _tmp22_;
			_tmp23_ = r;
			if (bird_font_glyph_range_is_class (_tmp23_)) {
				BirdFontFont* _tmp24_;
				BirdFontKerningRange* _tmp25_;
				BirdFontKerningRange* _tmp26_;
				BirdFontGlyphRange* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				BirdFontKerningRange* _tmp30_;
				_tmp24_ = font;
				_tmp25_ = bird_font_kerning_range_new (_tmp24_, NULL, "");
				_g_object_unref0 (kr);
				kr = _tmp25_;
				_tmp26_ = kr;
				_tmp27_ = r;
				_tmp28_ = bird_font_glyph_range_get_all_ranges (_tmp27_);
				_tmp29_ = _tmp28_;
				bird_font_kerning_range_set_ranges (_tmp26_, _tmp29_);
				_g_free0 (_tmp29_);
				_tmp30_ = kr;
				bird_font_kerning_tools_add_unique_class (_tmp30_);
			}
		}
	}
	_tmp31_ = bird_font_kerning_tools_classes;
	bird_font_expander_clear_cache (_tmp31_);
	_tmp32_ = bird_font_kerning_tools_classes;
	bird_font_expander_redraw (_tmp32_);
	_bird_font_glyph_range_unref0 (r);
	_g_object_unref0 (kr);
	_g_object_unref0 (k);
	_g_object_unref0 (font);
}

static void
bird_font_kerning_tools_remove_all_kerning_classes (void)
{
	BirdFontExpander* _tmp0_;
	BirdFontExpander* _tmp1_;
	GeeArrayList* _tmp2_;
	BirdFontToolbox* _tmp3_;
	_tmp0_ = bird_font_kerning_tools_classes;
	if (bird_font_is_null (_tmp0_)) {
		bird_font_kerning_tools_init ();
	}
	_tmp1_ = bird_font_kerning_tools_classes;
	_tmp2_ = _tmp1_->tool;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = bird_font_main_window_get_toolbox ();
	if (!bird_font_is_null (_tmp3_)) {
		BirdFontToolbox* _tmp4_;
		BirdFontToolbox* _tmp5_;
		_tmp4_ = bird_font_main_window_get_toolbox ();
		_tmp5_ = _tmp4_;
		bird_font_toolbox_update_expanders (_tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}

void
bird_font_kerning_tools_remove_empty_classes (void)
{
	BirdFontKerningRange* kr = NULL;
	gint i = 0;
	BirdFontExpander* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = bird_font_kerning_tools_classes;
	_tmp1_ = _tmp0_->tool;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_g_object_unref0 (kr);
		return;
	}
	i = 0;
	{
		GeeArrayList* _t_list = NULL;
		BirdFontExpander* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _t_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _t_index = 0;
		_tmp4_ = bird_font_kerning_tools_classes;
		_tmp5_ = _tmp4_->tool;
		_t_list = _tmp5_;
		_tmp6_ = _t_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_t_size = _tmp8_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontTool* _tmp13_;
			BirdFontTool* _tmp14_;
			BirdFontKerningRange* _tmp15_;
			BirdFontKerningRange* _tmp16_;
			BirdFontGlyphRange* _tmp17_;
			gint _tmp22_;
			_t_index = _t_index + 1;
			_tmp9_ = _t_index;
			_tmp10_ = _t_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _t_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _t_index);
			t = (BirdFontTool*) _tmp12_;
			_tmp13_ = t;
			g_return_if_fail (BIRD_FONT_IS_KERNING_RANGE (_tmp13_));
			_tmp14_ = t;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_KERNING_RANGE, BirdFontKerningRange));
			_g_object_unref0 (kr);
			kr = _tmp15_;
			_tmp16_ = kr;
			_tmp17_ = _tmp16_->glyph_range;
			if (bird_font_glyph_range_is_empty (_tmp17_)) {
				BirdFontExpander* _tmp18_;
				GeeArrayList* _tmp19_;
				gpointer _tmp20_;
				BirdFontTool* _tmp21_;
				_tmp18_ = bird_font_kerning_tools_classes;
				_tmp19_ = _tmp18_->tool;
				_tmp20_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp19_, i);
				_tmp21_ = (BirdFontTool*) _tmp20_;
				_g_object_unref0 (_tmp21_);
				bird_font_kerning_tools_remove_empty_classes ();
				bird_font_toolbox_redraw_tool_box ();
				_g_object_unref0 (t);
				_g_object_unref0 (kr);
				return;
			}
			_tmp22_ = i;
			i = _tmp22_ + 1;
			_g_object_unref0 (t);
		}
	}
	_g_object_unref0 (kr);
}

static GeeArrayList*
bird_font_kerning_tools_real_get_expanders (BirdFontToolCollection* base)
{
	BirdFontKerningTools * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontKerningTools*) base;
	_tmp0_ = bird_font_kerning_tools_expanders;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_kerning_tools_update_spacing_classes (void)
{
	BirdFontKerningRange* kr = NULL;
	BirdFontExpander* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = bird_font_kerning_tools_classes;
	_tmp1_ = _tmp0_->tool;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_g_object_unref0 (kr);
		return;
	}
	{
		GeeArrayList* _t_list = NULL;
		BirdFontExpander* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _t_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _t_index = 0;
		_tmp4_ = bird_font_kerning_tools_classes;
		_tmp5_ = _tmp4_->tool;
		_t_list = _tmp5_;
		_tmp6_ = _t_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_t_size = _tmp8_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontTool* _tmp13_;
			BirdFontTool* _tmp14_;
			BirdFontKerningRange* _tmp15_;
			BirdFontKerningRange* _tmp16_;
			_t_index = _t_index + 1;
			_tmp9_ = _t_index;
			_tmp10_ = _t_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _t_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _t_index);
			t = (BirdFontTool*) _tmp12_;
			_tmp13_ = t;
			g_return_if_fail (BIRD_FONT_IS_KERNING_RANGE (_tmp13_));
			_tmp14_ = t;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_KERNING_RANGE, BirdFontKerningRange));
			_g_object_unref0 (kr);
			kr = _tmp15_;
			_tmp16_ = kr;
			bird_font_kerning_range_update_spacing_class (_tmp16_);
			_g_object_unref0 (t);
		}
	}
	_g_object_unref0 (kr);
}

static GeeArrayList*
bird_font_kerning_tools_real_get_displays (BirdFontToolCollection* base)
{
	BirdFontKerningTools * self;
	GeeArrayList* d = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	self = (BirdFontKerningTools*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	d = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) d, "Kerning");
	gee_abstract_collection_add ((GeeAbstractCollection*) d, "Spacing");
	result = d;
	return result;
}

static void
bird_font_kerning_tools_class_init (BirdFontKerningToolsClass * klass,
                                    gpointer klass_data)
{
	bird_font_kerning_tools_parent_class = g_type_class_peek_parent (klass);
	((BirdFontToolCollectionClass *) klass)->selected = (void (*) (BirdFontToolCollection*)) bird_font_kerning_tools_real_selected;
	((BirdFontToolCollectionClass *) klass)->get_expanders = (GeeArrayList* (*) (BirdFontToolCollection*)) bird_font_kerning_tools_real_get_expanders;
	((BirdFontToolCollectionClass *) klass)->get_displays = (GeeArrayList* (*) (BirdFontToolCollection*)) bird_font_kerning_tools_real_get_displays;
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_tools_finalize;
}

static void
bird_font_kerning_tools_instance_init (BirdFontKerningTools * self,
                                       gpointer klass)
{
}

static void
bird_font_kerning_tools_finalize (GObject * obj)
{
	BirdFontKerningTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_TOOLS, BirdFontKerningTools);
	G_OBJECT_CLASS (bird_font_kerning_tools_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_tools_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningTools), 0, (GInstanceInitFunc) bird_font_kerning_tools_instance_init, NULL };
	GType bird_font_kerning_tools_type_id;
	bird_font_kerning_tools_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL_COLLECTION, "BirdFontKerningTools", &g_define_type_info, 0);
	return bird_font_kerning_tools_type_id;
}

GType
bird_font_kerning_tools_get_type (void)
{
	static volatile gsize bird_font_kerning_tools_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_tools_type_id__once)) {
		GType bird_font_kerning_tools_type_id;
		bird_font_kerning_tools_type_id = bird_font_kerning_tools_get_type_once ();
		g_once_init_leave (&bird_font_kerning_tools_type_id__once, bird_font_kerning_tools_type_id);
	}
	return bird_font_kerning_tools_type_id__once;
}

