/* OverviewItem.c generated by valac 0.56.17, the Vala compiler
 * generated from OverviewItem.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "birdfont.h"
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_OVERVIEW_ITEM_0_PROPERTY,
	BIRD_FONT_OVERVIEW_ITEM_NUM_PROPERTIES
};
static GParamSpec* bird_font_overview_item_properties[BIRD_FONT_OVERVIEW_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _BirdFontOverviewItemPrivate {
	BirdFontText* label;
	cairo_surface_t* cache;
};

static gint BirdFontOverviewItem_private_offset;
static gpointer bird_font_overview_item_parent_class = NULL;
gdouble bird_font_overview_item_DEFAULT_WIDTH = (gdouble) 100;
gdouble bird_font_overview_item_DEFAULT_HEIGHT = (gdouble) 130;
gdouble bird_font_overview_item_DEFAULT_MARGIN = (gdouble) 20;
gdouble bird_font_overview_item_width = (gdouble) 100;
gdouble bird_font_overview_item_height = (gdouble) 130;
gdouble bird_font_overview_item_margin = (gdouble) 20;
gdouble bird_font_overview_item_glyph_scale = 1.0;
cairo_surface_t* bird_font_overview_item_label_background = NULL;
cairo_surface_t* bird_font_overview_item_selected_label_background = NULL;
cairo_surface_t* bird_font_overview_item_label_background_no_menu = NULL;
cairo_surface_t* bird_font_overview_item_selected_label_background_no_menu = NULL;

static void ___lambda340_ (BirdFontOverviewItem* self,
                    BirdFontGlyph* glyph);
static void ____lambda340__bird_font_version_list_add_glyph_item (BirdFontVersionList* _sender,
                                                           BirdFontGlyph* item,
                                                           gpointer self);
static void ___lambda341_ (BirdFontOverviewItem* self,
                    gint glyph_index);
static void ____lambda341__bird_font_version_list_signal_delete_item (BirdFontVersionList* _sender,
                                                               gint item_index,
                                                               gpointer self);
static void bird_font_overview_item_truncate_label (BirdFontOverviewItem* self);
static void bird_font_overview_item_draw_thumbnail (BirdFontOverviewItem* self,
                                             cairo_t* cr,
                                             gdouble x,
                                             gdouble y);
static void bird_font_overview_item_draw_menu (BirdFontOverviewItem* self,
                                        cairo_t* cr);
static void bird_font_overview_item_draw_menu_icon (BirdFontOverviewItem* self,
                                             cairo_t* cc,
                                             gboolean selected);
static void bird_font_overview_item_draw_character_info_icon (BirdFontOverviewItem* self,
                                                       cairo_t* cr);
static gboolean bird_font_overview_item_has_menu (BirdFontOverviewItem* self);
static void bird_font_overview_item_finalize (GObject * obj);
static GType bird_font_overview_item_get_type_once (void);

static inline gpointer
bird_font_overview_item_get_instance_private (BirdFontOverviewItem* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontOverviewItem_private_offset);
}

BirdFontOverviewItem*
bird_font_overview_item_construct (GType object_type)
{
	BirdFontOverviewItem * self = NULL;
	self = (BirdFontOverviewItem*) g_object_new (object_type, NULL);
	return self;
}

BirdFontOverviewItem*
bird_font_overview_item_new (void)
{
	return bird_font_overview_item_construct (BIRD_FONT_TYPE_OVERVIEW_ITEM);
}

void
bird_font_overview_item_set_character (BirdFontOverviewItem* self,
                                       gunichar character)
{
	g_return_if_fail (self != NULL);
	self->character = character;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda340_ (BirdFontOverviewItem* self,
               BirdFontGlyph* glyph)
{
	BirdFontGlyphCollection* _tmp0_;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = self->glyphs;
	bird_font_glyph_collection_insert_glyph (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection), glyph, TRUE);
}

static void
____lambda340__bird_font_version_list_add_glyph_item (BirdFontVersionList* _sender,
                                                      BirdFontGlyph* item,
                                                      gpointer self)
{
	___lambda340_ ((BirdFontOverviewItem*) self, item);
}

static void
___lambda341_ (BirdFontOverviewItem* self,
               gint glyph_index)
{
	BirdFontOverview* v = NULL;
	BirdFontOverview* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontVersionList* _tmp2_;
	_tmp0_ = bird_font_main_window_get_overview ();
	v = _tmp0_;
	_tmp1_ = self->glyphs;
	_tmp2_ = bird_font_version_list_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	_g_object_unref0 (self->version_menu);
	self->version_menu = _tmp2_;
	bird_font_overview_update_item_list (v);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (v);
}

static void
____lambda341__bird_font_version_list_signal_delete_item (BirdFontVersionList* _sender,
                                                          gint item_index,
                                                          gpointer self)
{
	___lambda341_ ((BirdFontOverviewItem*) self, item_index);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
bird_font_overview_item_set_glyphs (BirdFontOverviewItem* self,
                                    BirdFontGlyphCollection* gc)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp6_;
	BirdFontCharacterInfo* _tmp7_;
	BirdFontGlyphCollection* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (gc);
	_g_object_unref0 (self->glyphs);
	self->glyphs = _tmp0_;
	_tmp1_ = self->glyphs;
	if (_tmp1_ != NULL) {
		BirdFontGlyphCollection* _tmp2_;
		BirdFontVersionList* _tmp3_;
		BirdFontVersionList* _tmp4_;
		BirdFontVersionList* _tmp5_;
		_tmp2_ = self->glyphs;
		_tmp3_ = bird_font_version_list_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_object_unref0 (self->version_menu);
		self->version_menu = _tmp3_;
		_tmp4_ = self->version_menu;
		g_signal_connect_object (_tmp4_, "add-glyph-item", (GCallback) ____lambda340__bird_font_version_list_add_glyph_item, self, 0);
		_tmp5_ = self->version_menu;
		g_signal_connect_object (_tmp5_, "signal-delete-item", (GCallback) ____lambda341__bird_font_version_list_signal_delete_item, self, 0);
	}
	_tmp6_ = self->glyphs;
	_tmp7_ = bird_font_character_info_new (self->character, _tmp6_);
	_g_object_unref0 (self->info);
	self->info = _tmp7_;
	_tmp8_ = self->glyphs;
	if (_tmp8_ == NULL) {
		BirdFontText* _tmp9_;
		_tmp9_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
		_g_object_unref0 (self->priv->label);
		self->priv->label = _tmp9_;
	} else {
		if (self->character != ((gunichar) '\0')) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			BirdFontText* _tmp12_;
			_tmp10_ = g_unichar_to_string (self->character);
			_tmp11_ = (gchar*) _tmp10_;
			_tmp12_ = bird_font_text_new (_tmp11_, (gdouble) 17, (gdouble) 0);
			_g_object_unref0 (self->priv->label);
			self->priv->label = _tmp12_;
			_g_free0 (_tmp11_);
		} else {
			BirdFontCharacterInfo* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			BirdFontText* _tmp16_;
			_tmp13_ = self->info;
			_tmp14_ = bird_font_character_info_get_name (_tmp13_);
			_tmp15_ = (gchar*) _tmp14_;
			_tmp16_ = bird_font_text_new (_tmp15_, (gdouble) 17, (gdouble) 0);
			_g_object_unref0 (self->priv->label);
			self->priv->label = _tmp16_;
			_g_free0 (_tmp15_);
		}
		bird_font_overview_item_truncate_label (self);
	}
	bird_font_overview_item_draw_background (self);
}

void
bird_font_overview_item_clear_cache (BirdFontOverviewItem* self)
{
	BirdFontGlyphCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	_cairo_surface_destroy0 (self->priv->cache);
	self->priv->cache = NULL;
	_tmp0_ = self->glyphs;
	if (_tmp0_ != NULL) {
		BirdFontGlyph* g = NULL;
		BirdFontGlyphCollection* _tmp1_;
		BirdFontGlyph* _tmp2_;
		BirdFontGlyph* _tmp3_;
		_tmp1_ = self->glyphs;
		_tmp2_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		g = _tmp2_;
		_tmp3_ = g;
		_cairo_surface_destroy0 (_tmp3_->overview_thumbnail);
		_tmp3_->overview_thumbnail = NULL;
		_g_object_unref0 (g);
	}
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

void
bird_font_overview_item_draw_glyph_from_font (BirdFontOverviewItem* self)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyph* g = NULL;
	gdouble gx = 0.0;
	gdouble gy = 0.0;
	gdouble x1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y1 = 0.0;
	gdouble y2 = 0.0;
	gdouble scale_box = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble glyph_width = 0.0;
	gdouble glyph_height = 0.0;
	cairo_surface_t* s = NULL;
	cairo_t* c = NULL;
	BirdFontColor* color = NULL;
	BirdFontColor* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontGlyph* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	BirdFontGlyph* _tmp13_;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	BirdFontGlyph* _tmp20_;
	BirdFontGlyph* _tmp21_;
	BirdFontGlyph* _tmp22_;
	cairo_t* _tmp23_;
	BirdFontGlyph* _tmp24_;
	BirdFontGlyph* _tmp25_;
	cairo_t* _tmp26_;
	BirdFontColor* _tmp27_;
	cairo_t* _tmp28_;
	cairo_surface_t* _tmp29_;
	cairo_surface_t* _tmp30_;
	BirdFontGlyph* _tmp31_;
	cairo_surface_t* _tmp32_;
	cairo_surface_t* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->glyphs;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = bird_font_color_black ();
	color = _tmp1_;
	_tmp2_ = self->glyphs;
	_tmp3_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	_g_object_unref0 (g);
	g = _tmp3_;
	_tmp4_ = g;
	_tmp5_ = _tmp4_->overview_thumbnail;
	if (G_LIKELY (_tmp5_ != NULL)) {
		BirdFontGlyph* _tmp6_;
		cairo_surface_t* _tmp7_;
		cairo_surface_t* _tmp8_;
		_tmp6_ = g;
		_tmp7_ = _tmp6_->overview_thumbnail;
		_tmp8_ = _cairo_surface_reference0 (_tmp7_);
		_cairo_surface_destroy0 (self->priv->cache);
		self->priv->cache = _tmp8_;
		_bird_font_color_unref0 (color);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (s);
		_g_object_unref0 (g);
		return;
	}
	w = bird_font_overview_item_width;
	h = bird_font_overview_item_height;
	scale_box = (bird_font_overview_item_height / bird_font_overview_item_DEFAULT_HEIGHT) * 0.65;
	_tmp9_ = bird_font_screen_create_background_surface ((gint) bird_font_overview_item_width, ((gint) bird_font_overview_item_height) - 20);
	_cairo_surface_destroy0 (s);
	s = _tmp9_;
	_tmp10_ = s;
	_tmp11_ = cairo_create (_tmp10_);
	_cairo_destroy0 (c);
	c = _tmp11_;
	_tmp12_ = c;
	cairo_save (_tmp12_);
	_tmp13_ = g;
	bird_font_glyph_boundaries (_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
	x1 = _tmp14_;
	y1 = _tmp15_;
	x2 = _tmp16_;
	y2 = _tmp17_;
	glyph_width = x2 - x1;
	glyph_height = y2 - y1;
	_tmp18_ = c;
	cairo_save (_tmp18_);
	_tmp19_ = c;
	cairo_scale (_tmp19_, scale_box * bird_font_screen_get_scale (), scale_box * bird_font_screen_get_scale ());
	_tmp20_ = g;
	bird_font_glyph_add_help_lines (_tmp20_);
	_tmp21_ = g;
	gx = (((w / scale_box) - glyph_width) / 2) - bird_font_glyph_get_left_side_bearing (_tmp21_);
	_tmp22_ = g;
	gy = (((h / scale_box) + bird_font_glyph_get_baseline (_tmp22_)) - (20 / scale_box)) - 20;
	_tmp23_ = c;
	_tmp24_ = g;
	cairo_translate (_tmp23_, (gx - bird_font_glyph_xc ()) - bird_font_glyph_get_lsb (_tmp24_), gy - bird_font_glyph_yc ());
	_tmp25_ = g;
	_tmp26_ = c;
	_tmp27_ = color;
	bird_font_glyph_draw_paths (_tmp25_, _tmp26_, _tmp27_);
	_tmp28_ = c;
	cairo_restore (_tmp28_);
	_tmp29_ = s;
	_tmp30_ = _cairo_surface_reference0 (_tmp29_);
	_cairo_surface_destroy0 (self->priv->cache);
	self->priv->cache = _tmp30_;
	_tmp31_ = g;
	_tmp32_ = s;
	_tmp33_ = _cairo_surface_reference0 (_tmp32_);
	_cairo_surface_destroy0 (_tmp31_->overview_thumbnail);
	_tmp31_->overview_thumbnail = _tmp33_;
	bird_font_glyph_canvas_redraw ();
	_bird_font_color_unref0 (color);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (s);
	_g_object_unref0 (g);
}

void
bird_font_overview_item_draw_background (BirdFontOverviewItem* self)
{
	gdouble scale_box = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	cairo_surface_t* s = NULL;
	cairo_t* c = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	BirdFontGlyphCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	w = bird_font_overview_item_width;
	h = bird_font_overview_item_height;
	scale_box = bird_font_overview_item_width / bird_font_overview_item_DEFAULT_WIDTH;
	_tmp0_ = bird_font_screen_create_background_surface ((gint) bird_font_overview_item_width, ((gint) bird_font_overview_item_height) - 20);
	_cairo_surface_destroy0 (s);
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = cairo_create (_tmp1_);
	_cairo_destroy0 (c);
	c = _tmp2_;
	_tmp3_ = self->glyphs;
	if (_tmp3_ != NULL) {
		bird_font_overview_item_draw_glyph_from_font (self);
	} else {
		cairo_t* _tmp4_;
		cairo_t* _tmp5_;
		gboolean glyph_found = FALSE;
		gchar* font_file = NULL;
		cairo_t* _tmp6_;
		BirdFontFallbackFont* _tmp7_;
		gchar* _tmp8_;
		cairo_t* _tmp9_;
		const gchar* _tmp10_;
		cairo_t* _tmp21_;
		cairo_surface_t* _tmp22_;
		cairo_surface_t* _tmp23_;
		_tmp4_ = c;
		cairo_scale (_tmp4_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
		_tmp5_ = c;
		cairo_save (_tmp5_);
		_tmp6_ = c;
		bird_font_theme_color (_tmp6_, "Overview Glyph");
		_tmp7_ = bird_font_font_cache_fallback_font;
		_tmp8_ = bird_font_fallback_font_get_default_font_file (_tmp7_);
		_g_free0 (font_file);
		font_file = _tmp8_;
		_tmp9_ = c;
		_tmp10_ = font_file;
		glyph_found = draw_overview_glyph (_tmp9_, (const gchar*) _tmp10_, bird_font_overview_item_width, bird_font_overview_item_height, self->character);
		if (!glyph_found) {
			FcConfig* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp11_ = bird_font_fallback_font_font_config;
			_tmp12_ = g_unichar_to_string (self->character);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = find_font (_tmp11_, _tmp13_);
			_g_free0 (font_file);
			font_file = _tmp14_;
			_g_free0 (_tmp13_);
			_tmp15_ = font_file;
			if (_tmp15_ != NULL) {
				gchar* path = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = font_file;
				_tmp17_ = g_strdup ((const gchar*) _tmp16_);
				path = _tmp17_;
				_tmp18_ = path;
				if (!g_str_has_suffix (_tmp18_, "LastResort.ttf")) {
					cairo_t* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = c;
					_tmp20_ = path;
					draw_overview_glyph (_tmp19_, _tmp20_, bird_font_overview_item_width, bird_font_overview_item_height, self->character);
				}
				_g_free0 (path);
			}
		}
		_tmp21_ = c;
		cairo_restore (_tmp21_);
		_tmp22_ = s;
		_tmp23_ = _cairo_surface_reference0 (_tmp22_);
		_cairo_surface_destroy0 (self->priv->cache);
		self->priv->cache = _tmp23_;
		bird_font_glyph_canvas_redraw ();
		_g_free0 (font_file);
	}
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (s);
}

void
bird_font_overview_item_reset_label (void)
{
	_cairo_surface_destroy0 (bird_font_overview_item_label_background);
	bird_font_overview_item_label_background = NULL;
	_cairo_surface_destroy0 (bird_font_overview_item_selected_label_background);
	bird_font_overview_item_selected_label_background = NULL;
}

static void
bird_font_overview_item_truncate_label (BirdFontOverviewItem* self)
{
	gdouble _tmp0_ = 0.0;
	gdouble w = 0.0;
	BirdFontText* _tmp1_;
	g_return_if_fail (self != NULL);
	if (bird_font_overview_item_has_icons (self)) {
		_tmp0_ = bird_font_overview_item_width - 43;
	} else {
		_tmp0_ = bird_font_overview_item_width;
	}
	w = _tmp0_;
	_tmp1_ = self->priv->label;
	bird_font_text_truncate (_tmp1_, w);
}

gchar*
bird_font_overview_item_get_name (BirdFontOverviewItem* self)
{
	GString* s = NULL;
	BirdFontGlyphCollection* _tmp0_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->glyphs;
	if (_tmp0_ != NULL) {
		BirdFontGlyphCollection* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->glyphs;
		_tmp2_ = bird_font_glyph_collection_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		result = _tmp2_;
		_g_string_free0 (s);
		return result;
	}
	_tmp3_ = g_string_new ("");
	_g_string_free0 (s);
	s = _tmp3_;
	_tmp4_ = s;
	g_string_append_unichar (_tmp4_, self->character);
	_tmp5_ = s;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (s);
	return result;
}

void
bird_font_overview_item_set_selected (BirdFontOverviewItem* self,
                                      gboolean s)
{
	g_return_if_fail (self != NULL);
	self->selected = s;
}

gdouble
bird_font_overview_item_full_width (void)
{
	gdouble result;
	result = bird_font_overview_item_width + bird_font_overview_item_margin;
	return result;
}

gdouble
bird_font_overview_item_full_height (void)
{
	gdouble result;
	result = bird_font_overview_item_height + bird_font_overview_item_margin;
	return result;
}

gboolean
bird_font_overview_item_click_menu (BirdFontOverviewItem* self,
                                    guint button,
                                    gdouble px,
                                    gdouble py)
{
	gboolean a = FALSE;
	BirdFontGlyphCollection* g = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (bird_font_overview_item_has_icons (self)) {
		BirdFontGlyphCollection* _tmp1_;
		_tmp1_ = self->glyphs;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontGlyphCollection* _tmp2_;
		BirdFontGlyphCollection* _tmp3_;
		BirdFontVersionList* _tmp4_;
		BirdFontVersionList* _tmp5_;
		BirdFontVersionList* _tmp10_;
		_tmp2_ = self->glyphs;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_object_unref0 (g);
		g = _tmp3_;
		_tmp4_ = self->version_menu;
		bird_font_version_list_set_position (_tmp4_, (self->x + bird_font_overview_item_width) - 21, (self->y + bird_font_overview_item_height) - 18);
		_tmp5_ = self->version_menu;
		a = bird_font_version_list_menu_item_action (_tmp5_, px, py);
		if (a) {
			BirdFontOverview* _tmp6_;
			BirdFontOverview* _tmp7_;
			BirdFontOverview* _tmp8_;
			BirdFontOverview* _tmp9_;
			_tmp6_ = bird_font_main_window_get_overview ();
			_tmp7_ = _tmp6_;
			bird_font_overview_reset_cache (_tmp7_);
			_g_object_unref0 (_tmp7_);
			_tmp8_ = bird_font_main_window_get_overview ();
			_tmp9_ = _tmp8_;
			bird_font_overview_update_item_list (_tmp9_);
			_g_object_unref0 (_tmp9_);
			bird_font_glyph_canvas_redraw ();
			result = TRUE;
			_g_object_unref0 (g);
			return result;
		}
		_tmp10_ = self->version_menu;
		bird_font_version_list_menu_icon_action (_tmp10_, px, py);
	}
	result = FALSE;
	_g_object_unref0 (g);
	return result;
}

gboolean
bird_font_overview_item_click_info (BirdFontOverviewItem* self,
                                    guint button,
                                    gdouble px,
                                    gdouble py)
{
	BirdFontCharacterInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	bird_font_character_info_set_position (_tmp0_, (self->x + bird_font_overview_item_width) - 17, (self->y + bird_font_overview_item_height) - 22.5);
	if (bird_font_overview_item_has_icons (self)) {
		BirdFontCharacterInfo* _tmp2_;
		_tmp2_ = self->info;
		_tmp1_ = bird_font_character_info_is_over_icon (_tmp2_, px, py);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontOverview* _tmp3_;
		BirdFontOverview* _tmp4_;
		BirdFontCharacterInfo* _tmp5_;
		_tmp3_ = bird_font_main_window_get_overview ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->info;
		bird_font_overview_set_character_info (_tmp4_, _tmp5_);
		_g_object_unref0 (_tmp4_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
bird_font_overview_item_click (BirdFontOverviewItem* self,
                               guint button,
                               gdouble px,
                               gdouble py)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean s = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = px;
	if ((self->x <= _tmp1_) && (_tmp1_ <= (self->x + bird_font_overview_item_width))) {
		gdouble _tmp2_;
		_tmp2_ = py;
		_tmp0_ = (self->y <= _tmp2_) && (_tmp2_ <= (self->y + bird_font_overview_item_height));
	} else {
		_tmp0_ = FALSE;
	}
	s = _tmp0_;
	result = s;
	return result;
}

gboolean
bird_font_overview_item_double_click (BirdFontOverviewItem* self,
                                      guint button,
                                      gdouble px,
                                      gdouble py)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = px;
	if ((self->x <= _tmp1_) && (_tmp1_ <= (self->x + bird_font_overview_item_width))) {
		gdouble _tmp2_;
		_tmp2_ = py;
		_tmp0_ = (self->y <= _tmp2_) && (_tmp2_ <= (self->y + bird_font_overview_item_height));
	} else {
		_tmp0_ = FALSE;
	}
	self->selected = _tmp0_;
	result = self->selected;
	return result;
}

gboolean
bird_font_overview_item_is_on_screen (BirdFontOverviewItem* self,
                                      BirdFontWidgetAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (allocation != NULL, FALSE);
	if ((self->y + bird_font_overview_item_height) > ((gdouble) 0)) {
		_tmp0_ = self->y < ((gdouble) allocation->height);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
bird_font_overview_item_draw (BirdFontOverviewItem* self,
                              BirdFontWidgetAllocation* allocation,
                              cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	if (!bird_font_overview_item_is_on_screen (self, allocation)) {
		return;
	}
	cairo_save (cr);
	bird_font_theme_color (cr, "Background 1");
	cairo_rectangle (cr, self->x, self->y, bird_font_overview_item_width, bird_font_overview_item_height);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Overview Item Border");
	cairo_rectangle (cr, self->x, self->y, bird_font_overview_item_width, bird_font_overview_item_height);
	cairo_set_line_width (cr, (gdouble) 1);
	cairo_stroke (cr);
	cairo_restore (cr);
	bird_font_overview_item_draw_thumbnail (self, cr, self->x, self->y + bird_font_overview_item_height);
	bird_font_overview_item_draw_caption (self, cr);
	bird_font_overview_item_draw_menu (self, cr);
}

static void
bird_font_overview_item_draw_thumbnail (BirdFontOverviewItem* self,
                                        cairo_t* cr,
                                        gdouble x,
                                        gdouble y)
{
	cairo_surface_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->cache;
	if (_tmp0_ != NULL) {
		cairo_surface_t* _tmp1_;
		cairo_save (cr);
		cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
		cairo_scale (cr, 1 / bird_font_screen_get_scale (), 1 / bird_font_screen_get_scale ());
		_tmp1_ = self->priv->cache;
		cairo_set_source_surface (cr, (cairo_surface_t*) _tmp1_, (gdouble) ((gint) (x * bird_font_screen_get_scale ())), ((gint) (y - bird_font_overview_item_height)) * bird_font_screen_get_scale ());
		cairo_paint (cr);
		cairo_restore (cr);
	}
}

gboolean
bird_font_overview_item_has_icons (BirdFontOverviewItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = bird_font_overview_item_width > ((gdouble) 50);
	return result;
}

void
bird_font_overview_item_draw_caption (BirdFontOverviewItem* self,
                                      cairo_t* cr)
{
	BirdFontGlyphCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	bird_font_overview_item_draw_label_background (self, cr);
	cairo_save (cr);
	_tmp0_ = self->glyphs;
	if (_tmp0_ != NULL) {
		BirdFontText* _tmp3_;
		if (self->selected) {
			BirdFontText* _tmp1_;
			_tmp1_ = self->priv->label;
			bird_font_theme_text_color (_tmp1_, "Overview Selected Foreground");
		} else {
			BirdFontText* _tmp2_;
			_tmp2_ = self->priv->label;
			bird_font_theme_text_color (_tmp2_, "Overview Foreground");
		}
		_tmp3_ = self->priv->label;
		bird_font_text_draw_at_baseline (_tmp3_, cr, self->x + (0.08 * bird_font_overview_item_width), (self->y + bird_font_overview_item_height) - 6, "");
	}
	cairo_restore (cr);
}

void
bird_font_overview_item_create_label_background_cache (BirdFontOverviewItem* self,
                                                       cairo_t* cr)
{
	cairo_t* cc = NULL;
	cairo_pattern_t* p = NULL;
	cairo_surface_t* cache = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_surface_t* _tmp23_;
	cairo_surface_t* _tmp24_;
	cairo_surface_t* _tmp25_;
	cairo_surface_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_pattern_t* _tmp30_;
	cairo_pattern_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_pattern_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_surface_t* _tmp36_;
	cairo_surface_t* _tmp37_;
	cairo_surface_t* _tmp38_;
	cairo_surface_t* _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	cairo_t* _tmp44_;
	cairo_surface_t* _tmp46_;
	cairo_surface_t* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_screen_create_background_surface (((gint) bird_font_overview_item_width) + 1, 20);
	_cairo_surface_destroy0 (cache);
	cache = _tmp0_;
	_tmp1_ = cache;
	_tmp2_ = cairo_create (_tmp1_);
	_cairo_destroy0 (cc);
	cc = _tmp2_;
	_tmp3_ = cc;
	cairo_scale (_tmp3_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
	_tmp4_ = cc;
	cairo_rectangle (_tmp4_, (gdouble) 0, (gdouble) 0, bird_font_overview_item_width, (gdouble) (20 - 1));
	_tmp5_ = cairo_pattern_create_linear (0.0, (gdouble) 0, 0.0, (gdouble) 20);
	_cairo_pattern_destroy0 (p);
	p = _tmp5_;
	_tmp6_ = p;
	bird_font_theme_gradient (_tmp6_, "Overview Item 1", "Overview Item 2");
	_tmp7_ = cc;
	_tmp8_ = p;
	cairo_set_source (_tmp7_, _tmp8_);
	_tmp9_ = cc;
	cairo_fill (_tmp9_);
	if (bird_font_overview_item_has_icons (self)) {
		cairo_t* _tmp10_;
		cairo_t* _tmp11_;
		_tmp10_ = cc;
		bird_font_overview_item_draw_menu_icon (self, _tmp10_, FALSE);
		_tmp11_ = cc;
		bird_font_overview_item_draw_character_info_icon (self, _tmp11_);
	}
	_tmp12_ = cache;
	_tmp13_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp12_);
	_cairo_surface_destroy0 (bird_font_overview_item_label_background);
	bird_font_overview_item_label_background = _tmp13_;
	_tmp14_ = bird_font_screen_create_background_surface (((gint) bird_font_overview_item_width) + 1, 20);
	_cairo_surface_destroy0 (cache);
	cache = _tmp14_;
	_tmp15_ = cache;
	_tmp16_ = cairo_create (_tmp15_);
	_cairo_destroy0 (cc);
	cc = _tmp16_;
	_tmp17_ = cc;
	cairo_scale (_tmp17_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
	_tmp18_ = cc;
	cairo_rectangle (_tmp18_, (gdouble) 0, (gdouble) 0, bird_font_overview_item_width, (gdouble) (20 - 1));
	_tmp19_ = cc;
	bird_font_theme_color (_tmp19_, "Selected Overview Item");
	_tmp20_ = cc;
	cairo_fill (_tmp20_);
	if (bird_font_overview_item_has_icons (self)) {
		cairo_t* _tmp21_;
		cairo_t* _tmp22_;
		_tmp21_ = cc;
		bird_font_overview_item_draw_menu_icon (self, _tmp21_, TRUE);
		_tmp22_ = cc;
		bird_font_overview_item_draw_character_info_icon (self, _tmp22_);
	}
	_tmp23_ = cache;
	_tmp24_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp23_);
	_cairo_surface_destroy0 (bird_font_overview_item_selected_label_background);
	bird_font_overview_item_selected_label_background = _tmp24_;
	_tmp25_ = bird_font_screen_create_background_surface ((gint) bird_font_overview_item_width, 20);
	_cairo_surface_destroy0 (cache);
	cache = _tmp25_;
	_tmp26_ = cache;
	_tmp27_ = cairo_create (_tmp26_);
	_cairo_destroy0 (cc);
	cc = _tmp27_;
	_tmp28_ = cc;
	cairo_scale (_tmp28_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
	_tmp29_ = cc;
	cairo_rectangle (_tmp29_, (gdouble) 0, (gdouble) 0, bird_font_overview_item_width - 1, (gdouble) (20 - 1));
	_tmp30_ = cairo_pattern_create_linear (0.0, (gdouble) 0, 0.0, (gdouble) 20);
	_cairo_pattern_destroy0 (p);
	p = _tmp30_;
	_tmp31_ = p;
	bird_font_theme_gradient (_tmp31_, "Overview Item 1", "Overview Item 2");
	_tmp32_ = cc;
	_tmp33_ = p;
	cairo_set_source (_tmp32_, _tmp33_);
	_tmp34_ = cc;
	cairo_fill (_tmp34_);
	if (bird_font_overview_item_has_icons (self)) {
		cairo_t* _tmp35_;
		_tmp35_ = cc;
		bird_font_overview_item_draw_character_info_icon (self, _tmp35_);
	}
	_tmp36_ = cache;
	_tmp37_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp36_);
	_cairo_surface_destroy0 (bird_font_overview_item_label_background_no_menu);
	bird_font_overview_item_label_background_no_menu = _tmp37_;
	_tmp38_ = bird_font_screen_create_background_surface (((gint) bird_font_overview_item_width) + 1, 20);
	_cairo_surface_destroy0 (cache);
	cache = _tmp38_;
	_tmp39_ = cache;
	_tmp40_ = cairo_create (_tmp39_);
	_cairo_destroy0 (cc);
	cc = _tmp40_;
	_tmp41_ = cc;
	cairo_scale (_tmp41_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
	_tmp42_ = cc;
	cairo_rectangle (_tmp42_, (gdouble) 0, (gdouble) 0, bird_font_overview_item_width, (gdouble) (20 - 1));
	_tmp43_ = cc;
	bird_font_theme_color (_tmp43_, "Selected Overview Item");
	_tmp44_ = cc;
	cairo_fill (_tmp44_);
	if (bird_font_overview_item_has_icons (self)) {
		cairo_t* _tmp45_;
		_tmp45_ = cc;
		bird_font_overview_item_draw_character_info_icon (self, _tmp45_);
	}
	_tmp46_ = cache;
	_tmp47_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp46_);
	_cairo_surface_destroy0 (bird_font_overview_item_selected_label_background_no_menu);
	bird_font_overview_item_selected_label_background_no_menu = _tmp47_;
	_cairo_surface_destroy0 (cache);
	_cairo_pattern_destroy0 (p);
	_cairo_destroy0 (cc);
}

static gboolean
bird_font_overview_item_has_menu (BirdFontOverviewItem* self)
{
	BirdFontGlyphCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->glyphs;
	result = _tmp0_ != NULL;
	return result;
}

void
bird_font_overview_item_draw_label_background (BirdFontOverviewItem* self,
                                               cairo_t* cr)
{
	cairo_surface_t* cache = NULL;
	gboolean icon = FALSE;
	cairo_surface_t* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	cairo_surface_t* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_overview_item_label_background;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		bird_font_overview_item_create_label_background_cache (self, cr);
	}
	_tmp4_ = bird_font_overview_item_label_background;
	if (_tmp4_ != NULL) {
		cairo_surface_t* _tmp5_;
		_tmp5_ = bird_font_overview_item_selected_label_background;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		cairo_surface_t* _tmp6_;
		_tmp6_ = bird_font_overview_item_label_background_no_menu;
		_tmp2_ = _tmp6_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		cairo_surface_t* _tmp7_;
		_tmp7_ = bird_font_overview_item_selected_label_background_no_menu;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		cairo_surface_t* _tmp19_;
		icon = bird_font_overview_item_has_menu (self);
		if (self->selected) {
			_tmp8_ = icon;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			cairo_surface_t* _tmp9_;
			cairo_surface_t* _tmp10_;
			_tmp9_ = bird_font_overview_item_selected_label_background;
			_tmp10_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp9_);
			_cairo_surface_destroy0 (cache);
			cache = _tmp10_;
		} else {
			gboolean _tmp11_ = FALSE;
			if (!self->selected) {
				_tmp11_ = icon;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				cairo_surface_t* _tmp12_;
				cairo_surface_t* _tmp13_;
				_tmp12_ = bird_font_overview_item_label_background;
				_tmp13_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp12_);
				_cairo_surface_destroy0 (cache);
				cache = _tmp13_;
			} else {
				gboolean _tmp14_ = FALSE;
				if (self->selected) {
					_tmp14_ = !icon;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					cairo_surface_t* _tmp15_;
					cairo_surface_t* _tmp16_;
					_tmp15_ = bird_font_overview_item_selected_label_background_no_menu;
					_tmp16_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp15_);
					_cairo_surface_destroy0 (cache);
					cache = _tmp16_;
				} else {
					cairo_surface_t* _tmp17_;
					cairo_surface_t* _tmp18_;
					_tmp17_ = bird_font_overview_item_label_background_no_menu;
					_tmp18_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp17_);
					_cairo_surface_destroy0 (cache);
					cache = _tmp18_;
				}
			}
		}
		_tmp19_ = cache;
		bird_font_screen_paint_background_surface (cr, _tmp19_, (gint) self->x, (gint) ((self->y + bird_font_overview_item_height) - 19));
	}
	_cairo_surface_destroy0 (cache);
}

static void
bird_font_overview_item_draw_character_info_icon (BirdFontOverviewItem* self,
                                                  cairo_t* cr)
{
	BirdFontCharacterInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->info;
	bird_font_character_info_draw_icon (_tmp0_, cr, self->selected, bird_font_overview_item_width - 17, -1.5);
}

void
bird_font_overview_item_hide_menu (BirdFontOverviewItem* self)
{
	BirdFontVersionList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->version_menu;
	if (!bird_font_is_null (_tmp0_)) {
		BirdFontVersionList* _tmp1_;
		_tmp1_ = self->version_menu;
		bird_font_version_list_set_menu_visible (_tmp1_, FALSE);
	}
}

static void
bird_font_overview_item_draw_menu_icon (BirdFontOverviewItem* self,
                                        cairo_t* cc,
                                        gboolean selected)
{
	BirdFontText* icon = NULL;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cc != NULL);
	_tmp0_ = bird_font_text_new ("dropdown_menu", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (icon);
	icon = _tmp0_;
	_tmp1_ = icon;
	bird_font_text_load_font (_tmp1_, "icons.birdfont");
	if (selected) {
		BirdFontText* _tmp2_;
		_tmp2_ = icon;
		bird_font_theme_text_color (_tmp2_, "Overview Selected Foreground");
	} else {
		BirdFontText* _tmp3_;
		_tmp3_ = icon;
		bird_font_theme_text_color (_tmp3_, "Overview Foreground");
	}
	_tmp4_ = icon;
	bird_font_text_draw_at_top (_tmp4_, cc, bird_font_overview_item_width - 32, (gdouble) 0, "");
	_g_object_unref0 (icon);
}

static void
bird_font_overview_item_draw_menu (BirdFontOverviewItem* self,
                                   cairo_t* cr)
{
	gboolean _tmp0_ = FALSE;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontVersionList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp1_ = self->glyphs;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BirdFontVersionList* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->version_menu;
		_tmp3_ = bird_font_version_list_get_menu_visible (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (G_LIKELY (_tmp0_)) {
		return;
	}
	_tmp5_ = self->version_menu;
	bird_font_version_list_draw_menu (_tmp5_, cr);
}

static void
bird_font_overview_item_class_init (BirdFontOverviewItemClass * klass,
                                    gpointer klass_data)
{
	bird_font_overview_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontOverviewItem_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_overview_item_finalize;
}

static void
bird_font_overview_item_instance_init (BirdFontOverviewItem * self,
                                       gpointer klass)
{
	self->priv = bird_font_overview_item_get_instance_private (self);
	self->character = (gunichar) '\0';
	self->selected = FALSE;
	self->priv->cache = NULL;
}

static void
bird_font_overview_item_finalize (GObject * obj)
{
	BirdFontOverviewItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OVERVIEW_ITEM, BirdFontOverviewItem);
	_g_object_unref0 (self->glyphs);
	_g_object_unref0 (self->info);
	_g_object_unref0 (self->version_menu);
	_g_object_unref0 (self->priv->label);
	_cairo_surface_destroy0 (self->priv->cache);
	G_OBJECT_CLASS (bird_font_overview_item_parent_class)->finalize (obj);
}

static GType
bird_font_overview_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOverviewItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_overview_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOverviewItem), 0, (GInstanceInitFunc) bird_font_overview_item_instance_init, NULL };
	GType bird_font_overview_item_type_id;
	bird_font_overview_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontOverviewItem", &g_define_type_info, 0);
	BirdFontOverviewItem_private_offset = g_type_add_instance_private (bird_font_overview_item_type_id, sizeof (BirdFontOverviewItemPrivate));
	return bird_font_overview_item_type_id;
}

GType
bird_font_overview_item_get_type (void)
{
	static volatile gsize bird_font_overview_item_type_id__once = 0;
	if (g_once_init_enter (&bird_font_overview_item_type_id__once)) {
		GType bird_font_overview_item_type_id;
		bird_font_overview_item_type_id = bird_font_overview_item_get_type_once ();
		g_once_init_leave (&bird_font_overview_item_type_id__once, bird_font_overview_item_type_id);
	}
	return bird_font_overview_item_type_id__once;
}

