// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
#include <bdep/new-parsers.hxx>
//
// End prologue.

#include <bdep/new-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_new_c_options
  //

  cmd_new_c_options::
  cmd_new_c_options ()
  : cpp_ (),
    hxx_ (),
    hxx_specified_ (false),
    cxx_ (),
    cxx_specified_ (false),
    ixx_ (),
    ixx_specified_ (false),
    txx_ (),
    txx_specified_ (false),
    mxx_ (),
    mxx_specified_ (false)
  {
  }

  bool cmd_new_c_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_c_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_c_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_c_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_c_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_c_options::
  merge (const cmd_new_c_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.cpp_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->cpp_, a.cpp_);
    }

    if (a.hxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->hxx_, a.hxx_);
      this->hxx_specified_ = true;
    }

    if (a.cxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->cxx_, a.cxx_);
      this->cxx_specified_ = true;
    }

    if (a.ixx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->ixx_, a.ixx_);
      this->ixx_specified_ = true;
    }

    if (a.txx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->txx_, a.txx_);
      this->txx_specified_ = true;
    }

    if (a.mxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->mxx_, a.mxx_);
      this->mxx_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_new_c_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_c_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_c_options_desc_type ()
    {
      ::bdep::cmd_new_c_options::fill (*this);
    }
  };

  void cmd_new_c_options::
  fill (::bdep::cli::options& os)
  {
    // cpp
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("c++");
      std::string dv;
      ::bdep::cli::option o ("cpp", a, true, dv);
      os.push_back (o);
    }

    // hxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("hxx", a, false, dv);
      os.push_back (o);
    }

    // cxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("cxx", a, false, dv);
      os.push_back (o);
    }

    // ixx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("ixx", a, false, dv);
      os.push_back (o);
    }

    // txx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("txx", a, false, dv);
      os.push_back (o);
    }

    // mxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("mxx", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_c_options::
  description ()
  {
    static _cli_cmd_new_c_options_desc_type _cli_cmd_new_c_options_desc_;
    return _cli_cmd_new_c_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_c_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_c_options_map;

  static _cli_cmd_new_c_options_map _cli_cmd_new_c_options_map_;

  struct _cli_cmd_new_c_options_map_init
  {
    _cli_cmd_new_c_options_map_init ()
    {
      _cli_cmd_new_c_options_map_["cpp"] =
      &::bdep::cli::thunk< cmd_new_c_options, &cmd_new_c_options::cpp_ >;
      _cli_cmd_new_c_options_map_["c++"] =
      &::bdep::cli::thunk< cmd_new_c_options, &cmd_new_c_options::cpp_ >;
      _cli_cmd_new_c_options_map_["hxx"] =
      &::bdep::cli::thunk< cmd_new_c_options, string, &cmd_new_c_options::hxx_,
        &cmd_new_c_options::hxx_specified_ >;
      _cli_cmd_new_c_options_map_["cxx"] =
      &::bdep::cli::thunk< cmd_new_c_options, string, &cmd_new_c_options::cxx_,
        &cmd_new_c_options::cxx_specified_ >;
      _cli_cmd_new_c_options_map_["ixx"] =
      &::bdep::cli::thunk< cmd_new_c_options, string, &cmd_new_c_options::ixx_,
        &cmd_new_c_options::ixx_specified_ >;
      _cli_cmd_new_c_options_map_["txx"] =
      &::bdep::cli::thunk< cmd_new_c_options, string, &cmd_new_c_options::txx_,
        &cmd_new_c_options::txx_specified_ >;
      _cli_cmd_new_c_options_map_["mxx"] =
      &::bdep::cli::thunk< cmd_new_c_options, string, &cmd_new_c_options::mxx_,
        &cmd_new_c_options::mxx_specified_ >;
    }
  };

  static _cli_cmd_new_c_options_map_init _cli_cmd_new_c_options_map_init_;

  bool cmd_new_c_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_c_options_map::const_iterator i (_cli_cmd_new_c_options_map_.find (o));

    if (i != _cli_cmd_new_c_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_c_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_cxx_options
  //

  cmd_new_cxx_options::
  cmd_new_cxx_options ()
  : cpp_ (),
    extension_ (),
    extension_specified_ (false),
    hxx_ (),
    hxx_specified_ (false),
    cxx_ (),
    cxx_specified_ (false),
    ixx_ (),
    ixx_specified_ (false),
    txx_ (),
    txx_specified_ (false),
    mxx_ (),
    mxx_specified_ (false),
    c_ ()
  {
  }

  bool cmd_new_cxx_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_cxx_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_cxx_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_cxx_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_cxx_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_cxx_options::
  merge (const cmd_new_cxx_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.cpp_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->cpp_, a.cpp_);
    }

    if (a.extension_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->extension_, a.extension_);
      this->extension_specified_ = true;
    }

    if (a.hxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->hxx_, a.hxx_);
      this->hxx_specified_ = true;
    }

    if (a.cxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->cxx_, a.cxx_);
      this->cxx_specified_ = true;
    }

    if (a.ixx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->ixx_, a.ixx_);
      this->ixx_specified_ = true;
    }

    if (a.txx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->txx_, a.txx_);
      this->txx_specified_ = true;
    }

    if (a.mxx_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->mxx_, a.mxx_);
      this->mxx_specified_ = true;
    }

    if (a.c_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->c_, a.c_);
    }
  }

  ::bdep::cli::usage_para cmd_new_cxx_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_cxx_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_cxx_options_desc_type ()
    {
      ::bdep::cmd_new_cxx_options::fill (*this);
    }
  };

  void cmd_new_cxx_options::
  fill (::bdep::cli::options& os)
  {
    // cpp
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("cpp", a, true, dv);
      os.push_back (o);
    }

    // extension
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("extension", a, false, dv);
      os.push_back (o);
    }

    // hxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("hxx", a, false, dv);
      os.push_back (o);
    }

    // cxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("cxx", a, false, dv);
      os.push_back (o);
    }

    // ixx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("ixx", a, false, dv);
      os.push_back (o);
    }

    // txx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("txx", a, false, dv);
      os.push_back (o);
    }

    // mxx
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("mxx", a, false, dv);
      os.push_back (o);
    }

    // c
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("c", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_cxx_options::
  description ()
  {
    static _cli_cmd_new_cxx_options_desc_type _cli_cmd_new_cxx_options_desc_;
    return _cli_cmd_new_cxx_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_cxx_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_cxx_options_map;

  static _cli_cmd_new_cxx_options_map _cli_cmd_new_cxx_options_map_;

  struct _cli_cmd_new_cxx_options_map_init
  {
    _cli_cmd_new_cxx_options_map_init ()
    {
      _cli_cmd_new_cxx_options_map_["cpp"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, &cmd_new_cxx_options::cpp_ >;
      _cli_cmd_new_cxx_options_map_["extension"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::extension_,
        &cmd_new_cxx_options::extension_specified_ >;
      _cli_cmd_new_cxx_options_map_["hxx"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::hxx_,
        &cmd_new_cxx_options::hxx_specified_ >;
      _cli_cmd_new_cxx_options_map_["cxx"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::cxx_,
        &cmd_new_cxx_options::cxx_specified_ >;
      _cli_cmd_new_cxx_options_map_["ixx"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::ixx_,
        &cmd_new_cxx_options::ixx_specified_ >;
      _cli_cmd_new_cxx_options_map_["txx"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::txx_,
        &cmd_new_cxx_options::txx_specified_ >;
      _cli_cmd_new_cxx_options_map_["mxx"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, string, &cmd_new_cxx_options::mxx_,
        &cmd_new_cxx_options::mxx_specified_ >;
      _cli_cmd_new_cxx_options_map_["c"] =
      &::bdep::cli::thunk< cmd_new_cxx_options, &cmd_new_cxx_options::c_ >;
    }
  };

  static _cli_cmd_new_cxx_options_map_init _cli_cmd_new_cxx_options_map_init_;

  bool cmd_new_cxx_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_cxx_options_map::const_iterator i (_cli_cmd_new_cxx_options_map_.find (o));

    if (i != _cli_cmd_new_cxx_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_cxx_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_exe_options
  //

  cmd_new_exe_options::
  cmd_new_exe_options ()
  : no_tests_ (),
    unit_tests_ (),
    no_install_ (),
    export_stub_ (),
    prefix_ (),
    prefix_specified_ (false),
    subdir_ (),
    subdir_specified_ (false),
    no_subdir_ (),
    buildfile_in_prefix_ (),
    third_party_ (),
    license_ ("other: proprietary"),
    license_specified_ (false),
    no_readme_ (),
    no_package_readme_ (),
    alt_naming_ (),
    source_ (),
    source_specified_ (false)
  {
  }

  bool cmd_new_exe_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_exe_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_exe_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_exe_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_exe_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_exe_options::
  merge (const cmd_new_exe_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.no_tests_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_tests_, a.no_tests_);
    }

    if (a.unit_tests_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->unit_tests_, a.unit_tests_);
    }

    if (a.no_install_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_install_, a.no_install_);
    }

    if (a.export_stub_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->export_stub_, a.export_stub_);
    }

    if (a.prefix_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->prefix_, a.prefix_);
      this->prefix_specified_ = true;
    }

    if (a.subdir_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->subdir_, a.subdir_);
      this->subdir_specified_ = true;
    }

    if (a.no_subdir_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_subdir_, a.no_subdir_);
    }

    if (a.buildfile_in_prefix_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->buildfile_in_prefix_, a.buildfile_in_prefix_);
    }

    if (a.third_party_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->third_party_, a.third_party_);
    }

    if (a.license_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->license_, a.license_);
      this->license_specified_ = true;
    }

    if (a.no_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_readme_, a.no_readme_);
    }

    if (a.no_package_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_package_readme_, a.no_package_readme_);
    }

    if (a.alt_naming_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->alt_naming_, a.alt_naming_);
    }

    if (a.source_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->source_, a.source_);
      this->source_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_new_exe_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_exe_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_exe_options_desc_type ()
    {
      ::bdep::cmd_new_exe_options::fill (*this);
    }
  };

  void cmd_new_exe_options::
  fill (::bdep::cli::options& os)
  {
    // no-tests
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-tests", a, true, dv);
      os.push_back (o);
    }

    // unit-tests
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("unit-tests", a, true, dv);
      os.push_back (o);
    }

    // no-install
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-install", a, true, dv);
      os.push_back (o);
    }

    // export-stub
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("export-stub", a, true, dv);
      os.push_back (o);
    }

    // prefix
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("prefix", a, false, dv);
      os.push_back (o);
    }

    // subdir
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("subdir", a, false, dv);
      os.push_back (o);
    }

    // no-subdir
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-subdir", a, true, dv);
      os.push_back (o);
    }

    // buildfile-in-prefix
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("buildfile-in-prefix", a, true, dv);
      os.push_back (o);
    }

    // third-party
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("third-party", a, true, dv);
      os.push_back (o);
    }

    // license
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("other: proprietary");
      ::bdep::cli::option o ("license", a, false, dv);
      os.push_back (o);
    }

    // no-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-readme", a, true, dv);
      os.push_back (o);
    }

    // no-package-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-package-readme", a, true, dv);
      os.push_back (o);
    }

    // alt-naming
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("alt-naming", a, true, dv);
      os.push_back (o);
    }

    // source
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("source", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_exe_options::
  description ()
  {
    static _cli_cmd_new_exe_options_desc_type _cli_cmd_new_exe_options_desc_;
    return _cli_cmd_new_exe_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_exe_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_exe_options_map;

  static _cli_cmd_new_exe_options_map _cli_cmd_new_exe_options_map_;

  struct _cli_cmd_new_exe_options_map_init
  {
    _cli_cmd_new_exe_options_map_init ()
    {
      _cli_cmd_new_exe_options_map_["no-tests"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::no_tests_ >;
      _cli_cmd_new_exe_options_map_["unit-tests"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::unit_tests_ >;
      _cli_cmd_new_exe_options_map_["no-install"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::no_install_ >;
      _cli_cmd_new_exe_options_map_["export-stub"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::export_stub_ >;
      _cli_cmd_new_exe_options_map_["prefix"] =
      &::bdep::cli::thunk< cmd_new_exe_options, dir_path, &cmd_new_exe_options::prefix_,
        &cmd_new_exe_options::prefix_specified_ >;
      _cli_cmd_new_exe_options_map_["subdir"] =
      &::bdep::cli::thunk< cmd_new_exe_options, dir_path, &cmd_new_exe_options::subdir_,
        &cmd_new_exe_options::subdir_specified_ >;
      _cli_cmd_new_exe_options_map_["no-subdir"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::no_subdir_ >;
      _cli_cmd_new_exe_options_map_["buildfile-in-prefix"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::buildfile_in_prefix_ >;
      _cli_cmd_new_exe_options_map_["third-party"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::third_party_ >;
      _cli_cmd_new_exe_options_map_["license"] =
      &::bdep::cli::thunk< cmd_new_exe_options, string, &cmd_new_exe_options::license_,
        &cmd_new_exe_options::license_specified_ >;
      _cli_cmd_new_exe_options_map_["no-readme"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::no_readme_ >;
      _cli_cmd_new_exe_options_map_["no-package-readme"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::no_package_readme_ >;
      _cli_cmd_new_exe_options_map_["alt-naming"] =
      &::bdep::cli::thunk< cmd_new_exe_options, &cmd_new_exe_options::alt_naming_ >;
      _cli_cmd_new_exe_options_map_["source"] =
      &::bdep::cli::thunk< cmd_new_exe_options, dir_path, &cmd_new_exe_options::source_,
        &cmd_new_exe_options::source_specified_ >;
    }
  };

  static _cli_cmd_new_exe_options_map_init _cli_cmd_new_exe_options_map_init_;

  bool cmd_new_exe_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_exe_options_map::const_iterator i (_cli_cmd_new_exe_options_map_.find (o));

    if (i != _cli_cmd_new_exe_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_exe_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_lib_options
  //

  cmd_new_lib_options::
  cmd_new_lib_options ()
  : binless_ (),
    no_tests_ (),
    unit_tests_ (),
    no_install_ (),
    no_version_ (),
    no_symexport_ (),
    auto_symexport_ (),
    prefix_include_ (),
    prefix_include_specified_ (false),
    prefix_source_ (),
    prefix_source_specified_ (false),
    prefix_ (),
    prefix_specified_ (false),
    split_ (),
    subdir_ (),
    subdir_specified_ (false),
    no_subdir_include_ (),
    no_subdir_source_ (),
    no_subdir_ (),
    buildfile_in_prefix_ (),
    third_party_ (),
    license_ ("other: proprietary"),
    license_specified_ (false),
    no_readme_ (),
    no_package_readme_ (),
    alt_naming_ (),
    source_ (),
    source_specified_ (false)
  {
  }

  bool cmd_new_lib_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_lib_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_lib_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_lib_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_lib_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_lib_options::
  merge (const cmd_new_lib_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.binless_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->binless_, a.binless_);
    }

    if (a.no_tests_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_tests_, a.no_tests_);
    }

    if (a.unit_tests_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->unit_tests_, a.unit_tests_);
    }

    if (a.no_install_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_install_, a.no_install_);
    }

    if (a.no_version_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_version_, a.no_version_);
    }

    if (a.no_symexport_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_symexport_, a.no_symexport_);
    }

    if (a.auto_symexport_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->auto_symexport_, a.auto_symexport_);
    }

    if (a.prefix_include_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->prefix_include_, a.prefix_include_);
      this->prefix_include_specified_ = true;
    }

    if (a.prefix_source_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->prefix_source_, a.prefix_source_);
      this->prefix_source_specified_ = true;
    }

    if (a.prefix_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->prefix_, a.prefix_);
      this->prefix_specified_ = true;
    }

    if (a.split_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->split_, a.split_);
    }

    if (a.subdir_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->subdir_, a.subdir_);
      this->subdir_specified_ = true;
    }

    if (a.no_subdir_include_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_subdir_include_, a.no_subdir_include_);
    }

    if (a.no_subdir_source_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_subdir_source_, a.no_subdir_source_);
    }

    if (a.no_subdir_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_subdir_, a.no_subdir_);
    }

    if (a.buildfile_in_prefix_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->buildfile_in_prefix_, a.buildfile_in_prefix_);
    }

    if (a.third_party_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->third_party_, a.third_party_);
    }

    if (a.license_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->license_, a.license_);
      this->license_specified_ = true;
    }

    if (a.no_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_readme_, a.no_readme_);
    }

    if (a.no_package_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_package_readme_, a.no_package_readme_);
    }

    if (a.alt_naming_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->alt_naming_, a.alt_naming_);
    }

    if (a.source_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->source_, a.source_);
      this->source_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_new_lib_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_lib_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_lib_options_desc_type ()
    {
      ::bdep::cmd_new_lib_options::fill (*this);
    }
  };

  void cmd_new_lib_options::
  fill (::bdep::cli::options& os)
  {
    // binless
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("binless", a, true, dv);
      os.push_back (o);
    }

    // no-tests
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-tests", a, true, dv);
      os.push_back (o);
    }

    // unit-tests
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("unit-tests", a, true, dv);
      os.push_back (o);
    }

    // no-install
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-install", a, true, dv);
      os.push_back (o);
    }

    // no-version
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-version", a, true, dv);
      os.push_back (o);
    }

    // no-symexport
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-symexport", a, true, dv);
      os.push_back (o);
    }

    // auto-symexport
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("auto-symexport", a, true, dv);
      os.push_back (o);
    }

    // prefix-include
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("prefix-include", a, false, dv);
      os.push_back (o);
    }

    // prefix-source
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("prefix-source", a, false, dv);
      os.push_back (o);
    }

    // prefix
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("prefix", a, false, dv);
      os.push_back (o);
    }

    // split
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("split", a, true, dv);
      os.push_back (o);
    }

    // subdir
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("subdir", a, false, dv);
      os.push_back (o);
    }

    // no-subdir-include
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-subdir-include", a, true, dv);
      os.push_back (o);
    }

    // no-subdir-source
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-subdir-source", a, true, dv);
      os.push_back (o);
    }

    // no-subdir
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-subdir", a, true, dv);
      os.push_back (o);
    }

    // buildfile-in-prefix
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("buildfile-in-prefix", a, true, dv);
      os.push_back (o);
    }

    // third-party
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("third-party", a, true, dv);
      os.push_back (o);
    }

    // license
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("other: proprietary");
      ::bdep::cli::option o ("license", a, false, dv);
      os.push_back (o);
    }

    // no-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-readme", a, true, dv);
      os.push_back (o);
    }

    // no-package-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-package-readme", a, true, dv);
      os.push_back (o);
    }

    // alt-naming
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("alt-naming", a, true, dv);
      os.push_back (o);
    }

    // source
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("source", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_lib_options::
  description ()
  {
    static _cli_cmd_new_lib_options_desc_type _cli_cmd_new_lib_options_desc_;
    return _cli_cmd_new_lib_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_lib_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_lib_options_map;

  static _cli_cmd_new_lib_options_map _cli_cmd_new_lib_options_map_;

  struct _cli_cmd_new_lib_options_map_init
  {
    _cli_cmd_new_lib_options_map_init ()
    {
      _cli_cmd_new_lib_options_map_["binless"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::binless_ >;
      _cli_cmd_new_lib_options_map_["no-tests"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_tests_ >;
      _cli_cmd_new_lib_options_map_["unit-tests"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::unit_tests_ >;
      _cli_cmd_new_lib_options_map_["no-install"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_install_ >;
      _cli_cmd_new_lib_options_map_["no-version"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_version_ >;
      _cli_cmd_new_lib_options_map_["no-symexport"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_symexport_ >;
      _cli_cmd_new_lib_options_map_["auto-symexport"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::auto_symexport_ >;
      _cli_cmd_new_lib_options_map_["prefix-include"] =
      &::bdep::cli::thunk< cmd_new_lib_options, dir_path, &cmd_new_lib_options::prefix_include_,
        &cmd_new_lib_options::prefix_include_specified_ >;
      _cli_cmd_new_lib_options_map_["prefix-source"] =
      &::bdep::cli::thunk< cmd_new_lib_options, dir_path, &cmd_new_lib_options::prefix_source_,
        &cmd_new_lib_options::prefix_source_specified_ >;
      _cli_cmd_new_lib_options_map_["prefix"] =
      &::bdep::cli::thunk< cmd_new_lib_options, dir_path, &cmd_new_lib_options::prefix_,
        &cmd_new_lib_options::prefix_specified_ >;
      _cli_cmd_new_lib_options_map_["split"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::split_ >;
      _cli_cmd_new_lib_options_map_["subdir"] =
      &::bdep::cli::thunk< cmd_new_lib_options, dir_path, &cmd_new_lib_options::subdir_,
        &cmd_new_lib_options::subdir_specified_ >;
      _cli_cmd_new_lib_options_map_["no-subdir-include"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_subdir_include_ >;
      _cli_cmd_new_lib_options_map_["no-subdir-source"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_subdir_source_ >;
      _cli_cmd_new_lib_options_map_["no-subdir"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_subdir_ >;
      _cli_cmd_new_lib_options_map_["buildfile-in-prefix"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::buildfile_in_prefix_ >;
      _cli_cmd_new_lib_options_map_["third-party"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::third_party_ >;
      _cli_cmd_new_lib_options_map_["license"] =
      &::bdep::cli::thunk< cmd_new_lib_options, string, &cmd_new_lib_options::license_,
        &cmd_new_lib_options::license_specified_ >;
      _cli_cmd_new_lib_options_map_["no-readme"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_readme_ >;
      _cli_cmd_new_lib_options_map_["no-package-readme"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::no_package_readme_ >;
      _cli_cmd_new_lib_options_map_["alt-naming"] =
      &::bdep::cli::thunk< cmd_new_lib_options, &cmd_new_lib_options::alt_naming_ >;
      _cli_cmd_new_lib_options_map_["source"] =
      &::bdep::cli::thunk< cmd_new_lib_options, dir_path, &cmd_new_lib_options::source_,
        &cmd_new_lib_options::source_specified_ >;
    }
  };

  static _cli_cmd_new_lib_options_map_init _cli_cmd_new_lib_options_map_init_;

  bool cmd_new_lib_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_lib_options_map::const_iterator i (_cli_cmd_new_lib_options_map_.find (o));

    if (i != _cli_cmd_new_lib_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_lib_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_bare_options
  //

  cmd_new_bare_options::
  cmd_new_bare_options ()
  : no_tests_ (),
    no_install_ (),
    license_ ("other: proprietary"),
    license_specified_ (false),
    no_readme_ (),
    alt_naming_ ()
  {
  }

  bool cmd_new_bare_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_bare_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_bare_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_bare_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_bare_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_bare_options::
  merge (const cmd_new_bare_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.no_tests_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_tests_, a.no_tests_);
    }

    if (a.no_install_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_install_, a.no_install_);
    }

    if (a.license_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->license_, a.license_);
      this->license_specified_ = true;
    }

    if (a.no_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_readme_, a.no_readme_);
    }

    if (a.alt_naming_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->alt_naming_, a.alt_naming_);
    }
  }

  ::bdep::cli::usage_para cmd_new_bare_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_bare_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_bare_options_desc_type ()
    {
      ::bdep::cmd_new_bare_options::fill (*this);
    }
  };

  void cmd_new_bare_options::
  fill (::bdep::cli::options& os)
  {
    // no-tests
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-tests", a, true, dv);
      os.push_back (o);
    }

    // no-install
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-install", a, true, dv);
      os.push_back (o);
    }

    // license
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("other: proprietary");
      ::bdep::cli::option o ("license", a, false, dv);
      os.push_back (o);
    }

    // no-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-readme", a, true, dv);
      os.push_back (o);
    }

    // alt-naming
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("alt-naming", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_bare_options::
  description ()
  {
    static _cli_cmd_new_bare_options_desc_type _cli_cmd_new_bare_options_desc_;
    return _cli_cmd_new_bare_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_bare_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_bare_options_map;

  static _cli_cmd_new_bare_options_map _cli_cmd_new_bare_options_map_;

  struct _cli_cmd_new_bare_options_map_init
  {
    _cli_cmd_new_bare_options_map_init ()
    {
      _cli_cmd_new_bare_options_map_["no-tests"] =
      &::bdep::cli::thunk< cmd_new_bare_options, &cmd_new_bare_options::no_tests_ >;
      _cli_cmd_new_bare_options_map_["no-install"] =
      &::bdep::cli::thunk< cmd_new_bare_options, &cmd_new_bare_options::no_install_ >;
      _cli_cmd_new_bare_options_map_["license"] =
      &::bdep::cli::thunk< cmd_new_bare_options, string, &cmd_new_bare_options::license_,
        &cmd_new_bare_options::license_specified_ >;
      _cli_cmd_new_bare_options_map_["no-readme"] =
      &::bdep::cli::thunk< cmd_new_bare_options, &cmd_new_bare_options::no_readme_ >;
      _cli_cmd_new_bare_options_map_["alt-naming"] =
      &::bdep::cli::thunk< cmd_new_bare_options, &cmd_new_bare_options::alt_naming_ >;
    }
  };

  static _cli_cmd_new_bare_options_map_init _cli_cmd_new_bare_options_map_init_;

  bool cmd_new_bare_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_bare_options_map::const_iterator i (_cli_cmd_new_bare_options_map_.find (o));

    if (i != _cli_cmd_new_bare_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_bare_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_empty_options
  //

  cmd_new_empty_options::
  cmd_new_empty_options ()
  : third_party_ (),
    no_readme_ ()
  {
  }

  bool cmd_new_empty_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_empty_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_empty_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_empty_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_empty_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_empty_options::
  merge (const cmd_new_empty_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.third_party_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->third_party_, a.third_party_);
    }

    if (a.no_readme_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_readme_, a.no_readme_);
    }
  }

  ::bdep::cli::usage_para cmd_new_empty_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_empty_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_empty_options_desc_type ()
    {
      ::bdep::cmd_new_empty_options::fill (*this);
    }
  };

  void cmd_new_empty_options::
  fill (::bdep::cli::options& os)
  {
    // third-party
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("third-party", a, true, dv);
      os.push_back (o);
    }

    // no-readme
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("no-readme", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_empty_options::
  description ()
  {
    static _cli_cmd_new_empty_options_desc_type _cli_cmd_new_empty_options_desc_;
    return _cli_cmd_new_empty_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_empty_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_empty_options_map;

  static _cli_cmd_new_empty_options_map _cli_cmd_new_empty_options_map_;

  struct _cli_cmd_new_empty_options_map_init
  {
    _cli_cmd_new_empty_options_map_init ()
    {
      _cli_cmd_new_empty_options_map_["third-party"] =
      &::bdep::cli::thunk< cmd_new_empty_options, &cmd_new_empty_options::third_party_ >;
      _cli_cmd_new_empty_options_map_["no-readme"] =
      &::bdep::cli::thunk< cmd_new_empty_options, &cmd_new_empty_options::no_readme_ >;
    }
  };

  static _cli_cmd_new_empty_options_map_init _cli_cmd_new_empty_options_map_init_;

  bool cmd_new_empty_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_empty_options_map::const_iterator i (_cli_cmd_new_empty_options_map_.find (o));

    if (i != _cli_cmd_new_empty_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_empty_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_git_options
  //

  cmd_new_git_options::
  cmd_new_git_options ()
  : branch_ (),
    branch_specified_ (false)
  {
  }

  bool cmd_new_git_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_git_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_git_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_git_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_git_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_git_options::
  merge (const cmd_new_git_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.branch_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->branch_, a.branch_);
      this->branch_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_new_git_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_git_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_git_options_desc_type ()
    {
      ::bdep::cmd_new_git_options::fill (*this);
    }
  };

  void cmd_new_git_options::
  fill (::bdep::cli::options& os)
  {
    // branch
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("branch", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_git_options::
  description ()
  {
    static _cli_cmd_new_git_options_desc_type _cli_cmd_new_git_options_desc_;
    return _cli_cmd_new_git_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_git_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_git_options_map;

  static _cli_cmd_new_git_options_map _cli_cmd_new_git_options_map_;

  struct _cli_cmd_new_git_options_map_init
  {
    _cli_cmd_new_git_options_map_init ()
    {
      _cli_cmd_new_git_options_map_["branch"] =
      &::bdep::cli::thunk< cmd_new_git_options, string, &cmd_new_git_options::branch_,
        &cmd_new_git_options::branch_specified_ >;
    }
  };

  static _cli_cmd_new_git_options_map_init _cli_cmd_new_git_options_map_init_;

  bool cmd_new_git_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_git_options_map::const_iterator i (_cli_cmd_new_git_options_map_.find (o));

    if (i != _cli_cmd_new_git_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_git_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_none_options
  //

  cmd_new_none_options::
  cmd_new_none_options ()
  {
  }

  bool cmd_new_none_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_none_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_none_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_none_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_none_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_none_options::
  merge (const cmd_new_none_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);
  }

  ::bdep::cli::usage_para cmd_new_none_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_new_none_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_none_options_desc_type ()
    {
      ::bdep::cmd_new_none_options::fill (*this);
    }
  };

  void cmd_new_none_options::
  fill (::bdep::cli::options&)
  {
  }

  const ::bdep::cli::options& cmd_new_none_options::
  description ()
  {
    static _cli_cmd_new_none_options_desc_type _cli_cmd_new_none_options_desc_;
    return _cli_cmd_new_none_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_none_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_none_options_map;

  static _cli_cmd_new_none_options_map _cli_cmd_new_none_options_map_;

  struct _cli_cmd_new_none_options_map_init
  {
    _cli_cmd_new_none_options_map_init ()
    {
    }
  };

  static _cli_cmd_new_none_options_map_init _cli_cmd_new_none_options_map_init_;

  bool cmd_new_none_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_none_options_map::const_iterator i (_cli_cmd_new_none_options_map_.find (o));

    if (i != _cli_cmd_new_none_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_new_none_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_new_options
  //

  cmd_new_options::
  cmd_new_options ()
  : no_init_ (),
    package_ (),
    source_ (),
    subdirectory_ (),
    output_dir_ (),
    output_dir_specified_ (false),
    directory_ (),
    directory_specified_ (false),
    type_ (),
    type_specified_ (false),
    lang_ (),
    lang_specified_ (false),
    vcs_ (),
    vcs_specified_ (false),
    pre_hook_ (),
    pre_hook_specified_ (false),
    post_hook_ (),
    post_hook_specified_ (false),
    no_amalgamation_ (),
    no_checks_ (),
    config_add_ (),
    config_add_specified_ (false),
    config_create_ (),
    config_create_specified_ (false)
  {
  }

  bool cmd_new_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_new_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_new_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_new_options::
  merge (const cmd_new_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // configuration_add_options base
    //
    ::bdep::configuration_add_options::merge (a);

    // configuration_name_options base
    //
    ::bdep::configuration_name_options::merge (a);

    if (a.no_init_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_init_, a.no_init_);
    }

    if (a.package_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->package_, a.package_);
    }

    if (a.source_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->source_, a.source_);
    }

    if (a.subdirectory_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->subdirectory_, a.subdirectory_);
    }

    if (a.output_dir_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->output_dir_, a.output_dir_);
      this->output_dir_specified_ = true;
    }

    if (a.directory_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->directory_, a.directory_);
      this->directory_specified_ = true;
    }

    if (a.type_specified_)
    {
      ::bdep::cli::parser< cmd_new_type>::merge (
        this->type_, a.type_);
      this->type_specified_ = true;
    }

    if (a.lang_specified_)
    {
      ::bdep::cli::parser< cmd_new_lang>::merge (
        this->lang_, a.lang_);
      this->lang_specified_ = true;
    }

    if (a.vcs_specified_)
    {
      ::bdep::cli::parser< cmd_new_vcs>::merge (
        this->vcs_, a.vcs_);
      this->vcs_specified_ = true;
    }

    if (a.pre_hook_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->pre_hook_, a.pre_hook_);
      this->pre_hook_specified_ = true;
    }

    if (a.post_hook_specified_)
    {
      ::bdep::cli::parser< strings>::merge (
        this->post_hook_, a.post_hook_);
      this->post_hook_specified_ = true;
    }

    if (a.no_amalgamation_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_amalgamation_, a.no_amalgamation_);
    }

    if (a.no_checks_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_checks_, a.no_checks_);
    }

    if (a.config_add_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->config_add_, a.config_add_);
      this->config_add_specified_ = true;
    }

    if (a.config_create_specified_)
    {
      ::bdep::cli::parser< dir_path>::merge (
        this->config_create_, a.config_create_);
      this->config_create_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_new_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mNEW OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--no-init\033[0m                 Don't initialize an empty build configuration set." << ::std::endl;

    os << std::endl
       << "\033[1m--package\033[0m                 Create a new package inside an already existing" << ::std::endl
       << "                          project rather than a new project." << ::std::endl;

    os << std::endl
       << "\033[1m--source\033[0m                  Create a new source subdirectory inside an already" << ::std::endl
       << "                          existing project or package rather than a new" << ::std::endl
       << "                          project." << ::std::endl;

    os << std::endl
       << "\033[1m--output-dir\033[0m|\033[1m-o\033[0m \033[4mdir\033[0m       Create the project, package, or source subdirectory" << ::std::endl
       << "                          in the specified directory." << ::std::endl;

    os << std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mdir\033[0m        Assume the project/package is in the specified" << ::std::endl
       << "                          directory rather than in the current working" << ::std::endl
       << "                          directory. Only used with \033[1m--package\033[0m or \033[1m--source\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--type\033[0m|\033[1m-t\033[0m \033[4mtype\033[0m[,\033[4mopt\033[0m...]   Specify project type and options. Valid values for" << ::std::endl
       << "                          \033[4mtype\033[0m are \033[1mexe\033[0m (executable project, default), \033[1mlib\033[0m" << ::std::endl
       << "                          (library project), \033[1mbare\033[0m (bare project without any" << ::std::endl
       << "                          source code), and \033[1mempty\033[0m (empty project ready to be" << ::std::endl
       << "                          filled with packages). Valid values for \033[4mopt\033[0m are" << ::std::endl
       << "                          type-specific." << ::std::endl;

    os << std::endl
       << "\033[1m--lang\033[0m|\033[1m-l\033[0m \033[4mlang\033[0m[,\033[4mopt\033[0m...]   Specify project language and options. Valid values" << ::std::endl
       << "                          for \033[4mlang\033[0m are \033[1mc\033[0m and \033[1mc++\033[0m (default). Valid values for" << ::std::endl
       << "                          \033[4mopt\033[0m are language-specific." << ::std::endl;

    os << std::endl
       << "\033[1m--vcs\033[0m|\033[1m-s\033[0m \033[4mvcs\033[0m[,\033[4mopt\033[0m...]     Specify project version control system and options." << ::std::endl
       << "                          Valid values for \033[4mvcs\033[0m are \033[1mgit\033[0m (default) and \033[1mnone\033[0m." << ::std::endl
       << "                          Valid values for \033[4mopt\033[0m are system-specific." << ::std::endl;

    os << std::endl
       << "\033[1m--pre-hook\033[0m \033[4mcommand\033[0m" << std::endl;

    os << std::endl
       << "\033[1m--post-hook\033[0m \033[4mcommand\033[0m       Run the specified command before/after creating the" << ::std::endl
       << "                          project, package, or source directory." << ::std::endl
       << ::std::endl
       << "                          The \033[4mcommand\033[0m value is interpreted as a" << ::std::endl
       << "                          whitespace-separated, potentially quoted command line" << ::std::endl
       << "                          consisting of a program or a portable builtin" << ::std::endl
       << "                          (testscript#builtins) optionally followed by" << ::std::endl
       << "                          arguments and redirects. Specifically, a single level" << ::std::endl
       << "                          of quotes (either single or double) is removed and" << ::std::endl
       << "                          whitespaces are not treated as separators inside such" << ::std::endl
       << "                          quoted fragments. Currently only the \033[1mstdout\033[0m redirect" << ::std::endl
       << "                          to a file is supported. For example:" << ::std::endl
       << ::std::endl
       << "                          $ bdep new --post-hook \"echo '.idea/ # IDE'" << ::std::endl
       << "                          >>.gitignore\" hello" << ::std::endl
       << ::std::endl
       << "                          The command line elements (program, arguments, etc)" << ::std::endl
       << "                          may optionally contain substitutions -- variable" << ::std::endl
       << "                          names enclosed with the \033[1m@\033[0m substitution symbol --" << ::std::endl
       << "                          which are replaced with the corresponding variable" << ::std::endl
       << "                          values to produce the actual command. The following" << ::std::endl
       << "                          variable names are recognized with the double" << ::std::endl
       << "                          substitution symbol (\033[1m@@\033[0m) serving as an escape" << ::std::endl
       << "                          sequence." << ::std::endl
       << ::std::endl
       << "                          @mode@ - one of 'project', 'package', or 'source'" << ::std::endl
       << "                          @name@ - project, package, or source subdirectory" << ::std::endl
       << "                          name" << ::std::endl
       << "                          @base@ - name base (name without extension)" << ::std::endl
       << "                          @stem@ - name stem (name base without 'lib' prefix)" << ::std::endl
       << "                          @root@ - project/package root directory" << ::std::endl
       << "                          @pfx@  - combined prefix relative to project/package" << ::std::endl
       << "                          root" << ::std::endl
       << "                          @inc@  - split header prefix relative to" << ::std::endl
       << "                          project/package root" << ::std::endl
       << "                          @src@  - split source prefix relative to" << ::std::endl
       << "                          project/package root" << ::std::endl
       << "                          @sub@  - source subdirectory relative to" << ::std::endl
       << "                          header/source prefix" << ::std::endl
       << "                          @type@ - type (--type|-t value: 'exe', 'lib', etc)" << ::std::endl
       << "                          @lang@ - language (--lang|-l value: 'c', 'c++', etc)" << ::std::endl
       << "                          @vcs@  - version control system (--vcs|-s value:" << ::std::endl
       << "                          'git', etc)" << ::std::endl
       << ::std::endl
       << "                          Note that the \033[1m@inc@\033[0m and \033[1m@src@\033[0m variables are only set" << ::std::endl
       << "                          if the header/source prefix is split with the" << ::std::endl
       << "                          combined \033[1m@pfx@\033[0m variable set otherwise." << ::std::endl
       << ::std::endl
       << "                          For example:" << ::std::endl
       << ::std::endl
       << "                          $ bdep new --post-hook \"echo bin/" << ::std::endl
       << "                          >>@name@/.gitignore\" hello" << ::std::endl
       << ::std::endl
       << "                          These substitution variables are also made available" << ::std::endl
       << "                          to the hook program as the \033[1mBDEP_NEW_*\033[0m environment" << ::std::endl
       << "                          variables (\033[1mBDEP_NEW_MODE\033[0m, \033[1mBDEP_NEW_NAME\033[0m, etc)." << ::std::endl;

    os << std::endl
       << "\033[1m--no-amalgamation\033[0m         Create a project with disabled amalgamation support." << ::std::endl
       << "                          This option is normally only used for testing." << ::std::endl;

    os << std::endl
       << "\033[1m--no-checks\033[0m               Suppress nested project/package checks. This option" << ::std::endl
       << "                          is normally only used for testing." << ::std::endl;

    os << std::endl
       << "\033[1m--config-add\033[0m|\033[1m-A\033[0m \033[4mdir\033[0m       Add an existing build configuration \033[4mdir\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--config-create\033[0m|\033[1m-C\033[0m \033[4mdir\033[0m    Create a new build configuration in \033[4mdir\033[0m." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // configuration_add_options base
    //
    p = ::bdep::configuration_add_options::print_usage (os, p);

    // configuration_name_options base
    //
    p = ::bdep::configuration_name_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_new_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_new_options_desc_type ()
    {
      ::bdep::cmd_new_options::fill (*this);
    }
  };

  void cmd_new_options::
  fill (::bdep::cli::options& os)
  {
    // configuration_add_options base
    //
    ::bdep::configuration_add_options::fill (os);

    // configuration_name_options base
    //
    ::bdep::configuration_name_options::fill (os);

    // --no-init
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-init", a, true, dv);
      os.push_back (o);
    }

    // --package
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--package", a, true, dv);
      os.push_back (o);
    }

    // --source
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--source", a, true, dv);
      os.push_back (o);
    }

    // --subdirectory
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--subdirectory", a, true, dv);
      os.push_back (o);
    }

    // --output-dir
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-o");
      std::string dv;
      ::bdep::cli::option o ("--output-dir", a, false, dv);
      os.push_back (o);
    }

    // --directory
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-d");
      std::string dv;
      ::bdep::cli::option o ("--directory", a, false, dv);
      os.push_back (o);
    }

    // --type
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-t");
      std::string dv;
      ::bdep::cli::option o ("--type", a, false, dv);
      os.push_back (o);
    }

    // --lang
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-l");
      std::string dv;
      ::bdep::cli::option o ("--lang", a, false, dv);
      os.push_back (o);
    }

    // --vcs
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-s");
      std::string dv;
      ::bdep::cli::option o ("--vcs", a, false, dv);
      os.push_back (o);
    }

    // --pre-hook
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--pre-hook", a, false, dv);
      os.push_back (o);
    }

    // --post-hook
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--post-hook", a, false, dv);
      os.push_back (o);
    }

    // --no-amalgamation
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-amalgamation", a, true, dv);
      os.push_back (o);
    }

    // --no-checks
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-checks", a, true, dv);
      os.push_back (o);
    }

    // --config-add
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-A");
      std::string dv;
      ::bdep::cli::option o ("--config-add", a, false, dv);
      os.push_back (o);
    }

    // --config-create
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-C");
      std::string dv;
      ::bdep::cli::option o ("--config-create", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_new_options::
  description ()
  {
    static _cli_cmd_new_options_desc_type _cli_cmd_new_options_desc_;
    return _cli_cmd_new_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_new_options&, ::bdep::cli::scanner&)>
  _cli_cmd_new_options_map;

  static _cli_cmd_new_options_map _cli_cmd_new_options_map_;

  struct _cli_cmd_new_options_map_init
  {
    _cli_cmd_new_options_map_init ()
    {
      _cli_cmd_new_options_map_["--no-init"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::no_init_ >;
      _cli_cmd_new_options_map_["--package"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::package_ >;
      _cli_cmd_new_options_map_["--source"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::source_ >;
      _cli_cmd_new_options_map_["--subdirectory"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::subdirectory_ >;
      _cli_cmd_new_options_map_["--output-dir"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::output_dir_,
        &cmd_new_options::output_dir_specified_ >;
      _cli_cmd_new_options_map_["-o"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::output_dir_,
        &cmd_new_options::output_dir_specified_ >;
      _cli_cmd_new_options_map_["--directory"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::directory_,
        &cmd_new_options::directory_specified_ >;
      _cli_cmd_new_options_map_["-d"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::directory_,
        &cmd_new_options::directory_specified_ >;
      _cli_cmd_new_options_map_["--type"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_type, &cmd_new_options::type_,
        &cmd_new_options::type_specified_ >;
      _cli_cmd_new_options_map_["-t"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_type, &cmd_new_options::type_,
        &cmd_new_options::type_specified_ >;
      _cli_cmd_new_options_map_["--lang"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_lang, &cmd_new_options::lang_,
        &cmd_new_options::lang_specified_ >;
      _cli_cmd_new_options_map_["-l"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_lang, &cmd_new_options::lang_,
        &cmd_new_options::lang_specified_ >;
      _cli_cmd_new_options_map_["--vcs"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_vcs, &cmd_new_options::vcs_,
        &cmd_new_options::vcs_specified_ >;
      _cli_cmd_new_options_map_["-s"] =
      &::bdep::cli::thunk< cmd_new_options, cmd_new_vcs, &cmd_new_options::vcs_,
        &cmd_new_options::vcs_specified_ >;
      _cli_cmd_new_options_map_["--pre-hook"] =
      &::bdep::cli::thunk< cmd_new_options, strings, &cmd_new_options::pre_hook_,
        &cmd_new_options::pre_hook_specified_ >;
      _cli_cmd_new_options_map_["--post-hook"] =
      &::bdep::cli::thunk< cmd_new_options, strings, &cmd_new_options::post_hook_,
        &cmd_new_options::post_hook_specified_ >;
      _cli_cmd_new_options_map_["--no-amalgamation"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::no_amalgamation_ >;
      _cli_cmd_new_options_map_["--no-checks"] =
      &::bdep::cli::thunk< cmd_new_options, &cmd_new_options::no_checks_ >;
      _cli_cmd_new_options_map_["--config-add"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::config_add_,
        &cmd_new_options::config_add_specified_ >;
      _cli_cmd_new_options_map_["-A"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::config_add_,
        &cmd_new_options::config_add_specified_ >;
      _cli_cmd_new_options_map_["--config-create"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::config_create_,
        &cmd_new_options::config_create_specified_ >;
      _cli_cmd_new_options_map_["-C"] =
      &::bdep::cli::thunk< cmd_new_options, dir_path, &cmd_new_options::config_create_,
        &cmd_new_options::config_create_specified_ >;
    }
  };

  static _cli_cmd_new_options_map_init _cli_cmd_new_options_map_init_;

  bool cmd_new_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_new_options_map::const_iterator i (_cli_cmd_new_options_map_.find (o));

    if (i != _cli_cmd_new_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // configuration_add_options base
    //
    if (::bdep::configuration_add_options::_parse (o, s))
      return true;

    // configuration_name_options base
    //
    if (::bdep::configuration_name_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_new_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_new_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep new\033[0m [\033[4moptions\033[0m] [\033[1m--no-init\033[0m] \033[4mspec\033[0m [\033[4mname\033[0m]" << ::std::endl
       << "\033[1mbdep new\033[0m [\033[4moptions\033[0m] \033[1m--config-add|-A\033[0m \033[4mcfg-dir\033[0m [\033[1m@\033[0m\033[4mcfg-name\033[0m] \033[4mspec\033[0m [\033[4mname\033[0m]" << ::std::endl
       << "\033[1mbdep new\033[0m [\033[4moptions\033[0m] \033[1m--config-create|-C\033[0m \033[4mcfg-dir\033[0m [\033[1m@\033[0m\033[4mcfg-name\033[0m] \033[4mspec\033[0m [\033[4mname\033[0m]" << ::std::endl
       << "         [\033[4mcfg-args\033[0m]" << ::std::endl
       << "\033[1mbdep new\033[0m [\033[4moptions\033[0m] \033[1m--package\033[0m [\033[4mprj-spec\033[0m] \033[4mspec\033[0m [\033[4mname\033[0m]" << ::std::endl
       << "\033[1mbdep new\033[0m [\033[4moptions\033[0m] \033[1m--source\033[0m [\033[4mprj-spec\033[0m] \033[4mspec\033[0m [\033[4mname\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mspec\033[0m     = [\033[4mlang\033[0m] [\033[4mtype\033[0m] [\033[4mvcs\033[0m]" << ::std::endl
       << "\033[4mlang\033[0m     = \033[1m--lang\033[0m|\033[1m-l\033[0m (\033[1mc\033[0m|\033[1mc++\033[0m)[\033[1m,\033[0m\033[4mlang-opt\033[0m...]" << ::std::endl
       << "\033[4mtype\033[0m     = \033[1m--type\033[0m|\033[1m-t\033[0m (\033[1mexe\033[0m|\033[1mlib\033[0m|\033[1mbare\033[0m|\033[1mempty\033[0m)[\033[1m,\033[0m\033[4mtype-opt\033[0m...]" << ::std::endl
       << "\033[4mvcs\033[0m      = \033[1m--vcs\033[0m|\033[1m-s\033[0m  (\033[1mgit\033[0m|\033[1mnone\033[0m)[\033[1m,\033[0m\033[4mvcs-opt\033[0m...]" << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m" << ::std::endl
       << "\033[4mcfg-args\033[0m = [\033[1m--\033[0m [\033[4mbpkg-options\033[0m]] [\033[1m--existing\033[0m|\033[1m-e\033[0m | (\033[4mmodule\033[0m | \033[4mcfg-var\033[0m)...]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mnew\033[0m command creates and initializes a new project (the first three forms)," << ::std::endl
       << "a new package in an already existing project (the \033[1m--package\033[0m form), or a new" << ::std::endl
       << "source subdirectory in an already existing project/package (the \033[1m--source\033[0m form)." << ::std::endl
       << "All the forms except \033[1m--source\033[0m first create according to \033[4mspec\033[0m a new \033[1mbuild2\033[0m" << ::std::endl
       << "project/package called \033[4mname\033[0m in the \033[4mname\033[0m subdirectory of the current working" << ::std::endl
       << "directory (unless overridden with \033[1m--output-dir\033[0m|\033[1m-o\033[0m\033[0m or, in case of \033[1m--package\033[0m," << ::std::endl
       << "with \033[1m--directory\033[0m|\033[1m-d\033[0m\033[0m). If \033[4mname\033[0m contains a directory component, then the" << ::std::endl
       << "project/package is created in this directory, as if it was specified with" << ::std::endl
       << "\033[1m--output-dir\033[0m|\033[1m-o\033[0m\033[0m." << ::std::endl
       << ::std::endl
       << "The first form then, unless the \033[1m--no-init\033[0m option is specified, initializes an" << ::std::endl
       << "empty project database as if by executing the \033[1mbdep-init(1)\033[0m command with the" << ::std::endl
       << "\033[1m--empty\033[0m option. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t exe hello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- hello/" << ::std::endl
       << "|   |-- hello.cxx" << ::std::endl
       << "|   `-- buildfile" << ::std::endl
       << "|-- buildfile" << ::std::endl
       << "`-- manifest" << ::std::endl
       << ::std::endl
       << "Similarly, the second and third forms add an existing or create a new build" << ::std::endl
       << "configuration and then initialize the project in that configuration as if by" << ::std::endl
       << "executing the \033[1mbdep-init(1)\033[0m command with the \033[1m--config-add\033[0m or \033[1m--config-create\033[0m" << ::std::endl
       << "option, respectively. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t exe -C @gcc hello cc config.cxx=g++" << ::std::endl
       << ::std::endl
       << "The \033[1m--package\033[0m form adds the new package to the \033[1mpackages.manifest\033[0m file creating" << ::std::endl
       << "it if necessary. If no project directory is explicitly specified with" << ::std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m\033[0m, then it will be deduced from the current working directory (see" << ::std::endl
       << "\033[1mbdep-projects-configs(1)\033[0m for details on specifying projects). Note that nested" << ::std::endl
       << "packages are not allowed. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new -t empty hello" << ::std::endl
       << "$ cd hello" << ::std::endl
       << ::std::endl
       << "$ bdep new --package -l c++ -t lib libhello" << ::std::endl
       << "$ bdep new --package -l c++ -t exe hello" << ::std::endl
       << ::std::endl
       << "$ bdep init -C @gcc cc config.cxx=g++" << ::std::endl
       << ::std::endl
       << "$ cd .." << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- hello/" << ::std::endl
       << "|   |-- hello/" << ::std::endl
       << "|   |   |-- hello.cxx" << ::std::endl
       << "|   |   `-- buildfile" << ::std::endl
       << "|   |-- buildfile" << ::std::endl
       << "|   `-- manifest" << ::std::endl
       << "|-- libhello/" << ::std::endl
       << "|   |-- libhello/" << ::std::endl
       << "|   |   |-- hello.hxx" << ::std::endl
       << "|   |   |-- hello.cxx" << ::std::endl
       << "|   |   `-- buildfile" << ::std::endl
       << "|   |-- buildfile" << ::std::endl
       << "|   `-- manifest" << ::std::endl
       << "`-- packages.manifest" << ::std::endl
       << ::std::endl
       << "The \033[1m--source\033[0m form operates \033[4mas-if\033[0m by first creating according to \033[4mspec\033[0m a" << ::std::endl
       << "temporary project called \033[4mname\033[0m and then copying its source subdirectory" << ::std::endl
       << "(\033[4mname\033[0m\033[1m/\033[0m\033[4mname\033[0m\033[1m/\033[0m\033[0m by default) over to the current working directory (unless" << ::std::endl
       << "overridden with \033[1m--output-dir\033[0m|\033[1m-o\033[0m\033[0m). If no project/package directory is explicitly" << ::std::endl
       << "specified with \033[1m--directory\033[0m|\033[1m-d\033[0m\033[0m, then the current working directory is assumed." << ::std::endl
       << "For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t bare hello" << ::std::endl
       << "$ cd hello" << ::std::endl
       << ::std::endl
       << "$ bdep new --source -l c++ -t lib libhello" << ::std::endl
       << "$ bdep new --source -l c++ -t exe hello" << ::std::endl
       << ::std::endl
       << "$ bdep init -C @gcc cc config.cxx=g++" << ::std::endl
       << ::std::endl
       << "$ cd .." << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- hello/" << ::std::endl
       << "|   |-- hello.cxx" << ::std::endl
       << "|   `-- buildfile" << ::std::endl
       << "|-- libhello/" << ::std::endl
       << "|   |-- hello.hxx" << ::std::endl
       << "|   |-- hello.cxx" << ::std::endl
       << "|   `-- buildfile" << ::std::endl
       << "|-- buildfile" << ::std::endl
       << "`-- manifest" << ::std::endl
       << ::std::endl
       << "In all the forms, if \033[4mname\033[0m is omitted, then the current working directory name" << ::std::endl
       << "(unless overridden with \033[1m--output-dir\033[0m|\033[1m-o\033[0m\033[0m) is used as the project/package/source" << ::std::endl
       << "subdirectory name. See Package Name (bpkg#package-name) for details on" << ::std::endl
       << "project/package names." << ::std::endl
       << ::std::endl
       << "The source subdirectory can be customized with the \033[1msubdir\033[0m project type" << ::std::endl
       << "sub-option (see below for details). For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,subdir=libhello/io libhello-io" << ::std::endl
       << ::std::endl
       << "$ tree libhello-io/" << ::std::endl
       << "libhello-io/" << ::std::endl
       << "`-- libhello/" << ::std::endl
       << "    `-- io/" << ::std::endl
       << "        |-- hello-io.hxx" << ::std::endl
       << "        `-- hello-io.cxx" << ::std::endl
       << ::std::endl
       << "By default the source subdirectory is created in the project/package root" << ::std::endl
       << "directory and contains both headers (including public headers for libraries) as" << ::std::endl
       << "well as sources. This can be customized in a number of ways using the \033[1mprefix*\033[0m" << ::std::endl
       << "and \033[1msplit\033[0m project type sub-options (see below for details). For example, to" << ::std::endl
       << "move the source subdirectory inside \033[1msrc/\033[0m:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t exe,prefix=src hello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "And to split the library source subdirectory into public headers and other" << ::std::endl
       << "source files:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,split libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- libhello/" << ::std::endl
       << "|       `-- hello.hxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- libhello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "See the SOURCE LAYOUT section below for details and more examples." << ::std::endl
       << ::std::endl
       << "The output directory may already contain existing files provided they don't" << ::std::endl
       << "clash with the files to be created. The \033[1mnew\033[0m command also recognizes certain" << ::std::endl
       << "well-known files and tries to use the extracted information in the package" << ::std::endl
       << "\033[1mmanifest\033[0m file. Specifically, it tries to guess the license from the \033[1mLICENSE\033[0m" << ::std::endl
       << "file as well as extract the summary from \033[1mREADME.md\033[0m. This allows for the" << ::std::endl
       << "following workflow:" << ::std::endl
       << ::std::endl
       << "# Create a project with LICENSE and README.md on one of the Git" << ::std::endl
       << "# hosting services (GitHub, GitLab, etc)." << ::std::endl
       << ::std::endl
       << "$ git clone .../libhello.git" << ::std::endl
       << "$ cd libhello" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib" << ::std::endl
       << ::std::endl
       << "The project parameters such as language, type (executable, library, etc), and" << ::std::endl
       << "version control system can be customized as described next. Some of these" << ::std::endl
       << "parameters also support parameter-specific sub-options (such as the file" << ::std::endl
       << "extensions to use in a C++ project) that can be specified with a comma after" << ::std::endl
       << "the parameter value." << ::std::endl
       << ::std::endl
       << "The project language can be specified with the \033[1m--lang\033[0m|\033[1m-l\033[0m\033[0m option. Valid values" << ::std::endl
       << "for this option and their semantics are described next. If unspecified, a C++" << ::std::endl
       << "project is created by default." << ::std::endl
       << ::std::endl
       << "\033[1mc\033[0m" << ::std::endl
       << "    A C project. Recognized language sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mc++\033[0m" << ::std::endl
       << "    A C project that can also use C++. If specified, then the \033[1mhxx\033[0m, \033[1mcxx\033[0m, \033[1mixx\033[0m," << ::std::endl
       << "    \033[1mtxx\033[0m, and \033[1mmxx\033[0m \033[1mc++\033[0m language sub-options can also be specified." << ::std::endl
       << ::std::endl
       << "\033[1mc++\033[0m" << ::std::endl
       << "    A C++ project. Recognized language sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mcpp\033[0m" << ::std::endl
       << "    Use the \033[1m.cpp\033[0m, \033[1m.hpp\033[0m, \033[1m.ipp\033[0m, \033[1m.tpp\033[0m, and \033[1m.mpp\033[0m source file extensions (alias for" << ::std::endl
       << "    \033[1mextension=?pp\033[0m)." << ::std::endl
       << ::std::endl
       << "   \033[1mextension=\033[0m\033[4mpattern\033[0m\033[0m" << ::std::endl
       << "    Derive source file extensions from \033[4mpattern\033[0m by replacing every \033[1m?\033[0m with one of" << ::std::endl
       << "    the \033[1mc\033[0m (source), \033[1mh\033[0m (header), \033[1mi\033[0m (inline), \033[1mt\033[0m (template), or \033[1mm\033[0m (module" << ::std::endl
       << "    interface) letters. If unspecified and no individual extensions are" << ::std::endl
       << "    specified with the below options, then \033[1m?xx\033[0m is used by default." << ::std::endl
       << ::std::endl
       << "   \033[1mhxx=\033[0m\033[4mextension\033[0m\033[0m" << ::std::endl
       << "    Use the specified \033[4mextension\033[0m for header files instead of the default \033[1m.hxx\033[0m." << ::std::endl
       << ::std::endl
       << "   \033[1mcxx=\033[0m\033[4mextension\033[0m\033[0m" << ::std::endl
       << "    Use the specified \033[4mextension\033[0m for source files instead of the default \033[1m.cxx\033[0m." << ::std::endl
       << ::std::endl
       << "   \033[1mixx=\033[0m\033[4mextension\033[0m\033[0m" << ::std::endl
       << "    Use the specified \033[4mextension\033[0m for inline files. If unspecified, then assume" << ::std::endl
       << "    no inline files are used by the project." << ::std::endl
       << ::std::endl
       << "   \033[1mtxx=\033[0m\033[4mextension\033[0m\033[0m" << ::std::endl
       << "    Use the specified \033[4mextension\033[0m for template files. If unspecified, then assume" << ::std::endl
       << "    no template files are used by the project." << ::std::endl
       << ::std::endl
       << "   \033[1mmxx=\033[0m\033[4mextension\033[0m\033[0m" << ::std::endl
       << "    Use the specified \033[4mextension\033[0m for module interface files. If unspecified," << ::std::endl
       << "    then assume no modules are used by the project." << ::std::endl
       << ::std::endl
       << "   \033[1mc\033[0m" << ::std::endl
       << "    A C++ project that can also use C." << ::std::endl
       << ::std::endl
       << "As an example, the following command creates a header-only C++ library that" << ::std::endl
       << "uses the \033[1m.h\033[0m extension for header files and \033[1m.cpp\033[0m -- for source files:" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++,hxx=h,cxx=cpp -t lib,binless libhello" << ::std::endl
       << ::std::endl
       << "The project type can be specified with the \033[1m--type\033[0m|\033[1m-t\033[0m\033[0m option. The \033[1mempty\033[0m project" << ::std::endl
       << "type is language-agnostic with the semantics and valid sub-options for the rest" << ::std::endl
       << "being language-dependent, as described next. If unspecified, an executable" << ::std::endl
       << "project is created by default." << ::std::endl
       << ::std::endl
       << "\033[1mexe\033[0m" << ::std::endl
       << "    A project that builds a sample C or C++ executable. Recognized executable" << ::std::endl
       << "    project sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mno-tests\033[0m" << ::std::endl
       << "    Don't add support for functional/integration testing." << ::std::endl
       << ::std::endl
       << "   \033[1munit-tests\033[0m" << ::std::endl
       << "    Add support for unit testing." << ::std::endl
       << ::std::endl
       << "   \033[1mno-install\033[0m" << ::std::endl
       << "    Don't add support for installing." << ::std::endl
       << ::std::endl
       << "   \033[1mexport-stub\033[0m" << ::std::endl
       << "    Add support for importing this project's targets from other projects." << ::std::endl
       << ::std::endl
       << "   \033[1mprefix=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Optional source prefix relative to project/package root." << ::std::endl
       << ::std::endl
       << "   \033[1msubdir=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Alternative source subdirectory relative to source prefix." << ::std::endl
       << ::std::endl
       << "   \033[1mno-subdir\033[0m" << ::std::endl
       << "    Omit the source subdirectory." << ::std::endl
       << ::std::endl
       << "   \033[1mbuildfile-in-prefix\033[0m" << ::std::endl
       << "    Create the \033[1mbuildfile\033[0m in the source prefix directory rather than in its" << ::std::endl
       << "    source subdirectory." << ::std::endl
       << ::std::endl
       << "   \033[1mthird-party\033[0m" << ::std::endl
       << "    Create a package for converting an existing third-party executable to" << ::std::endl
       << "    \033[1mbuild2\033[0m. This sub-option automatically enables the \033[1mno-readme\033[0m sub-option. It" << ::std::endl
       << "    also adds a number of values to \033[1mmanifest\033[0m that makes sense to specify in a" << ::std::endl
       << "    package of a third-party project and, unless \033[1mno-package-readme\033[0m is" << ::std::endl
       << "    specified, generates the \033[1mPACKAGE-README.md\033[0m template (see" << ::std::endl
       << "    \033[1mpackage-description\033[0m (bpkg#manifest-package-description) package manifest" << ::std::endl
       << "    value for background)." << ::std::endl
       << ::std::endl
       << "   \033[1mlicense=\033[0m\033[4mname\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1mno-readme\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1mno-package-readme\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1malt-naming\033[0m" << ::std::endl
       << "    See \033[1mcommon\033[0m sub-options below." << ::std::endl
       << ::std::endl
       << "\033[1mlib\033[0m" << ::std::endl
       << "    A project that builds a sample C or C++ library. Recognized library project" << ::std::endl
       << "    sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mbinless\033[0m" << ::std::endl
       << "    Create a header-only library." << ::std::endl
       << ::std::endl
       << "   \033[1mno-tests\033[0m" << ::std::endl
       << "    Don't add support for functional/integration testing." << ::std::endl
       << ::std::endl
       << "   \033[1munit-tests\033[0m" << ::std::endl
       << "    Add support for unit testing." << ::std::endl
       << ::std::endl
       << "   \033[1mno-install\033[0m" << ::std::endl
       << "    Don't add support for installing." << ::std::endl
       << ::std::endl
       << "   \033[1mno-version\033[0m" << ::std::endl
       << "    Don't add support for generating the version header." << ::std::endl
       << ::std::endl
       << "   \033[1mno-symexport\033[0m" << ::std::endl
       << "    Don't add support for DLL symbol exporting." << ::std::endl
       << ::std::endl
       << "   \033[1mauto-symexport\033[0m" << ::std::endl
       << "    Add support for automatic DLL symbol exporting." << ::std::endl
       << ::std::endl
       << "   \033[1mprefix-include=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Optional public header prefix relative to project/package root." << ::std::endl
       << ::std::endl
       << "   \033[1mprefix-source=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Optional source prefix relative to project/package root." << ::std::endl
       << ::std::endl
       << "   \033[1mprefix=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Shortcut for \033[1mprefix-include=\033[0m\033[4mdir\033[0m\033[1m,prefix-source=\033[0m\033[4mdir\033[0m\033[0m." << ::std::endl
       << ::std::endl
       << "   \033[1msplit\033[0m" << ::std::endl
       << "    Shortcut for \033[1mprefix-include=include,prefix-source=src\033[0m." << ::std::endl
       << ::std::endl
       << "   \033[1msubdir=\033[0m\033[4mdir\033[0m\033[0m" << ::std::endl
       << "    Alternative source subdirectory relative to header/source prefix." << ::std::endl
       << ::std::endl
       << "   \033[1mno-subdir-include\033[0m" << ::std::endl
       << "    Omit the source subdirectory relative to the header prefix." << ::std::endl
       << ::std::endl
       << "   \033[1mno-subdir-source\033[0m" << ::std::endl
       << "    Omit the source subdirectory relative to the source prefix." << ::std::endl
       << ::std::endl
       << "   \033[1mno-subdir\033[0m" << ::std::endl
       << "    Shortcut for \033[1mno-subdir-include,no-subdir-source\033[0m." << ::std::endl
       << ::std::endl
       << "   \033[1mbuildfile-in-prefix\033[0m" << ::std::endl
       << "    Create the \033[1mbuildfiles\033[0m in the header/source prefix directories rather than" << ::std::endl
       << "    in their source subdirectories." << ::std::endl
       << ::std::endl
       << "   \033[1mthird-party\033[0m" << ::std::endl
       << "    Create a package for converting an existing third-party library to \033[1mbuild2\033[0m." << ::std::endl
       << "    This sub-option automatically enables the \033[1mno-version\033[0m and \033[1mno-readme\033[0m" << ::std::endl
       << "    sub-options as well as \033[1mno-symexport\033[0m unless \033[1mauto-symexport\033[0m is specified. It" << ::std::endl
       << "    also adds a number of values to \033[1mmanifest\033[0m that makes sense to specify in a" << ::std::endl
       << "    package of a third-party project and, unless \033[1mno-package-readme\033[0m is" << ::std::endl
       << "    specified, generates the \033[1mPACKAGE-README.md\033[0m template (see" << ::std::endl
       << "    \033[1mpackage-description\033[0m (bpkg#manifest-package-description) package manifest" << ::std::endl
       << "    value for background)." << ::std::endl
       << ::std::endl
       << "   \033[1mlicense=\033[0m\033[4mname\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1mno-readme\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1mno-package-readme\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1malt-naming\033[0m" << ::std::endl
       << "    See \033[1mcommon\033[0m sub-options below." << ::std::endl
       << ::std::endl
       << "\033[1mbare\033[0m" << ::std::endl
       << "    A project without any source code that can be filled later (see \033[1m--source\033[0m)." << ::std::endl
       << "    Recognized bare project sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mno-tests\033[0m" << ::std::endl
       << "    Don't add support for testing." << ::std::endl
       << ::std::endl
       << "   \033[1mno-install\033[0m" << ::std::endl
       << "    Don't add support for installing." << ::std::endl
       << ::std::endl
       << "   \033[1mlicense=\033[0m\033[4mname\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1mno-readme\033[0m" << ::std::endl
       << ::std::endl
       << "   \033[1malt-naming\033[0m" << ::std::endl
       << "    See \033[1mcommon\033[0m sub-options below." << ::std::endl
       << ::std::endl
       << "\033[1mempty\033[0m" << ::std::endl
       << "    An empty project that can be filled with packages (see \033[1m--package\033[0m)." << ::std::endl
       << "    Recognized empty project sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mthird-party\033[0m" << ::std::endl
       << "    Create a project for converting an existing third-party project to \033[1mbuild2\033[0m." << ::std::endl
       << "    This sub-option adjusts the generated \033[1mREADME.md\033[0m template wording to reflect" << ::std::endl
       << "    such a conversion." << ::std::endl
       << ::std::endl
       << "   \033[1mno-readme\033[0m" << ::std::endl
       << "    See \033[1mcommon\033[0m sub-options below." << ::std::endl
       << ::std::endl
       << "\033[1mcommon\033[0m" << ::std::endl
       << "    Common project type sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mlicense=\033[0m\033[4mname\033[0m\033[0m" << ::std::endl
       << "    Specify the project's license. The license name can be an SPDX License" << ::std::endl
       << "    Expression (https://spdx.org/licenses/), which, in its simplest form, is" << ::std::endl
       << "    just the license ID. Or it can be a free form name in the \033[1mother:\033[0m license" << ::std::endl
       << "    name scheme. If unspecified, then \033[1mother: proprietary\033[0m is assumed. The" << ::std::endl
       << "    following tables lists the most commonly used free/open source software" << ::std::endl
       << "    license IDs as well as a number of pre-defined \033[1mother:\033[0m names. See the" << ::std::endl
       << "    \033[1mlicense\033[0m (bpkg#manifest-package-license) package manifest value for more" << ::std::endl
       << "    information." << ::std::endl
       << ::std::endl
       << "    MIT                MIT License." << ::std::endl
       << ::std::endl
       << "    BSD-2-Clause       BSD 2-Clause \"Simplified\" License" << ::std::endl
       << "    BSD-3-Clause       BSD 3-Clause \"New\" or \"Revised\" License" << ::std::endl
       << ::std::endl
       << "    GPL-3.0-only       GNU General Public License v3.0 only" << ::std::endl
       << "    GPL-3.0-or-later   GNU General Public License v3.0 or later" << ::std::endl
       << ::std::endl
       << "    LGPL-3.0-only      GNU Lesser General Public License v3.0 only" << ::std::endl
       << "    LGPL-3.0-or-later  GNU Lesser General Public License v3.0 or later" << ::std::endl
       << ::std::endl
       << "    AGPL-3.0-only      GNU Affero General Public License v3.0 only" << ::std::endl
       << "    AGPL-3.0-or-later  GNU Affero General Public License v3.0 or later" << ::std::endl
       << ::std::endl
       << "    Apache-2.0         Apache License 2.0" << ::std::endl
       << ::std::endl
       << "    MPL-2.0            Mozilla Public License 2.0" << ::std::endl
       << ::std::endl
       << "    BSL-1.0            Boost Software License 1.0" << ::std::endl
       << ::std::endl
       << "    Unlicense          The Unlicense (public domain)" << ::std::endl
       << ::std::endl
       << "    other: public domain     Released into the public domain" << ::std::endl
       << "    other: available source  Not free/open source with public source code" << ::std::endl
       << "    other: proprietary       Not free/open source" << ::std::endl
       << "    other: TODO              License is not yet decided" << ::std::endl
       << ::std::endl
       << "   \033[1mno-readme\033[0m" << ::std::endl
       << "    Don't add new \033[1mREADME.md\033[0m (but still check for the existing one)." << ::std::endl
       << ::std::endl
       << "   \033[1mno-package-readme\033[0m" << ::std::endl
       << "    Don't add new \033[1mPACKAGE-README.md\033[0m (but still check for the existing one)." << ::std::endl
       << ::std::endl
       << "   \033[1malt-naming\033[0m" << ::std::endl
       << "    Use the alternative build file/directory naming scheme." << ::std::endl
       << ::std::endl
       << "The project version control system can be specified with the \033[1m--vcs\033[0m|\033[1m-s\033[0m\033[0m option." << ::std::endl
       << "Valid values for this option and their semantics are described next. If" << ::std::endl
       << "unspecified, \033[1mgit\033[0m is assumed by default." << ::std::endl
       << ::std::endl
       << "\033[1mgit\033[0m" << ::std::endl
       << "    Initialize a \033[1mgit(1)\033[0m repository inside the project and generate \033[1m.gitignore\033[0m" << ::std::endl
       << "    files. Recognized version control system sub-options:" << ::std::endl
       << ::std::endl
       << "   \033[1mbranch=\033[0m\033[4mname\033[0m\033[0m" << ::std::endl
       << "    Use the specified name for the initial branch in the newly created" << ::std::endl
       << "    repository." << ::std::endl
       << ::std::endl
       << "\033[1mnone\033[0m" << ::std::endl
       << "    Don't initialize a version control system inside the project." << ::std::endl
       << ::std::endl
       << "The created project, package, or source subdirectory can be further customized" << ::std::endl
       << "using the pre and post-creation hooks specified with the \033[1m--pre-hook\033[0m and" << ::std::endl
       << "\033[1m--post-hook\033[0m options, respectively. The pre hooks are executed before any new" << ::std::endl
       << "files are created and the post hook -- after all the files have been created." << ::std::endl
       << "The hook commands are executed in the project, package, or source directory as" << ::std::endl
       << "their current working directory. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new --post-hook \"echo .idea/ >>.gitignore\" hello" << ::std::endl
       << ::std::endl
       << "The pre hooks are primarily useful for moving/renaming existing files that" << ::std::endl
       << "would otherwise clash with files created by the \033[1mnew\033[0m command. For example:" << ::std::endl
       << ::std::endl
       << "$ bdep new --pre-hook  \"mv .gitignore .gitignore.bak\" \\" << ::std::endl
       << "           --post-hook \"cat .gitignore.bak >>.gitignore\" \\" << ::std::endl
       << "           --post-hook \"rm .gitignore.bak\" ..." << ::std::endl
       << ::std::endl
       << "See the \033[1m--pre-hook\033[0m and \033[1m--post-hook\033[0m options documentation below for details." << ::std::endl;

    p = ::bdep::cmd_new_c_options::print_usage (os, ::bdep::cli::usage_para::text);

    p = ::bdep::cmd_new_cxx_options::print_usage (os, p);

    p = ::bdep::cmd_new_exe_options::print_usage (os, p);

    p = ::bdep::cmd_new_lib_options::print_usage (os, p);

    p = ::bdep::cmd_new_bare_options::print_usage (os, p);

    p = ::bdep::cmd_new_empty_options::print_usage (os, p);

    p = ::bdep::cmd_new_git_options::print_usage (os, p);

    p = ::bdep::cmd_new_none_options::print_usage (os, p);

    p = ::bdep::cmd_new_options::print_usage (os, p);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSOURCE LAYOUT\033[0m" << ::std::endl
       << ::std::endl
       << "C and C++ projects employ a bewildering variety of source code layouts most of" << ::std::endl
       << "which fit into two broad classes: \033[4mcombined\033[0m, where all the source code for a" << ::std::endl
       << "single executable or library resides in the same directory and \033[4msplit\033[0m, where" << ::std::endl
       << "headers (typically public headers of a library) and other source files reside" << ::std::endl
       << "in separate directories (most commonly called \033[1minclude/\033[0m and \033[1msrc/\033[0m)." << ::std::endl
       << ::std::endl
       << "To support the creation of such varying layouts the \033[1mnew\033[0m command divides paths" << ::std::endl
       << "leading to source code inside a package/project into a number of customizable" << ::std::endl
       << "components:" << ::std::endl
       << ::std::endl
       << "libhello/{include,src}/hello/" << ::std::endl
       << "    ^         ^          ^" << ::std::endl
       << "    |         |          |" << ::std::endl
       << " project/   source    source" << ::std::endl
       << " package    prefix  subdirectory" << ::std::endl
       << "  root" << ::std::endl
       << ::std::endl
       << "Note that while the same physical layout can be achieved with various" << ::std::endl
       << "combinations of source prefix and subdirectory, there will be differences in" << ::std::endl
       << "semantics since the headers in the project are included with the source" << ::std::endl
       << "subdirectory (if any) as a prefix. See Canonical Project Structure" << ::std::endl
       << "(intro#proj-struct) for rationale and details." << ::std::endl
       << ::std::endl
       << "As we have already seen, the source subdirectory can be customized with the" << ::std::endl
       << "\033[1msubdir\033[0m project type sub-option. For example:" << ::std::endl
       << ::std::endl
       << "# libhello/hello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,subdir=hello libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "`-- hello/" << ::std::endl
       << "    |-- hello.hxx" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "Note: pass \033[1m-l c++,cpp\033[0m if you prefer the \033[1m.hpp\033[0m/\033[1m.cpp\033[0m source file naming scheme." << ::std::endl
       << ::std::endl
       << "The source prefix can be combined, in which case it can be customized with the" << ::std::endl
       << "single \033[1mprefix\033[0m project type sub-option. For example:" << ::std::endl
       << ::std::endl
       << "# hello/src/hello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t exe,prefix=src hello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "The prefix can also be split, in which case the \033[1mprefix-include\033[0m and" << ::std::endl
       << "\033[1mprefix-source\033[0m sub-options can be used to customize the respective directories" << ::std::endl
       << "independently. If either is omitted, then the corresponding prefix is left" << ::std::endl
       << "empty. For example:" << ::std::endl
       << ::std::endl
       << "# libhello/{include,.}/libhello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,prefix-include=include libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- libhello/" << ::std::endl
       << "|       `-- hello.hxx" << ::std::endl
       << "`-- libhello/" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "The \033[1msplit\033[0m sub-option is a convenient shortcut for the most common case where" << ::std::endl
       << "the header prefix is \033[1minclude/\033[0m and source prefix is \033[1msrc/\033[0m. For example:" << ::std::endl
       << ::std::endl
       << "# libhello/{include,src}/libhello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,split libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- libhello/" << ::std::endl
       << "|       `-- hello.hxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- libhello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "The source subdirectory can be omitted by specifying the \033[1mno-subdir\033[0m project type" << ::std::endl
       << "sub-option. For example:" << ::std::endl
       << ::std::endl
       << "# hello/src/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t exe,prefix=src,no-subdir hello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "The same but for the split layout (we also have to disable the generated" << ::std::endl
       << "version header that is not supported in this layout):" << ::std::endl
       << ::std::endl
       << "# libhello/{include,src}/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,split,no-subdir,no-version libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- hello.hxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "To achieve the layout where all the source code resides in the project root, we" << ::std::endl
       << "omit both the source prefix and subdirectory (we also have to disable a couple" << ::std::endl
       << "of other features that are not supported in this layout):" << ::std::endl
       << ::std::endl
       << "# hello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,no-subdir,no-version,no-tests libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- hello.cxx" << ::std::endl
       << "`-- hello.hxx" << ::std::endl
       << ::std::endl
       << "We can also omit the source subdirectory but only in the source prefix of the" << ::std::endl
       << "split layout by specifying the \033[1mno-subdir-source\033[0m sub-option. For example:" << ::std::endl
       << ::std::endl
       << "# libhello/{include/hello,src}/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t lib,split,subdir=hello,no-subdir-source libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- hello/" << ::std::endl
       << "|       `-- hello.hxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "Similarly, we can also omit the source subdirectory but only in the header" << ::std::endl
       << "prefix of the split layout by specifying the \033[1mno-subdir-include\033[0m sub-option (we" << ::std::endl
       << "also have to disable the generated version header that is not supported in this" << ::std::endl
       << "layout):" << ::std::endl
       << ::std::endl
       << "# libhello/{include,src/hello}/" << ::std::endl
       << ::std::endl
       << "$ bdep new                                                         \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,split,subdir=hello,no-subdir-include,no-version           \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- hello.hxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "To achieve the split layout where the \033[1minclude/\033[0m directory is inside \033[1msrc/\033[0m:" << ::std::endl
       << ::std::endl
       << "# libhello/src/{include,.}/hello/" << ::std::endl
       << ::std::endl
       << "$ bdep new                                                         \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,prefix-include=src/include,prefix-source=src,subdir=hello \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    |-- include/" << ::std::endl
       << "    |   `-- hello/" << ::std::endl
       << "    |       `-- hello.hxx" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "A similar layout but without the source subdirectory in \033[1msrc/\033[0m:" << ::std::endl
       << ::std::endl
       << "# libhello/src/{include/hello,.}/" << ::std::endl
       << ::std::endl
       << "$ bdep new                                                         \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,prefix-include=src/include,prefix-source=src,\\" << ::std::endl
       << "subdir=hello,no-subdir-source                                      \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    |-- include/" << ::std::endl
       << "    |   `-- hello/" << ::std::endl
       << "    |       `-- hello.hxx" << ::std::endl
       << "    `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "The layout used by the Boost libraries:" << ::std::endl
       << ::std::endl
       << "# libhello/{include/hello,libs/hello/src}/" << ::std::endl
       << ::std::endl
       << "$ bdep new                                                         \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,prefix-include=include,prefix-source=libs/hello/src,\\" << ::std::endl
       << "subdir=hello,no-subdir-source                                      \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ tree libhello/" << ::std::endl
       << "libhello/" << ::std::endl
       << "|-- include/" << ::std::endl
       << "|   `-- hello/" << ::std::endl
       << "|       `-- hello.hxx" << ::std::endl
       << "`-- libs/" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- src/" << ::std::endl
       << "            `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "A layout where multiple components each have their own \033[1minclude/src\033[0m split:" << ::std::endl
       << ::std::endl
       << "# hello/libhello1/{include/hello1,src}/" << ::std::endl
       << "# hello/libhello2/{include/hello2,src}/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t bare hello" << ::std::endl
       << ::std::endl
       << "$ bdep new -d hello --source                                       \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,\\" << ::std::endl
       << "prefix-include=libhello1/include,prefix-source=libhello1/src,\\" << ::std::endl
       << "subdir=hello1,no-subdir-source                                     \\" << ::std::endl
       << "  libhello1" << ::std::endl
       << ::std::endl
       << "$ bdep new -d hello --source                                       \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,\\" << ::std::endl
       << "prefix-include=libhello2/include,prefix-source=libhello2/src,\\" << ::std::endl
       << "subdir=hello2,no-subdir-source                                     \\" << ::std::endl
       << "  libhello2" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- libhello1/" << ::std::endl
       << "|   |-- include/" << ::std::endl
       << "|   |   `-- hello1/" << ::std::endl
       << "|   |       `-- hello1.hxx" << ::std::endl
       << "|   `-- src/" << ::std::endl
       << "|       `-- hello1.cxx" << ::std::endl
       << "`-- libhello2/" << ::std::endl
       << "    |-- include/" << ::std::endl
       << "    |   `-- hello2/" << ::std::endl
       << "    |       `-- hello2.hxx" << ::std::endl
       << "    `-- src/" << ::std::endl
       << "        `-- hello2.cxx" << ::std::endl
       << ::std::endl
       << "A layout where libraries and executables have different prefixes:" << ::std::endl
       << ::std::endl
       << "# hello/libs/libhello/{include/hello,src}/" << ::std::endl
       << "# hello/src/hello/" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c++ -t bare hello" << ::std::endl
       << ::std::endl
       << "$ bdep new -d hello --source                                       \\" << ::std::endl
       << "  -l c++                                                           \\" << ::std::endl
       << "  -t lib,\\" << ::std::endl
       << "prefix-include=libs/libhello/include,prefix-source=libs/libhello/src,\\" << ::std::endl
       << "subdir=hello,no-subdir-source                                      \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ bdep new -d hello --source -l c++ -t exe,prefix=src hello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- libs/" << ::std::endl
       << "|   `-- libhello/" << ::std::endl
       << "|       |-- include/" << ::std::endl
       << "|       |   `-- hello/" << ::std::endl
       << "|       |       `-- hello.hxx" << ::std::endl
       << "|       `-- src/" << ::std::endl
       << "|           `-- hello.cxx" << ::std::endl
       << "`-- src/" << ::std::endl
       << "    `-- hello/" << ::std::endl
       << "        `-- hello.cxx" << ::std::endl
       << ::std::endl
       << "When packaging a third-party project for \033[1mbuild2\033[0m, one of the common approaches" << ::std::endl
       << "is to create a project with the split layout and the \033[1mbuildfiles\033[0m in the source" << ::std::endl
       << "prefix directories rather than in the source subdirectories:" << ::std::endl
       << ::std::endl
       << "# hello/libhello/{include,src}/hello/" << ::std::endl
       << "# hello/libhello/{include,src}/buildfile" << ::std::endl
       << ::std::endl
       << "$ bdep new -l c -t empty hello" << ::std::endl
       << ::std::endl
       << "$ bdep new -d hello --package                                      \\" << ::std::endl
       << "  -l c                                                             \\" << ::std::endl
       << "  -t lib,                                                          \\" << ::std::endl
       << "split,subdir=hello,no-version,no-symexport,buildfile-in-prefix     \\" << ::std::endl
       << "  libhello" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "`-- libhello/" << ::std::endl
       << "    |-- include/" << ::std::endl
       << "    |   |-- buildfile" << ::std::endl
       << "    |   `-- hello/" << ::std::endl
       << "    |       `-- hello.h" << ::std::endl
       << "    `-- src/" << ::std::endl
       << "        |-- buildfile" << ::std::endl
       << "        `-- hello/" << ::std::endl
       << "            `-- hello.c" << ::std::endl
       << ::std::endl
       << "After that the upstream project is added as a \033[1mgit\033[0m submodule to the project root" << ::std::endl
       << "directory and the source subdirectories are replaced with the symbolic links to" << ::std::endl
       << "the directories inside the upstream project directory:" << ::std::endl
       << ::std::endl
       << "$ tree hello/" << ::std::endl
       << "hello/" << ::std::endl
       << "|-- libhello/" << ::std::endl
       << "|   |-- include/" << ::std::endl
       << "|   |   |-- buildfile" << ::std::endl
       << "|   |   `-- hello/ -> ../../upstream/include/hello/" << ::std::endl
       << "|   `-- src/" << ::std::endl
       << "|       |-- buildfile" << ::std::endl
       << "|       `-- hello/ -> ../../upstream/src/" << ::std::endl
       << "`-- upstream/" << ::std::endl
       << "    |-- include/" << ::std::endl
       << "    |   `-- hello/" << ::std::endl
       << "    |       `-- hello.h" << ::std::endl
       << "    `-- src/" << ::std::endl
       << "        `-- hello.c" << ::std::endl
       << ::std::endl
       << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mnew\033[0m command the search start directory is the project directory in the" << ::std::endl
       << "package and source modes and the parent directory of the new project in all" << ::std::endl
       << "other modes. The following options files are searched for in each directory" << ::std::endl
       << "and, if found, loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-{config config-add}.options                # if --config-add|-A" << ::std::endl
       << "bdep-{config config-add config-create}.options  # if --config-create|-C" << ::std::endl
       << "bdep-new.options" << ::std::endl
       << "bdep-new-{project|package|source}.options # (mode-dependent)" << ::std::endl
       << ::std::endl
       << "The following \033[1mnew\033[0m command options cannot be specified in the default options" << ::std::endl
       << "files:" << ::std::endl
       << ::std::endl
       << "--output-dir|-o" << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--package" << ::std::endl
       << "--source" << ::std::endl
       << "--no-checks" << ::std::endl
       << "--config-add|-A" << ::std::endl
       << "--config-create|-C" << ::std::endl
       << "--wipe" << ::std::endl
       << ::std::endl
       << "While the presence of the \033[1m--pre-hook\033[0m or \033[1m--post-hook\033[0m options in remote default" << ::std::endl
       << "options files will trigger a prompt." << ::std::endl
       << ::std::endl
       << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mBDEP_AUTHOR_EMAIL\033[0m environment variable can be used to specify the package" << ::std::endl
       << "email address. If not set, the \033[1mnew\033[0m command will first try to obtain the email" << ::std::endl
       << "from the version control system (if used) and then from the \033[1mEMAIL\033[0m environment" << ::std::endl
       << "variable. If all these methods fail, a dummy \033[1myou@example.org\033[0m email is used." << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

