/* MimeTypeManager.c generated by valac 0.56.17, the Vala compiler
 * generated from MimeTypeManager.vala, do not modify */

/*
 * Copyright (C) 2013-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_MIME_TYPE_MANAGER (contractor_mime_type_manager_get_type ())
#define CONTRACTOR_MIME_TYPE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManager))
#define CONTRACTOR_MIME_TYPE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManagerClass))
#define CONTRACTOR_IS_MIME_TYPE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER))
#define CONTRACTOR_IS_MIME_TYPE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_MIME_TYPE_MANAGER))
#define CONTRACTOR_MIME_TYPE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManagerClass))

typedef struct _ContractorMimeTypeManager ContractorMimeTypeManager;
typedef struct _ContractorMimeTypeManagerClass ContractorMimeTypeManagerClass;
typedef struct _ContractorMimeTypeManagerPrivate ContractorMimeTypeManagerPrivate;
enum  {
	CONTRACTOR_MIME_TYPE_MANAGER_0_PROPERTY,
	CONTRACTOR_MIME_TYPE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* contractor_mime_type_manager_properties[CONTRACTOR_MIME_TYPE_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContractorMimeTypeManager {
	GObject parent_instance;
	ContractorMimeTypeManagerPrivate * priv;
};

struct _ContractorMimeTypeManagerClass {
	GObjectClass parent_class;
};

struct _ContractorMimeTypeManagerPrivate {
	gchar** values;
	gint values_length1;
	gint _values_size_;
	gboolean is_conditional;
};

static gint ContractorMimeTypeManager_private_offset;
static gpointer contractor_mime_type_manager_parent_class = NULL;

VALA_EXTERN GType contractor_mime_type_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorMimeTypeManager, g_object_unref)
VALA_EXTERN ContractorMimeTypeManager* contractor_mime_type_manager_new (gchar** mimetypes,
                                                             gint mimetypes_length1,
                                                             GError** error);
VALA_EXTERN ContractorMimeTypeManager* contractor_mime_type_manager_construct (GType object_type,
                                                                   gchar** mimetypes,
                                                                   gint mimetypes_length1,
                                                                   GError** error);
VALA_EXTERN gchar** contractor_string_clean_array (gchar** str_array,
                                       gint str_array_length1,
                                       gint* result_length1);
VALA_EXTERN gboolean contractor_mime_type_manager_is_type_supported (ContractorMimeTypeManager* self,
                                                         const gchar* mime_type);
static gboolean contractor_mime_type_manager_contains_mimetype (ContractorMimeTypeManager* self,
                                                         const gchar* mime_type);
static gboolean contractor_mime_type_manager_compare (const gchar* mime_type,
                                               const gchar* ref_mime_type);
static void contractor_mime_type_manager_finalize (GObject * obj);
static GType contractor_mime_type_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contractor_mime_type_manager_get_instance_private (ContractorMimeTypeManager* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorMimeTypeManager_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

ContractorMimeTypeManager*
contractor_mime_type_manager_construct (GType object_type,
                                        gchar** mimetypes,
                                        gint mimetypes_length1,
                                        GError** error)
{
	ContractorMimeTypeManager * self = NULL;
	const gchar* _tmp0_;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	self = (ContractorMimeTypeManager*) g_object_new (object_type, NULL);
	_tmp0_ = mimetypes[0];
	if (string_contains (_tmp0_, "!")) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		self->priv->is_conditional = TRUE;
		_tmp1_ = mimetypes[0];
		_tmp2_ = string_replace (_tmp1_, "!", "");
		_g_free0 (mimetypes[0]);
		mimetypes[0] = _tmp2_;
	}
	_tmp4_ = contractor_string_clean_array (mimetypes, (gint) mimetypes_length1, &_tmp3_);
	self->priv->values = (_vala_array_free (self->priv->values, self->priv->values_length1, (GDestroyNotify) g_free), NULL);
	self->priv->values = _tmp4_;
	self->priv->values_length1 = _tmp3_;
	self->priv->_values_size_ = self->priv->values_length1;
	_tmp5_ = self->priv->values;
	_tmp5__length1 = self->priv->values_length1;
	if (_tmp5__length1 == 0) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "No values specified for MimeType.");
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

ContractorMimeTypeManager*
contractor_mime_type_manager_new (gchar** mimetypes,
                                  gint mimetypes_length1,
                                  GError** error)
{
	return contractor_mime_type_manager_construct (CONTRACTOR_TYPE_MIME_TYPE_MANAGER, mimetypes, mimetypes_length1, error);
}

gboolean
contractor_mime_type_manager_is_type_supported (ContractorMimeTypeManager* self,
                                                const gchar* mime_type)
{
	gboolean has_mimetype = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type != NULL, FALSE);
	has_mimetype = contractor_mime_type_manager_contains_mimetype (self, mime_type);
	if (self->priv->is_conditional) {
		_tmp0_ = !has_mimetype;
	} else {
		_tmp0_ = has_mimetype;
	}
	result = _tmp0_;
	return result;
}

static gboolean
contractor_mime_type_manager_contains_mimetype (ContractorMimeTypeManager* self,
                                                const gchar* mime_type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type != NULL, FALSE);
	_tmp0_ = self->priv->values;
	_tmp0__length1 = self->priv->values_length1;
	{
		gchar** local_mime_type_collection = NULL;
		gint local_mime_type_collection_length1 = 0;
		gint _local_mime_type_collection_size_ = 0;
		gint local_mime_type_it = 0;
		local_mime_type_collection = _tmp0_;
		local_mime_type_collection_length1 = _tmp0__length1;
		for (local_mime_type_it = 0; local_mime_type_it < local_mime_type_collection_length1; local_mime_type_it = local_mime_type_it + 1) {
			gchar* _tmp1_;
			gchar* local_mime_type = NULL;
			_tmp1_ = g_strdup (local_mime_type_collection[local_mime_type_it]);
			local_mime_type = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = local_mime_type;
				if (contractor_mime_type_manager_compare (mime_type, _tmp2_)) {
					result = TRUE;
					_g_free0 (local_mime_type);
					return result;
				}
				_g_free0 (local_mime_type);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
contractor_mime_type_manager_compare (const gchar* mime_type,
                                      const gchar* ref_mime_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (mime_type != NULL, FALSE);
	g_return_val_if_fail (ref_mime_type != NULL, FALSE);
	if (g_str_has_prefix (mime_type, ref_mime_type)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_content_type_equals (mime_type, ref_mime_type);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_content_type_is_a (mime_type, ref_mime_type);
	}
	result = _tmp0_;
	return result;
}

static void
contractor_mime_type_manager_class_init (ContractorMimeTypeManagerClass * klass,
                                         gpointer klass_data)
{
	contractor_mime_type_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorMimeTypeManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_mime_type_manager_finalize;
}

static void
contractor_mime_type_manager_instance_init (ContractorMimeTypeManager * self,
                                            gpointer klass)
{
	self->priv = contractor_mime_type_manager_get_instance_private (self);
	self->priv->is_conditional = FALSE;
}

static void
contractor_mime_type_manager_finalize (GObject * obj)
{
	ContractorMimeTypeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManager);
	self->priv->values = (_vala_array_free (self->priv->values, self->priv->values_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (contractor_mime_type_manager_parent_class)->finalize (obj);
}

static GType
contractor_mime_type_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorMimeTypeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_mime_type_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorMimeTypeManager), 0, (GInstanceInitFunc) contractor_mime_type_manager_instance_init, NULL };
	GType contractor_mime_type_manager_type_id;
	contractor_mime_type_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorMimeTypeManager", &g_define_type_info, 0);
	ContractorMimeTypeManager_private_offset = g_type_add_instance_private (contractor_mime_type_manager_type_id, sizeof (ContractorMimeTypeManagerPrivate));
	return contractor_mime_type_manager_type_id;
}

GType
contractor_mime_type_manager_get_type (void)
{
	static volatile gsize contractor_mime_type_manager_type_id__once = 0;
	if (g_once_init_enter (&contractor_mime_type_manager_type_id__once)) {
		GType contractor_mime_type_manager_type_id;
		contractor_mime_type_manager_type_id = contractor_mime_type_manager_get_type_once ();
		g_once_init_leave (&contractor_mime_type_manager_type_id__once, contractor_mime_type_manager_type_id);
	}
	return contractor_mime_type_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

