/* keymap.c generated by valac 0.56.17, the Vala compiler
 * generated from keymap.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gchar* keymap_get_keyevent_name (GdkEventKey* key_event);
VALA_EXTERN gchar** keymap_get_key_event_modifiers (GdkEventKey* key_event,
                                        gint* result_length1);
VALA_EXTERN gchar* keymap_get_key_name (guint keyval);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gboolean keymap_has_ctrl_mask (GdkEventKey* key_event);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN gboolean keymap_has_shift_mask (GdkEventKey* key_event);
VALA_EXTERN gboolean keymap_is_no_key_press (GdkEventKey* key_event);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
keymap_get_keyevent_name (GdkEventKey* key_event)
{
	gchar* result;
	g_return_val_if_fail (key_event != NULL, NULL);
	if (key_event->is_modifier != ((guint) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	} else {
		gchar** key_modifiers = NULL;
		gint _tmp1_ = 0;
		gchar** _tmp2_;
		gint key_modifiers_length1;
		gint _key_modifiers_size_;
		gchar* key_name = NULL;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp2_ = keymap_get_key_event_modifiers (key_event, &_tmp1_);
		key_modifiers = _tmp2_;
		key_modifiers_length1 = _tmp1_;
		_key_modifiers_size_ = key_modifiers_length1;
		_tmp3_ = keymap_get_key_name (key_event->keyval);
		key_name = _tmp3_;
		_tmp4_ = key_modifiers;
		_tmp4__length1 = key_modifiers_length1;
		if (_tmp4__length1 == 0) {
			result = key_name;
			key_modifiers = (_vala_array_free (key_modifiers, key_modifiers_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* name = NULL;
			gchar* _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp5_ = g_strdup ("");
			name = _tmp5_;
			_tmp6_ = key_modifiers;
			_tmp6__length1 = key_modifiers_length1;
			{
				gchar** modifier_collection = NULL;
				gint modifier_collection_length1 = 0;
				gint _modifier_collection_size_ = 0;
				gint modifier_it = 0;
				modifier_collection = _tmp6_;
				modifier_collection_length1 = _tmp6__length1;
				for (modifier_it = 0; modifier_it < modifier_collection_length1; modifier_it = modifier_it + 1) {
					gchar* _tmp7_;
					gchar* modifier = NULL;
					_tmp7_ = g_strdup (modifier_collection[modifier_it]);
					modifier = _tmp7_;
					{
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp8_ = name;
						_tmp9_ = modifier;
						_tmp10_ = g_strconcat (_tmp9_, " + ", NULL);
						_tmp11_ = _tmp10_;
						_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
						_g_free0 (name);
						name = _tmp12_;
						_g_free0 (_tmp11_);
						_g_free0 (modifier);
					}
				}
			}
			_tmp13_ = name;
			_tmp14_ = key_name;
			_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
			_g_free0 (name);
			name = _tmp15_;
			result = name;
			_g_free0 (key_name);
			key_modifiers = (_vala_array_free (key_modifiers, key_modifiers_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (key_name);
		key_modifiers = (_vala_array_free (key_modifiers, key_modifiers_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
keymap_get_key_event_modifiers (GdkEventKey* key_event,
                                gint* result_length1)
{
	gchar** modifiers = NULL;
	gchar** _tmp0_;
	gint modifiers_length1;
	gint _modifiers_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	g_return_val_if_fail (key_event != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	modifiers = _tmp0_;
	modifiers_length1 = 0;
	_modifiers_size_ = modifiers_length1;
	if ((key_event->state & GDK_CONTROL_MASK) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("Ctrl");
		_vala_array_add1 (&modifiers, &modifiers_length1, &_modifiers_size_, _tmp1_);
	}
	if ((key_event->state & GDK_SUPER_MASK) != 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("Super");
		_vala_array_add2 (&modifiers, &modifiers_length1, &_modifiers_size_, _tmp2_);
	}
	if ((key_event->state & GDK_HYPER_MASK) != 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("Hyper");
		_vala_array_add3 (&modifiers, &modifiers_length1, &_modifiers_size_, _tmp3_);
	}
	if ((key_event->state & GDK_MOD1_MASK) != 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("Alt");
		_vala_array_add4 (&modifiers, &modifiers_length1, &_modifiers_size_, _tmp4_);
	}
	if ((key_event->state & GDK_SHIFT_MASK) != 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("Shift");
		_vala_array_add5 (&modifiers, &modifiers_length1, &_modifiers_size_, _tmp5_);
	}
	_tmp6_ = modifiers;
	_tmp6__length1 = modifiers_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
keymap_get_key_name (guint keyval)
{
	gunichar key_unicode = 0U;
	gchar* result;
	key_unicode = (gunichar) gdk_keyval_to_unicode (gdk_keyval_to_lower (keyval));
	if (key_unicode == ((gunichar) 0)) {
		gchar* keyname = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp4_;
		_tmp0_ = gdk_keyval_name (keyval);
		_tmp1_ = g_strdup (_tmp0_);
		keyname = _tmp1_;
		_tmp2_ = keyname;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			_g_free0 (keyname);
			return result;
		}
		_tmp4_ = keyname;
		if (g_strcmp0 (_tmp4_, "ISO_Left_Tab") == 0) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Tab");
			result = _tmp5_;
			_g_free0 (keyname);
			return result;
		} else {
			result = keyname;
			return result;
		}
		_g_free0 (keyname);
	} else {
		if (key_unicode == ((gunichar) 13)) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("Enter");
			result = _tmp6_;
			return result;
		} else {
			if (key_unicode == ((gunichar) 9)) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("Tab");
				result = _tmp7_;
				return result;
			} else {
				if (key_unicode == ((gunichar) 27)) {
					gchar* _tmp8_;
					_tmp8_ = g_strdup ("Esc");
					result = _tmp8_;
					return result;
				} else {
					if (key_unicode == ((gunichar) 8)) {
						gchar* _tmp9_;
						_tmp9_ = g_strdup ("Backspace");
						result = _tmp9_;
						return result;
					} else {
						if (key_unicode == ((gunichar) 127)) {
							gchar* _tmp10_;
							_tmp10_ = g_strdup ("Delete");
							result = _tmp10_;
							return result;
						} else {
							if (key_unicode == ((gunichar) 32)) {
								gchar* _tmp11_;
								_tmp11_ = g_strdup ("Space");
								result = _tmp11_;
								return result;
							} else {
								gchar* _tmp12_;
								_tmp12_ = g_unichar_to_string (key_unicode);
								result = _tmp12_;
								return result;
							}
						}
					}
				}
			}
		}
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
keymap_has_ctrl_mask (GdkEventKey* key_event)
{
	gchar** mask_list = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mask_list_length1;
	gint _mask_list_size_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (key_event != NULL, FALSE);
	_tmp0_ = g_strdup ("Control_L");
	_tmp1_ = g_strdup ("Control_R");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mask_list = _tmp2_;
	mask_list_length1 = 2;
	_mask_list_size_ = mask_list_length1;
	_tmp3_ = keymap_get_key_name (key_event->keyval);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_string_array_contains (mask_list, mask_list_length1, _tmp4_);
	_g_free0 (_tmp4_);
	result = _tmp5_;
	mask_list = (_vala_array_free (mask_list, mask_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
keymap_has_shift_mask (GdkEventKey* key_event)
{
	gchar** mask_list = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mask_list_length1;
	gint _mask_list_size_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (key_event != NULL, FALSE);
	_tmp0_ = g_strdup ("Shift_L");
	_tmp1_ = g_strdup ("Shift_R");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mask_list = _tmp2_;
	mask_list_length1 = 2;
	_mask_list_size_ = mask_list_length1;
	_tmp3_ = keymap_get_key_name (key_event->keyval);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_string_array_contains (mask_list, mask_list_length1, _tmp4_);
	_g_free0 (_tmp4_);
	result = _tmp5_;
	mask_list = (_vala_array_free (mask_list, mask_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
keymap_is_no_key_press (GdkEventKey* key_event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (key_event != NULL, FALSE);
	if (key_event->is_modifier == ((guint) 0)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = keymap_get_key_name (key_event->keyval);
		_tmp3_ = _tmp2_;
		_tmp4_ = keymap_get_keyevent_name (key_event);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (key_event->is_modifier != ((guint) 0)) {
			gint _tmp7_ = 0;
			gchar** _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp8_ = keymap_get_key_event_modifiers (key_event, &_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp9__length1 = _tmp7_;
			_tmp6_ = _tmp7_ == 1;
			_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

