/* highlight_frame.c generated by valac 0.56.17, the Vala compiler
 * generated from highlight_frame.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_HIGHLIGHT_FRAME (widgets_highlight_frame_get_type ())
#define WIDGETS_HIGHLIGHT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_HIGHLIGHT_FRAME, WidgetsHighlightFrame))
#define WIDGETS_HIGHLIGHT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_HIGHLIGHT_FRAME, WidgetsHighlightFrameClass))
#define WIDGETS_IS_HIGHLIGHT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_HIGHLIGHT_FRAME))
#define WIDGETS_IS_HIGHLIGHT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_HIGHLIGHT_FRAME))
#define WIDGETS_HIGHLIGHT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_HIGHLIGHT_FRAME, WidgetsHighlightFrameClass))

typedef struct _WidgetsHighlightFrame WidgetsHighlightFrame;
typedef struct _WidgetsHighlightFrameClass WidgetsHighlightFrameClass;
typedef struct _WidgetsHighlightFramePrivate WidgetsHighlightFramePrivate;
enum  {
	WIDGETS_HIGHLIGHT_FRAME_0_PROPERTY,
	WIDGETS_HIGHLIGHT_FRAME_NUM_PROPERTIES
};
static GParamSpec* widgets_highlight_frame_properties[WIDGETS_HIGHLIGHT_FRAME_NUM_PROPERTIES];

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _WidgetsHighlightFrame {
	GtkEventBox parent_instance;
	WidgetsHighlightFramePrivate * priv;
	GdkRGBA foreground_color;
};

struct _WidgetsHighlightFrameClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

static gpointer widgets_highlight_frame_parent_class = NULL;

VALA_EXTERN GType widgets_highlight_frame_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsHighlightFrame, g_object_unref)
VALA_EXTERN WidgetsHighlightFrame* widgets_highlight_frame_new (void);
VALA_EXTERN WidgetsHighlightFrame* widgets_highlight_frame_construct (GType object_type);
static gboolean widgets_highlight_frame_on_draw (WidgetsHighlightFrame* self,
                                          GtkWidget* widget,
                                          cairo_t* cr);
static gboolean _widgets_highlight_frame_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                           cairo_t* cr,
                                                           gpointer self);
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
static void widgets_highlight_frame_finalize (GObject * obj);
static GType widgets_highlight_frame_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_highlight_frame_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                  cairo_t* cr,
                                                  gpointer self)
{
	gboolean result;
	result = widgets_highlight_frame_on_draw ((WidgetsHighlightFrame*) self, _sender, cr);
	return result;
}

WidgetsHighlightFrame*
widgets_highlight_frame_construct (GType object_type)
{
	WidgetsHighlightFrame * self = NULL;
	self = (WidgetsHighlightFrame*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_highlight_frame_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsHighlightFrame*
widgets_highlight_frame_new (void)
{
	return widgets_highlight_frame_construct (WIDGETS_TYPE_HIGHLIGHT_FRAME);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
widgets_highlight_frame_on_draw (WidgetsHighlightFrame* self,
                                 GtkWidget* widget,
                                 cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GtkAllocation _tmp15_;
	GtkAllocation _tmp16_;
	GtkAllocation _tmp17_;
	GtkAllocation _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	{
		WidgetsConfigWindow* parent_window = NULL;
		GtkWidget* _tmp1_;
		WidgetsConfigWindow* _tmp2_;
		gchar* _tmp3_ = NULL;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		GdkRGBA _tmp8_ = {0};
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
		parent_window = _tmp2_;
		_tmp4_ = parent_window->config;
		_tmp5_ = _tmp4_->config_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "theme", "foreground", &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			_g_object_unref0 (parent_window);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
		utils_hex_to_rgba (_tmp3_, 1.0, &_tmp8_);
		self->foreground_color = _tmp8_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (parent_window);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_print ("HighlightFrame: %s\n", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = self->foreground_color;
	_tmp13_ = self->foreground_color;
	_tmp14_ = self->foreground_color;
	cairo_set_source_rgba (cr, _tmp12_.red, _tmp13_.green, _tmp14_.blue, 0.4);
	_tmp15_ = rect;
	_tmp16_ = rect;
	_tmp17_ = rect;
	_tmp18_ = rect;
	draw_draw_rectangle (cr, _tmp15_.x, _tmp16_.y, _tmp17_.width, _tmp18_.height, FALSE);
	result = TRUE;
	return result;
}

static void
widgets_highlight_frame_class_init (WidgetsHighlightFrameClass * klass,
                                    gpointer klass_data)
{
	widgets_highlight_frame_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_highlight_frame_finalize;
}

static void
widgets_highlight_frame_instance_init (WidgetsHighlightFrame * self,
                                       gpointer klass)
{
	memset (&self->foreground_color, 0, sizeof (GdkRGBA));
}

static void
widgets_highlight_frame_finalize (GObject * obj)
{
	WidgetsHighlightFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_HIGHLIGHT_FRAME, WidgetsHighlightFrame);
	G_OBJECT_CLASS (widgets_highlight_frame_parent_class)->finalize (obj);
}

static GType
widgets_highlight_frame_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsHighlightFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_highlight_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsHighlightFrame), 0, (GInstanceInitFunc) widgets_highlight_frame_instance_init, NULL };
	GType widgets_highlight_frame_type_id;
	widgets_highlight_frame_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsHighlightFrame", &g_define_type_info, 0);
	return widgets_highlight_frame_type_id;
}

GType
widgets_highlight_frame_get_type (void)
{
	static volatile gsize widgets_highlight_frame_type_id__once = 0;
	if (g_once_init_enter (&widgets_highlight_frame_type_id__once)) {
		GType widgets_highlight_frame_type_id;
		widgets_highlight_frame_type_id = widgets_highlight_frame_get_type_once ();
		g_once_init_leave (&widgets_highlight_frame_type_id__once, widgets_highlight_frame_type_id);
	}
	return widgets_highlight_frame_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

