#ifndef ELDBUS_FPRINT_DEVICE_H
#define ELDBUS_FPRINT_DEVICE_H

#include <Eina.h>
#include <Ecore.h>
#include <Eldbus.h>
#include "eldbus_utils.h"

Eldbus_Proxy *fprint_device_proxy_get(Eldbus_Connection *conn, const char *bus, const char *path);
void fprint_device_proxy_unref(Eldbus_Proxy *proxy);
void fprint_device_log_domain_set(int id);
typedef void (*Fprint_Device_List_Enrolled_Fingers_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error, Eina_Value *args);
Eldbus_Pending *fprint_device_list_enrolled_fingers_call(Eldbus_Proxy *proxy, Fprint_Device_List_Enrolled_Fingers_Cb cb, const void *data, const char *username);
typedef void (*Fprint_Device_Delete_Enrolled_Fingers_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_delete_enrolled_fingers_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Fingers_Cb cb, const void *data, const char *username);
typedef void (*Fprint_Device_Delete_Enrolled_Fingers2_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_delete_enrolled_fingers2_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Fingers2_Cb cb, const void *data);
typedef void (*Fprint_Device_Delete_Enrolled_Finger_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_delete_enrolled_finger_call(Eldbus_Proxy *proxy, Fprint_Device_Delete_Enrolled_Finger_Cb cb, const void *data, const char *finger_name);
typedef void (*Fprint_Device_Claim_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_claim_call(Eldbus_Proxy *proxy, Fprint_Device_Claim_Cb cb, const void *data, const char *username);
typedef void (*Fprint_Device_Release_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_release_call(Eldbus_Proxy *proxy, Fprint_Device_Release_Cb cb, const void *data);
typedef void (*Fprint_Device_Verify_Start_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_verify_start_call(Eldbus_Proxy *proxy, Fprint_Device_Verify_Start_Cb cb, const void *data, const char *finger_name);
typedef void (*Fprint_Device_Verify_Stop_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_verify_stop_call(Eldbus_Proxy *proxy, Fprint_Device_Verify_Stop_Cb cb, const void *data);
typedef void (*Fprint_Device_Enroll_Start_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_enroll_start_call(Eldbus_Proxy *proxy, Fprint_Device_Enroll_Start_Cb cb, const void *data, const char *finger_name);
typedef void (*Fprint_Device_Enroll_Stop_Cb)(Eldbus_Proxy *proxy, void *data, Eldbus_Pending *pending, Eldbus_Error_Info *error);
Eldbus_Pending *fprint_device_enroll_stop_call(Eldbus_Proxy *proxy, Fprint_Device_Enroll_Stop_Cb cb, const void *data);
extern int FPRINT_DEVICE_VERIFY_FINGER_SELECTED_EVENT;
typedef struct _Fprint_Device_VerifyFingerSelected_Data
{
   Eldbus_Proxy *proxy;
   char *finger_name;
} Fprint_Device_VerifyFingerSelected_Data;
extern int FPRINT_DEVICE_VERIFY_STATUS_EVENT;
typedef struct _Fprint_Device_VerifyStatus_Data
{
   Eldbus_Proxy *proxy;
   char *result;
   Eina_Bool done;
} Fprint_Device_VerifyStatus_Data;
extern int FPRINT_DEVICE_ENROLL_STATUS_EVENT;
typedef struct _Fprint_Device_EnrollStatus_Data
{
   Eldbus_Proxy *proxy;
   char *result;
   Eina_Bool done;
} Fprint_Device_EnrollStatus_Data;
Eldbus_Pending *fprint_device_name_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_String_Get_Cb cb, const void *data);
Eldbus_Pending *fprint_device_num_enroll_stages_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Int32_Get_Cb cb, const void *data);
Eldbus_Pending *fprint_device_scan_type_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_String_Get_Cb cb, const void *data);
Eldbus_Pending *fprint_device_finger_present_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Bool_Get_Cb cb, const void *data);
Eldbus_Pending *fprint_device_finger_needed_propget(Eldbus_Proxy *proxy, Eldbus_Codegen_Property_Bool_Get_Cb cb, const void *data);

#endif