// Generated from libavcodec/vulkan/common.comp
const char *ff_source_common_comp =
"/*\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 1) buffer u8buf {\n"
"    uint8_t v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 1) buffer u8vec2buf {\n"
"    u8vec2 v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 1) buffer u8vec4buf {\n"
"    u8vec4 v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 2) buffer u16buf {\n"
"    uint16_t v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 4) buffer u32buf {\n"
"    uint32_t v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 4) buffer u32vec2buf {\n"
"    u32vec2 v;\n"
"};\n"
"\n"
"layout(buffer_reference, buffer_reference_align = 8) buffer u64buf {\n"
"    uint64_t v;\n"
"};\n"
"\n"
"#define OFFBUF(type, b, l) \\\n"
"    type(uint64_t(b) + uint64_t(l))\n"
"\n"
"#define zero_extend(a, p) \\\n"
"    ((a) & ((1 << (p)) - 1))\n"
"\n"
"#define sign_extend(val, bits) \\\n"
"    bitfieldExtract(val, 0, bits)\n"
"\n"
"#define fold(diff, bits) \\\n"
"    sign_extend(diff, bits)\n"
"\n"
"#define mid_pred(a, b, c) \\\n"
"    max(min((a), (b)), min(max((a), (b)), (c)))\n"
"\n"
"/* TODO: optimize */\n"
"uint align(uint src, uint a)\n"
"{\n"
"    uint res = src % a;\n"
"    if (res == 0)\n"
"        return src;\n"
"    return src + a - res;\n"
"}\n"
"\n"
"/* TODO: optimize */\n"
"uint64_t align64(uint64_t src, uint64_t a)\n"
"{\n"
"    uint64_t res = src % a;\n"
"    if (res == 0)\n"
"        return src;\n"
"    return src + a - res;\n"
"}\n"
"\n"
"#define reverse4(src) \\\n"
"    (pack32(unpack8(uint32_t(src)).wzyx))\n"
"\n"
"u32vec2 reverse8(uint64_t src)\n"
"{\n"
"    u32vec2 tmp = unpack32(src);\n"
"    tmp.x = reverse4(tmp.x);\n"
"    tmp.y = reverse4(tmp.y);\n"
"    return tmp.yx;\n"
"}\n"
"\n"
"#ifdef PB_32\n"
"#define BIT_BUF_TYPE uint32_t\n"
"#define BUF_TYPE u32buf\n"
"#define BUF_REVERSE(src) reverse4(src)\n"
"#define BUF_BITS uint8_t(32)\n"
"#define BUF_BYTES uint8_t(4)\n"
"#define BYTE_EXTRACT(src, byte_off) \\\n"
"    (uint8_t(bitfieldExtract((src), ((byte_off) << 3), 8)))\n"
"#else\n"
"#define BIT_BUF_TYPE uint64_t\n"
"#define BUF_TYPE u32vec2buf\n"
"#define BUF_REVERSE(src) reverse8(src)\n"
"#define BUF_BITS uint8_t(64)\n"
"#define BUF_BYTES uint8_t(8)\n"
"#define BYTE_EXTRACT(src, byte_off) \\\n"
"    (uint8_t(((src) >> ((byte_off) << 3)) & 0xFF))\n"
"#endif\n"
"\n"
"struct PutBitContext {\n"
"    uint64_t buf_start;\n"
"    uint64_t buf;\n"
"\n"
"    BIT_BUF_TYPE bit_buf;\n"
"    uint8_t bit_left;\n"
"};\n"
"\n"
"void put_bits(inout PutBitContext pb, const uint32_t n, uint32_t value)\n"
"{\n"
"    if (n < pb.bit_left) {\n"
"        pb.bit_buf = (pb.bit_buf << n) | value;\n"
"        pb.bit_left -= uint8_t(n);\n"
"    } else {\n"
"        pb.bit_buf <<= pb.bit_left;\n"
"        pb.bit_buf |= (value >> (n - pb.bit_left));\n"
"\n"
"#ifdef PB_UNALIGNED\n"
"        u8buf bs = u8buf(pb.buf);\n"
"        [[unroll]]\n"
"        for (uint8_t i = uint8_t(0); i < BUF_BYTES; i++)\n"
"            bs[i].v = BYTE_EXTRACT(pb.bit_buf, BUF_BYTES - uint8_t(1) - i);\n"
"#else\n"
"#ifdef DEBUG\n"
"        if ((pb.buf % BUF_BYTES) != 0)\n"
"            debugPrintfEXT(\"put_bits buffer is not aligned!\");\n"
"#endif\n"
"\n"
"        BUF_TYPE bs = BUF_TYPE(pb.buf);\n"
"        bs.v = BUF_REVERSE(pb.bit_buf);\n"
"#endif\n"
"        pb.buf = uint64_t(bs) + BUF_BYTES;\n"
"\n"
"        pb.bit_left += BUF_BITS - uint8_t(n);\n"
"        pb.bit_buf = value;\n"
"    }\n"
"}\n"
"\n"
"uint32_t flush_put_bits(inout PutBitContext pb)\n"
"{\n"
"    /* Align bits to MSBs */\n"
"    if (pb.bit_left < BUF_BITS)\n"
"        pb.bit_buf <<= pb.bit_left;\n"
"\n"
"    if (pb.bit_left < BUF_BITS) {\n"
"        uint to_write = ((BUF_BITS - pb.bit_left - 1) >> 3) + 1;\n"
"\n"
"        u8buf bs = u8buf(pb.buf);\n"
"        for (int i = 0; i < to_write; i++)\n"
"            bs[i].v = BYTE_EXTRACT(pb.bit_buf, BUF_BYTES - uint8_t(1) - i);\n"
"        pb.buf = uint64_t(bs) + to_write;\n"
"    }\n"
"\n"
"    pb.bit_left = BUF_BITS;\n"
"    pb.bit_buf = 0x0;\n"
"\n"
"    return uint32_t(pb.buf - pb.buf_start);\n"
"}\n"
"\n"
"void init_put_bits(out PutBitContext pb, u8buf data, uint64_t len)\n"
"{\n"
"    pb.buf_start = uint64_t(data);\n"
"    pb.buf = uint64_t(data);\n"
"\n"
"    pb.bit_buf = 0;\n"
"    pb.bit_left = BUF_BITS;\n"
"}\n"
"\n"
"uint64_t put_bits_count(in PutBitContext pb)\n"
"{\n"
"    return (pb.buf - pb.buf_start)*8 + BUF_BITS - pb.bit_left;\n"
"}\n"
"\n"
"uint32_t put_bytes_count(in PutBitContext pb)\n"
"{\n"
"    uint64_t num_bytes = (pb.buf - pb.buf_start) + ((BUF_BITS - pb.bit_left) >> 3);\n"
"    return uint32_t(num_bytes);\n"
"}\n"
"\n"
"struct GetBitContext {\n"
"    uint64_t buf_start;\n"
"    uint64_t buf;\n"
"    uint64_t buf_end;\n"
"\n"
"    uint64_t bits;\n"
"    int bits_valid;\n"
"    int size_in_bits;\n"
"};\n"
"\n"
"#define LOAD64()                                       \\\n"
"    {                                                  \\\n"
"        u8vec4buf ptr = u8vec4buf(gb.buf);             \\\n"
"        uint32_t rf1 = pack32((ptr[0].v).wzyx);        \\\n"
"        uint32_t rf2 = pack32((ptr[1].v).wzyx);        \\\n"
"        gb.buf += 8;                                   \\\n"
"        gb.bits = uint64_t(rf1) << 32 | uint64_t(rf2); \\\n"
"        gb.bits_valid = 64;                            \\\n"
"    }\n"
"\n"
"#define RELOAD32()                                                \\\n"
"    {                                                             \\\n"
"        u8vec4buf ptr = u8vec4buf(gb.buf);                        \\\n"
"        uint32_t rf = pack32((ptr[0].v).wzyx);                    \\\n"
"        gb.buf += 4;                                              \\\n"
"        gb.bits = uint64_t(rf) << (32 - gb.bits_valid) | gb.bits; \\\n"
"        gb.bits_valid += 32;                                      \\\n"
"    }\n"
"\n"
"void init_get_bits(inout GetBitContext gb, u8buf data, int len)\n"
"{\n"
"    gb.buf = gb.buf_start = uint64_t(data);\n"
"    gb.buf_end = uint64_t(data) + len;\n"
"    gb.size_in_bits = len * 8;\n"
"\n"
"    /* Preload */\n"
"    LOAD64()\n"
"}\n"
"\n"
"bool get_bit(inout GetBitContext gb)\n"
"{\n"
"    if (gb.bits_valid == 0)\n"
"        LOAD64()\n"
"\n"
"    bool val = bool(gb.bits >> (64 - 1));\n"
"    gb.bits <<= 1;\n"
"    gb.bits_valid--;\n"
"    return val;\n"
"}\n"
"\n"
"uint get_bits(inout GetBitContext gb, int n)\n"
"{\n"
"    if (n == 0)\n"
"        return 0;\n"
"\n"
"    if (n > gb.bits_valid)\n"
"        RELOAD32()\n"
"\n"
"    uint val = uint(gb.bits >> (64 - n));\n"
"    gb.bits <<= n;\n"
"    gb.bits_valid -= n;\n"
"    return val;\n"
"}\n"
"\n"
"uint show_bits(inout GetBitContext gb, int n)\n"
"{\n"
"    if (n > gb.bits_valid)\n"
"        RELOAD32()\n"
"\n"
"    return uint(gb.bits >> (64 - n));\n"
"}\n"
"\n"
"void skip_bits(inout GetBitContext gb, int n)\n"
"{\n"
"    if (n > gb.bits_valid)\n"
"        RELOAD32()\n"
"\n"
"    gb.bits <<= n;\n"
"    gb.bits_valid -= n;\n"
"}\n"
"\n"
"int tell_bits(in GetBitContext gb)\n"
"{\n"
"    return int(gb.buf - gb.buf_start) * 8 - gb.bits_valid;\n"
"}\n"
"\n"
"int left_bits(in GetBitContext gb)\n"
"{\n"
"    return gb.size_in_bits - int(gb.buf - gb.buf_start) * 8 + gb.bits_valid;\n"
"}\n"
;
