/* conversation-list-row.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from conversation-list-row.vala, do not modify */

/*
 * Copyright © 2022 John Renner <john@jrenner.net>
 * Copyright © 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "geary-engine.h"
#include "geary-client-46.0.h"
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CONVERSATION_LIST_TYPE_ROW (conversation_list_row_get_type ())
#define CONVERSATION_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_LIST_TYPE_ROW, ConversationListRow))
#define CONVERSATION_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_LIST_TYPE_ROW, ConversationListRowClass))
#define CONVERSATION_LIST_IS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_LIST_TYPE_ROW))
#define CONVERSATION_LIST_IS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_LIST_TYPE_ROW))
#define CONVERSATION_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_LIST_TYPE_ROW, ConversationListRowClass))

typedef struct _ConversationListRow ConversationListRow;
typedef struct _ConversationListRowClass ConversationListRowClass;
typedef struct _ConversationListRowPrivate ConversationListRowPrivate;
enum  {
	CONVERSATION_LIST_ROW_0_PROPERTY,
	CONVERSATION_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* conversation_list_row_properties[CONVERSATION_LIST_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONVERSATION_LIST_TYPE_PARTICIPANT (conversation_list_participant_get_type ())
#define CONVERSATION_LIST_PARTICIPANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipant))
#define CONVERSATION_LIST_PARTICIPANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipantClass))
#define CONVERSATION_LIST_IS_PARTICIPANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT))
#define CONVERSATION_LIST_IS_PARTICIPANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONVERSATION_LIST_TYPE_PARTICIPANT))
#define CONVERSATION_LIST_PARTICIPANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONVERSATION_LIST_TYPE_PARTICIPANT, ConversationListParticipantClass))

typedef struct _ConversationListParticipant ConversationListParticipant;
typedef struct _ConversationListParticipantClass ConversationListParticipantClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	CONVERSATION_LIST_ROW_TOGGLE_FLAG_SIGNAL,
	CONVERSATION_LIST_ROW_TOGGLE_SELECTION_SIGNAL,
	CONVERSATION_LIST_ROW_NUM_SIGNALS
};
static guint conversation_list_row_signals[CONVERSATION_LIST_ROW_NUM_SIGNALS] = {0};

struct _ConversationListRow {
	GtkListBoxRow parent_instance;
	GearyAppConversation* conversation;
	ConversationListRowPrivate * priv;
};

struct _ConversationListRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ConversationListRowPrivate {
	GtkLabel* preview;
	GtkLabel* subject;
	GtkLabel* participants;
	GtkLabel* date;
	GtkLabel* count_badge;
	GtkImage* flagged_icon;
	GtkCheckButton* selected_button;
	ApplicationConfiguration* config;
	GDateTime* recv_time;
};

static gint ConversationListRow_private_offset;
static gpointer conversation_list_row_parent_class = NULL;

VALA_EXTERN GType conversation_list_row_get_type (void) G_GNUC_CONST ;
static GeeList* conversation_list_row_get_user_accounts (ConversationListRow* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
VALA_EXTERN ConversationListRow* conversation_list_row_new (ApplicationConfiguration* config,
                                                GearyAppConversation* conversation,
                                                gboolean selection_mode_enabled);
VALA_EXTERN ConversationListRow* conversation_list_row_construct (GType object_type,
                                                      ApplicationConfiguration* config,
                                                      GearyAppConversation* conversation,
                                                      gboolean selection_mode_enabled);
static void conversation_list_row_update_flags (ConversationListRow* self,
                                         GearyEmail* email);
static void _conversation_list_row_update_flags_geary_app_conversation_email_flags_changed (GearyAppConversation* _sender,
                                                                                     GearyEmail* email,
                                                                                     gpointer self);
VALA_EXTERN void conversation_list_row_set_selection_enabled (ConversationListRow* self,
                                                  gboolean enabled);
VALA_EXTERN void conversation_list_row_update (ConversationListRow* self);
VALA_EXTERN void conversation_list_row_refresh_time (ConversationListRow* self);
static gchar* conversation_list_row_get_participants (ConversationListRow* self);
static void conversation_list_row_set_button_active (ConversationListRow* self,
                                              gboolean active);
static void conversation_list_row_update_button (ConversationListRow* self);
static void _conversation_list_row_update_button_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                          GtkStateFlags previous_state_flags,
                                                                          gpointer self);
static void conversation_list_row_update_state_flags (ConversationListRow* self);
static void _conversation_list_row_update_state_flags_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                          gpointer self);
VALA_EXTERN GType conversation_list_participant_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ConversationListParticipant* conversation_list_participant_new (GearyRFC822MailboxAddress* address);
VALA_EXTERN ConversationListParticipant* conversation_list_participant_construct (GType object_type,
                                                                      GearyRFC822MailboxAddress* address);
VALA_EXTERN gchar* conversation_list_participant_get_full_markup (ConversationListParticipant* self,
                                                      GeeList* account_mailboxes);
VALA_EXTERN gchar* conversation_list_participant_get_short_markup (ConversationListParticipant* self,
                                                       GeeList* account_mailboxes);
static void conversation_list_row_finalize (GObject * obj);
static GType conversation_list_row_get_type_once (void);
static void _vala_conversation_list_row_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
conversation_list_row_get_instance_private (ConversationListRow* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationListRow_private_offset);
}

static GeeList*
conversation_list_row_get_user_accounts (ConversationListRow* self)
{
	GeeList* result;
	GearyAppConversation* _tmp0_;
	GearyFolder* _tmp1_;
	GearyFolder* _tmp2_;
	GearyAccount* _tmp3_;
	GearyAccount* _tmp4_;
	GearyAccountInformation* _tmp5_;
	GearyAccountInformation* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	g_return_val_if_fail (CONVERSATION_LIST_IS_ROW (self), NULL);
	_tmp0_ = self->conversation;
	_tmp1_ = geary_app_conversation_get_base_folder (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_folder_get_account (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_account_get_information (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_account_information_get_sender_mailboxes (_tmp6_);
	_tmp8_ = _tmp7_;
	result = _tmp8_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_conversation_list_row_update_flags_geary_app_conversation_email_flags_changed (GearyAppConversation* _sender,
                                                                                GearyEmail* email,
                                                                                gpointer self)
{
	conversation_list_row_update_flags ((ConversationListRow*) self, email);
}

ConversationListRow*
conversation_list_row_construct (GType object_type,
                                 ApplicationConfiguration* config,
                                 GearyAppConversation* conversation,
                                 gboolean selection_mode_enabled)
{
	ConversationListRow * self = NULL;
	ApplicationConfiguration* _tmp0_;
	GearyAppConversation* _tmp1_;
	GtkLabel* _tmp2_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION), NULL);
	self = (ConversationListRow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = _g_object_ref0 (conversation);
	_g_object_unref0 (self->conversation);
	self->conversation = _tmp1_;
	g_signal_connect_object (conversation, "email-flags-changed", (GCallback) _conversation_list_row_update_flags_geary_app_conversation_email_flags_changed, self, 0);
	_tmp2_ = self->priv->preview;
	application_configuration_bind (config, APPLICATION_CONFIGURATION_DISPLAY_PREVIEW_KEY, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "visible", G_SETTINGS_BIND_DEFAULT);
	if (selection_mode_enabled) {
		conversation_list_row_set_selection_enabled (self, TRUE);
	}
	conversation_list_row_update (self);
	return self;
}

ConversationListRow*
conversation_list_row_new (ApplicationConfiguration* config,
                           GearyAppConversation* conversation,
                           gboolean selection_mode_enabled)
{
	return conversation_list_row_construct (CONVERSATION_LIST_TYPE_ROW, config, conversation, selection_mode_enabled);
}

void
conversation_list_row_update (ConversationListRow* self)
{
	GearyEmail* last_email = NULL;
	GearyAppConversation* _tmp0_;
	GearyEmail* _tmp1_;
	GearyEmail* _tmp2_;
	GtkLabel* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint count = 0;
	GearyAppConversation* _tmp20_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	_tmp0_ = self->conversation;
	_tmp1_ = geary_app_conversation_get_latest_recv_email (_tmp0_, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL);
	last_email = _tmp1_;
	_tmp2_ = last_email;
	if (_tmp2_ != NULL) {
		gchar* text = NULL;
		GearyEmail* _tmp3_;
		gchar* _tmp4_;
		GtkLabel* _tmp5_;
		const gchar* _tmp6_;
		GtkLabel* _tmp7_;
		GearyEmail* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GearyEmail* _tmp11_;
		GearyEmailProperties* _tmp12_;
		GearyEmailProperties* _tmp13_;
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp16_;
		_tmp3_ = last_email;
		_tmp4_ = util_email_strip_subject_prefixes (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		text = _tmp4_;
		_tmp5_ = self->priv->subject;
		_tmp6_ = text;
		gtk_label_set_text (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->preview;
		_tmp8_ = last_email;
		_tmp9_ = geary_email_get_preview_as_string (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_label_set_text (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = last_email;
		_tmp12_ = geary_email_get_properties (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = geary_email_properties_get_date_received (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_date_time_to_local (_tmp15_);
		_g_date_time_unref0 (self->priv->recv_time);
		self->priv->recv_time = _tmp16_;
		conversation_list_row_refresh_time (self);
		_g_free0 (text);
	}
	_tmp17_ = self->priv->participants;
	_tmp18_ = conversation_list_row_get_participants (self);
	_tmp19_ = _tmp18_;
	gtk_label_set_markup (_tmp17_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = self->conversation;
	count = geary_app_conversation_get_count (_tmp20_);
	if (count > 1) {
		GtkLabel* _tmp21_;
		GearyAppConversation* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = self->priv->count_badge;
		_tmp22_ = self->conversation;
		_tmp23_ = g_strdup_printf ("%i", geary_app_conversation_get_count (_tmp22_));
		_tmp24_ = _tmp23_;
		gtk_label_set_text (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	} else {
		GtkLabel* _tmp25_;
		_tmp25_ = self->priv->count_badge;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	}
	conversation_list_row_update_flags (self, NULL);
	_g_object_unref0 (last_email);
}

static void
_conversation_list_row_update_button_gtk_widget_state_flags_changed (GtkWidget* _sender,
                                                                     GtkStateFlags previous_state_flags,
                                                                     gpointer self)
{
	conversation_list_row_update_button ((ConversationListRow*) self);
}

static void
_conversation_list_row_update_state_flags_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self)
{
	conversation_list_row_update_state_flags ((ConversationListRow*) self);
}

void
conversation_list_row_set_selection_enabled (ConversationListRow* self,
                                             gboolean enabled)
{
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	if (enabled) {
		GtkCheckButton* _tmp0_;
		GtkCheckButton* _tmp1_;
		conversation_list_row_set_button_active (self, gtk_list_box_row_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow)));
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "state-flags-changed", (GCallback) _conversation_list_row_update_button_gtk_widget_state_flags_changed, self, 0);
		_tmp0_ = self->priv->selected_button;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _conversation_list_row_update_state_flags_gtk_toggle_button_toggled, self, 0);
		_tmp1_ = self->priv->selected_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	} else {
		guint _tmp2_;
		GtkCheckButton* _tmp3_;
		guint _tmp4_;
		GtkCheckButton* _tmp5_;
		g_signal_parse_name ("state-flags-changed", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _conversation_list_row_update_button_gtk_widget_state_flags_changed, self);
		_tmp3_ = self->priv->selected_button;
		g_signal_parse_name ("toggled", gtk_toggle_button_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_toggle_button_get_type (), GtkToggleButton), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _conversation_list_row_update_state_flags_gtk_toggle_button_toggled, self);
		conversation_list_row_set_button_active (self, FALSE);
		_tmp5_ = self->priv->selected_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}

void
conversation_list_row_refresh_time (ConversationListRow* self)
{
	GDateTime* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	_tmp0_ = self->priv->recv_time;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		GDateTime* _tmp2_;
		ApplicationConfiguration* _tmp3_;
		UtilDateClockFormat _tmp4_;
		UtilDateClockFormat _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->date;
		_tmp2_ = self->priv->recv_time;
		_tmp3_ = self->priv->config;
		_tmp4_ = application_configuration_get_clock_format (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = util_date_pretty_print (_tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		gtk_label_set_text (_tmp1_, _tmp7_);
		_g_free0 (_tmp7_);
	}
}

static void
conversation_list_row_set_button_active (ConversationListRow* self,
                                         gboolean active)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	_tmp0_ = self->priv->selected_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), active);
	if (active) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "selected");
		gtk_widget_set_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_SELECTED, FALSE);
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "selected");
		gtk_widget_unset_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_SELECTED);
	}
}

static void
conversation_list_row_update_button (ConversationListRow* self)
{
	gboolean is_selected = FALSE;
	GtkCheckButton* _tmp0_;
	guint _tmp1_;
	GtkCheckButton* _tmp2_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	is_selected = (gtk_widget_get_state_flags (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget)) & GTK_STATE_FLAG_SELECTED) == GTK_STATE_FLAG_SELECTED;
	_tmp0_ = self->priv->selected_button;
	g_signal_parse_name ("toggled", gtk_toggle_button_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _conversation_list_row_update_state_flags_gtk_toggle_button_toggled, self);
	conversation_list_row_set_button_active (self, is_selected);
	_tmp2_ = self->priv->selected_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) _conversation_list_row_update_state_flags_gtk_toggle_button_toggled, self, 0);
}

static void
conversation_list_row_update_state_flags (ConversationListRow* self)
{
	guint _tmp0_;
	GtkCheckButton* _tmp1_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	g_signal_parse_name ("state-flags-changed", gtk_widget_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _conversation_list_row_update_button_gtk_widget_state_flags_changed, self);
	_tmp1_ = self->priv->selected_button;
	g_signal_emit (self, conversation_list_row_signals[CONVERSATION_LIST_ROW_TOGGLE_SELECTION_SIGNAL], 0, self, gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton)));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "state-flags-changed", (GCallback) _conversation_list_row_update_button_gtk_widget_state_flags_changed, self, 0);
}

static void
conversation_list_row_update_flags (ConversationListRow* self,
                                    GearyEmail* email)
{
	GearyAppConversation* _tmp0_;
	GearyAppConversation* _tmp3_;
	g_return_if_fail (CONVERSATION_LIST_IS_ROW (self));
	g_return_if_fail ((email == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL));
	_tmp0_ = self->conversation;
	if (geary_app_conversation_is_unread (_tmp0_)) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "unread");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "unread");
	}
	_tmp3_ = self->conversation;
	if (geary_app_conversation_is_flagged (_tmp3_)) {
		GtkImage* _tmp4_;
		_tmp4_ = self->priv->flagged_icon;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkImage* _tmp5_;
		_tmp5_ = self->priv->flagged_icon;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	}
}

static gchar*
conversation_list_row_get_participants (ConversationListRow* self)
{
	GeeArrayList* participants = NULL;
	GeeArrayList* _tmp0_;
	GeeList* emails = NULL;
	GearyAppConversation* _tmp1_;
	GeeList* _tmp2_;
	GeeArrayList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GString* builder = NULL;
	GString* _tmp56_;
	gboolean first = FALSE;
	GString* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* result;
	g_return_val_if_fail (CONVERSATION_LIST_IS_ROW (self), NULL);
	_tmp0_ = gee_array_list_new (CONVERSATION_LIST_TYPE_PARTICIPANT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	participants = _tmp0_;
	_tmp1_ = self->conversation;
	_tmp2_ = geary_app_conversation_get_emails (_tmp1_, GEARY_APP_CONVERSATION_ORDERING_RECV_DATE_ASCENDING, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, TRUE);
	emails = _tmp2_;
	{
		GeeList* _message_list = NULL;
		GeeList* _tmp3_;
		gint _message_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _message_index = 0;
		_tmp3_ = emails;
		_message_list = _tmp3_;
		_tmp4_ = _message_list;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_message_size = _tmp6_;
		_message_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GearyEmail* message = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			GearyRFC822MailboxAddresses* _tmp11_ = NULL;
			GearyAppConversation* _tmp12_;
			GearyFolder* _tmp13_;
			GearyFolder* _tmp14_;
			GearyFolderSpecialUse _tmp15_;
			GearyFolderSpecialUse _tmp16_;
			GearyRFC822MailboxAddresses* addresses = NULL;
			GearyRFC822MailboxAddresses* _tmp25_;
			GearyRFC822MailboxAddresses* _tmp26_;
			_message_index = _message_index + 1;
			_tmp7_ = _message_index;
			_tmp8_ = _message_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _message_list;
			_tmp10_ = gee_list_get (_tmp9_, _message_index);
			message = (GearyEmail*) _tmp10_;
			_tmp12_ = self->conversation;
			_tmp13_ = geary_app_conversation_get_base_folder (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = geary_folder_get_used_as (_tmp14_);
			_tmp16_ = _tmp15_;
			if (geary_folder_special_use_is_outgoing (_tmp16_)) {
				GearyEmail* _tmp17_;
				GearyRFC822MailboxAddress* _tmp18_;
				GearyRFC822MailboxAddress* _tmp19_;
				GearyRFC822MailboxAddresses* _tmp20_;
				_tmp17_ = message;
				_tmp18_ = util_email_get_primary_originator (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp19_ = _tmp18_;
				_tmp20_ = geary_rf_c822_mailbox_addresses_new_single (_tmp19_);
				_g_object_unref0 (_tmp11_);
				_tmp11_ = _tmp20_;
				_g_object_unref0 (_tmp19_);
			} else {
				GearyEmail* _tmp21_;
				GearyRFC822MailboxAddresses* _tmp22_;
				GearyRFC822MailboxAddresses* _tmp23_;
				GearyRFC822MailboxAddresses* _tmp24_;
				_tmp21_ = message;
				_tmp22_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp23_ = _tmp22_;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (_tmp11_);
				_tmp11_ = _tmp24_;
			}
			_tmp25_ = _g_object_ref0 (_tmp11_);
			addresses = _tmp25_;
			_tmp26_ = addresses;
			if (_tmp26_ == NULL) {
				_g_object_unref0 (addresses);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (message);
				continue;
			}
			{
				GearyRFC822MailboxAddresses* _address_list = NULL;
				GearyRFC822MailboxAddresses* _tmp27_;
				gint _address_size = 0;
				GearyRFC822MailboxAddresses* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _address_index = 0;
				_tmp27_ = addresses;
				_address_list = _tmp27_;
				_tmp28_ = _address_list;
				_tmp29_ = geary_rf_c822_mailbox_addresses_get_size (_tmp28_);
				_tmp30_ = _tmp29_;
				_address_size = _tmp30_;
				_address_index = -1;
				while (TRUE) {
					gint _tmp31_;
					gint _tmp32_;
					GearyRFC822MailboxAddress* address = NULL;
					GearyRFC822MailboxAddresses* _tmp33_;
					GearyRFC822MailboxAddress* _tmp34_;
					ConversationListParticipant* participant_display = NULL;
					GearyRFC822MailboxAddress* _tmp35_;
					ConversationListParticipant* _tmp36_;
					gint existing_index = 0;
					GeeArrayList* _tmp37_;
					ConversationListParticipant* _tmp38_;
					_address_index = _address_index + 1;
					_tmp31_ = _address_index;
					_tmp32_ = _address_size;
					if (!(_tmp31_ < _tmp32_)) {
						break;
					}
					_tmp33_ = _address_list;
					_tmp34_ = geary_rf_c822_mailbox_addresses_get (_tmp33_, _address_index);
					address = _tmp34_;
					_tmp35_ = address;
					_tmp36_ = conversation_list_participant_new (_tmp35_);
					participant_display = _tmp36_;
					_tmp37_ = participants;
					_tmp38_ = participant_display;
					existing_index = gee_abstract_list_index_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp38_);
					if (existing_index < 0) {
						GeeArrayList* _tmp39_;
						ConversationListParticipant* _tmp40_;
						_tmp39_ = participants;
						_tmp40_ = participant_display;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp40_);
						_g_object_unref0 (participant_display);
						_g_object_unref0 (address);
						continue;
					}
					_g_object_unref0 (participant_display);
					_g_object_unref0 (address);
				}
			}
			_g_object_unref0 (addresses);
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (message);
		}
	}
	_tmp41_ = participants;
	_tmp42_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp43_ = _tmp42_;
	if (_tmp43_ == 0) {
		gchar* _tmp44_;
		_tmp44_ = g_strdup ("");
		result = _tmp44_;
		_g_object_unref0 (emails);
		_g_object_unref0 (participants);
		return result;
	}
	_tmp45_ = participants;
	_tmp46_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp47_ = _tmp46_;
	if (_tmp47_ == 1) {
		GeeArrayList* _tmp48_;
		gpointer _tmp49_;
		ConversationListParticipant* _tmp50_;
		GeeList* _tmp51_;
		GeeList* _tmp52_;
		GeeList* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp48_ = participants;
		_tmp49_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
		_tmp50_ = (ConversationListParticipant*) _tmp49_;
		_tmp51_ = conversation_list_row_get_user_accounts (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_;
		_tmp54_ = conversation_list_participant_get_full_markup (_tmp50_, _tmp53_);
		_tmp55_ = _tmp54_;
		_g_object_unref0 (_tmp53_);
		_g_object_unref0 (_tmp50_);
		result = _tmp55_;
		_g_object_unref0 (emails);
		_g_object_unref0 (participants);
		return result;
	}
	_tmp56_ = g_string_new ("");
	builder = _tmp56_;
	first = TRUE;
	{
		GeeArrayList* _participant_list = NULL;
		GeeArrayList* _tmp57_;
		gint _participant_size = 0;
		GeeArrayList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _participant_index = 0;
		_tmp57_ = participants;
		_participant_list = _tmp57_;
		_tmp58_ = _participant_list;
		_tmp59_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp60_ = _tmp59_;
		_participant_size = _tmp60_;
		_participant_index = -1;
		while (TRUE) {
			gint _tmp61_;
			gint _tmp62_;
			ConversationListParticipant* participant = NULL;
			GeeArrayList* _tmp63_;
			gpointer _tmp64_;
			GString* _tmp66_;
			ConversationListParticipant* _tmp67_;
			GeeList* _tmp68_;
			GeeList* _tmp69_;
			GeeList* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			_participant_index = _participant_index + 1;
			_tmp61_ = _participant_index;
			_tmp62_ = _participant_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _participant_list;
			_tmp64_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _participant_index);
			participant = (ConversationListParticipant*) _tmp64_;
			if (!first) {
				GString* _tmp65_;
				_tmp65_ = builder;
				g_string_append (_tmp65_, ", ");
			}
			_tmp66_ = builder;
			_tmp67_ = participant;
			_tmp68_ = conversation_list_row_get_user_accounts (self);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_tmp71_ = conversation_list_participant_get_short_markup (_tmp67_, _tmp70_);
			_tmp72_ = _tmp71_;
			g_string_append (_tmp66_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_object_unref0 (_tmp70_);
			first = FALSE;
			_g_object_unref0 (participant);
		}
	}
	_tmp73_ = builder;
	_tmp74_ = _tmp73_->str;
	_tmp75_ = g_strdup (_tmp74_);
	result = _tmp75_;
	_g_string_free0 (builder);
	_g_object_unref0 (emails);
	_g_object_unref0 (participants);
	return result;
}

static void
conversation_list_row_class_init (ConversationListRowClass * klass,
                                  gpointer klass_data)
{
	conversation_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_list_row_get_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_list_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/conversation-list-row.ui");
	conversation_list_row_signals[CONVERSATION_LIST_ROW_TOGGLE_FLAG_SIGNAL] = g_signal_new ("toggle-flag", CONVERSATION_LIST_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, CONVERSATION_LIST_TYPE_ROW, GEARY_TYPE_NAMED_FLAG);
	conversation_list_row_signals[CONVERSATION_LIST_ROW_TOGGLE_SELECTION_SIGNAL] = g_signal_new ("toggle-selection", CONVERSATION_LIST_TYPE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, CONVERSATION_LIST_TYPE_ROW, G_TYPE_BOOLEAN);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, preview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subject", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, subject));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "participants", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, participants));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "date", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, date));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "count_badge", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, count_badge));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flagged_icon", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, flagged_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "selected_button", FALSE, ConversationListRow_private_offset + G_STRUCT_OFFSET (ConversationListRowPrivate, selected_button));
}

static void
conversation_list_row_instance_init (ConversationListRow * self,
                                     gpointer klass)
{
	self->priv = conversation_list_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversation_list_row_finalize (GObject * obj)
{
	ConversationListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONVERSATION_LIST_TYPE_ROW, ConversationListRow);
	_g_object_unref0 (self->conversation);
	_g_object_unref0 (self->priv->config);
	_g_date_time_unref0 (self->priv->recv_time);
	G_OBJECT_CLASS (conversation_list_row_parent_class)->finalize (obj);
}

/**
 * A conversation list row displaying an email summary
 */
static GType
conversation_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationListRow), 0, (GInstanceInitFunc) conversation_list_row_instance_init, NULL };
	GType conversation_list_row_type_id;
	conversation_list_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ConversationListRow", &g_define_type_info, 0);
	ConversationListRow_private_offset = g_type_add_instance_private (conversation_list_row_type_id, sizeof (ConversationListRowPrivate));
	return conversation_list_row_type_id;
}

GType
conversation_list_row_get_type (void)
{
	static volatile gsize conversation_list_row_type_id__once = 0;
	if (g_once_init_enter (&conversation_list_row_type_id__once)) {
		GType conversation_list_row_type_id;
		conversation_list_row_type_id = conversation_list_row_get_type_once ();
		g_once_init_leave (&conversation_list_row_type_id__once, conversation_list_row_type_id);
	}
	return conversation_list_row_type_id__once;
}

static void
_vala_conversation_list_row_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ConversationListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONVERSATION_LIST_TYPE_ROW, ConversationListRow);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

